# Notation used in actuarial work

There are a number of special notations particular to actuarial work.  For example, 

\[\require{enclose} EPV = a _{[25]+5:\enclose{actuarial}{30}} ^ {\space 1},\]

which is typeset using `\[\require{enclose} EPV = a _{[25]+5:\enclose{actuarial}{30}} ^ {\space 1}\]`. Further examples are given below.

## Life Contingencies' Symbols ##


| Inline                                                                  | Code (without LaTeX delimiters)                                         | 
| ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | 
| \( a \)                                                                 |  `a`                                                                    | 
| \( \require{enclose} a_{\enclose{actuarial}{K}} \)                      |  `\require{enclose} a_{\enclose{actuarial}{K}}`                         | 
| \( \require{enclose} \bar{a}_{\enclose{actuarial}{T}} \)                |  `\require{enclose} \bar{a}_{\enclose{actuarial}{T}}`                   | 
| \( \require{enclose} \ddot{a}_x \)                                      |  `\require{enclose} \ddot{a}_x`                                         | 
| \( \require{enclose} \bar{a}_{h}^{r} \)                                 |  `\require{enclose} \bar{a}_{h}^{r}`                                    | 
| \( \require{enclose} \ddot{a}_{x}^{\{m\}} \)                            |  `\require{enclose} \ddot{a}_{x}^{\{m\}}`                               | 
| \( \require{enclose} a_{x:\enclose{actuarial}{n}} \)                    |  `\require{enclose} a_{x:\enclose{actuarial}{n}}`                       | 
| \( \require{enclose} \bar{a}_{x:\enclose{actuarial}{n}} \)              |  `\require{enclose} \bar{a}_{x:\enclose{actuarial}{n}}`                 | 
| \( \require{enclose} \ddot{a}_{x:\enclose{actuarial}{n}} \)             |  `\require{enclose} \ddot{a}_{x:\enclose{actuarial}{n}}`                | 
| \( \require{enclose} \ddot{a}_{x:\enclose{actuarial}{n}}^{(m)} \)       |  `\require{enclose} \ddot{a}_{x:\enclose{actuarial}{n}}^{(m)}`          | 
| \( \require{enclose} \mathring{a}_{x:\enclose{actuarial}{n}}^{(m)} \)   |  `\require{enclose} \mathring{a}_{x:\enclose{actuarial}{n}}^{(m)}`      | 
| \( \require{enclose} \ddot{a}_{x:\enclose{actuarial}{n}}^{\{m\}} \)     |  `\require{enclose} \ddot{a}_{x:\enclose{actuarial}{n}}^{\{m\}}`        | 
| \( \require{enclose} \bar{a}_{\overline{x:\enclose{actuarial}{n}}} \)   |  `\require{enclose} \bar{a}_{\overline{x:\enclose{actuarial}{n}}}`      | 
| \( \require{enclose} {}^{2}\bar{a}_{x:\enclose{actuarial}{n}} \)        |  `\require{enclose} {}^{2}\bar{a}_{x:\enclose{actuarial}{n}}`           | 
| \( \require{enclose} {}^{2}\ddot{a}_{xy:\enclose{actuarial}{n}} \)      |  `\require{enclose} {}^{2}\ddot{a}_{xy:\enclose{actuarial}{n}}`         | 

STACK provides some support for statistical functions via optional Maxima packages.  See specific pages on [statistics](../CAS/Statistics.md).
