# A pocket map of algebraic manipulation

## Introduction and use

This is a markdown copy of a summary of *a pocket map of algebraic manipulation* by Tony Barnard. The original PDF summary is available as a [PDF](../../../static/Barnard.pdf) and the [TeX source code](../../../static/Barnard.tex).

The numbering of sections in this document corresponds to the numbering of questions and quizzes in the questions in the library.

## The Map of Algebraic Manipulation

At the heart of the secondary school algebra curriculum lies the development of skills in algebraic manipulation. This little booklet collects together for reference some of the stepping stones of experiences in the development of these basic algebraic skills.

A guiding factor in the categorisation of the contents has been the splitting of an item into a range of separate cases where it was felt that these cases constituted significantly different experiences for a learner whose development in that item was at an early stage. Manipulation with numerical fractions has been dealt with fairly extensively in this sense, as it was considered that experience with a wide range of possibilities was essential in order for later progress in algebra. Similarly situations in which a sum or difference of two terms in an algebraic expression has to be mentally perceived as a single item, have been noted explicitly. On the other hand, there has been an attempt to balance the conflicting aims of comprehensiveness and conciseness. So, for example, in listing the three kinds of behaviour for the roots of a quadratic equation, it was considered unnecessary to split this further and give two different graphs for each case, relating to whether the turning point was a maximum or minimum, as this was felt to be a less significant distinction at this stage in the development. Generally speaking things have been broken down in the hope that they will be put together, and if a learner is unable to see why an item comes in so many 'different' cases, having developed to a stage where the distinctions seem insignificant, this is to be regarded as a success!

This booklet is intended for use by teachers rather than by pupils. However, as well as listing the items from the pupil's viewpoint in getting to grips with what you actually do in a particular situation, the language has also been chosen with an eye on teacher-pupil dialogue. Thus practical descriptions such as ''two-term expression", ''no number in front of the \(x^2\)" and ''no factor in common with" have been used instead of technical expressions such as ''binomial", ''monic" and ''relatively prime". As an aid to describing the items, each is accompanied by at least one illustrative example. Sometimes only the 'question' has been given, sometimes the 'answer' has also been given and sometimes the 'working' has been included as well. In each case, the aim of keeping the booklet as concise as possible has been at the forefront, and the 'answer' or 'working' have been included only if it was felt that doing so would give a clearer picture of the experiences in algebraic manipulation encompassed by the item.

Finally it should be emphasised that, in summarising this collection of pupil oriented steps in algebraic manipulation, there is no desire to lay out a prescribed route that everyone must follow. On the contrary it is hoped that the booklet might be thought of simply as a pocket map of the landscape.

I should like to thank Ian Evans and Tom Roper for their valuable comments in the preparation of this booklet.

Tony Barnard

## 1 Combinations of arithmetic operations


\((+)+(+)\), \((+)+(-)\), \((-)+(+)\), \((-)+(-)\)  \(\quad\rightarrow\quad\)  **Example:**  \(7+(-6)\), \(5-(-9)\), \(-6-(+4)\), \((-3) \times (-1)\),
 
\((+)-(+)\), \((+)-(-)\), \((-)-(+)\), \((-)-(-)\)  \(\quad\rightarrow\quad\)  **Example:**  \((+2) \times (-7)\), \((-6) \div (+2)\), \((-9) \div (-3)\),
 
\((+)\times(+)\), \((+)\times(-)\), \((-)\times(+)\), \((-)\times(-)\)  \(\quad\rightarrow\quad\)  **Example:**  \(2-3+1\), \(-6+2+7\), \((4\times 3)+2\)
 
\((+)\div(+)\), \((+)\div(-)\), \((-)\div(+)\), \((-)\div(-)\) \(\quad\rightarrow\quad\)  **Example:**   \(4 \times(3+2)\), \(4+(3\times 2)\), \(3-(4\div 2)\).
 

'**B**rackets, **O**f, **D**ivision,**M**ultiplication, **A**ddition,**S**ubtraction.'

Powers of whole numbers   \(\quad\rightarrow\quad\)   **Example:**  \(2^3 \times 2^4 = 2^7\), \(2^5 \div 2^2 = 2^3\), \((5^2)^3 = 5^6\), \((2 \times 3)^4 = 2^4 \times 3^4\).
 

'**B**rackets, **I**ndices, **D**ivision, **M**ultiplication,**A**ddition, **S**ubtraction.'


Negative and fractional powers  \(\quad\rightarrow\quad\)  **Example:**  \(2^{-1}=\frac{1}{2}\), \(2^0 = 1\), \(3^{-2} = \frac{1}{3^2} = \frac{1}{9}\), \(9^\frac{1}{2} = \sqrt{9} = 3\), \(8^\frac{1}{3} = \sqrt[3]{8} =2\).


## 2 Factorisation of whole numbers

Prime factorisations  \(\quad\rightarrow\quad\)   **Example:**  \(228 = 2^2 \times 3 \times 19\), \(1734 = 2 \times 3 \times 17^2\).

Highest common factor  \(\quad\rightarrow\quad\)  **Example:**   HCF of \(228\) and \(1734\) is \(2 \times 3 = 6\).

Least common multiple   \(\quad\rightarrow\quad\)  **Example:**  LCM of \(228\) and \(1734\) is \(2^2 \times 3 \times 17^2 \times 19 = 65892\).

Reduction of fractions to lowest terms   \(\quad\rightarrow\quad\)  **Example:**  \(\frac{10}{18} = \frac{5}{9}\).

Change of improper fractions to mixed fractions, and vice-versa \(\quad\rightarrow\quad\)  **Example:**  \(\frac{13}{5} = 2\frac{3}{5}\), \(1\frac{7}{8} = \frac{15}{8}\).

Products and quotients of surds 
\(\quad\rightarrow\quad\)  **Example:**  \(\sqrt{12} \times \sqrt{6} = \sqrt{2^2 \times 3} \times \sqrt{2 \times 3} = 2 \times 3 \times \sqrt{2} = 6\sqrt{2}\), 
\(\frac{\sqrt{108}}{\sqrt{150}} = \frac{\sqrt{2^2 \times 3^3}}{\sqrt{2 \times 3 \times 5^2}} = \sqrt{\frac{2^2 \times 3^3}{2 \times 3 \times 5^2}} = \sqrt{\frac{2 \times 3^2}{5^2}} = \frac{3\sqrt{2}}{5}.\)
 

## 3 Addition and subtraction of fractions

### 3.1 Nature of denominators

Same denominator \(\quad\rightarrow\quad\)  **Example:**  \(\frac{4}{7} + \frac{2}{7}\), \(\frac{5}{6} - \frac{1}{6}\).

One denominator a multiple of the other   \(\quad\rightarrow\quad\)  **Example:**  \(\frac{1}{4} + \frac{5}{12}\), \(\frac{9}{10} - \frac{4}{5}\).

Denominators having no common factor\(\quad\rightarrow\quad\)  **Example:**  \(\frac{2}{3} + \frac{4}{7}\), \(\frac{5}{8} - \frac{1}{3}\).
 
Denominators having a common factor \(\quad\rightarrow\quad\)   **Example:**  \(\frac{4}{9} + \frac{1}{6}\), \(\frac{7}{12} - \frac{3}{8}\).
 
### 3.2 Mixed numbers

(Addition) Fractional parts adding to less than \(1\)  \(\quad\rightarrow\quad\)   **Example:**  \(1\frac{3}{16} + 2\frac{3}{4} = 3\frac{15}{16}\)

(Addition) Fractional parts adding to greater than \(1\)  \(\quad\rightarrow\quad\)  **Example:**  \(3\frac{1}{2} + 2\frac{2}{3} = 6\frac{1}{6}\)
 

(Subtraction) Fractional part of smaller fraction less than fractional part of greater fraction \(\quad\rightarrow\quad\)   **Example:**  \(4\frac{5}{6} - 2\frac{3}{4} = 2\frac{1}{12}\)
  
(Subtraction) Fractional part of smaller fraction greater than fractional part of greater fraction \(\quad\rightarrow\quad\)   **Example:**  \(5\frac{1}{6} - 3\frac{4}{9} = 1\frac{13}{18}\)
   

### 3.3 Number of fractions
 
Two, three, ...  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{7}{10} + \frac{1}{4} + \frac{3}{5}\), \(2\frac{3}{8} + 4\frac{5}{12} + 1\frac{2}{3}\).

### 3.4 Combination of operations
 
\(a+b\), \(a - b\), \(a-b+c\), ...  \(\quad\rightarrow\quad\)  **Example:**  \(\frac{5}{6} - \frac{2}{3} - \frac{1}{9}\), \(1\frac{2}{3} - 3\frac{7}{8} + 4\frac{5}{6}\).

### 3.5 Special case

Fraction minus itself; e.g. \(\frac{4}{5} - \frac{4}{5}\). \(x - x = 0\), rather than \(\frac{4}{5} - \frac{4}{5} = \frac{4-4}{5} = \frac{0}{5} = 0\).

## 4 Multiplication and division of fractions

### 4.1 Nature of component fractions
 
Fraction times whole number which is relatively prime to the denominator \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2}{9} \times 4\)
  
Fraction times whole number which is a factor of the denominator (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3}{8} \times 4\)
 
Fraction times whole number which has a factor in common with the denominator (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{5}{12} \times 9\)
 
Fraction times fraction with no cancelling involved \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2}{7} \times \frac{3}{5}\)
 
Fraction times fraction with cancelling involved (preferably *before* multiplying)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{14}{15} \times \frac{3}{4}\)

Fraction divided by whole number which is a factor of the numerator \(\quad\rightarrow\quad\)   **Example:**  \(\frac{4}{5} \div 2\)

Fraction divided by whole number which has no factor in common with the numerator \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3}{4} \div 5\)

Fraction divided by whole number which has a factor in common with the numerator (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{4}{7} \div 6\)

Fraction divided by fraction with no cancelling involved \(\quad\rightarrow\quad\)   **Example:**  \(\frac{5}{8} \div \frac{2}{3}\)

Fraction divided by fraction with cancelling involved \(\quad\rightarrow\quad\)   **Example:**  \(\frac{6}{7} \div \frac{9}{14}\)
 
#### 14.1.1 Mixed numbers

In question \(\quad\rightarrow\quad\)   **Example:**  \(1\frac{1}{5} \times \frac{1}{3} = \frac{2}{5}\), \(3 \div 4\frac{1}{2} = \frac{2}{3}\).

In answer \(\quad\rightarrow\quad\)   **Example:**  \(\frac{5}{16} \times 6 = 1\frac{7}{8}\),
\(\frac{3}{5} \div \frac{4}{7} = 1\frac{1}{20}\).

In both question and answer \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3}{4} \times 3\frac{1}{5} = 2\frac{2}{5}\), \(3\frac{1}{6} \div 1\frac{1}{2} = 2\frac{1}{9}\).

#### 4.1.2 Number of fractions

Two, three, ...  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2}{5} \times \frac{1}{3} \times \frac{15}{16}\), \(1\frac{1}{3} \times 2\frac{1}{4} \times 1\frac{7}{12}\).

#### 4.1.3 Combination of operations

\(a \times b\), \(a \div b\), \(a \times b \div c\), \(a \div (b \times c)\), \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2}{3} \div \left(\frac{1}{2} \times \frac{5}{6} \right)\),

\((a \div b) \times c\), \(a \div (b \div c)\), \((a \div b) \div c\), ...  \(\quad\rightarrow\quad\)   **Example:**  \(\left(\frac{9}{10} \times 6\frac{2}{3} \right) \div 2 \frac{1}{4}\).

#### 4.1.4 Special case

Fraction divided by itself; e.g. \(\frac{2}{3} \div \frac{2}{3}\). \(x \div x = 1\) (or \(\frac{x}{x} = 1\)), rather than \(\frac{2}{3} \times \frac{3}{2} = \frac{1}{1} = 1\).

## 5 Combinations of arithmetic operations on fractions

Including fractions in which the numerator and denominator are themselves a sum or difference of two fractions.

\[5\frac{1}{4} - \left(1\frac{1}{5} \times \frac{15}{16} \right),\ \left( \frac{3}{10} \div \frac{1}{4} \right)  + 2 \frac{1}{5},\ 3\frac{3}{8} \left(  4 \frac{2}{3} + 1\frac{3}{7}\right),\] \[\left( \frac{1}{3} + \frac{1}{2}\right)  \left(  2\frac{1}{2} + 1 \frac{1}{4} \right),\ \frac{2+\frac{3}{8}}{1\frac{1}{3}+\frac{1}{4}},\ \frac{1\frac{1}{2}+\frac{2}{3}}{\frac{5}{6}},\ \frac{\frac{4}{9} + \frac{5}{6}}{\frac{5}{8} - \frac{7}{12}}.\]

Substituting numbers for letters \(\quad\rightarrow\quad\)   **Example:**  \(\frac{s^2 + 2t^2}{3 - 2t}\) when \(s = \frac{3}{8}\) and \(t = \frac{2}{5}\)

## 6 Simplifying algebraic expressions

### 6.1 Collecting like terms

#### 6.1.1 Linear

Numbers and one letter \(\quad\rightarrow\quad\)   **Example:**  \(6-2x-4 + 3x\)

Two (or more) letters \(\quad\rightarrow\quad\)   **Example:**  \(2a + b - c + 3a - 2b\)

Numbers and two (or more) letters \(\quad\rightarrow\quad\)   **Example:**  \(5s + 3t - 1 - 2s + t - 6\)

#### 6.1.2 Higher orders

Numbers and terms in one letter \(\quad\rightarrow\quad\)   **Example:**  \(x^2 - 2x^3 + 1 - 3x^2 - 4 + x + 5x^3\)

Numbers and terms in two (or more) letters \(\quad\rightarrow\quad\)   **Example:**  \(xy^2 - y - xy + 2 + x^2 + 3xy^2 + 4y\)

#### 6.1.3 'Compound terms' (non-removal of brackets)

\(2(4x+1)+3(4x+1) = 5(4x+1)\),
\(7(a+b) - 4(a+b) = 3(a+b)\).

### 6.2 Powers of single-term expressions

Rules of indices, mainly for particular integer values of \(m\) and \(n\):

\(a^ma^n = a^{m+n}\), \(a^m \div a^n = a^{m-n}\), \((a^m)^n = a^{mn}\), \(\quad\rightarrow\quad\)   **Example:** \((a^2)^3 = a^6\), \((ab)^3 = a^3b^3\),
\(a^0 = 1\), \(a^{-1} = \frac{1}{a}\), \(a^{-n} = \frac{1}{a^n}\),\((ab)^n = a^nb^n\) \(\quad\rightarrow\quad\)   **Example:**    \(\left(  \frac{1}{a} \right)  ^{-2} = a^2\),\((3a)^2 = 9a^2\), \((2a^2b)^3 = 8a^6b^3\).


Fractional indices and surds  \(\quad\rightarrow\quad\)    **Example:**  \(a^{\frac{1}{n}} = \sqrt[n]{a}\), 
\(a^{\frac{m}{n}} = \sqrt[n]{a^m} = \left(  \sqrt[n]{a} \right) ^m\).  \(\quad\rightarrow\quad\)   **Example:**  \(\left(  2 \sqrt{a}\right)  ^4 = 16a^2\), \((4a)^{\frac{1}{2}} \div a^\frac{3}{2} = \frac{2}{a}\).

Substituting numbers for letters \(\quad\rightarrow\quad\)   **Example:**  \(a^\frac{3}{4} + b^\frac{2}{3}\) when \(a = 16\) and \(b = 27\),
\(\sqrt{(y^2 + z^2)x^{-1}}\) when \(x = 4\), \(y = 6\) and \(z = 8\).

### 6.3 Multiplying and dividing single-term expressions

Terms in a single letter   \(\quad\rightarrow\quad\)   **Example:**  \(a \times a \times a = a^3\), \(b^4 \div b^2 = b^2\), \(c^2 \div c^3 = \frac{1}{c}\).

Terms in a single letter with numbers   \(\quad\rightarrow\quad\)   **Example:**  \(5a \times 2a^2 = 10a^3\), \(6b^2 \div 2b = 3b\).

Terms involving more than one letter \(\quad\rightarrow\quad\)   **Example:**  \(4a \times 3b = 12ab\), \(8a \div 2b = \frac{4a}{b}\), \(9a^3 \div 6ab = \frac{3a^2}{b}\).

## 7 Removing brackets

### 7.1 Multiplying single-term expression and bracket

Number times linear expression in one letter \(\quad\rightarrow\quad\)   **Example:**  \(2(3x +4)\), \(-3(x+2)\).

Number times linear expression in two (or more) letters   \(\quad\rightarrow\quad\)   **Example:**  \(3(a-2b)\), \(-2(x+4y)\).

Minus sign on its own outside bracket \(\quad\rightarrow\quad\)   **Example:**  \(-(x+3)\), \(-(a-b)\), \(-(-2x-1)\).

Letter times linear expression in same letter   \(\quad\rightarrow\quad\)   **Example:**  \(x(x+2)\)

Letter times linear expression in two (or more) letters   \(\quad\rightarrow\quad\)   **Example:**  \(a(b-c)\)

Higher order terms \(\quad\rightarrow\quad\)   **Example:**  \(x^2(1-x)\), \(x(x^3+x)\).

More than two terms inside bracket \(\quad\rightarrow\quad\)   **Example:**  \(a(a^2-ab+b^2)\), \(xy(x+y-1)\).

### 7.2 Multiplying two brackets, each with two terms

#### 7.2.1 Linear terms in a single letter

Various types, illustrated by the following examples 
\[
(x+1)(x+2),\  (x+1)(x-2),\  (x-1)(x+2),\  (x-1)(x-2),\\
(x+1)(2+x),\ (x+1)(2-x),\ (x-1)(2+x),\ (x-1)(2-x),\\
(1+x)(x+2),\ (1+x)(x-2),\ (1-x)(x+2),\ (1-x)(x-2),\\
(1+x)(2+x),\ (1+x)(2-x),\ (1-x)(2+x),\ (1-x)(2-x).\\
\]

As above, but with one of the \(x\)s replaced by a number times \(x\)  \(\quad\rightarrow\quad\)   **Example:**  \((5x + 1)(x - 2)\)

As above, but with both of the \(x\)s replaced by a number times \(x\)  \(\quad\rightarrow\quad\)   **Example:**  \((4x - 1)(2+ 3x)\)

#### 7.2.2 Linear terms involving more than one letter


The same two letters in each bracket   \(\quad\rightarrow\quad\)   **Example:**  \((a+3b)(2a-b)\)

More than two different letters involved   \(\quad\rightarrow\quad\)   **Example:**  \((x+4y)(2x+3z)\), \((a-b)(c - d)\).
 

#### 7.2.3 'Square, twice product, square'


\((x+1)^2 = x^2+2x+1\),
\((x-1)^2 = x^2 - 2x +1\),
\((2x+3)^2 = 4x^2 + 12x + 9\),
\((pq-r)^2 = p^2q^2 - 2pq + r^2\),
\((a+b)^2 = a^2 + 2ab + b^2\).
 

#### 7.2.4 'Difference of two squares'


\((x+2)(x-2) = x^2 - 4\),
\((2x+5)(2x-5) = 4x^2 - 25\),
\((xy+zt)(xy - zt) = x^2y^2 - z^2t^2\),
\((a+b)(a-b) = a^2 - b^2\).

### 7.3 Additional features

Three or more factors \(\quad\rightarrow\quad\)   **Example:**  \(x(y+2z)(y - z)\)

Three or more terms inside one (or more) of the brackets \(\quad\rightarrow\quad\)   **Example:**  \((x+2y+1)(x-y)\), \((a+b+c)^2\).

Removing brackets and collecting like terms \(\quad\rightarrow\quad\)   **Example:** \(x^3(x+1) - x^2(x-1)\), \(a(b-c)-b(a-c)\),
\(5b(a+2) - a(3b+4)\), \((2x+1)^2 + (x-3)^2\).
 



Involvement of surds \(\quad\rightarrow\quad\)   **Example:**  \(\left(  \sqrt{2} - 1 \right)  \left(  \sqrt{2} + 3 \right)\), \(\left(  1 + 2 \sqrt{2} \right)  ^2\),
\(\left(  \sqrt{a} - 6 \right)  \left(  \sqrt{a} + 6 \right)\), \(\sqrt{25xy^3(x - 2y)^2}\).

## 8 Algebraic fractions

### 8.1 Cancelling


Cancelling a number only \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2a}{4b}\)

Cancelling a letter only \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3a}{2a}\)

Leaving \(1\) or \(-1\) after cancelling   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{x}{2x} = \frac{1}{2}\)

Cancelling both letters and numbers   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{8ab^2}{12ab}\)

Cancelling a bracketed term   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{(y+1)^2}{y+1}\),
\(\frac{20(x-2)}{5(x-2)^3}\).
 

#### 8.1.1 Minus 1

Minus \(1\) in denominator   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{a}{-1} = -a\), \(\frac{a-b}{-1} = b - a\), \(\frac{x^2+x-2}{-1}= 2 - x - x^2\).
 
Expressions of opposite sign in numerator and denominator \(\quad\rightarrow\quad\)   **Example:**  \(\frac{b-a}{a-b} = -1\)

### 8.2 Adding and subtracting algebraic fractions

*Denominators numbers and numerators multiples of the same letter or
bracketed expression*

Same denominator \(\quad\rightarrow\quad\)   **Example:**  \(\frac{5x}{8} + \frac{x}{8}\), \(\frac{4(x+2)}{7} - \frac{3(x+2)}{7}\).

One denominator a multiple of the other   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3x}{4} + \frac{x}{12}\)

Denominators having no common factor   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3a}{4}-\frac{2a}{5}\), \(\frac{2(x+y)}{3}+\frac{3(x+y)}{4}\).

Denominators having a common factor   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{5x}{6}+\frac{2x}{9}\)

#### 8.2.1 Single-term numerators and denominators

Same denominator   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{1}{9x}+\frac{2}{9x}\), \(\frac{a}{5}+\frac{2b}{5}\).

One denominator a multiple of the other   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3}{4x} + \frac{5}{8x}\)

Denominators having no common factor \(\quad\rightarrow\quad\)   **Example:**  \(\frac{1}{a} + \frac{1}{b}\), \(\frac{a}{b}+\frac{c}{d}\).

Denominators having a common factor \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2}{ab} + \frac{5}{bc}\), \(\frac{7}{4x} - \frac{2}{5x}\), \(\frac{3a}{10b}+\frac{4c}{5d}\).

Numerical and literal fractions mixed   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{1}{2}+\frac{1}{x}\), \(\frac{a}{b} - \frac{5}{8}\).

Adding or subtracting \(1\) \(\quad\rightarrow\quad\)   **Example:**  \(\frac{x}{y} - 1 = \frac{x-y}{y}\), \(1+\frac{a}{b} = \frac{b+a}{b}\).

#### 8.2.2 Linear expression in numerator or denominator

In numerators only \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2x-1}{5}+\frac{x+3}{2}\)

In denominators only   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3}{x-2} - \frac{4}{x+1}\)

In both numerator and denominator   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{2x+1}{x-3} + \frac{3x-1}{x+4}\)

#### 8.2.3 Higher powers or/and several different letters

\[\frac{a-c}{a+b} - \frac{a-b}{a+c},\ \frac{2}{3xy} + \frac{5}{4x^2y}.\]

#### 8.2.4 Combinations of operations

\[\frac{2}{x} - \frac{3}{x^2} + \frac{4}{x^3},\ \frac{a-3}{3} + \frac{a+5}{4} - \frac{2a-1}{6}.\]

### 8.3 Multiplying and dividing algebraic fractions

No cancelling involved   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{x^2}{y} \times \frac{x^3}{2}\), \(\frac{x-1}{2} \div \frac{5}{x}\).

(Multiplication) single-term common factor in numerator of one fraction and denominator of the other (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{4y}{3} \times \frac{15z}{8y}\)

(Multiplication) bracketed common factor in numerator of one fraction and denominator of the other (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{x+y}{5} \times \frac{7}{2(x+y)}\), \(\frac{4a^2}{a-b} \times \frac{a-b}{8a}\).

(Division) single-term common factor in numerators or in denominators (cancelling involved)   \(\quad\rightarrow\quad\)   **Example:**  \(xy \div \frac{x}{y+1}\)

(Division) bracketed common factor in numerators or in denominators (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{a(a+b)}{2b^2} \div \frac{a+b}{6b^3}\)

### 8.4 Combinations of arithmetic operations on algebraic fractions

Including fractions in which the numerator and denominator are themselves a sum or difference of two fractions.

\[\frac{a}{b}\div c = \frac{a}{bc},\ \frac{a}{b \div c} = \frac{ac}{b}, \ \frac{\frac{b+1}{a}+1}{b} = \frac{a+b+1}{ab},\] \[\left(  \left(  x - \frac{1}{x} \right)  ^2 + 2 \right)  \div \frac{1}{x^2} = x^4 + 1.\]

## 9 Linear equations

Unknown on one side of equation   \(\quad\rightarrow\quad\)   **Example:**  \(3x+2 = 11\), \(7-2x = 3\).

Unknown on both sides of equation   \(\quad\rightarrow\quad\)   **Example:**  \(2x+6=3-x\), \(3x-5 = 7+9x\).

Removal of brackets involved   \(\quad\rightarrow\quad\)   **Example:**  \(3(2x-1)-2(x-1)=0\)

Fractions involved   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3-x}{5} + 3 = \frac{2x+1}{10}\)

## 10 Single-term common factors

Common factor a number   \(\quad\rightarrow\quad\)   **Example:**  \(8 - 2x\), \(6x+9y\).

Common factor a letter   \(\quad\rightarrow\quad\)   **Example:**  \(3x^2 + 2x\), \(x^2 - 4xy\).

More than one common factor   \(\quad\rightarrow\quad\)   **Example:**  \(5xy + 10x^2z\), \(6abc - 8bcd\).

More than two terms   \(\quad\rightarrow\quad\)   **Example:**  \(3xy + 6y^2 - 9y\)

Leaving \(1\) or \(-1\) after taking out common factor   \(\quad\rightarrow\quad\)   **Example:**  \(x^3+x^2\), \(6s^2 - s\).

Some, but not all, terms fractions   \(\quad\rightarrow\quad\)   **Example:**  \(P + \frac{PRT}{100}\)

Common given bracketed expression   \(\quad\rightarrow\quad\)   **Example:**  \((a-b)c + (a-b)d\), \(x(y+1) - 2(y+1)\).

## 11 Rearranging algebraic formulae

### 11.1 Fundamental multiplicative equivalences

Equivalence of \(ab=c\), \(b = \frac{c}{a}\) and \(a = \frac{c}{b}\).

Equivalence of \(\frac{a}{b} = \frac{c}{d}\) and \(ad = bc\) (*cross multiplication*).

### 11.2 Making a specified letter the subject of a formula

Specified letter in one term \(\quad\rightarrow\quad\)   **Example:**  \(s = 2t - d\ (t)\)

Specified letter in two (or more) terms   \(\quad\rightarrow\quad\)   **Example:**  \(a-bx = c+dx\ (x)\)

Specified letter with mixed coefficients (numbers and letters)  \(\quad\rightarrow\quad\)   **Example:**  \(T= 2p+ph\ (p)\)

Removal of brackets involved   \(\quad\rightarrow\quad\)   **Example:**  \(r^2=V(h-a)\ (a)\)

Fractions involved   \(\quad\rightarrow\quad\)   **Example:**  \(a=b+\frac{x}{c}\), \(\frac{x}{a}+\frac{x}{b} = 2\ (x)\)

Removal of surds involved   \(\quad\rightarrow\quad\)   **Example:**  \(a=b\sqrt{x}\), \(a= \sqrt{b+x}\ (x)\)

Taking square roots involved   \(\quad\rightarrow\quad\)   **Example:**  \(z^2 = y^2 - x^2\), \(y = \sqrt{x^2 + 4}\), \(y = \sqrt{\frac{x^2-1}{x^2+1}}\ (x)\)


### 11.3 Substituting from one formula into another


Direct substitution of one letter \(\quad\rightarrow\quad\)   **Example:**  \(m = \frac{r}{s}\), \(k = mr \rightarrow k\) in terms of \(r\) and \(s\)

Direct substitution of two (or more) letters \(\quad\rightarrow\quad\)   **Example:**  \(c=2ab\), \(a=x+5\), \(b = x-1 \rightarrow c\) in terms of \(x\);
\(r = 4p - q\), \(p = x - 2y\), \(q = x-5y \rightarrow r\) in terms of \(x\) and \(y\).

Elimination of a letter from two formulae \(\quad\rightarrow\quad\)   **Example:**  \(k = \frac{A}{u}\), \(L = \frac{u^2}{m} \rightarrow L\) in terms of \(A\), \(k\) and \(m\);\
\(v = at\), \(s = \frac{1}{2}at^2 \rightarrow s\) in terms of \(v\) and \(t\).

## 12 Simultaneous linear equations

Coefficients of one unknown the same in both equations (*Subtract one equation from the other*)

- Coefficient positive \(\quad\rightarrow\quad\)   **Example:**  \(3x + 2y = 9\), \(x+2y = 7\)

- Coefficient negative \(\quad\rightarrow\quad\)   **Example:**  \(5x-y = 14\), \(2x - y = 5\)

- Equations given in least convenient order (*Subtract first from second*)  \(\quad\rightarrow\quad\)   **Example:**  \(x+2y = 7\), \(3x + 2y = 9\)

Coefficient of an unknown in one equation minus its coefficient in the other (*Add equations*)  
\(\quad\rightarrow\quad\)   **Example:**  \(3x+2y = 12\), \(5x - 2y = 4\)

Coefficient of an unknown in one equation a positive multiple of its coefficient in the other (*Multiply and subtract*)  
\(\quad\rightarrow\quad\)   **Example:**  \(2x + 5y = 24\), \(4x + 3y = 20\)

Coefficient of an unknown in one equation a negative multiple of its coefficient in the other (*Multiply and add*)  
\(\quad\rightarrow\quad\)   **Example:**  \(3x - 2y = 7\), \(4x + y = 13\)

Multiplication of both equations before adding or subtracting 
\(\quad\rightarrow\quad\)   **Example:**  \(4x - 3y = 11\), \(5x + 2y = 9\)

Prior rearrangement of equations involved \(\quad\rightarrow\quad\)   **Example:**  \(2x = 5y + 1\), \(5x + 3(y-6) = 0\)

*Substitution method*  \(\quad\rightarrow\quad\)  **Example:**  \[\left.
\begin{array}{l}
x - 2y = 1 \\
3x + 5y = 14
\end{array}
\right\} \rightarrow 3(2y+1) + 5y = 14 \rightarrow 11y = 11 \rightarrow
\left. \begin{array}{l}
y = 1 \\
x = 3
\end{array}
\right\}\]

## 13 Factorising algebraic expressions

### 13.1 Quadratic expressions

#### 13.1.1 No number in front of the \(x^2\)

Constant term \(+\), \(x\)-term \(+\)   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 + 5x +4\)

Constant term \(+\), \(x\)-term \(-\)   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 - 7x +12\)

Constant term \(-\), \(x\)-term \(+\)   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 + 3x - 10\)

Constant term \(-\), \(x\)-term \(-\)   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 - 2x - 15\)

'Square, twice product, square'   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 + 6x + 9\)

'Difference of two squares'   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 - 16\)

#### 13.1.2 Number in front of the \(x^2\)

Constant term \(+\), \(x\)-term \(+\)  \(\quad\rightarrow\quad\)   **Example:**  \(2x^2 + 11x +12\)

Constant term \(+\), \(x\)-term \(-\)   \(\quad\rightarrow\quad\)   **Example:**  \(15x^2 - 13x + 2\)

Constant term \(-\), \(x\)-term \(+\)   \(\quad\rightarrow\quad\)   **Example:**  \(3x^2 + x - 4\)

Constant term \(-\), \(x\)-term \(-\)   \(\quad\rightarrow\quad\)   **Example:**  \(6x^2 - 7x - 10\)

'Square, twice product, square'   \(\quad\rightarrow\quad\)   **Example:**  \(9x^2 - 12x + 4\)

'Difference of two squares'   \(\quad\rightarrow\quad\)   **Example:**  \(25x^2 - 4\)

#### 13.1.3 Modifications of the above

Terms not in usual order   \(\quad\rightarrow\quad\)   **Example:**  \(3x+4-x^2\), \(11x - x^2 - 30\), \(4 - 8x + 4x^2\).

Homogeneous in two variables   \(\quad\rightarrow\quad\)   **Example:**  \(x^2 + xy - 6y^2\), \(36x^2 - 49y^2\), \(x^2 + 8xy + 16y^2\).

Single-term factor leaving quadratic   \(\quad\rightarrow\quad\)   **Example:**  \(3x^3 - 6x^2 - 24x\), \(50a^3 - 18ab^2\).

Expression in place of a single letter   \(\quad\rightarrow\quad\)   **Example:**  \(x^2y^2 - 2xy + 1\), \((a+b)^2 - (a+c)^2\).

Fractions involved \(\quad\rightarrow\quad\)   **Example:**  \(x^2 - \frac{y^2}{4} = \left(  x - \frac{y}{2} \right)  \left(  x + \frac{y}{2} \right)\), \(x^2 + 2 + \frac{1}{x^2} = \left(  x + \frac{1}{x} \right)  ^2\).

### 13.2 Other two (or more)-term factors

Grouping   \(\quad\rightarrow\quad\)   **Example:**  \(ab + a + b + 1 = (a+1)(b+1)\), \(ax + ay - bx - by = (a-b)(x+y)\).

Sum of two cubes   \(\quad\rightarrow\quad\)   **Example:**  \(x^3 + y^3 = (x+y)(x^2 - xy + y^2)\)

Difference of two cubes   \(\quad\rightarrow\quad\)   **Example:**  \(x^3 - y^3 = (x-y)(x^2 + xy + y^2)\)

Just for fun \(\quad\rightarrow\quad\)   **Example:**  \(a^3 + b^3 + c^3 - 3abc = (a+b+c)(a^2 + b^2 + c^2 - bc - ca - ab)\)
\(= \frac{1}{2}\left(  a+b+c \right)  \left( (b-c)^2 + (c-a)^2 + (a-b)^2 \right)\)

## 14 Algebraic fractions involving factorising

### 14.1 Cancelling

Cancelling a number only   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{9x+3}{3x}\), \(\frac{4x^2 + 2x}{6x^2 - 10}\).

Cancelling a letter only   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3x}{4x+5x^2}\), \(\frac{a^2 - 2ab}{a^3 + 3a^2b + ab^2}\).

Cancelling both letters and numbers   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{4a}{(2a)^2 - 8a}\), \(\frac{5x^3 - 15x^2y + 10xy^2}{5x^2 + 10xy}\).

Cancelling a two (or more)-term expression \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3a-6b}{a^2-2ab} = \frac{3(a-2b)}{a(a-2b)} = \frac{3}{a}\), \(\frac{x^2 - 5x + 6}{3y - xy} = \frac{(x-2)(x-3)}{y(3-x)} = \frac{2-x}{y}\).

### 14.2 Arithmetic operations

Adding and subtracting where there is a common factor in the denominators   \(\quad\rightarrow\quad\)   **Example:**  \(\frac{1}{x^2 + 5x +6} - \frac{2}{x^2 - 4}\)

Multiplying where there is a common factor in the numerator of one fraction and the denominator of the other (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{6}{x^2 - 2x - 8} \times \frac{x+2}{3}\)

Dividing where there is a common factor in the numerators or in the denominators (cancelling involved)  \(\quad\rightarrow\quad\)   **Example:**  \(\frac{3x}{x^2 - 1} \div \frac{5}{x+1}\)

Combinations of arithmetic operations \(\quad\rightarrow\quad\)   **Example:**  \(\frac{\frac{a+b+1}{ab} + 1}{\frac{b+1}{a}} = \frac{ab + a + b + 1}{b(b+1)} = \frac{(a+1)(b+1)}{b(b+1)} = \frac{a+1}{b}\),
\(\frac{\frac{a+1}{b} + 1}{\frac{a+b+1}{ab}} = \frac{a(a+1) + ab}{a+b + 1} = \frac{a(a+b + 1)}{a+b+1} = a\)

<ins>Aside  \(\quad\rightarrow\quad\)  **Example:**  </ins> The sequence \((u_n)\), given by \(u_1 = a\), \(u_2 = b\), \(u_n = \frac{u_{n-1} + 1}{u_{n-2}}\) \((n \geq 3)\), therefore repeats itself after \(5\) terms  \(\quad\rightarrow\quad\)  **Example:**   \(a\), \(b\), \(\frac{b+1}{a}\), \(\frac{a+b+1}{ab}\), \(\frac{a+1}{b}\), \(a\), \(b\), \(\cdots\). It is an interesting exercise, beyond the scope of school algebra, to 'explain' this phenomenon!

## 15 Quadratic equations

### 15.1 Solution by factorising


\(6x^2 - 11x - 2 = 0 \rightarrow (x-2)(6x+1) = 0 \rightarrow x = 2\) or \(-\frac{1}{6}\)
 

### 15.2 Completing the square of a quadratic expression

No number in front of the \(x^2\)  \(\quad\rightarrow\quad\)   **Example:**  \(x^2 + 5x + 3 = \left(  x + \frac{5}{2} \right)  ^2 - \frac{13}{4}\)

Number in front of the \(x^2\)  \(\quad\rightarrow\quad\)   **Example:**  \(2x^2 - 3x + 5 = 2 \left(  x - \frac{3}{4} \right)  ^2 + \frac{31}{8}\)


### 15.3 Solution by completing the square

\(x^2 + 5x + 3 = 0 \rightarrow x + \frac{5}{2} = \pm \frac{\sqrt{13}}{2} \rightarrow x = -\frac{5}{2} \pm \frac{\sqrt{13}}{2}\)

General case ('the formula')   \(\quad\rightarrow\quad\)   **Example:**  \(ax^2 + bx + c = 0\) 
\((a \neq 0) \rightarrow x = \frac{-b \pm \sqrt{b^2 - 4ac}}{2a}\)

Prior rearrangement involved \(\quad\rightarrow\quad\)   **Example:**  \(\frac{1}{x-2} - \frac{1}{x+5} = \frac{7}{18}\)

### 15.4 The three kinds of behaviour and corresponding graphical interpretation


\(b^2 > 4ac\) - two roots 
![graph of y=x^2+5x+3](..\..\..\content\yx25x3.svg)

\(b^2 = 4ac\) - one root 
![graph of y=-x^2+4x-4](..\..\..\content\yx24x4.svg)

\(b^2 < 4ac\) - no (real) roots
![graph of y=x^2-2x+2](..\..\..\content\yx22x2.svg)

### 15.5 Simultaneous equations, one linear and one quadratic

Direct substitution from linear equation into quadratic equation \(\quad\rightarrow\quad\)   **Example:**  \(x^2 + y^2 = 10\), \(y = 2 - x\)

Prior rearrangement involved \(\quad\rightarrow\quad\)   **Example:**  \(x^2 - xy + y^2 = 13\), \(2x - 3y = 5\) 