# HELM: Helping Engineers Learn Mathematics

HELM (Helping Engineers Learn Mathematics) materials aimed to enhance the mathematical education of engineering undergraduates through a range of flexible learning resources in the form of Workbooks and web-delivered interactive segments.  HELM materials were originally developed through a three-year curriculum development project led by [Loughborough University](https://www.lboro.ac.uk/departments/mlsc/student-resources/helm-workbooks/), between October 2002 September 2005.  Starting in 2020 these materials were converted to STACK questions and are now released as quizzes, mapped to the original workbooks.

For more information about the original project, see original [Workbook 50: Tutor’s Guide](https://www.lboro.ac.uk/media/media/schoolanddepartments/mlsc/downloads/HELM%20Workbook%2050%20Tutor's%20Guide.pdf).

As of December 2025, about two-thirds of the original HELM workbooks were converted to STACK.  If there is demand for the remaining workbooks they will be added later.

Individual questions, directories of related questions, and quizzes with basic structure, can be imported into Moodle through the STACK question library.

HELM question banks are managed using [Gitsync](https://github.com/maths/moodle-qbank_gitsync).

## HELM Workbooks List

1. Basic Algebra
2. Basic Functions
3. Equations, Inequalities & Partial Fractions
4. Trigonometry
5. Functions and Modelling
6. Exponential and Logarithmic Functions
7. Matrices
8. Matrix Solution of Equations
9. Vectors
10. Complex Numbers
11. Differentiation
12. Applications of Differentiation
13. Integration
14. Applications of Integration 1
15. Applications of Integration 2
16. Sequences and Series
17. Conics and Polar Coordinates
18. Functions of Several Variables
19. Differential Equations
20. Laplace Transforms
21. z-Transforms
22. Eigenvalues and Eigenvectors
23. Fourier Series
24. Fourier Transforms
25. Partial Differential Equations
26. Functions of a Complex Variable
27. Multiple Integration
28. Differential Vector Calculus
29. Integral Vector Calculus
30. Introduction to Numerical Methods
31. Numerical Methods of Approximation
33. Numerical Boundary Value Problems
32. Numerical Initial Value Problems
34. Modelling Motion
35. Sets and Probability
36. Descriptive Statistics
37. Discrete Probability Distributions
38. Continuous Probability Distributions
39. The Normal Distribution
40. Sampling Distributions and Estimation
41. Hypothesis Testing
42. Goodness of Fit and Contingency Tables
43. Regression and Correlation
44. Analysis of Variance
45. Non-parametric Statistics
46. Reliability and Quality Control
47. Mathematics and Physics Miscellany
48. Engineering Case Studies (Not converted to STACK)
49. Student’s Guide (Not converted to STACK)
50. Tutor’s Guide (Not converted to STACK)
