# The STACK question library

STACK is distributed with a library of over 4200 questions.

* Examples are tied to documentation and to demonstrate features.
* Templates for particular types of problems, e.g. drag and drop Parsons proofs
* Collections of questions for particular groups of students, e.g. engineering students.

Individual question files can be imported via the STACK library page. 

1. Create a new STACK question in your required question category. 
2. On the question edit form click on the 'STACK question library' link. You can then browse and import questions.

The question files are contained in the STACK source code under

     /qtype_stack/samplequestions/stacklibrary

This directory contains sub-directories with large libraries of questions, some of which arose from specific projects:

* `HELM` provides [comprehensive workbooks for engineering undergraduates](HELM.md).  Question numbers are linked to the original workbooks.
* `Algebra-Refresher` contains elementary algebra questions to cover all parts of the [The Map of Algebraic Manipulation](Algebra_refresher.md). Question numbers are linked to the map.
* `Calculus-Refresher` contains questions to cover all of the [Calculus Refresher](https://docs.stack-assessment.org/static/final0502-calc-ref-ukmlsc.pdf) by Dr Tony Croft and Dr Anthony Kay.
* `Introductory-Mathematics` is a comprehensive course of mathematics questions for students at the upper level of school or the transition to university. 
* `Topics` contains questions on a variety of mathematical topics.

The following directories are linked to documentation and templates

* `Doc-Examples` contains questions linked to documentation pages.  These are not intended as exemplar questions!  (They may be incomplete, and illustrate a starting point for an exercise for question authors to complete.) This is split by documentation section.
* `Features` contains questions to illustrate the features of STACK such as different input types.  These are intended as exemplar questions.
* `Templates` contains questions which are templates for question authors to use. They should require a small amount of editing to make them into a complete tailored question.

A significant advantage of using questions from the STACK library is that they are distributed with the source code, and therefore use features which match your version of STACK.  Consider using [Gitsync](https://github.com/maths/moodle-qbank_gitsync) to manage large question banks.

# Moodle courses released with STACK #

STACK is released with a demonstration course.

     /qtype_stack/samplequestions/STACK-demo.mbz

We have also release a course containing all the HELM materials, which are comprehensive courses in engineering mathematics.

     /qtype_stack/samplequestions/HELM_Sept_23.mbz

You can "restore" these into your version of Moodle.  It has a number of quizzes, pre-created with questions and deployed variants.  It also has a large question bank, with questions not arranged into quizzes.

# Open Educational Resources #

* The FETLAR project released a large collection of STACK questions in English covering calculus and algebra in April 2010.  These materials have been redeveloped are now part of the STACK library.
* Abacus is a material bank for STEM education which seeks to produce, share and host high-quality educational material between collaborators.  For more information see [https://abacus.aalto.fi/](https://abacus.aalto.fi/) 