# Vectors

## Student input

Students do find typing in matrices very tedious.  The convenient notation

    c(1,2,3)

for column vectors and

    r(1,2,3,4)

for row vectors is provided.  By default, these will display as \(c(1,2,3)\) and \(r(1,2,3,4)\), but TeX support (e.g. for student input) is provided by the `stack_linear_algebra_declare(true)` function. If this function is included in the question variables, either by a teacher including it directly or by including one of the linear algebra contributed libraries, they will instead display as column or row vectors as expected. 

Once converted into matrices, the student's answer will be evaluated by PRTs as matrices.  Of course, this will not be reflected in the valuation.

* `vec_convert(ex)` Attempts to convert `c` and `r` convenience functions into matrices. If the expression contains multiple `c` and `r` terms that do not conform, the original expression is returned.
* `vec_convertedp(ex)` A predicate function that checks whether `c` or `r` is present. This is useful in a PRT to ensure that an earlier conversion was successful (i.e. everything conforms) before continuing.
* `un_vec_convert(ex)` Given a row or column vector, convert it to `c()` or `r()` form.

## Vectors as single entities

It is very useful to treat vectors as a single entity.  The vector `stackvector(a)` and the atom `a` are different, and are not considered algebraically equivalent.  While students may type in `stackvector(a)` as an answer, they are likely to type in `a`.  The teacher can either (1) add in `stackvector` ephemeral forms to the student's answer in the feedback variables using `texboldatoms` or (2) remove all `stackvector` forms from the teacher's answer by using the `destackvector(ex)` function on their answer.  In the future we may have an option in the input to apply texboldatoms to student's expressions.

The display of the ephemeral form of `stackvector` is controlled by the function `stackvectortex`, e.g. you can display vectors differently using the following examples.

    stackvectortex(ex):= block(sconcat("{\\bf \\vec{", tex1(first(args(ex))), "}}"));
    stackvectortex(ex):= block(sconcat("{\\bf \\underline{", tex1(first(args(ex))), "}}"));

which should go in the question variables.

Any `texput` commands in the question variables now become "context variables" and will be available to the inputs. So, if in the context of your question you would like a variable such as `x` to be considered as a vector and displayed as a vector you can add one of the following to the question variables.

    texput(x, "\\mathbf{\\vec{x}}");
    texput(x, "\\mathbf{\\underline{x}}");

Whenever `x` is then displayed in any part of the question, including the student's input validation or feedback generated by the answer tests, we will have the updated tex for this atom.  E.g.

    texput(x, "\\mathbf{\\vec{x}}");
    texput(y, "\\mathbf{\\vec{y}}");

and a student types in `a*x+b*y` then the tex output will be \(a\cdot \mathbf{\vec{x}}+b\cdot \mathbf{\vec{y}}\).


* `texboldatoms(ex)` Displays all non-numeric atoms in bold.  Useful for vector questions.


## Inline i,j,k notation

If you are trying to use the vector notation such as \(3i+4j\) you will probably want to redefine \(i\) to be an abstract symbol, not a complex number.
More information on this is given under [Numbers](../../CAS/Numbers.md).  In particular, use the question level option "Meaning and display of sqrt(-1)" value `symi` to stop interpreting `i` with `i^2=-1` and return it to being an abstract symbol.

Another way to do this is to create matrices as follows:

    ordergreat(i,j,k);
    %_stack_preamble_end;
    p:matrix([-7],[2],[-3]);
    q:matrix([i],[j],[k]);

Now we can use the dot product to create the vector.  The STACK function `texboldatoms` wraps all atomic variable names in the ephemeral function `stackvector`, which is typeset in bold.

    v:texboldatoms(dotproduct(p,q));

If you turn the option "Multiplication sign" to none, this should display as
\[-7\,{\bf{i}}+2\,{\bf{j}}-3\,{\bf{k}}\]
Notice the use of the function `ordergreat`.  `ordergreat` can only be used once at the beginning of the question.

If you use the special constant `%_stack_preamble_end;` then anything before this constant will be available everywhere in the question, including the inputs.




