# Mathematical topics

This section of the STACK documentation contains information on how to author questions in particular mathematical topics.  Many topics have different requirements, e.g. physics needs support for scientific units.  These pages contain know-how on linking together features such as [inputs](../Authoring/Inputs/index.md), [answer tests](../Authoring/Answer_Tests/index.md) and [options](../Authoring/Question_options.md) to write questions in particular subject areas.

* [Curve sketching](Curve_sketching.md)
* [Differential equations](Differential_equations/index.md)
* [Discrete mathematics](Discrete_mathematics.md)
* String similarity via the [Levenshtein distance](Levenshtein_distance.md)
* [Linear algebra](../Topics/Linear_algebra/index.md)
* [Propositional Logic](Propositional_Logic.md)
* [Scientific Units](Units.md)
* [Vector Calculus](Vector_Calculus.md)
* [Proof](../Topics/Proof/index.md).

There is separate documentation on [specialist tools](../Specialist_tools/index.md), such as those needed for, drag and drop (Parsons problems), graphical interaction and so on.  Specialist tool documentaion is not linked to a single mathematical topic, but rather to a technical tool.

The stack question library contains many examples in directories matching the structure of the documentation.