# 問題作成クイック・スタート 1: 動作する最小限の問題

1 - 基本的な問題 | [2 - 問題変数](Authoring_quick_start_2.md) | [3 - フィードバックを改善する](Authoring_quick_start_3.md) | [4 - ランダム化](Authoring_quick_start_4.md) | [5 - 問題のテスト](Authoring_quick_start_5.md) | [6 - 複数解答欄問題](Authoring_quick_start_6.md) | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)

問題作成クイック・スタート・ガイドはSTACKでの問題の作成方法を紹介します。
パート1では動作する最小限の問題を作成します。次のビデオでそのやり方を説明します：


<iframe width="560" height="315" src="https://www.youtube.com/embed/cpwo-D6EUgA" frameborder="0" allowfullscreen></iframe>
## 始めに

以下を仮定します:

1. STACKがインストールされたコースに教師としてアクセスできること。
2. 簡単な数式の\(\LaTeX\)記法に慣れていること。
いくつかの基本的な例は，[CASText](../../en/Authoring/CASText.md) ドキュメントに記載されています。

## 最小限の問題を作成する

あなたのコースに移動し，[問題バンク](../../en/Moodle/Question_bank.md)で，「新しい問題を作成する」から「STACK」問題タイプを選択して「追加」をクリックしてください。

たくさんの設定項目がありますが，必須な項目はほんの一部です。

1. 「問題名」
2. 生徒に表示される「問題テキスト」
3. 「正解」（デフォルトの問題では「解答欄: ans1」にあります）
4. 解答の評価方法

デフォルトでは，新しい問題は自動的に1つの[入力](../../en/Authoring/Inputs.md)と，解答を評価するための1つのアルゴリズムが設定されています。

### 問題名 ###

`問題1`のような問題名を設定してください。

### 問題テキスト ###

\((x-1)^3\)を\(x\)について微分する問題について考えましょう。
まずは問題文そのものを書く必要があります。以下を問題テキストの入力ボックスにコピーしてください（2行目は最初から用意されています）。

    \((x-1)^3\)を \(x\) について微分しなさい。
	[[input:ans1]] [[validation:ans1]]

補足:

* Moodle には幅広いテキストエディタの選択肢があるため，このクイック・スタート・ガイドのスクリーンショットはあなたが使用する Moodle とは若干表示が異なるかもしれません。また，コピーするテキストは整形されている場合があります。
* テキストは LaTeX の数式環境を含みます。数式環境`$..$`と`$$..$$`は使用しないでください。 代わりに，インライン数式と別行立て数式にはそれぞれ`\(..\)`と `\[..\]`を使ってください。(古い教材がたくさんある場合，Moodle qtype_stackプラグインページに自動一括変換機能があります)
* 内部的には生徒の解答は変数 `ans1` に代入されます。
* タグ`[[input:ans1]]`は生徒が解答を入力するテキストボックスの位置を表します。
* タグ`[[validation:ans1]]`は，入力`ans1`のバリデーションに関するフィードバックに置き換えられます。例：括弧の欠落による構文エラー
* これらのタグは問題テキストのどこにでも配置できます。

## 解答欄: ans1

下にスクロールすると，[入力](../../en/Authoring/Inputs.md)セクションの編集フォームがあります。見出し`解答欄: ans1`をクリックすると，関連する設定が表示されます。

最小限の問題のために，__正解__ を指定する必要があります。ここでは「正解」欄に以下のように設定しましょう。

    3*(x-1)^2

補足

1. 生徒の解答は解答変数 ans1 に格納されます。
2. 正解はLaTeXではなく，CAS（Maxima）の構文で有効な式である必要があります。特に，乗算は `*` を使って明示的に指定しなければなりません。
3. [入力](../../en/Authoring/Inputs.md)は，様々な解答形式をドロップダウンメニューから選択することができます。デフォルトは __数式__ で，今回はこれを利用します。
4. 問題は複数の解答欄を持つことができます。これについては後のパートで説明します。

## 解答の正しさを評価する - ポテンシャル・レスポンス・ツリー (PRT)

次は，学生の解答が正しいかどうかを判断する必要があります。

生徒の解答を採点するには，[ポテンシャル・レスポンス・ツリー](../../en/Authoring/Potential_response_trees.md)と呼ばれるアルゴリズムを使って，解答の数学的性質を評価する必要があります。

デフォルトでは，新しい問題は`prt1`という名前の[ポテンシャル・レスポンス・ツリー](../../en/Authoring/Potential_response_trees.md)を持ちます。ツリーによって生成されたフィードバックは適切なタイミングでタグ`[[feedback:prt1]]`を置き換えます。

### ポテンシャル・レスポンス・ノードの設定

ポテンシャル・レスポンス・ツリーは，__ポテンシャル・レスポンス・ノード__ からなる空でない非循環有向グラフで，デフォルトでは，ポテンシャル・レスポンス・ノードは1つです。「ポテンシャル・レスポンス・ツリー:prt1」のノード1の基本的な説明は以下の通りです。

1. `評価対象`は評価関数によって`評価基準`と比較されます。オプションをつけることも可能です。
2. もし`真`なら真の場合の分岐を実行します。
3. もし`偽`なら偽の場合の分岐を実行します。

各分岐では以下のことができます。

* 点数を割り当て/更新する。
* 学生に形成的[評価](../../en/Authoring/Feedback.md)を割り当てる。
* 統計[レポート](../../en/Authoring/../STACK_question_admin/Reporting.md)用に[解答記録](../../en/Authoring/Potential_response_trees.md#Answer_note)を残す。
* 次のポテンシャル・レスポンス・ノードに進むか，`[stop]`で処理を終了する。

生徒が正しく振り分けられたどうかを判断するために，最初のノード（ノード1）を構成してみましょう。

1. `評価対象`に変数`ans1`を指定する。
2. `評価基準`に正しい解答，すなわち`3*(x-1)^2`を設定する。
3. __評価関数__ のドロップダウンメニューに`代数等価`があることを確認する。(デフォルトで設定されています。)

## 問題を保存する

ページを一番下までスクロールし，`[変更を保存して編集を続ける]`をクリックしてください。 質問の保存に失敗した場合は，間違いがないかよく確認し，修正して再度保存してください。

__これで最小限の問題が完成しました。__

要約すると，以下を設定しました

1. 「問題名」
2. 「問題テキスト」
3. 模範解答である「正解」
4. 解答の評価方法

次に，ページの下部にある「プレビュー」を押して，問題をテストしてみましょう。

![プレビューボタン](../../content/preview_button.png)   

## 問題のプレビュー

テストをスピードアップするため，プレビューウィンドウをスクロールし，「Attempt options」または「プレビューオプション」 (moodleのバージョンに依存します) の中にある，「問題動作」が「アダプティブモード」に設定されていることを確認してください。そして，「これらのオプションで再開する」を実行してください。これにより，「送信して終了する」と「再開する」を繰り返すことなく，あなたの解答を確認することができます。

プレビューを開いた状態で，次のように解答欄に入力してみてください。

    3*(x-1)^2

システムはまず，この解答の構文的妥当性を確認します。

`チェック`ボタンを押します。

システムはポテンシャル・レスポンス・ツリーを実行し，あなたの解答が模範解答 `3*(x-1)^2` と等価かどうかを確定します。

## 学生の解答の評価

学生が解答の評価には，2段階のプロセスがあることに注意してください。

第一段階は「バリデーション」です。通常，サーバーは「インスタント検証」を有効にしています。 式が構文的に有効な場合，STACKは生徒に「あなたの入力した数式は次のとおりです :」と表示し，その式を表示します。 無効な回答はエラーメッセージを表示します。

第2段階は有効な式が送信されたときに実行され，学生の解答がポテンシャル・レスポンス・ツリーによって評価されます。

この2段階のプロセスはSTACKに固有の不可欠な特徴です。 学生を助けるために，検証のオプションがたくさんあります。 例えば，上記の例題では，すべての式は厳密な構文に従っています。例えば`3*(x-1)^2`のような式を用い，記号`*`で掛け算を表しました。生徒が `3(x-1)^2` のような式を入力したとき，暗黙の掛け算を解釈するようにすることもできます。しかし，「正解」の入力は曖昧さを避けるために常に厳密でなければならないことに注意してください。これらのオプションに関するドキュメントは[入力](../../en/Authoring/Inputs.md)セクションにあります。

# 次のステップ #

これでSTACKで簡単な問題を作ることができるようになりました。


##### 問題作成クイック・スタート・ガイドの次のパートでは，[問題変数](Authoring_quick_start_2.md)の使用について説明します
