# 問題作成クイック・スタート・ガイド 3：フィードバックを改善する

[1 - 基本的な問題](Authoring_quick_start_1.md) | [2 - 問題変数](Authoring_quick_start_2.md) | 3 - フィードバックを改善する | [4 - ランダム化](Authoring_quick_start_4.md) | [5 - 問題のテスト](Authoring_quick_start_5.md) | [6 - 複数解答欄問題](Authoring_quick_start_6.md) | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)



問題作成クイック・スタート・ガイドのこのパートでは、フィードバックの改善について扱います。次のビデオでそのやり方を説明します：

<iframe width="560" height="315" src="https://www.youtube.com/embed/l6QAMmUA5Pk" frameborder="0" allowfullscreen></iframe>

## はじめに
直前のパートでは,問題変数を扱いました。具体的には,被積分関数を表す変数`exp`を定義し,正答を表す変数taを定義しました。そして,\(\int 3(x-1)^{-4}dx\)を求めさせました。

この問題のプレビューを表示し, `-1*(x-1)^(-3)+c`の解答を入力してください。システムはこの解答を正解と判定します。次に, `-1*(x-1)^(-3)+C`（`C`が大文字）の解答を入力してください。正答の`-1*(x-1)^(-3)+c`と比較し, ポテンシャル・レスポンス・ツリーの評価関数で「代数等価」を指定していたので，正答とはみなされません。理由は`c`と`C`は異なるからです。通常，定数の文字に何が用いられるかは問わないでしょう。この問題を解決します。

## 評価関数: 積分
より良い「評価関数」を用いるように，ポテンシャル・レスポンス・ツリーを修正する必要があります。問題の編集画面に戻り，ポテンシャル・レスポンス・ツリーの「評価関数」のプルダウンメニューで、「代数等価」から「積分」に変更してください。そして，オプション欄に`x`（変数）を入力してください。「変更を保存して編集を続ける」をクリックし，もう一度プレビューを実行してみましょう。

評価関数「積分」では，積分定数にどのような文字でも正答と判定します。例えば,`-(x-1)^(-3)+k` と入力してみてください。正答と判定されます。また,学生が積分の定数を忘れたり,誤って積分の代わりに微分した場合，標準的なフィードバックを与えます。これを試すには,`-12*(x-1)^(-5)`と入力してみてください。フィードバックを学生に見せたくない場合は,「抑制」オプションで「Yes」を選択してください。

`解答記録`は評価結果に対し付けられる名前です。STACKはこの名前を，ポテンシャル・レスポンス・ツリーの名前，ノード番号，ノードの結果にから自動的に生成されます。

## 考察
STACKで学生の解答をチェックするとき,教師は "学生の答えを正解/不正解にする数学的特性は何か"を問わなければいけません。今回の場合,この問は以下を含みます:

- 解答は被積分関数の不定積分か?
- 解答には積分定数が含まれているか？

評価関数`積分`がこれらの問に答え,教師この問に対応するためのコードを書く必要はありません。

次に,教師は "学生が何を間違う可能性があり,その結果どのような解答となるのか？"を問わなければいけません。この質問はより難しいです。それに対する回答は,経験を通じて,または前もって診断的な質問をすることによって得られるかもしれません。年度ごとにSTACKの問題での学生の解答を見直し,経験に照らしてより良いフィードバックを組み入れると良いでしょう。

## フィードバックをさらに改良する

学生が犯しそうなミスごとに,解答例を作成することができます。例えば,学生が解答の数式を展開したままにしておくとします。これはもちろん正しい答えかもしれませんが，不必要に答えを展開しないように学生を指導したいこともあります。学生が最終的な解答を因数分解した形で残したかどうかを判定する別のノードを作成し，ポテンシャル・レスポンス・ツリーの新たなノードとして追加します。

![Adding a new node](../../content/add_new_node.png)

ポテンシャル・レスポンス・ツリーに移動し,`[新しいノードを追加する]`をクリックします。次にノード 1 の `真の場合`のブランチで `次のノード` を `ノード2`に変更します。ノード2に入ったということは，学生の解答は正答であることはわかっているので，解答が因数分解されているかどうかを判定することにします。これを実現するために[評価関数](../../en/Authoring/Answer_Tests/index.md)「因数分解」を使用する必要があります。これは評価対象と評価基準が等価であることと,評価対象が因数分解されていることの両方をテストします。この問題の場合,我々はすでに学生の解答が正答と等価であることを知っています（評価関数「積分」を使用）。したがって,学生の解答自身に対してテストするだけで良いのです。

ノード2のフォームを次のようにします。
```
評価関数 = 因数分解
評価対象 = strip_int_const(ans1,x)
評価基準 = strip_int_const(ans1,x)
オプション = x
```
STACKでは,学生が使用した積分定数を削除するstrip_int_const関数が提供されています。なお，オプションで変数を指定する必要があります。

`真`と`偽`の結果で点数を変えないようにしてください。デフォルトではそれぞれ+0と-0に設定されます。点数を変更しないことで，学生の解答が展開されていても、減点されないようにします。

評価関数「因数分解」は自動的にフィードバックを返しますが，自分で書きたい場合は，「抑制」をYesに設定し，ノード2の偽のフィードバックに次のように入力します：

```
あなたの解答は因数分解されていません。正解ですが,括弧を展開する必要はないことに注意してください。
```
多くの一般的な間違いに対して，いくらでもチェックしながら，ポテンシャル・レスポンス・ツリーを拡大することができます。その他の評価関数については[ドキュメント](../../en/Authoring/Answer_Tests/index.md)を参照してください。

## 一般的なフィードバックを追加する

一般的なフィードバックは問題の正誤に関わらず,すべての学生に表示されます。ここは模範解答を追加するときに活用してください。

# 次のステップ

以上で，STACKで様々なフィードバックを作成できるはずです。

##### 問題作成クイック・スタート・ガイドの次のパートは[ランダム化](Authoring_quick_start_4.md)についてです。