# 問題作成クイック・スタート・ガイド 6: 複数解答欄問題

[1 - 基本的な問題](Authoring_quick_start_1.md) | [2 - 問題変数](Authoring_quick_start_2.md) | [3 - フィードバックを改善する](Authoring_quick_start_3.md) | [4 - ランダム化](Authoring_quick_start_4.md) | [5 - 問題のテスト](Authoring_quick_start_5.md) | 6 - 複数解答欄問題 | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)



問題作成クイック・スタート・ガイドのこのパートでは，複数解答欄問題について扱います。次のビデオでそのやり方を説明します：

<iframe width="560" height="315" src="https://www.youtube.com/embed/lQhDEnEYZQM" frameborder="0" allowfullscreen></iframe>
次の例を考えてみましょう：

### 例1

点\(x=2\)で\(x^3-2x^2+x\)に接する直線の方程式を求めよ。

1. \(x^3-2x^2+x\)を\(x\)で微分せよ。
2. \(x=2\)での微分係数を計算せよ。
3. 接線の方程式を求めよ。\(y=...\)

上の3つの小問はすべて1つの多項式\(x^3-2x^2+x\)を参照するので,ランダムに生成された問題が使用される場合,それらの小問はそれぞれ1つのランダムに生成された数式を参照する必要があります。したがって,小問1-3の解答は実際には1つの数式に依存します。ここで,小問1は他から独立していることに注意してください。小問2の解答には小問1の解答に\(x=2\)を代入する必要があります。小問3は独立して採点することも，小問1と2を考慮することも簡単にできます。教師は「依存」採点を選択できることにも注意してください。

### 例2

比較的若い学生を対象にした次の問題を考えてみましょう。

\((x+1)(x+2)\)を展開せよ。

解答方法として,次の方程式の「空欄を埋める」方法が考えられます：

```
(x+1)(x+2) = [?] x2 + [?] x + [?].
```

私たちは,この問題を「3つの入力」を持つ「1つの質問」であると解釈します。さらに, それぞれの入力 (係数) に対して別々のフィードバックが生成されたとしても,教師はフィードバックが割り当てられる前に,学生にすべて穴埋めしてほしいでしょう。また, このフィードバックはすべて画面上の1つの場所にグループ化されるべきです。そして,代数的ミスの可能性のある原因を特定するために, 自動採点のためにすべての係数が入力されている必要があります。3つの解答欄を独立に採点することはあまり意味がないでしょう。

この2つの例は,2つの対立的な評価方法を示しています。

1. 複数解答欄内のすべての入力は独立して評価できる。
2. 複数解答欄内のすべての入力は, その問題が採点される前に完了しなければならない。

この2つの評価方法を満たす複数解答欄問題を考案することは比較的簡単ですし, これらのの複数解答欄問題はより一般的であるとも考えられます。

## 複数解答欄問題の質問を作成する

新しいSTACKの問題作成を開始し，「接線」などの名前をつけてください。この問題には3つの小問があります。次のように，問題変数と問題テキストをコピーすることから始めます。この問題はランダム化を含んでいませんが，後の段階の簡単化のために，最初に変数名を使用していることに注意してください。

__問題変数:__

```
exp:x^3-2*x^2+x;
pt:2;
ta1:diff(exp,x);
ta2:subst(x=pt,ta1);
ta3:remainder(exp,(x-pt)^2);
```

__問題テキスト__

以下のテキストをエディターにコピーしてください。

	点\(x={@pt@}\)で{@exp@}に接する直線の方程式を求めよ。
	1. {@exp@}を\(x\)で微分せよ。[[input:ans1]] [[validation:ans1]] [[feedback:prt1]]
	2. 1の結果を用いて、\(x={@pt@}\)での微分係数を計算せよ。[[input:ans2]] [[validation:ans2]] [[feedback:prt2]]
	3. 接線の方程式を求めよ。\(y=\)[[input:ans3]] [[validation:ans3]] [[feedback:prt3]]

「個別フィードバック」セクションからフィードバックタグを削除し、「問題テキストのチェックと入力フォームの更新」をクリックしてください。STACKは，解答欄，フィードバックタグを自動的に検出して，3つの解答欄とポテンシャル・レスポンス・ツリーが作成されます。問題テキストでは、フィードバックが関連する部分の下に直接表示されるように，フィードバックタグを埋め込んでいます。それぞれの小問に対して，1つのポテンシャル・レスポンス・ツリーがあることに注意してください。

解答欄：`ans1`から解答欄：`ans3`の「正解」に，それぞれ`ta1`から`ta3`を入力してください。

次にポテンシャル・レスポンス・ツリーを編集する必要があります。これらは学生の解答の評価を設定します。

### ステージ1: ポテンシャル・レスポンス・ツリー

最初の段階は，最も単純なポテンシャル・レスポンス・ツリーを作成することです。これらは単純に答えが「正しい」かどうかを評価します。各ポテンシャル・レスポンス・ツリー：`prti`のそれぞれで，`ansi`が`tai`と代数的に等価であるかどうかを評価します（ただし、`i`は`1`から`3`としてください）。この段階で，実用的な問題ができたでしょう。「変更を保存して編集を続ける」をクリックして、問題をプレビューしてください。参考までに，正解は以下の通りです。

```
 ta1 = 3*x^2-4*x+1
 ta2 = 5
 ta3 = 5*x-8
```

### ステージ2: 依存採点

次に，シンプルな依存採点を実装します。

小問2を注意深く見てください。これは「正解」を求めていると同時に，学生が小問1の結果を用いて，与えられた点で正しく微分係数を計算できたかどうかも評価しています。したがって最初の課題は，小問1で与えられた数式を与えられた点で評価し，`ans2`と比較することです。`prt2`のノード1を以下のように更新します：

```
評価関数: 代数等価
評価対象: ans2
評価基準: subst(x=pt,ans1)
```

次に，`prt2`で，「新しいノードを追加する」をクリックして，に以下のノード（ノード2）を1つ追加します：

```
評価関数: 代数等価
評価対象: ans1
評価基準: ta1
```
そして，ノード1の真の分岐を（`prt2`の）ノード2につなぎます。これで3つの結果が得られます。

ノード1：小問1の結果を，与えられた点で正しく評価したか？もし "真"ならノード2に進み，"偽"なら0点で終了する。

ノード2：小問1の結果は正解か？もし"真"なら，これが理想的な状況であり，満点である。もし"偽"なら，好みに応じて点数を選び，例えば、次のようなフィードバックを加える：

	小問1の結果に基づき，与えられた点での微分係数は正しく計算されています。しかし，小問1は不正解です。小問1，2をやり直しましょう。

# 次のステップ #

これでSTACKで複数解答欄問題を作成できるようになりました。これまで，このクイックスタートガイドに従ってきていれば，すでにこの問題を改善することができるでしょう。例えば, [フィードバックを改善する](Authoring_quick_start_3.md), [ランダム化](Authoring_quick_start_4.md), [問題のテスト](Authoring_quick_start_5.md)。

##### **問題作成クイック・スタート・ガイドの次のパートは[数式簡略の無効化](Authoring_quick_start_7.md)についてです。**