# 問題作成クイック・スタート 7: 数式簡略を無効化する

[1 - 基本的な問題](Authoring_quick_start_1.md) | [2 - 問題変数](Authoring_quick_start_2.md) | [3 - フィードバックを改善する](Authoring_quick_start_3.md) | [4 - ランダム化](Authoring_quick_start_4.md) | [5 - 問題のテスト](Authoring_quick_start_5.md) | [6 - 複数解答欄問題](Authoring_quick_start_6.md) | 7 - 数式簡略の無効化 | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)



問題作成クイック・スタート・ガイドのこのパートでは，数式簡略を無効化する方法を説明します。次のビデオでその手順を説明します：

<iframe width="560" height="315" src="https://www.youtube.com/embed/Et1O2dibsDI" frameborder="0" allowfullscreen></iframe>
### 例題

複素数\(z=ae^{ib}\)が与えられたとき，\(z^{n}\)を求めなさい。

ここで，\(a,b,n\)はランダムに生成された数とします。

## 数式簡略の無効化

このような問題を作るとき，__表示の段階で__ 制御したくなります。私たちはすでにランダム化の方法を知っているので，a，b，nをランダムに生成し，問題文に埋め込むことができます。 例えば次のようにします:

```
 \(({@aa@}e^{{@bb@} i})^{@nn@}\)
```
ここでは，複素数のためにCASオブジェクトを1つ作るのではなく，各変数を別々に扱っています。 これは問題ないのですが，CASとLaTeXの記法が混在しているため読みにくくなっています。

したがって，数式簡略されない1つのCASオブジェクトにすべてを持たせる方がはるかに望ましいです。以下は単一のMaximaの式です：

```
 {@(aa*%e^(bb*%i))^nn@}
```

(2文字以上の変数名を使っていることに注意してください。これは良い習慣です。1文字の変数は学生の入力のためのものだからです。また，Maxima で記述するとき，標準的な数学記号の前に `%` をつけていることにも注意してください。これは必須ではありませんが，良い習慣であると考えられています。)

もちろん，Maximaにべき乗を計算して欲しいわけではなく，__そのまま__ 表示してほしいと思っています！違いを見るために，以下のSTACK問題の問題変数にコピーしてください：

```
simp:true;
a1: (3*%e^(%i*%pi/2))^4;
simp:false;
a2: (3*%e^(%i*%pi/2))^4;
```

次に問題テキストのどこかに`簡略化する: {@a1@} 簡略化しない: {@a2@}`と入力します。`simp:true;`と`simp:false;`による違いをプレビューで確認してください。

表示のレベルではなく，CASのレベルで問題を解決する方がよいことがよくあります。問題全体で`simp:false`を設定するようにSTACKに指示するには，フォームの一番下までスクロールし，`オプション`の下で`自動簡略化（全般）`を`No`に設定します。これでMaximaは表示する前に式を簡略化しないので，`{@2+5@}`は `7` ではなく `2+5` として表示されます。

これには欠点もあります。問題全体で数式簡略を無効化した場合，今度は明示的に簡略化させる必要があります！これをするには2つの方法があります。1つ目は，以下のようなコマンドを使うことです：

```
aa : ev(2+rand(10),simp);
```

具体的には，問題変数は次のように定義できます。

```
aa : ev(2+rand(10),simp);
bb : ev(2+rand(10),simp);
nn : ev(2+rand(5),simp);
qq : (aa*%e^(bb*%i))^nn;
```

多くの連続した式を簡略化する必要がある場合，2つ目の方法が使えます：

```
simp : true;
aa : 2+rand(10);
bb : 2+rand(10);
nn : 2+rand(5);
simp : false;
qq : (aa*%e^(bb*%i))^nn;
```

### 単項演算子のマイナス
たくさんの変数を使って表示するのか，それとも`simp:false`を指定したほうがいいのかは，状況によって決まります。よくある問題は単項演算子のマイナスで起こります。`{@aa@}+{@bb@}を求めよ`のような問題テキストを考えてみましょう。`bb`\(<0\)の場合，式は例えば\(3+-5\)のように表示されてしまいます。 簡略化を無効化した場合でも，Maximaの表示ルーチンは(多くの場合)賢明な方法で単項演算子のマイナスに対処します。

# 次のステップ

これで，いつ数式簡略を無効化するべきかを判断できるようになったはずです。あなたがこのクイック・スタート・ガイドに従っているのであれば，この問題を改善するために実行できるいくつかの方法をすでに知っているはずです。
例えば，より[具体的なフィードバックを追加](Authoring_quick_start_3.md)したり，[問題をランダム化](Authoring_quick_start_4.md)したり，[問題のテストを追加](Authoring_quick_start_5.md)したりすることができます。

##### **問題作成クイック・スタート・ガイドの次のパートでは[小テストの作成](Authoring_quick_start_8.md)について説明します。**