# 問題作成クイック・スタート・ガイド 8: 問題のインポートと小テスト

[1 - 基本的な問題](Authoring_quick_start_1.md) | [2 - 問題変数](Authoring_quick_start_2.md) | [3 - フィードバックを改善する](Authoring_quick_start_3.md) | [4 - ランダム化](Authoring_quick_start_4.md) | [5 - 問題のテスト](Authoring_quick_start_5.md) | [6 - 複数解答欄問題](Authoring_quick_start_6.md) | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | 8 - 問題のインポートと小テスト

問題作成クイック・スタート・ガイドのこのパートでは,問題のインポートと小テストについて扱います。次のビデオでそのやり方を説明します：

<iframe width="560" height="315" src="https://www.youtube.com/embed/P3bDdNVC6g0" frameborder="0" allowfullscreen></iframe>

### はじめに

問題を作成したら,小テストに組み込みたくなるでしょう。サンプル問題を使用して小テストを作成することもできます。

このドキュメントは,初心者がSTACKを使用して,Moodleの小テストで数学の問題の作成する方法について説明します。このガイドはMoodle小テストのドキュメントと一部重複します。

これらはDr Maureen McIver, Department of Mathematical Sciences, Loughborough University, UK, July 2016が作成したメモを編集したものです。

### 問題の選択

小テストに使う問題を選ぶことから始めましょう。すでに作られている問題を編集して,目的に合うように修正することが一番簡単な方法です。

これまでの問題作成クイックスタートガイドに従って,ゼロから独自の問題を作っても良いでしょう。

### 既存のサーバから問題をインポートする

既存のサーバから問題をインポートする方法を確認しましょう。

まず,既存の問題をエクスポートする必要があります：

1. エクスポートしたい問題があるMoodlにログインし,管理ブロックの`問題バンク`をクリックしてください。次に`エクスポート`をクリックしてください。
2. `Moodle XMLフォーマット`をクリックし,エクスポートしたいカテゴリを選択します。Moodleでは個々のカテゴリのみエクスポートすることができます。
3. `問題をファイルにエクスポートする`をクリックしてください。これにより,そのカテゴリのすべての問題を含むファイルがダウンロードされます。

これらの問題をあなたのサーバにインポートします：

1. Moodleサーバであなたのコースにログインし,管理ブロックの問題バンクをクリックします。
2. `インポート`をクリックしてください。
3. `Moodle XMLフォーマット`をクリックし,あなたのインポートしたい?.xmlファイルをドラッグ＆ドロップし,`インポート`および`続行`をクリックします。問題のコピーがあなたのコースの問題バンクに表示され,自由に問題を変更することができます。

### Moodle小テストを作成する

問題バンクをインポートしたり，自分で問題バンクを作成したら,そこから問題をMoodleクイズに追加することができます。

これにより,学生がSTACKの問題に解答を入力する構文を練習するためのクイズを含めると良いかもしれません。

### 問題の動作

「問題の動作」は学生に与える受験回数および減点の分配方法を決定します。Moodle小テストでは多くの「問題の動作」を利用することができます。最も重要なものは次のとおりです。

**即時フィードバック**
学生に各問題を1回だけ受験させますが,問題に解答した直後,またはすべての問題が解答され,提出された場合のみフィードバックを与えます。これは標準的な小テストに便利です。

**遅延フィードバック**
学生に各問題を1回だけ受験させ,与えられた日付が過ぎるまでフィードバックを与えません。これは学生に解答を共有させたくない試験やコースワークの小テストに便利です。

**複数回の受験が可能なインタラクティブ問題**
学生に有限回の受験をさせることができ,それぞれの受験の後にヒントが表示されます。不正解の場合,ペナルティとしてが減点されます。受験回数は各問題に表示されるヒント回数より1回多く設定されていることに注意してください。ヒントは問題を編集する際,オプションセクションに表示されます。

**アダプティブ**
学生に好きなだけ受験させることができますが,学生が答えを間違えるたびに問題の合計得点から減点します。これは問題を確認したり、ドリルなど練習問題としての実施に便利です。

### 小テストの設定

1. Moodleページに移動し,`編集を有効にする`をクリックします。
2. 小テストを設置または追加したいブロックに移動し,`活動またはリソースを追加する`をクリックして,`小テスト`,`追加`の順にクリックします。
3. クイズに名前を付け,説明ボックスに好きな説明を入力してください。必要であれば,ここでLaTeXを使用することもできます。 
4. `タイミング`をクリックし,小テストの開始，終了時刻を設定してください。  
5. `評点`をクリックし,受験可能回数を設定してください。例えば,練習問題には無制限,コースワークの小テストには1回を使用することができます。
6. `問題の動作`をクリックし,上述したように希望する問題の動作を選択してください。
7. レビューオプションでは小テスト中または終了後に学生に閲覧を許可する項目を選択することができます。これには彼らの答えが正しいかどうか,評点およびフィードバックなどのオプションを含みます。練習問題とコースワーク小テストの両方で`正解`をオフにし,練習問題では`一般的なフィードバック`をオンにし,コースワーク小テストではオフにすることをお勧めします。
8. `保存`をクリックして終了し,コースに戻ります。 

`編集`および`表示する`をクリックすることで,学生に小テスト/トピックを表示するかどうか切り替えることができます。

注意: Moodleの問題集では自動的に小テストのカテゴリを作成します。小テストで使用されるすべての問題をこのカテゴリに分類することが良い場合もありますが,あなたが以前に小テストに移動した場合のみ,カテゴリが表示されることに注意してください。


### 問題を追加する

1. クイズをクリックし,クイズを編集します。

2. `追加`をクリックし,`問題バンクから`をクリックして,カテゴリを選択し,作成したスタック問題を1つまたは複数選択します。
3. `選択した問題を小テストに追加する`をクリックし,`保存`をクリックしてメインモジュールページに戻ります。

小テストをプレビューするには,小テストをクリックし,`今すぐ小テストをプレビュー`をクリックしてください。

### 追加時間

追加時間が必要な学生がいる場合,その学生を含むグループを設定する必要があります。以下は25%の追加時間が必要な学生のグループの例です。

1. `コース管理`で`ユーザ`,`グループ`,`グループの作成`の順にクリックします。
2. グループ名を「25%追加グループ」などとしてください。グループの説明欄に,誰のためのグループなのか詳細を記入することができます。`変更を保存`をクリックします。
3. `ユーザーを追加/削除`し,このグループの特定の生徒のIDをクリックし,追加をクリックしてグループに入れます。このグループに入れる必要のある学生全員に対してこの操作繰り返します。
4. 戻って`Moodle小テスト`をクリックしてください。小テスト管理で`グループオーバーライド`をクリックし,`グループオーバーライドを追加する`をクリックして,関連するグループを選択し,そのグループの小テストに適切な制限時間を設定し,保存をクリックしてください。

### 結果を見る

特定の小テストの結果を見るには,小テストを表示し,`小テスト管理`で`結果`,`評点`をクリックしてください。これですべての受験,総合評点および各問題の評点を見ることができます。結果をエクセルでダウンロードすることもできます。

# 次のステップ

これでMoodleで小テストを操作できるようになりました。

以上で問題作成クイック・スタート・ガイドを終了します。STACKドキュメントは包括的で,参照できることがたくさんあります。例えば,以下の例が挙げられます。

- [より多くの入力タイプについて学ぶ](../../en/Authoring/Inputs.md),
- [より多くの解答テストについて学ぶ](../../en/Authoring/Answer_Tests/index.md),
- [CASTextフィールド](../../en/Authoring/CASText.md)に[プロット](../../en/Plots/Plots.md)  を追加する
- [複数言語のサポートを追加する](../../en/Authoring/Languages.md),
- [等価推論の使用について学ぶ](../../en/Authoring/Equivalence_reasoning.md),
- [曲線スケッチについて読む](../../en/Topics/Curve_sketching.md).
- Maxima の構文や関数名にあまり詳しくない場合は,Maxima のドキュメントを参照してください。[wxMaxima](http://andrejv.github.com/wxmaxima/) のようなグラフィカルな Maxima インターフェースも,適切な Maxima コマンドを簡単に見つけるのに非常に役立ちます。