<?php
/*
 * Generated by PEG.js 0.10.x with phpegjs plugin
 *
 * http://pegjs.majda.cz/
 */


/* Useful functions: */

/* chr_unicode - get unicode character from its char code */
if (!function_exists("chr_unicode")) {
    function chr_unicode($code) {
        return html_entity_decode("&#$code;", ENT_QUOTES, "UTF-8");
    }
}
/* ord_unicode - get unicode char code from string */
if (!function_exists("ord_unicode")) {
    function ord_unicode($character) {
        if (strlen($character) === 1) {
            return ord($character);
        }
        $json = json_encode($character);
        $utf16_1 = hexdec(substr($json, 3, 4));
        if (substr($json, 7, 2) === "\u") {
            $utf16_2 = hexdec(substr($json, 9, 4));
            return 0x10000 + (($utf16_1 & 0x3ff) << 10) + ($utf16_2 & 0x3ff);
        } else {
            return $utf16_1;
        }
    }
}
/* peg_regex_test - multibyte regex test */
if (!function_exists("peg_regex_test")) {
    function peg_regex_test($pattern, $string) {
        if (substr($pattern, -1) == "i") {
            return mb_eregi(substr($pattern, 1, -2), $string);
        } else {
            return mb_ereg(substr($pattern, 1, -1), $string);
        }
    }
}

/* Syntax error exception */
if (!class_exists("SyntaxError", false)) {
    class SyntaxError extends Exception {
        public $expected;
        public $found;
        public $grammarOffset;
        public $grammarLine;
        public $grammarColumn;
        public $name;
        public function __construct($message, $expected, $found, $offset, $line, $column) {
            parent::__construct($message, 0);
            $this->expected = $expected;
            $this->found = $found;
            $this->grammarOffset = $offset;
            $this->grammarLine = $line;
            $this->grammarColumn = $column;
            $this->name = "SyntaxError";
        }
    }
}

class CTP_Parser {
    private $peg_currPos          = 0;
    private $peg_reportedPos      = 0;
    private $peg_cachedPos        = 0;
    private $peg_cachedPosDetails = array('line' => 1, 'column' => 1, 'seenCR' => false );
    private $peg_maxFailPos       = 0;
    private $peg_maxFailExpected  = array();
    private $peg_silentFails      = 0;
    private $input                = array();
    private $input_length         = 0;
    public $peg_cache = array();

    private function cleanup_state() {
      $this->peg_currPos          = 0;
      $this->peg_reportedPos      = 0;
      $this->peg_cachedPos        = 0;
      $this->peg_cachedPosDetails = array('line' => 1, 'column' => 1, 'seenCR' => false );
      $this->peg_maxFailPos       = 0;
      $this->peg_maxFailExpected  = array();
      $this->peg_silentFails      = 0;
      $this->input                = array();
      $this->input_length         = 0;
      $this->peg_cache = array();
    }

    private function input_substr($start, $length) {
      if ($length === 1 && $start < $this->input_length) {
        return $this->input[$start];
      }
      $substr = '';
      $max = min($start + $length, $this->input_length);
      for ($i = $start; $i < $max; $i++) {
        $substr .= $this->input[$i];
      }
      return $substr;
    }


    private function text() {
      return substr($this->input, $this->peg_reportedPos, $this->peg_reportedPos + $this->peg_currPos);
    }

    private function offset() {
      return $this->peg_reportedPos;
    }

    private function line() {
      $compute_pd = $this->peg_computePosDetails($this->peg_reportedPos);
      return $compute_pd["line"];
    }

    private function column() {
      $compute_pd = $this->peg_computePosDetails($this->peg_reportedPos);
      return $compute_pd["column"];
    }

    private function expected($description) {
      throw $this->peg_buildException(
        null,
        array(array("type" => "other", "description" => $description )),
        $this->peg_reportedPos
      );
    }

    private function error($message) {
      throw $this->peg_buildException($message, null, $this->peg_reportedPos);
    }

    private function peg_advancePos(&$details, $startPos, $endPos) {
      for ($p = $startPos; $p < $endPos; $p++) {
        $ch = $this->input_substr($p, 1);
        if ($ch === "\n") {
          if (!$details["seenCR"]) { $details["line"]++; }
          $details["column"] = 1;
          $details["seenCR"] = false;
        } else if ($ch === "\r" || $ch === "\u2028" || $ch === "\u2029") {
          $details["line"]++;
          $details["column"] = 1;
          $details["seenCR"] = true;
        } else {
          $details["column"]++;
          $details["seenCR"] = false;
        }
      }
    }

    private function peg_computePosDetails($pos) {
      if ($this->peg_cachedPos !== $pos) {
        if ($this->peg_cachedPos > $pos) {
          $this->peg_cachedPos = 0;
          $this->peg_cachedPosDetails = array( "line" => 1, "column" => 1, "seenCR" => false );
        }
        $this->peg_advancePos($this->peg_cachedPosDetails, $this->peg_cachedPos, $pos);
        $this->peg_cachedPos = $pos;
      }

      return $this->peg_cachedPosDetails;
    }

    private function peg_fail($expected) {
      if ($this->peg_currPos < $this->peg_maxFailPos) { return; }

      if ($this->peg_currPos > $this->peg_maxFailPos) {
        $this->peg_maxFailPos = $this->peg_currPos;
        $this->peg_maxFailExpected = array();
      }

      $this->peg_maxFailExpected[] = $expected;
    }

    private function peg_buildException_expectedComparator($a, $b) {
      if ($a["description"] < $b["description"]) {
        return -1;
      } else if ($a["description"] > $b["description"]) {
        return 1;
      } else {
        return 0;
      }
    }

    private function peg_buildException($message, $expected, $pos) {
      $posDetails = $this->peg_computePosDetails($pos);
      $found      = $pos < $this->input_length ? $this->input[$pos] : null;

      if ($expected !== null) {
        usort($expected, array($this, "peg_buildException_expectedComparator"));
        $i = 1;
        while ($i < count($expected)) {
          if ($expected[$i - 1] === $expected[$i]) {
            array_splice($expected, $i, 1);
          } else {
            $i++;
          }
        }
      }

      if ($message === null) {
        $expectedDescs = array_fill(0, count($expected), null);

        for ($i = 0; $i < count($expected); $i++) {
          $expectedDescs[$i] = $expected[$i]["description"];
        }

        $expectedDesc = count($expected) > 1
          ? join(", ", array_slice($expectedDescs, 0, -1))
              . " or "
              . $expectedDescs[count($expected) - 1]
          : $expectedDescs[0];

        $foundDesc = $found ? json_encode($found) : "end of input";

        $message = "Expected " . $expectedDesc . " but " . $foundDesc . " found.";
      }

      return new SyntaxError(
        $message,
        $expected,
        $found,
        $pos,
        $posDetails["line"],
        $posDetails["column"]
      );
    }

    private $peg_FAILED;
    private $peg_c0;
    private $peg_c1;
    private $peg_c2;
    private $peg_c3;
    private $peg_c4;
    private $peg_c5;
    private $peg_c6;
    private $peg_c7;
    private $peg_c8;
    private $peg_c9;
    private $peg_c10;
    private $peg_c11;
    private $peg_c12;
    private $peg_c13;
    private $peg_c14;
    private $peg_c15;
    private $peg_c16;
    private $peg_c17;
    private $peg_c18;
    private $peg_c19;
    private $peg_c20;
    private $peg_c21;
    private $peg_c22;
    private $peg_c23;
    private $peg_c24;
    private $peg_c25;
    private $peg_c26;
    private $peg_c27;
    private $peg_c28;
    private $peg_c29;
    private $peg_c30;
    private $peg_c31;
    private $peg_c32;
    private $peg_c33;
    private $peg_c34;
    private $peg_c35;
    private $peg_c36;
    private $peg_c37;
    private $peg_c38;
    private $peg_c39;
    private $peg_c40;
    private $peg_c41;
    private $peg_c42;
    private $peg_c43;
    private $peg_c44;
    private $peg_c45;
    private $peg_c46;
    private $peg_c47;
    private $peg_c48;
    private $peg_c49;
    private $peg_c50;
    private $peg_c51;
    private $peg_c52;
    private $peg_c53;
    private $peg_c54;
    private $peg_c55;
    private $peg_c56;
    private $peg_c57;
    private $peg_c58;
    private $peg_c59;
    private $peg_c60;
    private $peg_c61;
    private $peg_c62;
    private $peg_c63;
    private $peg_c64;
    private $peg_c65;
    private $peg_c66;
    private $peg_c67;
    private $peg_c68;
    private $peg_c69;
    private $peg_c70;
    private $peg_c71;
    private $peg_c72;
    private $peg_c73;
    private $peg_c74;
    private $peg_c75;
    private $peg_c76;
    private $peg_c77;
    private $peg_c78;
    private $peg_c79;
    private $peg_c80;

    private function peg_f0($content) {
     $r = new CTP_Root($content);
     $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
     return $r;
     }
    private function peg_f1($chars) {
      $r = new CTP_Raw(join("",$chars));
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
     }
    private function peg_f2($c) { return $c[0] . join('',$c[1]); }
    private function peg_f3($c) { return $c; }
    private function peg_f4($content) {
      $r = new CTP_Block('comment',array(),array(new CTP_Raw(join("",$content))));
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
     }
    private function peg_f5($value, $content) {
      $p = array();
      if ($value)
        $p['value'] = $value[5];
      $r = new CTP_Block('escape',$p,array(new CTP_Raw(join("",$content))));
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
     }
    private function peg_f6($channel, $variable) {
     $r = new CTP_IOBlock($channel, $variable);
     $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
     return $r;
     }
    private function peg_f7($channel, $variable, $variables) {
     $variablestring = $variable;
     foreach ($variables as $var) {
      $variablestring .= ',' . $var[1];
     }
     $r = new CTP_IOBlock($channel, $variablestring);
     $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
     return $r;
     }
    private function peg_f8($chars) {
      $r = new CTP_Block('latex',array(),array(new CTP_Raw(join("",$chars))));
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
     }
    private function peg_f9($chars) {
      $r = new CTP_Block('raw',array(),array(new CTP_Raw(join("",$chars))));
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f10($char, $morechars) {
      return $char.join("",$morechars);
      }
    private function peg_f11($test, $contenta, $elifs, $contentb) {
     $conds = array($test);
     $branches = array(count($contenta));
     $content = $contenta;
     foreach ($elifs as $el) {
      $conds[] = $el[0];
      $branches[] = count($el[1]);
      $content = array_merge($content, $el[1]);
     }
     $branches[] = count($contentb);
     $content = array_merge($content, $contentb);

      $r = new CTP_Block('if',array('test'=>$conds,' branch lengths'=>$branches),$content);
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f12($test, $contenta, $elifs) {
     $conds = array($test);
     $branches = array(count($contenta));
     $content = $contenta;
     foreach ($elifs as $el) {
      $conds[] = $el[0];
      $branches[] = count($el[1]);
      $content = array_merge($content, $el[1]);
     }

      $r = new CTP_Block('if',array('test'=>$conds,' branch lengths'=>$branches),$content);
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f13($test, $contenta, $contentb) {
      $r = new CTP_Block('if',array('test'=>array($test),' branch lengths'=>array(count($contenta),count($contentb))),array_merge($contenta,$contentb));
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f14($test, $content) {
      $r = new CTP_Block('if',array('test'=>$test),$content);
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f15($cond) { return $cond; }
    private function peg_f16($params) {
      $p = array();
      foreach ($params as $el) {
        $p[] = array('key'=> $el[1], 'value' => $el[5]);
      }
      $r = new CTP_Block('define',$p,array());
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f17($id, $params) {
      $p = array();
      foreach ($params as $el) {
        $p[$el[1]] = $el[5];
      }
      $r = new CTP_Block($id,$p,array());
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f18($begin, $content, $end) { return $begin['name'] === $end; }
    private function peg_f19($begin, $content, $end) {
      $r = new CTP_Block($begin['name'],$begin['params'],$content);
      $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
      return $r;
      }
    private function peg_f20($openid, $params) {
      $p = array();
      foreach ($params as $el) {
        $p[$el[1]] = $el[5];
      }
      return array('name'=>$openid, 'params'=>$p);
      }
    private function peg_f21($closeid) {
      return $closeid;
      }
    private function peg_f22($chars) {
     $r = new CTP_String(join("",$chars), false);
     $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
     return $r;
     }
    private function peg_f23($chars) {
     $r = new CTP_String(join("",$chars), true);
     $r->position = array('start'=>$this->peg_reportedPos,'end'=>$this->peg_currPos);
     return $r;
     }
    private function peg_f24() { return "\\"; }
    private function peg_f25() { return '"'; }
    private function peg_f26() { return "'"; }

    private function peg_parseRoot() {

      $key    = $this->peg_currPos * 33 + 0;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = array();
      $s2 = $this->peg_parseBlock();
      if ($s2 === $this->peg_FAILED) {
        $s2 = $this->peg_parseRaw();
      }
      while ($s2 !== $this->peg_FAILED) {
        $s1[] = $s2;
        $s2 = $this->peg_parseBlock();
        if ($s2 === $this->peg_FAILED) {
          $s2 = $this->peg_parseRaw();
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f0($s1);
      }
      $s0 = $s1;

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBlock() {

      $key    = $this->peg_currPos * 33 + 1;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parseEscapeBlock();
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_parseCommentBlock();
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_parseIOBlock();
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_parseLatexBlock();
            if ($s0 === $this->peg_FAILED) {
              $s0 = $this->peg_parseRawBlock();
              if ($s0 === $this->peg_FAILED) {
                $s0 = $this->peg_parseIfBlock();
                if ($s0 === $this->peg_FAILED) {
                  $s0 = $this->peg_parseDefineBlock();
                  if ($s0 === $this->peg_FAILED) {
                    $s0 = $this->peg_parseGenericBlock();
                  }
                }
              }
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRaw() {

      $key    = $this->peg_currPos * 33 + 2;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = array();
      $s2 = $this->peg_parseRawChars();
      if ($s2 !== $this->peg_FAILED) {
        while ($s2 !== $this->peg_FAILED) {
          $s1[] = $s2;
          $s2 = $this->peg_parseRawChars();
        }
      } else {
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f1($s1);
      }
      $s0 = $s1;

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRawChars() {

      $key    = $this->peg_currPos * 33 + 3;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s2 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c2) {
          $s2 = $this->peg_c2;
          $this->peg_currPos += 2;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c3);
          }
        }
        if ($s2 === $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c4) {
            $s2 = $this->peg_c4;
            $this->peg_currPos += 2;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c5);
            }
          }
        }
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        if ($this->input_length > $this->peg_currPos) {
          $s3 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s3 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s3 !== $this->peg_FAILED) {
          $s4 = array();
          if (peg_regex_test($this->peg_c7, $this->input_substr($this->peg_currPos, 1))) {
            $s5 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c8);
            }
          }
          while ($s5 !== $this->peg_FAILED) {
            $s4[] = $s5;
            if (peg_regex_test($this->peg_c7, $this->input_substr($this->peg_currPos, 1))) {
              $s5 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s5 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c8);
              }
            }
          }
          if ($s4 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f2($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_currPos;
        $this->peg_silentFails++;
        $s2 = $this->peg_parseLatexBlock();
        $this->peg_silentFails--;
        if ($s2 === $this->peg_FAILED) {
          $s1 = null;
        } else {
          $this->peg_currPos = $s1;
          $s1 = $this->peg_FAILED;
        }
        if ($s1 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c4) {
            $s2 = $this->peg_c4;
            $this->peg_currPos += 2;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c5);
            }
          }
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f3($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_currPos;
          $this->peg_silentFails++;
          $s2 = $this->peg_parseRawBlock();
          $this->peg_silentFails--;
          if ($s2 === $this->peg_FAILED) {
            $s1 = null;
          } else {
            $this->peg_currPos = $s1;
            $s1 = $this->peg_FAILED;
          }
          if ($s1 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c2) {
              $s2 = $this->peg_c2;
              $this->peg_currPos += 2;
            } else {
              $s2 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c3);
              }
            }
            if ($s2 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f3($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_currPos;
            $this->peg_silentFails++;
            $s2 = $this->peg_parseIOBlock();
            if ($s2 === $this->peg_FAILED) {
              $s2 = $this->peg_parseGenericBlock();
              if ($s2 === $this->peg_FAILED) {
                $s2 = $this->peg_parseEndBlock();
              }
            }
            $this->peg_silentFails--;
            if ($s2 === $this->peg_FAILED) {
              $s1 = null;
            } else {
              $this->peg_currPos = $s1;
              $s1 = $this->peg_FAILED;
            }
            if ($s1 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
                $s2 = $this->peg_c0;
                $this->peg_currPos += 2;
              } else {
                $s2 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c1);
                }
              }
              if ($s2 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f3($s2);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRawIf() {

      $key    = $this->peg_currPos * 33 + 4;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = array();
      $s2 = $this->peg_parseRawIfChars();
      if ($s2 !== $this->peg_FAILED) {
        while ($s2 !== $this->peg_FAILED) {
          $s1[] = $s2;
          $s2 = $this->peg_parseRawIfChars();
        }
      } else {
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $this->peg_reportedPos = $s0;
        $s1 = $this->peg_f1($s1);
      }
      $s0 = $s1;

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRawIfChars() {

      $key    = $this->peg_currPos * 33 + 5;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s2 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c2) {
          $s2 = $this->peg_c2;
          $this->peg_currPos += 2;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c3);
          }
        }
        if ($s2 === $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c4) {
            $s2 = $this->peg_c4;
            $this->peg_currPos += 2;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c5);
            }
          }
        }
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        if ($this->input_length > $this->peg_currPos) {
          $s3 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s3 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s3 !== $this->peg_FAILED) {
          $s4 = array();
          if (peg_regex_test($this->peg_c7, $this->input_substr($this->peg_currPos, 1))) {
            $s5 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c8);
            }
          }
          while ($s5 !== $this->peg_FAILED) {
            $s4[] = $s5;
            if (peg_regex_test($this->peg_c7, $this->input_substr($this->peg_currPos, 1))) {
              $s5 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s5 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c8);
              }
            }
          }
          if ($s4 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f2($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_currPos;
        $this->peg_silentFails++;
        $s2 = $this->peg_parseLatexBlock();
        $this->peg_silentFails--;
        if ($s2 === $this->peg_FAILED) {
          $s1 = null;
        } else {
          $this->peg_currPos = $s1;
          $s1 = $this->peg_FAILED;
        }
        if ($s1 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c4) {
            $s2 = $this->peg_c4;
            $this->peg_currPos += 2;
          } else {
            $s2 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c5);
            }
          }
          if ($s2 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f3($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          $s1 = $this->peg_currPos;
          $this->peg_silentFails++;
          $s2 = $this->peg_parseRawBlock();
          $this->peg_silentFails--;
          if ($s2 === $this->peg_FAILED) {
            $s1 = null;
          } else {
            $this->peg_currPos = $s1;
            $s1 = $this->peg_FAILED;
          }
          if ($s1 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c2) {
              $s2 = $this->peg_c2;
              $this->peg_currPos += 2;
            } else {
              $s2 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c3);
              }
            }
            if ($s2 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f3($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            $s1 = $this->peg_currPos;
            $this->peg_silentFails++;
            $s2 = $this->peg_parseIOBlock();
            if ($s2 === $this->peg_FAILED) {
              $s2 = $this->peg_parseGenericBlock();
              if ($s2 === $this->peg_FAILED) {
                $s2 = $this->peg_parseEndBlock();
                if ($s2 === $this->peg_FAILED) {
                  $s2 = $this->peg_parseElIf();
                  if ($s2 === $this->peg_FAILED) {
                    $s2 = $this->peg_parseElse();
                  }
                }
              }
            }
            $this->peg_silentFails--;
            if ($s2 === $this->peg_FAILED) {
              $s1 = null;
            } else {
              $this->peg_currPos = $s1;
              $s1 = $this->peg_FAILED;
            }
            if ($s1 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
                $s2 = $this->peg_c0;
                $this->peg_currPos += 2;
              } else {
                $s2 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c1);
                }
              }
              if ($s2 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f3($s2);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCommentBlock() {

      $key    = $this->peg_currPos * 33 + 6;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c9) {
            $s3 = $this->peg_c9;
            $this->peg_currPos += 7;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c10);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                $s5 = $this->peg_c11;
                $this->peg_currPos += 2;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = array();
                $s7 = $this->peg_parseCommentChars();
                while ($s7 !== $this->peg_FAILED) {
                  $s6[] = $s7;
                  $s7 = $this->peg_parseCommentChars();
                }
                if ($s6 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
                    $s7 = $this->peg_c13;
                    $this->peg_currPos += 3;
                  } else {
                    $s7 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c14);
                    }
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c9) {
                        $s9 = $this->peg_c9;
                        $this->peg_currPos += 7;
                      } else {
                        $s9 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c10);
                        }
                      }
                      if ($s9 !== $this->peg_FAILED) {
                        $s10 = $this->peg_parse_();
                        if ($s10 !== $this->peg_FAILED) {
                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                            $s11 = $this->peg_c11;
                            $this->peg_currPos += 2;
                          } else {
                            $s11 = $this->peg_FAILED;
                            if ($this->peg_silentFails === 0) {
                                $this->peg_fail($this->peg_c12);
                            }
                          }
                          if ($s11 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f4($s6);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseCommentChars() {

      $key    = $this->peg_currPos * 33 + 7;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      $s2 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
        $s3 = $this->peg_c13;
        $this->peg_currPos += 3;
      } else {
        $s3 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c14);
        }
      }
      if ($s3 !== $this->peg_FAILED) {
        $s4 = $this->peg_parse_();
        if ($s4 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 7) === $this->peg_c9) {
            $s5 = $this->peg_c9;
            $this->peg_currPos += 7;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c10);
            }
          }
          if ($s5 !== $this->peg_FAILED) {
            $s6 = $this->peg_parse_();
            if ($s6 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                $s7 = $this->peg_c11;
                $this->peg_currPos += 2;
              } else {
                $s7 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s7 !== $this->peg_FAILED) {
                $s3 = array($s3, $s4, $s5, $s6, $s7);
                $s2 = $s3;
              } else {
                $this->peg_currPos = $s2;
                $s2 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s2;
              $s2 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s2;
        $s2 = $this->peg_FAILED;
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        if ($this->input_length > $this->peg_currPos) {
          $s3 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s3 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s3 !== $this->peg_FAILED) {
          $s4 = array();
          if (peg_regex_test($this->peg_c15, $this->input_substr($this->peg_currPos, 1))) {
            $s5 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c16);
            }
          }
          while ($s5 !== $this->peg_FAILED) {
            $s4[] = $s5;
            if (peg_regex_test($this->peg_c15, $this->input_substr($this->peg_currPos, 1))) {
              $s5 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s5 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c16);
              }
            }
          }
          if ($s4 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f2($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEscapeBlock() {

      $key    = $this->peg_currPos * 33 + 8;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c17) {
            $s3 = $this->peg_c17;
            $this->peg_currPos += 6;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c18);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_currPos;
            $s5 = array();
            $s6 = $this->peg_parse__();
            if ($s6 !== $this->peg_FAILED) {
              while ($s6 !== $this->peg_FAILED) {
                $s5[] = $s6;
                $s6 = $this->peg_parse__();
              }
            } else {
              $s5 = $this->peg_FAILED;
            }
            if ($s5 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 5) === $this->peg_c19) {
                $s6 = $this->peg_c19;
                $this->peg_currPos += 5;
              } else {
                $s6 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c20);
                }
              }
              if ($s6 !== $this->peg_FAILED) {
                $s7 = $this->peg_parse_();
                if ($s7 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                    $s8 = $this->peg_c21;
                    $this->peg_currPos++;
                  } else {
                    $s8 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c22);
                    }
                  }
                  if ($s8 !== $this->peg_FAILED) {
                    $s9 = $this->peg_parse_();
                    if ($s9 !== $this->peg_FAILED) {
                      $s10 = $this->peg_parseString();
                      if ($s10 !== $this->peg_FAILED) {
                        $s5 = array($s5, $s6, $s7, $s8, $s9, $s10);
                        $s4 = $s5;
                      } else {
                        $this->peg_currPos = $s4;
                        $s4 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s4;
                      $s4 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s4;
                    $s4 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s4;
                  $s4 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s4;
                $s4 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s4;
              $s4 = $this->peg_FAILED;
            }
            if ($s4 === $this->peg_FAILED) {
              $s4 = null;
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                  $s6 = $this->peg_c11;
                  $this->peg_currPos += 2;
                } else {
                  $s6 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c12);
                  }
                }
                if ($s6 !== $this->peg_FAILED) {
                  $s7 = array();
                  $s8 = $this->peg_parseEscapeChars();
                  while ($s8 !== $this->peg_FAILED) {
                    $s7[] = $s8;
                    $s8 = $this->peg_parseEscapeChars();
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
                      $s8 = $this->peg_c13;
                      $this->peg_currPos += 3;
                    } else {
                      $s8 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c14);
                      }
                    }
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parse_();
                      if ($s9 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c17) {
                          $s10 = $this->peg_c17;
                          $this->peg_currPos += 6;
                        } else {
                          $s10 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c18);
                          }
                        }
                        if ($s10 !== $this->peg_FAILED) {
                          $s11 = $this->peg_parse_();
                          if ($s11 !== $this->peg_FAILED) {
                            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                              $s12 = $this->peg_c11;
                              $this->peg_currPos += 2;
                            } else {
                              $s12 = $this->peg_FAILED;
                              if ($this->peg_silentFails === 0) {
                                  $this->peg_fail($this->peg_c12);
                              }
                            }
                            if ($s12 !== $this->peg_FAILED) {
                              $this->peg_reportedPos = $s0;
                              $s1 = $this->peg_f5($s4, $s7);
                              $s0 = $s1;
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEscapeChars() {

      $key    = $this->peg_currPos * 33 + 9;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      $s2 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
        $s3 = $this->peg_c13;
        $this->peg_currPos += 3;
      } else {
        $s3 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c14);
        }
      }
      if ($s3 !== $this->peg_FAILED) {
        $s4 = $this->peg_parse_();
        if ($s4 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c17) {
            $s5 = $this->peg_c17;
            $this->peg_currPos += 6;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c18);
            }
          }
          if ($s5 !== $this->peg_FAILED) {
            $s6 = $this->peg_parse_();
            if ($s6 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                $s7 = $this->peg_c11;
                $this->peg_currPos += 2;
              } else {
                $s7 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s7 !== $this->peg_FAILED) {
                $s3 = array($s3, $s4, $s5, $s6, $s7);
                $s2 = $s3;
              } else {
                $this->peg_currPos = $s2;
                $s2 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s2;
              $s2 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s2;
        $s2 = $this->peg_FAILED;
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_currPos;
        if ($this->input_length > $this->peg_currPos) {
          $s3 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s3 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s3 !== $this->peg_FAILED) {
          $s4 = array();
          if (peg_regex_test($this->peg_c15, $this->input_substr($this->peg_currPos, 1))) {
            $s5 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s5 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c16);
            }
          }
          while ($s5 !== $this->peg_FAILED) {
            $s4[] = $s5;
            if (peg_regex_test($this->peg_c15, $this->input_substr($this->peg_currPos, 1))) {
              $s5 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s5 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c16);
              }
            }
          }
          if ($s4 !== $this->peg_FAILED) {
            $s3 = array($s3, $s4);
            $s2 = $s3;
          } else {
            $this->peg_currPos = $s2;
            $s2 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s2;
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f2($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseIOBlock() {

      $key    = $this->peg_currPos * 33 + 10;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseIdentifier();
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c23) {
                $s5 = $this->peg_c23;
                $this->peg_currPos++;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c24);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parse_();
                if ($s6 !== $this->peg_FAILED) {
                  $s7 = $this->peg_parseIdentifier();
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                        $s9 = $this->peg_c11;
                        $this->peg_currPos += 2;
                      } else {
                        $s9 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c12);
                        }
                      }
                      if ($s9 !== $this->peg_FAILED) {
                        $this->peg_reportedPos = $s0;
                        $s1 = $this->peg_f6($s3, $s7);
                        $s0 = $s1;
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
          $s1 = $this->peg_c0;
          $this->peg_currPos += 2;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c1);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parse_();
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parseIdentifier();
            if ($s3 !== $this->peg_FAILED) {
              $s4 = $this->peg_parse_();
              if ($s4 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c23) {
                  $s5 = $this->peg_c23;
                  $this->peg_currPos++;
                } else {
                  $s5 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c24);
                  }
                }
                if ($s5 !== $this->peg_FAILED) {
                  $s6 = $this->peg_parse_();
                  if ($s6 !== $this->peg_FAILED) {
                    $s7 = $this->peg_parseIdentifier();
                    if ($s7 !== $this->peg_FAILED) {
                      $s8 = array();
                      $s9 = $this->peg_currPos;
                      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c25) {
                        $s10 = $this->peg_c25;
                        $this->peg_currPos++;
                      } else {
                        $s10 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c26);
                        }
                      }
                      if ($s10 !== $this->peg_FAILED) {
                        $s11 = $this->peg_parseIdentifier();
                        if ($s11 !== $this->peg_FAILED) {
                          $s10 = array($s10, $s11);
                          $s9 = $s10;
                        } else {
                          $this->peg_currPos = $s9;
                          $s9 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s9;
                        $s9 = $this->peg_FAILED;
                      }
                      while ($s9 !== $this->peg_FAILED) {
                        $s8[] = $s9;
                        $s9 = $this->peg_currPos;
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c25) {
                          $s10 = $this->peg_c25;
                          $this->peg_currPos++;
                        } else {
                          $s10 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c26);
                          }
                        }
                        if ($s10 !== $this->peg_FAILED) {
                          $s11 = $this->peg_parseIdentifier();
                          if ($s11 !== $this->peg_FAILED) {
                            $s10 = array($s10, $s11);
                            $s9 = $s10;
                          } else {
                            $this->peg_currPos = $s9;
                            $s9 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s9;
                          $s9 = $this->peg_FAILED;
                        }
                      }
                      if ($s8 !== $this->peg_FAILED) {
                        $s9 = $this->peg_parse_();
                        if ($s9 !== $this->peg_FAILED) {
                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                            $s10 = $this->peg_c11;
                            $this->peg_currPos += 2;
                          } else {
                            $s10 = $this->peg_FAILED;
                            if ($this->peg_silentFails === 0) {
                                $this->peg_fail($this->peg_c12);
                            }
                          }
                          if ($s10 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f7($s3, $s7, $s8);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseLatexBlock() {

      $key    = $this->peg_currPos * 33 + 11;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c4) {
        $s1 = $this->peg_c4;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c5);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = array();
        $s3 = $this->peg_parseLBChar();
        if ($s3 !== $this->peg_FAILED) {
          while ($s3 !== $this->peg_FAILED) {
            $s2[] = $s3;
            $s3 = $this->peg_parseLBChar();
          }
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c27) {
            $s3 = $this->peg_c27;
            $this->peg_currPos += 2;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c28);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f8($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseLBChar() {

      $key    = $this->peg_currPos * 33 + 12;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c4) {
        $s2 = $this->peg_c4;
        $this->peg_currPos += 2;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c5);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c27) {
          $s2 = $this->peg_c27;
          $this->peg_currPos += 2;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c28);
          }
        }
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_length > $this->peg_currPos) {
          $s2 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f3($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRawBlock() {

      $key    = $this->peg_currPos * 33 + 13;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c2) {
        $s1 = $this->peg_c2;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c3);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = array();
        $s3 = $this->peg_parseRBChar();
        if ($s3 !== $this->peg_FAILED) {
          while ($s3 !== $this->peg_FAILED) {
            $s2[] = $s3;
            $s3 = $this->peg_parseRBChar();
          }
        } else {
          $s2 = $this->peg_FAILED;
        }
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c29) {
            $s3 = $this->peg_c29;
            $this->peg_currPos += 2;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c30);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f9($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseRBChar() {

      $key    = $this->peg_currPos * 33 + 14;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c2) {
        $s2 = $this->peg_c2;
        $this->peg_currPos += 2;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c3);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c29) {
          $s2 = $this->peg_c29;
          $this->peg_currPos += 2;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c30);
          }
        }
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_length > $this->peg_currPos) {
          $s2 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f3($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseIdentifier() {

      $key    = $this->peg_currPos * 33 + 15;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_silentFails++;
      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseIdentifierStart();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = array();
        $s3 = $this->peg_parseIdentifierTail();
        while ($s3 !== $this->peg_FAILED) {
          $s2[] = $s3;
          $s3 = $this->peg_parseIdentifierTail();
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f10($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      $this->peg_silentFails--;
      if ($s0 === $this->peg_FAILED) {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c31);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseParamIdentifier() {

      $key    = $this->peg_currPos * 33 + 16;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_silentFails++;
      $s0 = $this->peg_currPos;
      $s1 = $this->peg_parseIdentifierStart();
      if ($s1 !== $this->peg_FAILED) {
        $s2 = array();
        $s3 = $this->peg_parseParamIdentifierTail();
        while ($s3 !== $this->peg_FAILED) {
          $s2[] = $s3;
          $s3 = $this->peg_parseParamIdentifierTail();
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f10($s1, $s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      $this->peg_silentFails--;
      if ($s0 === $this->peg_FAILED) {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c31);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseULetter() {

      $key    = $this->peg_currPos * 33 + 17;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_silentFails++;
      if (peg_regex_test($this->peg_c33, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c34);
        }
      }
      if ($s0 === $this->peg_FAILED) {
        if (peg_regex_test($this->peg_c35, $this->input_substr($this->peg_currPos, 1))) {
          $s0 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s0 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c36);
          }
        }
        if ($s0 === $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c37, $this->input_substr($this->peg_currPos, 1))) {
            $s0 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s0 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c38);
            }
          }
          if ($s0 === $this->peg_FAILED) {
            if (peg_regex_test($this->peg_c39, $this->input_substr($this->peg_currPos, 1))) {
              $s0 = $this->input_substr($this->peg_currPos, 1);
              $this->peg_currPos++;
            } else {
              $s0 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c40);
              }
            }
            if ($s0 === $this->peg_FAILED) {
              if (peg_regex_test($this->peg_c41, $this->input_substr($this->peg_currPos, 1))) {
                $s0 = $this->input_substr($this->peg_currPos, 1);
                $this->peg_currPos++;
              } else {
                $s0 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c42);
                }
              }
            }
          }
        }
      }
      $this->peg_silentFails--;
      if ($s0 === $this->peg_FAILED) {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c32);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseIdentifierStart() {

      $key    = $this->peg_currPos * 33 + 18;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      if (peg_regex_test($this->peg_c43, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c44);
        }
      }
      if ($s0 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c45) {
          $s0 = $this->peg_c45;
          $this->peg_currPos++;
        } else {
          $s0 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c46);
          }
        }
        if ($s0 === $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c47) {
            $s0 = $this->peg_c47;
            $this->peg_currPos++;
          } else {
            $s0 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c48);
            }
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_parseULetter();
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseIdentifierTail() {

      $key    = $this->peg_currPos * 33 + 19;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parseIdentifierStart();
      if ($s0 === $this->peg_FAILED) {
        if (peg_regex_test($this->peg_c49, $this->input_substr($this->peg_currPos, 1))) {
          $s0 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s0 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c50);
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseParamIdentifierTail() {

      $key    = $this->peg_currPos * 33 + 20;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_parseIdentifierStart();
      if ($s0 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c51) {
          $s0 = $this->peg_c51;
          $this->peg_currPos++;
        } else {
          $s0 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c52);
          }
        }
        if ($s0 === $this->peg_FAILED) {
          if (peg_regex_test($this->peg_c49, $this->input_substr($this->peg_currPos, 1))) {
            $s0 = $this->input_substr($this->peg_currPos, 1);
            $this->peg_currPos++;
          } else {
            $s0 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c50);
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseIfBlock() {

      $key    = $this->peg_currPos * 33 + 21;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
            $s3 = $this->peg_c53;
            $this->peg_currPos += 2;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c54);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = array();
            $s5 = $this->peg_parse__();
            if ($s5 !== $this->peg_FAILED) {
              while ($s5 !== $this->peg_FAILED) {
                $s4[] = $s5;
                $s5 = $this->peg_parse__();
              }
            } else {
              $s4 = $this->peg_FAILED;
            }
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c55) {
                $s5 = $this->peg_c55;
                $this->peg_currPos += 4;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c56);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parse_();
                if ($s6 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                    $s7 = $this->peg_c21;
                    $this->peg_currPos++;
                  } else {
                    $s7 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c22);
                    }
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parseString();
                      if ($s9 !== $this->peg_FAILED) {
                        $s10 = $this->peg_parse_();
                        if ($s10 !== $this->peg_FAILED) {
                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                            $s11 = $this->peg_c11;
                            $this->peg_currPos += 2;
                          } else {
                            $s11 = $this->peg_FAILED;
                            if ($this->peg_silentFails === 0) {
                                $this->peg_fail($this->peg_c12);
                            }
                          }
                          if ($s11 !== $this->peg_FAILED) {
                            $s12 = array();
                            $s13 = $this->peg_parseBlock();
                            if ($s13 === $this->peg_FAILED) {
                              $s13 = $this->peg_parseRawIf();
                            }
                            while ($s13 !== $this->peg_FAILED) {
                              $s12[] = $s13;
                              $s13 = $this->peg_parseBlock();
                              if ($s13 === $this->peg_FAILED) {
                                $s13 = $this->peg_parseRawIf();
                              }
                            }
                            if ($s12 !== $this->peg_FAILED) {
                              $s13 = array();
                              $s14 = $this->peg_currPos;
                              $s15 = $this->peg_parseElIf();
                              if ($s15 !== $this->peg_FAILED) {
                                $s16 = array();
                                $s17 = $this->peg_parseBlock();
                                if ($s17 === $this->peg_FAILED) {
                                  $s17 = $this->peg_parseRawIf();
                                }
                                while ($s17 !== $this->peg_FAILED) {
                                  $s16[] = $s17;
                                  $s17 = $this->peg_parseBlock();
                                  if ($s17 === $this->peg_FAILED) {
                                    $s17 = $this->peg_parseRawIf();
                                  }
                                }
                                if ($s16 !== $this->peg_FAILED) {
                                  $s15 = array($s15, $s16);
                                  $s14 = $s15;
                                } else {
                                  $this->peg_currPos = $s14;
                                  $s14 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s14;
                                $s14 = $this->peg_FAILED;
                              }
                              if ($s14 !== $this->peg_FAILED) {
                                while ($s14 !== $this->peg_FAILED) {
                                  $s13[] = $s14;
                                  $s14 = $this->peg_currPos;
                                  $s15 = $this->peg_parseElIf();
                                  if ($s15 !== $this->peg_FAILED) {
                                    $s16 = array();
                                    $s17 = $this->peg_parseBlock();
                                    if ($s17 === $this->peg_FAILED) {
                                      $s17 = $this->peg_parseRawIf();
                                    }
                                    while ($s17 !== $this->peg_FAILED) {
                                      $s16[] = $s17;
                                      $s17 = $this->peg_parseBlock();
                                      if ($s17 === $this->peg_FAILED) {
                                        $s17 = $this->peg_parseRawIf();
                                      }
                                    }
                                    if ($s16 !== $this->peg_FAILED) {
                                      $s15 = array($s15, $s16);
                                      $s14 = $s15;
                                    } else {
                                      $this->peg_currPos = $s14;
                                      $s14 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s14;
                                    $s14 = $this->peg_FAILED;
                                  }
                                }
                              } else {
                                $s13 = $this->peg_FAILED;
                              }
                              if ($s13 !== $this->peg_FAILED) {
                                $s14 = $this->peg_parseElse();
                                if ($s14 !== $this->peg_FAILED) {
                                  $s15 = array();
                                  $s16 = $this->peg_parseBlock();
                                  if ($s16 === $this->peg_FAILED) {
                                    $s16 = $this->peg_parseRawIf();
                                  }
                                  while ($s16 !== $this->peg_FAILED) {
                                    $s15[] = $s16;
                                    $s16 = $this->peg_parseBlock();
                                    if ($s16 === $this->peg_FAILED) {
                                      $s16 = $this->peg_parseRawIf();
                                    }
                                  }
                                  if ($s15 !== $this->peg_FAILED) {
                                    if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
                                      $s16 = $this->peg_c13;
                                      $this->peg_currPos += 3;
                                    } else {
                                      $s16 = $this->peg_FAILED;
                                      if ($this->peg_silentFails === 0) {
                                          $this->peg_fail($this->peg_c14);
                                      }
                                    }
                                    if ($s16 !== $this->peg_FAILED) {
                                      $s17 = $this->peg_parse_();
                                      if ($s17 !== $this->peg_FAILED) {
                                        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
                                          $s18 = $this->peg_c53;
                                          $this->peg_currPos += 2;
                                        } else {
                                          $s18 = $this->peg_FAILED;
                                          if ($this->peg_silentFails === 0) {
                                              $this->peg_fail($this->peg_c54);
                                          }
                                        }
                                        if ($s18 !== $this->peg_FAILED) {
                                          $s19 = $this->peg_parse_();
                                          if ($s19 !== $this->peg_FAILED) {
                                            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                                              $s20 = $this->peg_c11;
                                              $this->peg_currPos += 2;
                                            } else {
                                              $s20 = $this->peg_FAILED;
                                              if ($this->peg_silentFails === 0) {
                                                  $this->peg_fail($this->peg_c12);
                                              }
                                            }
                                            if ($s20 !== $this->peg_FAILED) {
                                              $this->peg_reportedPos = $s0;
                                              $s1 = $this->peg_f11($s9, $s12, $s13, $s15);
                                              $s0 = $s1;
                                            } else {
                                              $this->peg_currPos = $s0;
                                              $s0 = $this->peg_FAILED;
                                            }
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s0;
                                      $s0 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
          $s1 = $this->peg_c0;
          $this->peg_currPos += 2;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c1);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $s2 = $this->peg_parse_();
          if ($s2 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
              $s3 = $this->peg_c53;
              $this->peg_currPos += 2;
            } else {
              $s3 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c54);
              }
            }
            if ($s3 !== $this->peg_FAILED) {
              $s4 = array();
              $s5 = $this->peg_parse__();
              if ($s5 !== $this->peg_FAILED) {
                while ($s5 !== $this->peg_FAILED) {
                  $s4[] = $s5;
                  $s5 = $this->peg_parse__();
                }
              } else {
                $s4 = $this->peg_FAILED;
              }
              if ($s4 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c55) {
                  $s5 = $this->peg_c55;
                  $this->peg_currPos += 4;
                } else {
                  $s5 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c56);
                  }
                }
                if ($s5 !== $this->peg_FAILED) {
                  $s6 = $this->peg_parse_();
                  if ($s6 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                      $s7 = $this->peg_c21;
                      $this->peg_currPos++;
                    } else {
                      $s7 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c22);
                      }
                    }
                    if ($s7 !== $this->peg_FAILED) {
                      $s8 = $this->peg_parse_();
                      if ($s8 !== $this->peg_FAILED) {
                        $s9 = $this->peg_parseString();
                        if ($s9 !== $this->peg_FAILED) {
                          $s10 = $this->peg_parse_();
                          if ($s10 !== $this->peg_FAILED) {
                            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                              $s11 = $this->peg_c11;
                              $this->peg_currPos += 2;
                            } else {
                              $s11 = $this->peg_FAILED;
                              if ($this->peg_silentFails === 0) {
                                  $this->peg_fail($this->peg_c12);
                              }
                            }
                            if ($s11 !== $this->peg_FAILED) {
                              $s12 = array();
                              $s13 = $this->peg_parseBlock();
                              if ($s13 === $this->peg_FAILED) {
                                $s13 = $this->peg_parseRawIf();
                              }
                              while ($s13 !== $this->peg_FAILED) {
                                $s12[] = $s13;
                                $s13 = $this->peg_parseBlock();
                                if ($s13 === $this->peg_FAILED) {
                                  $s13 = $this->peg_parseRawIf();
                                }
                              }
                              if ($s12 !== $this->peg_FAILED) {
                                $s13 = array();
                                $s14 = $this->peg_currPos;
                                $s15 = $this->peg_parseElIf();
                                if ($s15 !== $this->peg_FAILED) {
                                  $s16 = array();
                                  $s17 = $this->peg_parseBlock();
                                  if ($s17 === $this->peg_FAILED) {
                                    $s17 = $this->peg_parseRawIf();
                                  }
                                  while ($s17 !== $this->peg_FAILED) {
                                    $s16[] = $s17;
                                    $s17 = $this->peg_parseBlock();
                                    if ($s17 === $this->peg_FAILED) {
                                      $s17 = $this->peg_parseRawIf();
                                    }
                                  }
                                  if ($s16 !== $this->peg_FAILED) {
                                    $s15 = array($s15, $s16);
                                    $s14 = $s15;
                                  } else {
                                    $this->peg_currPos = $s14;
                                    $s14 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s14;
                                  $s14 = $this->peg_FAILED;
                                }
                                if ($s14 !== $this->peg_FAILED) {
                                  while ($s14 !== $this->peg_FAILED) {
                                    $s13[] = $s14;
                                    $s14 = $this->peg_currPos;
                                    $s15 = $this->peg_parseElIf();
                                    if ($s15 !== $this->peg_FAILED) {
                                      $s16 = array();
                                      $s17 = $this->peg_parseBlock();
                                      if ($s17 === $this->peg_FAILED) {
                                        $s17 = $this->peg_parseRawIf();
                                      }
                                      while ($s17 !== $this->peg_FAILED) {
                                        $s16[] = $s17;
                                        $s17 = $this->peg_parseBlock();
                                        if ($s17 === $this->peg_FAILED) {
                                          $s17 = $this->peg_parseRawIf();
                                        }
                                      }
                                      if ($s16 !== $this->peg_FAILED) {
                                        $s15 = array($s15, $s16);
                                        $s14 = $s15;
                                      } else {
                                        $this->peg_currPos = $s14;
                                        $s14 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s14;
                                      $s14 = $this->peg_FAILED;
                                    }
                                  }
                                } else {
                                  $s13 = $this->peg_FAILED;
                                }
                                if ($s13 !== $this->peg_FAILED) {
                                  if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
                                    $s14 = $this->peg_c13;
                                    $this->peg_currPos += 3;
                                  } else {
                                    $s14 = $this->peg_FAILED;
                                    if ($this->peg_silentFails === 0) {
                                        $this->peg_fail($this->peg_c14);
                                    }
                                  }
                                  if ($s14 !== $this->peg_FAILED) {
                                    $s15 = $this->peg_parse_();
                                    if ($s15 !== $this->peg_FAILED) {
                                      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
                                        $s16 = $this->peg_c53;
                                        $this->peg_currPos += 2;
                                      } else {
                                        $s16 = $this->peg_FAILED;
                                        if ($this->peg_silentFails === 0) {
                                            $this->peg_fail($this->peg_c54);
                                        }
                                      }
                                      if ($s16 !== $this->peg_FAILED) {
                                        $s17 = $this->peg_parse_();
                                        if ($s17 !== $this->peg_FAILED) {
                                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                                            $s18 = $this->peg_c11;
                                            $this->peg_currPos += 2;
                                          } else {
                                            $s18 = $this->peg_FAILED;
                                            if ($this->peg_silentFails === 0) {
                                                $this->peg_fail($this->peg_c12);
                                            }
                                          }
                                          if ($s18 !== $this->peg_FAILED) {
                                            $this->peg_reportedPos = $s0;
                                            $s1 = $this->peg_f12($s9, $s12, $s13);
                                            $s0 = $s1;
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s0;
                                      $s0 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
            $s1 = $this->peg_c0;
            $this->peg_currPos += 2;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c1);
            }
          }
          if ($s1 !== $this->peg_FAILED) {
            $s2 = $this->peg_parse_();
            if ($s2 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
                $s3 = $this->peg_c53;
                $this->peg_currPos += 2;
              } else {
                $s3 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c54);
                }
              }
              if ($s3 !== $this->peg_FAILED) {
                $s4 = array();
                $s5 = $this->peg_parse__();
                if ($s5 !== $this->peg_FAILED) {
                  while ($s5 !== $this->peg_FAILED) {
                    $s4[] = $s5;
                    $s5 = $this->peg_parse__();
                  }
                } else {
                  $s4 = $this->peg_FAILED;
                }
                if ($s4 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c55) {
                    $s5 = $this->peg_c55;
                    $this->peg_currPos += 4;
                  } else {
                    $s5 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c56);
                    }
                  }
                  if ($s5 !== $this->peg_FAILED) {
                    $s6 = $this->peg_parse_();
                    if ($s6 !== $this->peg_FAILED) {
                      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                        $s7 = $this->peg_c21;
                        $this->peg_currPos++;
                      } else {
                        $s7 = $this->peg_FAILED;
                        if ($this->peg_silentFails === 0) {
                            $this->peg_fail($this->peg_c22);
                        }
                      }
                      if ($s7 !== $this->peg_FAILED) {
                        $s8 = $this->peg_parse_();
                        if ($s8 !== $this->peg_FAILED) {
                          $s9 = $this->peg_parseString();
                          if ($s9 !== $this->peg_FAILED) {
                            $s10 = $this->peg_parse_();
                            if ($s10 !== $this->peg_FAILED) {
                              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                                $s11 = $this->peg_c11;
                                $this->peg_currPos += 2;
                              } else {
                                $s11 = $this->peg_FAILED;
                                if ($this->peg_silentFails === 0) {
                                    $this->peg_fail($this->peg_c12);
                                }
                              }
                              if ($s11 !== $this->peg_FAILED) {
                                $s12 = array();
                                $s13 = $this->peg_parseBlock();
                                if ($s13 === $this->peg_FAILED) {
                                  $s13 = $this->peg_parseRawIf();
                                }
                                while ($s13 !== $this->peg_FAILED) {
                                  $s12[] = $s13;
                                  $s13 = $this->peg_parseBlock();
                                  if ($s13 === $this->peg_FAILED) {
                                    $s13 = $this->peg_parseRawIf();
                                  }
                                }
                                if ($s12 !== $this->peg_FAILED) {
                                  $s13 = $this->peg_parseElse();
                                  if ($s13 !== $this->peg_FAILED) {
                                    $s14 = array();
                                    $s15 = $this->peg_parseBlock();
                                    if ($s15 === $this->peg_FAILED) {
                                      $s15 = $this->peg_parseRawIf();
                                    }
                                    while ($s15 !== $this->peg_FAILED) {
                                      $s14[] = $s15;
                                      $s15 = $this->peg_parseBlock();
                                      if ($s15 === $this->peg_FAILED) {
                                        $s15 = $this->peg_parseRawIf();
                                      }
                                    }
                                    if ($s14 !== $this->peg_FAILED) {
                                      if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
                                        $s15 = $this->peg_c13;
                                        $this->peg_currPos += 3;
                                      } else {
                                        $s15 = $this->peg_FAILED;
                                        if ($this->peg_silentFails === 0) {
                                            $this->peg_fail($this->peg_c14);
                                        }
                                      }
                                      if ($s15 !== $this->peg_FAILED) {
                                        $s16 = $this->peg_parse_();
                                        if ($s16 !== $this->peg_FAILED) {
                                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
                                            $s17 = $this->peg_c53;
                                            $this->peg_currPos += 2;
                                          } else {
                                            $s17 = $this->peg_FAILED;
                                            if ($this->peg_silentFails === 0) {
                                                $this->peg_fail($this->peg_c54);
                                            }
                                          }
                                          if ($s17 !== $this->peg_FAILED) {
                                            $s18 = $this->peg_parse_();
                                            if ($s18 !== $this->peg_FAILED) {
                                              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                                                $s19 = $this->peg_c11;
                                                $this->peg_currPos += 2;
                                              } else {
                                                $s19 = $this->peg_FAILED;
                                                if ($this->peg_silentFails === 0) {
                                                    $this->peg_fail($this->peg_c12);
                                                }
                                              }
                                              if ($s19 !== $this->peg_FAILED) {
                                                $this->peg_reportedPos = $s0;
                                                $s1 = $this->peg_f13($s9, $s12, $s14);
                                                $s0 = $s1;
                                              } else {
                                                $this->peg_currPos = $s0;
                                                $s0 = $this->peg_FAILED;
                                              }
                                            } else {
                                              $this->peg_currPos = $s0;
                                              $s0 = $this->peg_FAILED;
                                            }
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s0;
                                      $s0 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
          if ($s0 === $this->peg_FAILED) {
            $s0 = $this->peg_currPos;
            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
              $s1 = $this->peg_c0;
              $this->peg_currPos += 2;
            } else {
              $s1 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c1);
              }
            }
            if ($s1 !== $this->peg_FAILED) {
              $s2 = $this->peg_parse_();
              if ($s2 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
                  $s3 = $this->peg_c53;
                  $this->peg_currPos += 2;
                } else {
                  $s3 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c54);
                  }
                }
                if ($s3 !== $this->peg_FAILED) {
                  $s4 = array();
                  $s5 = $this->peg_parse__();
                  if ($s5 !== $this->peg_FAILED) {
                    while ($s5 !== $this->peg_FAILED) {
                      $s4[] = $s5;
                      $s5 = $this->peg_parse__();
                    }
                  } else {
                    $s4 = $this->peg_FAILED;
                  }
                  if ($s4 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c55) {
                      $s5 = $this->peg_c55;
                      $this->peg_currPos += 4;
                    } else {
                      $s5 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c56);
                      }
                    }
                    if ($s5 !== $this->peg_FAILED) {
                      $s6 = $this->peg_parse_();
                      if ($s6 !== $this->peg_FAILED) {
                        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                          $s7 = $this->peg_c21;
                          $this->peg_currPos++;
                        } else {
                          $s7 = $this->peg_FAILED;
                          if ($this->peg_silentFails === 0) {
                              $this->peg_fail($this->peg_c22);
                          }
                        }
                        if ($s7 !== $this->peg_FAILED) {
                          $s8 = $this->peg_parse_();
                          if ($s8 !== $this->peg_FAILED) {
                            $s9 = $this->peg_parseString();
                            if ($s9 !== $this->peg_FAILED) {
                              $s10 = $this->peg_parse_();
                              if ($s10 !== $this->peg_FAILED) {
                                if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                                  $s11 = $this->peg_c11;
                                  $this->peg_currPos += 2;
                                } else {
                                  $s11 = $this->peg_FAILED;
                                  if ($this->peg_silentFails === 0) {
                                      $this->peg_fail($this->peg_c12);
                                  }
                                }
                                if ($s11 !== $this->peg_FAILED) {
                                  $s12 = array();
                                  $s13 = $this->peg_parseBlock();
                                  if ($s13 === $this->peg_FAILED) {
                                    $s13 = $this->peg_parseRawIf();
                                  }
                                  while ($s13 !== $this->peg_FAILED) {
                                    $s12[] = $s13;
                                    $s13 = $this->peg_parseBlock();
                                    if ($s13 === $this->peg_FAILED) {
                                      $s13 = $this->peg_parseRawIf();
                                    }
                                  }
                                  if ($s12 !== $this->peg_FAILED) {
                                    if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
                                      $s13 = $this->peg_c13;
                                      $this->peg_currPos += 3;
                                    } else {
                                      $s13 = $this->peg_FAILED;
                                      if ($this->peg_silentFails === 0) {
                                          $this->peg_fail($this->peg_c14);
                                      }
                                    }
                                    if ($s13 !== $this->peg_FAILED) {
                                      $s14 = $this->peg_parse_();
                                      if ($s14 !== $this->peg_FAILED) {
                                        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c53) {
                                          $s15 = $this->peg_c53;
                                          $this->peg_currPos += 2;
                                        } else {
                                          $s15 = $this->peg_FAILED;
                                          if ($this->peg_silentFails === 0) {
                                              $this->peg_fail($this->peg_c54);
                                          }
                                        }
                                        if ($s15 !== $this->peg_FAILED) {
                                          $s16 = $this->peg_parse_();
                                          if ($s16 !== $this->peg_FAILED) {
                                            if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                                              $s17 = $this->peg_c11;
                                              $this->peg_currPos += 2;
                                            } else {
                                              $s17 = $this->peg_FAILED;
                                              if ($this->peg_silentFails === 0) {
                                                  $this->peg_fail($this->peg_c12);
                                              }
                                            }
                                            if ($s17 !== $this->peg_FAILED) {
                                              $this->peg_reportedPos = $s0;
                                              $s1 = $this->peg_f14($s9, $s12);
                                              $s0 = $s1;
                                            } else {
                                              $this->peg_currPos = $s0;
                                              $s0 = $this->peg_FAILED;
                                            }
                                          } else {
                                            $this->peg_currPos = $s0;
                                            $s0 = $this->peg_FAILED;
                                          }
                                        } else {
                                          $this->peg_currPos = $s0;
                                          $s0 = $this->peg_FAILED;
                                        }
                                      } else {
                                        $this->peg_currPos = $s0;
                                        $s0 = $this->peg_FAILED;
                                      }
                                    } else {
                                      $this->peg_currPos = $s0;
                                      $s0 = $this->peg_FAILED;
                                    }
                                  } else {
                                    $this->peg_currPos = $s0;
                                    $s0 = $this->peg_FAILED;
                                  }
                                } else {
                                  $this->peg_currPos = $s0;
                                  $s0 = $this->peg_FAILED;
                                }
                              } else {
                                $this->peg_currPos = $s0;
                                $s0 = $this->peg_FAILED;
                              }
                            } else {
                              $this->peg_currPos = $s0;
                              $s0 = $this->peg_FAILED;
                            }
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          }
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseElse() {

      $key    = $this->peg_currPos * 33 + 22;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c57) {
            $s3 = $this->peg_c57;
            $this->peg_currPos += 4;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c58);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                $s5 = $this->peg_c11;
                $this->peg_currPos += 2;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s1 = array($s1, $s2, $s3, $s4, $s5);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseElIf() {

      $key    = $this->peg_currPos * 33 + 23;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c59) {
            $s3 = $this->peg_c59;
            $this->peg_currPos += 4;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c60);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = array();
            $s5 = $this->peg_parse__();
            if ($s5 !== $this->peg_FAILED) {
              while ($s5 !== $this->peg_FAILED) {
                $s4[] = $s5;
                $s5 = $this->peg_parse__();
              }
            } else {
              $s4 = $this->peg_FAILED;
            }
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 4) === $this->peg_c55) {
                $s5 = $this->peg_c55;
                $this->peg_currPos += 4;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c56);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $s6 = $this->peg_parse_();
                if ($s6 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                    $s7 = $this->peg_c21;
                    $this->peg_currPos++;
                  } else {
                    $s7 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c22);
                    }
                  }
                  if ($s7 !== $this->peg_FAILED) {
                    $s8 = $this->peg_parse_();
                    if ($s8 !== $this->peg_FAILED) {
                      $s9 = $this->peg_parseString();
                      if ($s9 !== $this->peg_FAILED) {
                        $s10 = $this->peg_parse_();
                        if ($s10 !== $this->peg_FAILED) {
                          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                            $s11 = $this->peg_c11;
                            $this->peg_currPos += 2;
                          } else {
                            $s11 = $this->peg_FAILED;
                            if ($this->peg_silentFails === 0) {
                                $this->peg_fail($this->peg_c12);
                            }
                          }
                          if ($s11 !== $this->peg_FAILED) {
                            $this->peg_reportedPos = $s0;
                            $s1 = $this->peg_f15($s9);
                            $s0 = $s1;
                          } else {
                            $this->peg_currPos = $s0;
                            $s0 = $this->peg_FAILED;
                          }
                        } else {
                          $this->peg_currPos = $s0;
                          $s0 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s0;
                        $s0 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s0;
                      $s0 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s0;
                    $s0 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseDefineBlock() {

      $key    = $this->peg_currPos * 33 + 24;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 6) === $this->peg_c61) {
            $s3 = $this->peg_c61;
            $this->peg_currPos += 6;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c62);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $s4 = array();
            $s5 = $this->peg_currPos;
            $s6 = array();
            $s7 = $this->peg_parse__();
            if ($s7 !== $this->peg_FAILED) {
              while ($s7 !== $this->peg_FAILED) {
                $s6[] = $s7;
                $s7 = $this->peg_parse__();
              }
            } else {
              $s6 = $this->peg_FAILED;
            }
            if ($s6 !== $this->peg_FAILED) {
              $s7 = $this->peg_parseParamIdentifier();
              if ($s7 !== $this->peg_FAILED) {
                $s8 = $this->peg_parse_();
                if ($s8 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                    $s9 = $this->peg_c21;
                    $this->peg_currPos++;
                  } else {
                    $s9 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c22);
                    }
                  }
                  if ($s9 !== $this->peg_FAILED) {
                    $s10 = $this->peg_parse_();
                    if ($s10 !== $this->peg_FAILED) {
                      $s11 = $this->peg_parseString();
                      if ($s11 !== $this->peg_FAILED) {
                        $s6 = array($s6, $s7, $s8, $s9, $s10, $s11);
                        $s5 = $s6;
                      } else {
                        $this->peg_currPos = $s5;
                        $s5 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s5;
                      $s5 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s5;
                    $s5 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s5;
                  $s5 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s5;
                $s5 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s5;
              $s5 = $this->peg_FAILED;
            }
            while ($s5 !== $this->peg_FAILED) {
              $s4[] = $s5;
              $s5 = $this->peg_currPos;
              $s6 = array();
              $s7 = $this->peg_parse__();
              if ($s7 !== $this->peg_FAILED) {
                while ($s7 !== $this->peg_FAILED) {
                  $s6[] = $s7;
                  $s7 = $this->peg_parse__();
                }
              } else {
                $s6 = $this->peg_FAILED;
              }
              if ($s6 !== $this->peg_FAILED) {
                $s7 = $this->peg_parseParamIdentifier();
                if ($s7 !== $this->peg_FAILED) {
                  $s8 = $this->peg_parse_();
                  if ($s8 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                      $s9 = $this->peg_c21;
                      $this->peg_currPos++;
                    } else {
                      $s9 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c22);
                      }
                    }
                    if ($s9 !== $this->peg_FAILED) {
                      $s10 = $this->peg_parse_();
                      if ($s10 !== $this->peg_FAILED) {
                        $s11 = $this->peg_parseString();
                        if ($s11 !== $this->peg_FAILED) {
                          $s6 = array($s6, $s7, $s8, $s9, $s10, $s11);
                          $s5 = $s6;
                        } else {
                          $this->peg_currPos = $s5;
                          $s5 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s5;
                        $s5 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s5;
                      $s5 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s5;
                    $s5 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s5;
                  $s5 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s5;
                $s5 = $this->peg_FAILED;
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c63) {
                  $s6 = $this->peg_c63;
                  $this->peg_currPos += 3;
                } else {
                  $s6 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c64);
                  }
                }
                if ($s6 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f16($s4);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseGenericBlock() {

      $key    = $this->peg_currPos * 33 + 25;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseIdentifier();
          if ($s3 !== $this->peg_FAILED) {
            $s4 = array();
            $s5 = $this->peg_currPos;
            $s6 = array();
            $s7 = $this->peg_parse__();
            if ($s7 !== $this->peg_FAILED) {
              while ($s7 !== $this->peg_FAILED) {
                $s6[] = $s7;
                $s7 = $this->peg_parse__();
              }
            } else {
              $s6 = $this->peg_FAILED;
            }
            if ($s6 !== $this->peg_FAILED) {
              $s7 = $this->peg_parseParamIdentifier();
              if ($s7 !== $this->peg_FAILED) {
                $s8 = $this->peg_parse_();
                if ($s8 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                    $s9 = $this->peg_c21;
                    $this->peg_currPos++;
                  } else {
                    $s9 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c22);
                    }
                  }
                  if ($s9 !== $this->peg_FAILED) {
                    $s10 = $this->peg_parse_();
                    if ($s10 !== $this->peg_FAILED) {
                      $s11 = $this->peg_parseString();
                      if ($s11 !== $this->peg_FAILED) {
                        $s6 = array($s6, $s7, $s8, $s9, $s10, $s11);
                        $s5 = $s6;
                      } else {
                        $this->peg_currPos = $s5;
                        $s5 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s5;
                      $s5 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s5;
                    $s5 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s5;
                  $s5 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s5;
                $s5 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s5;
              $s5 = $this->peg_FAILED;
            }
            while ($s5 !== $this->peg_FAILED) {
              $s4[] = $s5;
              $s5 = $this->peg_currPos;
              $s6 = array();
              $s7 = $this->peg_parse__();
              if ($s7 !== $this->peg_FAILED) {
                while ($s7 !== $this->peg_FAILED) {
                  $s6[] = $s7;
                  $s7 = $this->peg_parse__();
                }
              } else {
                $s6 = $this->peg_FAILED;
              }
              if ($s6 !== $this->peg_FAILED) {
                $s7 = $this->peg_parseParamIdentifier();
                if ($s7 !== $this->peg_FAILED) {
                  $s8 = $this->peg_parse_();
                  if ($s8 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                      $s9 = $this->peg_c21;
                      $this->peg_currPos++;
                    } else {
                      $s9 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c22);
                      }
                    }
                    if ($s9 !== $this->peg_FAILED) {
                      $s10 = $this->peg_parse_();
                      if ($s10 !== $this->peg_FAILED) {
                        $s11 = $this->peg_parseString();
                        if ($s11 !== $this->peg_FAILED) {
                          $s6 = array($s6, $s7, $s8, $s9, $s10, $s11);
                          $s5 = $s6;
                        } else {
                          $this->peg_currPos = $s5;
                          $s5 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s5;
                        $s5 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s5;
                      $s5 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s5;
                    $s5 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s5;
                  $s5 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s5;
                $s5 = $this->peg_FAILED;
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c63) {
                  $s6 = $this->peg_c63;
                  $this->peg_currPos += 3;
                } else {
                  $s6 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c64);
                  }
                }
                if ($s6 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f17($s3, $s4);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        $s1 = $this->peg_parseBeginBlock();
        if ($s1 !== $this->peg_FAILED) {
          $s2 = array();
          $s3 = $this->peg_parseBlock();
          if ($s3 === $this->peg_FAILED) {
            $s3 = $this->peg_parseRaw();
          }
          while ($s3 !== $this->peg_FAILED) {
            $s2[] = $s3;
            $s3 = $this->peg_parseBlock();
            if ($s3 === $this->peg_FAILED) {
              $s3 = $this->peg_parseRaw();
            }
          }
          if ($s2 !== $this->peg_FAILED) {
            $s3 = $this->peg_parseEndBlock();
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $this->peg_currPos;
              $s4 = $this->peg_f18($s1, $s2, $s3);
              if ($s4) {
                $s4 = null;
              } else {
                $s4 = $this->peg_FAILED;
              }
              if ($s4 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f19($s1, $s2, $s3);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseBeginBlock() {

      $key    = $this->peg_currPos * 33 + 26;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c0) {
        $s1 = $this->peg_c0;
        $this->peg_currPos += 2;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c1);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseIdentifier();
          if ($s3 !== $this->peg_FAILED) {
            $s4 = array();
            $s5 = $this->peg_currPos;
            $s6 = array();
            $s7 = $this->peg_parse__();
            if ($s7 !== $this->peg_FAILED) {
              while ($s7 !== $this->peg_FAILED) {
                $s6[] = $s7;
                $s7 = $this->peg_parse__();
              }
            } else {
              $s6 = $this->peg_FAILED;
            }
            if ($s6 !== $this->peg_FAILED) {
              $s7 = $this->peg_parseParamIdentifier();
              if ($s7 !== $this->peg_FAILED) {
                $s8 = $this->peg_parse_();
                if ($s8 !== $this->peg_FAILED) {
                  if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                    $s9 = $this->peg_c21;
                    $this->peg_currPos++;
                  } else {
                    $s9 = $this->peg_FAILED;
                    if ($this->peg_silentFails === 0) {
                        $this->peg_fail($this->peg_c22);
                    }
                  }
                  if ($s9 !== $this->peg_FAILED) {
                    $s10 = $this->peg_parse_();
                    if ($s10 !== $this->peg_FAILED) {
                      $s11 = $this->peg_parseString();
                      if ($s11 !== $this->peg_FAILED) {
                        $s6 = array($s6, $s7, $s8, $s9, $s10, $s11);
                        $s5 = $s6;
                      } else {
                        $this->peg_currPos = $s5;
                        $s5 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s5;
                      $s5 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s5;
                    $s5 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s5;
                  $s5 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s5;
                $s5 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s5;
              $s5 = $this->peg_FAILED;
            }
            while ($s5 !== $this->peg_FAILED) {
              $s4[] = $s5;
              $s5 = $this->peg_currPos;
              $s6 = array();
              $s7 = $this->peg_parse__();
              if ($s7 !== $this->peg_FAILED) {
                while ($s7 !== $this->peg_FAILED) {
                  $s6[] = $s7;
                  $s7 = $this->peg_parse__();
                }
              } else {
                $s6 = $this->peg_FAILED;
              }
              if ($s6 !== $this->peg_FAILED) {
                $s7 = $this->peg_parseParamIdentifier();
                if ($s7 !== $this->peg_FAILED) {
                  $s8 = $this->peg_parse_();
                  if ($s8 !== $this->peg_FAILED) {
                    if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c21) {
                      $s9 = $this->peg_c21;
                      $this->peg_currPos++;
                    } else {
                      $s9 = $this->peg_FAILED;
                      if ($this->peg_silentFails === 0) {
                          $this->peg_fail($this->peg_c22);
                      }
                    }
                    if ($s9 !== $this->peg_FAILED) {
                      $s10 = $this->peg_parse_();
                      if ($s10 !== $this->peg_FAILED) {
                        $s11 = $this->peg_parseString();
                        if ($s11 !== $this->peg_FAILED) {
                          $s6 = array($s6, $s7, $s8, $s9, $s10, $s11);
                          $s5 = $s6;
                        } else {
                          $this->peg_currPos = $s5;
                          $s5 = $this->peg_FAILED;
                        }
                      } else {
                        $this->peg_currPos = $s5;
                        $s5 = $this->peg_FAILED;
                      }
                    } else {
                      $this->peg_currPos = $s5;
                      $s5 = $this->peg_FAILED;
                    }
                  } else {
                    $this->peg_currPos = $s5;
                    $s5 = $this->peg_FAILED;
                  }
                } else {
                  $this->peg_currPos = $s5;
                  $s5 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s5;
                $s5 = $this->peg_FAILED;
              }
            }
            if ($s4 !== $this->peg_FAILED) {
              $s5 = $this->peg_parse_();
              if ($s5 !== $this->peg_FAILED) {
                if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                  $s6 = $this->peg_c11;
                  $this->peg_currPos += 2;
                } else {
                  $s6 = $this->peg_FAILED;
                  if ($this->peg_silentFails === 0) {
                      $this->peg_fail($this->peg_c12);
                  }
                }
                if ($s6 !== $this->peg_FAILED) {
                  $this->peg_reportedPos = $s0;
                  $s1 = $this->peg_f20($s3, $s4);
                  $s0 = $s1;
                } else {
                  $this->peg_currPos = $s0;
                  $s0 = $this->peg_FAILED;
                }
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseEndBlock() {

      $key    = $this->peg_currPos * 33 + 27;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 3) === $this->peg_c13) {
        $s1 = $this->peg_c13;
        $this->peg_currPos += 3;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c14);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = $this->peg_parse_();
        if ($s2 !== $this->peg_FAILED) {
          $s3 = $this->peg_parseIdentifier();
          if ($s3 !== $this->peg_FAILED) {
            $s4 = $this->peg_parse_();
            if ($s4 !== $this->peg_FAILED) {
              if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c11) {
                $s5 = $this->peg_c11;
                $this->peg_currPos += 2;
              } else {
                $s5 = $this->peg_FAILED;
                if ($this->peg_silentFails === 0) {
                    $this->peg_fail($this->peg_c12);
                }
              }
              if ($s5 !== $this->peg_FAILED) {
                $this->peg_reportedPos = $s0;
                $s1 = $this->peg_f21($s3);
                $s0 = $s1;
              } else {
                $this->peg_currPos = $s0;
                $s0 = $this->peg_FAILED;
              }
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseString() {

      $key    = $this->peg_currPos * 33 + 28;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c65) {
        $s1 = $this->peg_c65;
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c66);
        }
      }
      if ($s1 !== $this->peg_FAILED) {
        $s2 = array();
        $s3 = $this->peg_parseStringCharsA();
        while ($s3 !== $this->peg_FAILED) {
          $s2[] = $s3;
          $s3 = $this->peg_parseStringCharsA();
        }
        if ($s2 !== $this->peg_FAILED) {
          if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c65) {
            $s3 = $this->peg_c65;
            $this->peg_currPos++;
          } else {
            $s3 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c66);
            }
          }
          if ($s3 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f22($s2);
            $s0 = $s1;
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c67) {
          $s1 = $this->peg_c67;
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c68);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $s2 = array();
          $s3 = $this->peg_parseStringCharsB();
          while ($s3 !== $this->peg_FAILED) {
            $s2[] = $s3;
            $s3 = $this->peg_parseStringCharsB();
          }
          if ($s2 !== $this->peg_FAILED) {
            if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c67) {
              $s3 = $this->peg_c67;
              $this->peg_currPos++;
            } else {
              $s3 = $this->peg_FAILED;
              if ($this->peg_silentFails === 0) {
                  $this->peg_fail($this->peg_c68);
              }
            }
            if ($s3 !== $this->peg_FAILED) {
              $this->peg_reportedPos = $s0;
              $s1 = $this->peg_f23($s2);
              $s0 = $s1;
            } else {
              $this->peg_currPos = $s0;
              $s0 = $this->peg_FAILED;
            }
          } else {
            $this->peg_currPos = $s0;
            $s0 = $this->peg_FAILED;
          }
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseStringCharsA() {

      $key    = $this->peg_currPos * 33 + 29;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c65) {
        $s2 = $this->peg_c65;
        $this->peg_currPos++;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c66);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c69) {
          $s2 = $this->peg_c69;
          $this->peg_currPos++;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c70);
          }
        }
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_length > $this->peg_currPos) {
          $s2 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f3($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c71) {
          $s1 = $this->peg_c71;
          $this->peg_currPos += 2;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c72);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f24();
        }
        $s0 = $s1;
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c73) {
            $s1 = $this->peg_c73;
            $this->peg_currPos += 2;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c74);
            }
          }
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f25();
          }
          $s0 = $s1;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parseStringCharsB() {

      $key    = $this->peg_currPos * 33 + 30;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $s0 = $this->peg_currPos;
      $s1 = $this->peg_currPos;
      $this->peg_silentFails++;
      if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c67) {
        $s2 = $this->peg_c67;
        $this->peg_currPos++;
      } else {
        $s2 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c68);
        }
      }
      if ($s2 === $this->peg_FAILED) {
        if ($this->input_substr($this->peg_currPos, 1) === $this->peg_c69) {
          $s2 = $this->peg_c69;
          $this->peg_currPos++;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c70);
          }
        }
      }
      $this->peg_silentFails--;
      if ($s2 === $this->peg_FAILED) {
        $s1 = null;
      } else {
        $this->peg_currPos = $s1;
        $s1 = $this->peg_FAILED;
      }
      if ($s1 !== $this->peg_FAILED) {
        if ($this->input_length > $this->peg_currPos) {
          $s2 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s2 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c6);
          }
        }
        if ($s2 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f3($s2);
          $s0 = $s1;
        } else {
          $this->peg_currPos = $s0;
          $s0 = $this->peg_FAILED;
        }
      } else {
        $this->peg_currPos = $s0;
        $s0 = $this->peg_FAILED;
      }
      if ($s0 === $this->peg_FAILED) {
        $s0 = $this->peg_currPos;
        if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c71) {
          $s1 = $this->peg_c71;
          $this->peg_currPos += 2;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c72);
          }
        }
        if ($s1 !== $this->peg_FAILED) {
          $this->peg_reportedPos = $s0;
          $s1 = $this->peg_f24();
        }
        $s0 = $s1;
        if ($s0 === $this->peg_FAILED) {
          $s0 = $this->peg_currPos;
          if ($this->input_substr($this->peg_currPos, 2) === $this->peg_c75) {
            $s1 = $this->peg_c75;
            $this->peg_currPos += 2;
          } else {
            $s1 = $this->peg_FAILED;
            if ($this->peg_silentFails === 0) {
                $this->peg_fail($this->peg_c76);
            }
          }
          if ($s1 !== $this->peg_FAILED) {
            $this->peg_reportedPos = $s0;
            $s1 = $this->peg_f26();
          }
          $s0 = $s1;
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parse_() {

      $key    = $this->peg_currPos * 33 + 31;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_silentFails++;
      $s0 = array();
      if (peg_regex_test($this->peg_c78, $this->input_substr($this->peg_currPos, 1))) {
        $s1 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c79);
        }
      }
      while ($s1 !== $this->peg_FAILED) {
        $s0[] = $s1;
        if (peg_regex_test($this->peg_c78, $this->input_substr($this->peg_currPos, 1))) {
          $s1 = $this->input_substr($this->peg_currPos, 1);
          $this->peg_currPos++;
        } else {
          $s1 = $this->peg_FAILED;
          if ($this->peg_silentFails === 0) {
              $this->peg_fail($this->peg_c79);
          }
        }
      }
      $this->peg_silentFails--;
      if ($s0 === $this->peg_FAILED) {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c77);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

    private function peg_parse__() {

      $key    = $this->peg_currPos * 33 + 32;
          $cached = isset($this->peg_cache[$key]) ? $this->peg_cache[$key] : null;

      if ($cached) {
        $this->peg_currPos = $cached["nextPos"];
        return $cached["result"];
      }

      $this->peg_silentFails++;
      if (peg_regex_test($this->peg_c78, $this->input_substr($this->peg_currPos, 1))) {
        $s0 = $this->input_substr($this->peg_currPos, 1);
        $this->peg_currPos++;
      } else {
        $s0 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c79);
        }
      }
      $this->peg_silentFails--;
      if ($s0 === $this->peg_FAILED) {
        $s1 = $this->peg_FAILED;
        if ($this->peg_silentFails === 0) {
            $this->peg_fail($this->peg_c80);
        }
      }

      $this->peg_cache[$key] = array ("nextPos" => $this->peg_currPos, "result" => $s0 );

      return $s0;
    }

  public function parse($input) {
    $arguments = func_get_args();
    $options = count($arguments) > 1 ? $arguments[1] : array();
    $this->cleanup_state();

    if (is_array($input)) {
        $this->input = $input;
    } else {
        preg_match_all("/./us", $input, $match);
        $this->input = $match[0];
    }
    $this->input_length = count($this->input);

    $old_regex_encoding = mb_regex_encoding();
    mb_regex_encoding("UTF-8");

    $this->peg_FAILED = new stdClass;
    $this->peg_c0 = "[[";
    $this->peg_c1 = array( "type" => "literal", "value" => "[[", "description" => "\"[[\"" );
    $this->peg_c2 = "{#";
    $this->peg_c3 = array( "type" => "literal", "value" => "{#", "description" => "\"{#\"" );
    $this->peg_c4 = "{@";
    $this->peg_c5 = array( "type" => "literal", "value" => "{@", "description" => "\"{@\"" );
    $this->peg_c6 = array("type" => "any", "description" => "any character" );
    $this->peg_c7 = "/^[^\\[{]/";
    $this->peg_c8 = array( "type" => "class", "value" => "[[{]", "description" => "[[{]" );
    $this->peg_c9 = "comment";
    $this->peg_c10 = array( "type" => "literal", "value" => "comment", "description" => "\"comment\"" );
    $this->peg_c11 = "]]";
    $this->peg_c12 = array( "type" => "literal", "value" => "]]", "description" => "\"]]\"" );
    $this->peg_c13 = "[[/";
    $this->peg_c14 = array( "type" => "literal", "value" => "[[/", "description" => "\"[[/\"" );
    $this->peg_c15 = "/^[^\\[]/";
    $this->peg_c16 = array( "type" => "class", "value" => "[[]", "description" => "[[]" );
    $this->peg_c17 = "escape";
    $this->peg_c18 = array( "type" => "literal", "value" => "escape", "description" => "\"escape\"" );
    $this->peg_c19 = "value";
    $this->peg_c20 = array( "type" => "literal", "value" => "value", "description" => "\"value\"" );
    $this->peg_c21 = "=";
    $this->peg_c22 = array( "type" => "literal", "value" => "=", "description" => "\"=\"" );
    $this->peg_c23 = ":";
    $this->peg_c24 = array( "type" => "literal", "value" => ":", "description" => "\":\"" );
    $this->peg_c25 = ",";
    $this->peg_c26 = array( "type" => "literal", "value" => ",", "description" => "\",\"" );
    $this->peg_c27 = "@}";
    $this->peg_c28 = array( "type" => "literal", "value" => "@}", "description" => "\"@}\"" );
    $this->peg_c29 = "#}";
    $this->peg_c30 = array( "type" => "literal", "value" => "#}", "description" => "\"#}\"" );
    $this->peg_c31 = array("type" => "other", "description" => "identifier" );
    $this->peg_c32 = array("type" => "other", "description" => "unicode letter character" );
    $this->peg_c33 = "/^[a-zµß-öø-\\x{00FF}\\x{0101}\\x{0103}\\x{0105}\\x{0107}\\x{0109}\\x{010B}\\x{010D}\\x{010F}\\x{0111}\\x{0113}\\x{0115}\\x{0117}\\x{0119}\\x{011B}\\x{011D}\\x{011F}\\x{0121}\\x{0123}\\x{0125}\\x{0127}\\x{0129}\\x{012B}\\x{012D}\\x{012F}\\x{0131}\\x{0133}\\x{0135}\\x{0137}-\\x{0138}\\x{013A}\\x{013C}\\x{013E}\\x{0140}\\x{0142}\\x{0144}\\x{0146}\\x{0148}-\\x{0149}\\x{014B}\\x{014D}\\x{014F}\\x{0151}\\x{0153}\\x{0155}\\x{0157}\\x{0159}\\x{015B}\\x{015D}\\x{015F}\\x{0161}\\x{0163}\\x{0165}\\x{0167}\\x{0169}\\x{016B}\\x{016D}\\x{016F}\\x{0171}\\x{0173}\\x{0175}\\x{0177}\\x{017A}\\x{017C}\\x{017E}-\\x{0180}\\x{0183}\\x{0185}\\x{0188}\\x{018C}-\\x{018D}\\x{0192}\\x{0195}\\x{0199}-\\x{019B}\\x{019E}\\x{01A1}\\x{01A3}\\x{01A5}\\x{01A8}\\x{01AA}-\\x{01AB}\\x{01AD}\\x{01B0}\\x{01B4}\\x{01B6}\\x{01B9}-\\x{01BA}\\x{01BD}-\\x{01BF}\\x{01C6}\\x{01C9}\\x{01CC}\\x{01CE}\\x{01D0}\\x{01D2}\\x{01D4}\\x{01D6}\\x{01D8}\\x{01DA}\\x{01DC}-\\x{01DD}\\x{01DF}\\x{01E1}\\x{01E3}\\x{01E5}\\x{01E7}\\x{01E9}\\x{01EB}\\x{01ED}\\x{01EF}-\\x{01F0}\\x{01F3}\\x{01F5}\\x{01F9}\\x{01FB}\\x{01FD}\\x{01FF}\\x{0201}\\x{0203}\\x{0205}\\x{0207}\\x{0209}\\x{020B}\\x{020D}\\x{020F}\\x{0211}\\x{0213}\\x{0215}\\x{0217}\\x{0219}\\x{021B}\\x{021D}\\x{021F}\\x{0221}\\x{0223}\\x{0225}\\x{0227}\\x{0229}\\x{022B}\\x{022D}\\x{022F}\\x{0231}\\x{0233}-\\x{0239}\\x{023C}\\x{023F}-\\x{0240}\\x{0242}\\x{0247}\\x{0249}\\x{024B}\\x{024D}\\x{024F}-\\x{0293}\\x{0295}-\\x{02AF}\\x{0371}\\x{0373}\\x{0377}\\x{037B}-\\x{037D}\\x{0390}\\x{03AC}-\\x{03CE}\\x{03D0}-\\x{03D1}\\x{03D5}-\\x{03D7}\\x{03D9}\\x{03DB}\\x{03DD}\\x{03DF}\\x{03E1}\\x{03E3}\\x{03E5}\\x{03E7}\\x{03E9}\\x{03EB}\\x{03ED}\\x{03EF}-\\x{03F3}\\x{03F5}\\x{03F8}\\x{03FB}-\\x{03FC}\\x{0430}-\\x{045F}\\x{0461}\\x{0463}\\x{0465}\\x{0467}\\x{0469}\\x{046B}\\x{046D}\\x{046F}\\x{0471}\\x{0473}\\x{0475}\\x{0477}\\x{0479}\\x{047B}\\x{047D}\\x{047F}\\x{0481}\\x{048B}\\x{048D}\\x{048F}\\x{0491}\\x{0493}\\x{0495}\\x{0497}\\x{0499}\\x{049B}\\x{049D}\\x{049F}\\x{04A1}\\x{04A3}\\x{04A5}\\x{04A7}\\x{04A9}\\x{04AB}\\x{04AD}\\x{04AF}\\x{04B1}\\x{04B3}\\x{04B5}\\x{04B7}\\x{04B9}\\x{04BB}\\x{04BD}\\x{04BF}\\x{04C2}\\x{04C4}\\x{04C6}\\x{04C8}\\x{04CA}\\x{04CC}\\x{04CE}-\\x{04CF}\\x{04D1}\\x{04D3}\\x{04D5}\\x{04D7}\\x{04D9}\\x{04DB}\\x{04DD}\\x{04DF}\\x{04E1}\\x{04E3}\\x{04E5}\\x{04E7}\\x{04E9}\\x{04EB}\\x{04ED}\\x{04EF}\\x{04F1}\\x{04F3}\\x{04F5}\\x{04F7}\\x{04F9}\\x{04FB}\\x{04FD}\\x{04FF}\\x{0501}\\x{0503}\\x{0505}\\x{0507}\\x{0509}\\x{050B}\\x{050D}\\x{050F}\\x{0511}\\x{0513}\\x{0515}\\x{0517}\\x{0519}\\x{051B}\\x{051D}\\x{051F}\\x{0521}\\x{0523}\\x{0525}\\x{0527}\\x{0529}\\x{052B}\\x{052D}\\x{052F}\\x{0561}-\\x{0587}\\x{13F8}-\\x{13FD}\\x{1D00}-\\x{1D2B}\\x{1D6B}-\\x{1D77}\\x{1D79}-\\x{1D9A}\\x{1E01}\\x{1E03}\\x{1E05}\\x{1E07}\\x{1E09}\\x{1E0B}\\x{1E0D}\\x{1E0F}\\x{1E11}\\x{1E13}\\x{1E15}\\x{1E17}\\x{1E19}\\x{1E1B}\\x{1E1D}\\x{1E1F}\\x{1E21}\\x{1E23}\\x{1E25}\\x{1E27}\\x{1E29}\\x{1E2B}\\x{1E2D}\\x{1E2F}\\x{1E31}\\x{1E33}\\x{1E35}\\x{1E37}\\x{1E39}\\x{1E3B}\\x{1E3D}\\x{1E3F}\\x{1E41}\\x{1E43}\\x{1E45}\\x{1E47}\\x{1E49}\\x{1E4B}\\x{1E4D}\\x{1E4F}\\x{1E51}\\x{1E53}\\x{1E55}\\x{1E57}\\x{1E59}\\x{1E5B}\\x{1E5D}\\x{1E5F}\\x{1E61}\\x{1E63}\\x{1E65}\\x{1E67}\\x{1E69}\\x{1E6B}\\x{1E6D}\\x{1E6F}\\x{1E71}\\x{1E73}\\x{1E75}\\x{1E77}\\x{1E79}\\x{1E7B}\\x{1E7D}\\x{1E7F}\\x{1E81}\\x{1E83}\\x{1E85}\\x{1E87}\\x{1E89}\\x{1E8B}\\x{1E8D}\\x{1E8F}\\x{1E91}\\x{1E93}\\x{1E95}-\\x{1E9D}\\x{1E9F}\\x{1EA1}\\x{1EA3}\\x{1EA5}\\x{1EA7}\\x{1EA9}\\x{1EAB}\\x{1EAD}\\x{1EAF}\\x{1EB1}\\x{1EB3}\\x{1EB5}\\x{1EB7}\\x{1EB9}\\x{1EBB}\\x{1EBD}\\x{1EBF}\\x{1EC1}\\x{1EC3}\\x{1EC5}\\x{1EC7}\\x{1EC9}\\x{1ECB}\\x{1ECD}\\x{1ECF}\\x{1ED1}\\x{1ED3}\\x{1ED5}\\x{1ED7}\\x{1ED9}\\x{1EDB}\\x{1EDD}\\x{1EDF}\\x{1EE1}\\x{1EE3}\\x{1EE5}\\x{1EE7}\\x{1EE9}\\x{1EEB}\\x{1EED}\\x{1EEF}\\x{1EF1}\\x{1EF3}\\x{1EF5}\\x{1EF7}\\x{1EF9}\\x{1EFB}\\x{1EFD}\\x{1EFF}-\\x{1F07}\\x{1F10}-\\x{1F15}\\x{1F20}-\\x{1F27}\\x{1F30}-\\x{1F37}\\x{1F40}-\\x{1F45}\\x{1F50}-\\x{1F57}\\x{1F60}-\\x{1F67}\\x{1F70}-\\x{1F7D}\\x{1F80}-\\x{1F87}\\x{1F90}-\\x{1F97}\\x{1FA0}-\\x{1FA7}\\x{1FB0}-\\x{1FB4}\\x{1FB6}-\\x{1FB7}\\x{1FBE}\\x{1FC2}-\\x{1FC4}\\x{1FC6}-\\x{1FC7}\\x{1FD0}-\\x{1FD3}\\x{1FD6}-\\x{1FD7}\\x{1FE0}-\\x{1FE7}\\x{1FF2}-\\x{1FF4}\\x{1FF6}-\\x{1FF7}\\x{210A}\\x{210E}-\\x{210F}\\x{2113}\\x{212F}\\x{2134}\\x{2139}\\x{213C}-\\x{213D}\\x{2146}-\\x{2149}\\x{214E}\\x{2184}\\x{2C30}-\\x{2C5E}\\x{2C61}\\x{2C65}-\\x{2C66}\\x{2C68}\\x{2C6A}\\x{2C6C}\\x{2C71}\\x{2C73}-\\x{2C74}\\x{2C76}-\\x{2C7B}\\x{2C81}\\x{2C83}\\x{2C85}\\x{2C87}\\x{2C89}\\x{2C8B}\\x{2C8D}\\x{2C8F}\\x{2C91}\\x{2C93}\\x{2C95}\\x{2C97}\\x{2C99}\\x{2C9B}\\x{2C9D}\\x{2C9F}\\x{2CA1}\\x{2CA3}\\x{2CA5}\\x{2CA7}\\x{2CA9}\\x{2CAB}\\x{2CAD}\\x{2CAF}\\x{2CB1}\\x{2CB3}\\x{2CB5}\\x{2CB7}\\x{2CB9}\\x{2CBB}\\x{2CBD}\\x{2CBF}\\x{2CC1}\\x{2CC3}\\x{2CC5}\\x{2CC7}\\x{2CC9}\\x{2CCB}\\x{2CCD}\\x{2CCF}\\x{2CD1}\\x{2CD3}\\x{2CD5}\\x{2CD7}\\x{2CD9}\\x{2CDB}\\x{2CDD}\\x{2CDF}\\x{2CE1}\\x{2CE3}-\\x{2CE4}\\x{2CEC}\\x{2CEE}\\x{2CF3}\\x{2D00}-\\x{2D25}\\x{2D27}\\x{2D2D}\\x{A641}\\x{A643}\\x{A645}\\x{A647}\\x{A649}\\x{A64B}\\x{A64D}\\x{A64F}\\x{A651}\\x{A653}\\x{A655}\\x{A657}\\x{A659}\\x{A65B}\\x{A65D}\\x{A65F}\\x{A661}\\x{A663}\\x{A665}\\x{A667}\\x{A669}\\x{A66B}\\x{A66D}\\x{A681}\\x{A683}\\x{A685}\\x{A687}\\x{A689}\\x{A68B}\\x{A68D}\\x{A68F}\\x{A691}\\x{A693}\\x{A695}\\x{A697}\\x{A699}\\x{A69B}\\x{A723}\\x{A725}\\x{A727}\\x{A729}\\x{A72B}\\x{A72D}\\x{A72F}-\\x{A731}\\x{A733}\\x{A735}\\x{A737}\\x{A739}\\x{A73B}\\x{A73D}\\x{A73F}\\x{A741}\\x{A743}\\x{A745}\\x{A747}\\x{A749}\\x{A74B}\\x{A74D}\\x{A74F}\\x{A751}\\x{A753}\\x{A755}\\x{A757}\\x{A759}\\x{A75B}\\x{A75D}\\x{A75F}\\x{A761}\\x{A763}\\x{A765}\\x{A767}\\x{A769}\\x{A76B}\\x{A76D}\\x{A76F}\\x{A771}-\\x{A778}\\x{A77A}\\x{A77C}\\x{A77F}\\x{A781}\\x{A783}\\x{A785}\\x{A787}\\x{A78C}\\x{A78E}\\x{A791}\\x{A793}-\\x{A795}\\x{A797}\\x{A799}\\x{A79B}\\x{A79D}\\x{A79F}\\x{A7A1}\\x{A7A3}\\x{A7A5}\\x{A7A7}\\x{A7A9}\\x{A7B5}\\x{A7B7}\\x{A7FA}\\x{AB30}-\\x{AB5A}\\x{AB60}-\\x{AB65}\\x{AB70}-\\x{ABBF}\\x{FB00}-\\x{FB06}\\x{FB13}-\\x{FB17}\\x{FF41}-\\x{FF5A}]/";
    $this->peg_c34 = array( "type" => "class", "value" => "[a-zµß-öø-\x{00FF}\x{0101}\x{0103}\x{0105}\x{0107}\x{0109}\x{010B}\x{010D}\x{010F}\x{0111}\x{0113}\x{0115}\x{0117}\x{0119}\x{011B}\x{011D}\x{011F}\x{0121}\x{0123}\x{0125}\x{0127}\x{0129}\x{012B}\x{012D}\x{012F}\x{0131}\x{0133}\x{0135}\x{0137}-\x{0138}\x{013A}\x{013C}\x{013E}\x{0140}\x{0142}\x{0144}\x{0146}\x{0148}-\x{0149}\x{014B}\x{014D}\x{014F}\x{0151}\x{0153}\x{0155}\x{0157}\x{0159}\x{015B}\x{015D}\x{015F}\x{0161}\x{0163}\x{0165}\x{0167}\x{0169}\x{016B}\x{016D}\x{016F}\x{0171}\x{0173}\x{0175}\x{0177}\x{017A}\x{017C}\x{017E}-\x{0180}\x{0183}\x{0185}\x{0188}\x{018C}-\x{018D}\x{0192}\x{0195}\x{0199}-\x{019B}\x{019E}\x{01A1}\x{01A3}\x{01A5}\x{01A8}\x{01AA}-\x{01AB}\x{01AD}\x{01B0}\x{01B4}\x{01B6}\x{01B9}-\x{01BA}\x{01BD}-\x{01BF}\x{01C6}\x{01C9}\x{01CC}\x{01CE}\x{01D0}\x{01D2}\x{01D4}\x{01D6}\x{01D8}\x{01DA}\x{01DC}-\x{01DD}\x{01DF}\x{01E1}\x{01E3}\x{01E5}\x{01E7}\x{01E9}\x{01EB}\x{01ED}\x{01EF}-\x{01F0}\x{01F3}\x{01F5}\x{01F9}\x{01FB}\x{01FD}\x{01FF}\x{0201}\x{0203}\x{0205}\x{0207}\x{0209}\x{020B}\x{020D}\x{020F}\x{0211}\x{0213}\x{0215}\x{0217}\x{0219}\x{021B}\x{021D}\x{021F}\x{0221}\x{0223}\x{0225}\x{0227}\x{0229}\x{022B}\x{022D}\x{022F}\x{0231}\x{0233}-\x{0239}\x{023C}\x{023F}-\x{0240}\x{0242}\x{0247}\x{0249}\x{024B}\x{024D}\x{024F}-\x{0293}\x{0295}-\x{02AF}\x{0371}\x{0373}\x{0377}\x{037B}-\x{037D}\x{0390}\x{03AC}-\x{03CE}\x{03D0}-\x{03D1}\x{03D5}-\x{03D7}\x{03D9}\x{03DB}\x{03DD}\x{03DF}\x{03E1}\x{03E3}\x{03E5}\x{03E7}\x{03E9}\x{03EB}\x{03ED}\x{03EF}-\x{03F3}\x{03F5}\x{03F8}\x{03FB}-\x{03FC}\x{0430}-\x{045F}\x{0461}\x{0463}\x{0465}\x{0467}\x{0469}\x{046B}\x{046D}\x{046F}\x{0471}\x{0473}\x{0475}\x{0477}\x{0479}\x{047B}\x{047D}\x{047F}\x{0481}\x{048B}\x{048D}\x{048F}\x{0491}\x{0493}\x{0495}\x{0497}\x{0499}\x{049B}\x{049D}\x{049F}\x{04A1}\x{04A3}\x{04A5}\x{04A7}\x{04A9}\x{04AB}\x{04AD}\x{04AF}\x{04B1}\x{04B3}\x{04B5}\x{04B7}\x{04B9}\x{04BB}\x{04BD}\x{04BF}\x{04C2}\x{04C4}\x{04C6}\x{04C8}\x{04CA}\x{04CC}\x{04CE}-\x{04CF}\x{04D1}\x{04D3}\x{04D5}\x{04D7}\x{04D9}\x{04DB}\x{04DD}\x{04DF}\x{04E1}\x{04E3}\x{04E5}\x{04E7}\x{04E9}\x{04EB}\x{04ED}\x{04EF}\x{04F1}\x{04F3}\x{04F5}\x{04F7}\x{04F9}\x{04FB}\x{04FD}\x{04FF}\x{0501}\x{0503}\x{0505}\x{0507}\x{0509}\x{050B}\x{050D}\x{050F}\x{0511}\x{0513}\x{0515}\x{0517}\x{0519}\x{051B}\x{051D}\x{051F}\x{0521}\x{0523}\x{0525}\x{0527}\x{0529}\x{052B}\x{052D}\x{052F}\x{0561}-\x{0587}\x{13F8}-\x{13FD}\x{1D00}-\x{1D2B}\x{1D6B}-\x{1D77}\x{1D79}-\x{1D9A}\x{1E01}\x{1E03}\x{1E05}\x{1E07}\x{1E09}\x{1E0B}\x{1E0D}\x{1E0F}\x{1E11}\x{1E13}\x{1E15}\x{1E17}\x{1E19}\x{1E1B}\x{1E1D}\x{1E1F}\x{1E21}\x{1E23}\x{1E25}\x{1E27}\x{1E29}\x{1E2B}\x{1E2D}\x{1E2F}\x{1E31}\x{1E33}\x{1E35}\x{1E37}\x{1E39}\x{1E3B}\x{1E3D}\x{1E3F}\x{1E41}\x{1E43}\x{1E45}\x{1E47}\x{1E49}\x{1E4B}\x{1E4D}\x{1E4F}\x{1E51}\x{1E53}\x{1E55}\x{1E57}\x{1E59}\x{1E5B}\x{1E5D}\x{1E5F}\x{1E61}\x{1E63}\x{1E65}\x{1E67}\x{1E69}\x{1E6B}\x{1E6D}\x{1E6F}\x{1E71}\x{1E73}\x{1E75}\x{1E77}\x{1E79}\x{1E7B}\x{1E7D}\x{1E7F}\x{1E81}\x{1E83}\x{1E85}\x{1E87}\x{1E89}\x{1E8B}\x{1E8D}\x{1E8F}\x{1E91}\x{1E93}\x{1E95}-\x{1E9D}\x{1E9F}\x{1EA1}\x{1EA3}\x{1EA5}\x{1EA7}\x{1EA9}\x{1EAB}\x{1EAD}\x{1EAF}\x{1EB1}\x{1EB3}\x{1EB5}\x{1EB7}\x{1EB9}\x{1EBB}\x{1EBD}\x{1EBF}\x{1EC1}\x{1EC3}\x{1EC5}\x{1EC7}\x{1EC9}\x{1ECB}\x{1ECD}\x{1ECF}\x{1ED1}\x{1ED3}\x{1ED5}\x{1ED7}\x{1ED9}\x{1EDB}\x{1EDD}\x{1EDF}\x{1EE1}\x{1EE3}\x{1EE5}\x{1EE7}\x{1EE9}\x{1EEB}\x{1EED}\x{1EEF}\x{1EF1}\x{1EF3}\x{1EF5}\x{1EF7}\x{1EF9}\x{1EFB}\x{1EFD}\x{1EFF}-\x{1F07}\x{1F10}-\x{1F15}\x{1F20}-\x{1F27}\x{1F30}-\x{1F37}\x{1F40}-\x{1F45}\x{1F50}-\x{1F57}\x{1F60}-\x{1F67}\x{1F70}-\x{1F7D}\x{1F80}-\x{1F87}\x{1F90}-\x{1F97}\x{1FA0}-\x{1FA7}\x{1FB0}-\x{1FB4}\x{1FB6}-\x{1FB7}\x{1FBE}\x{1FC2}-\x{1FC4}\x{1FC6}-\x{1FC7}\x{1FD0}-\x{1FD3}\x{1FD6}-\x{1FD7}\x{1FE0}-\x{1FE7}\x{1FF2}-\x{1FF4}\x{1FF6}-\x{1FF7}\x{210A}\x{210E}-\x{210F}\x{2113}\x{212F}\x{2134}\x{2139}\x{213C}-\x{213D}\x{2146}-\x{2149}\x{214E}\x{2184}\x{2C30}-\x{2C5E}\x{2C61}\x{2C65}-\x{2C66}\x{2C68}\x{2C6A}\x{2C6C}\x{2C71}\x{2C73}-\x{2C74}\x{2C76}-\x{2C7B}\x{2C81}\x{2C83}\x{2C85}\x{2C87}\x{2C89}\x{2C8B}\x{2C8D}\x{2C8F}\x{2C91}\x{2C93}\x{2C95}\x{2C97}\x{2C99}\x{2C9B}\x{2C9D}\x{2C9F}\x{2CA1}\x{2CA3}\x{2CA5}\x{2CA7}\x{2CA9}\x{2CAB}\x{2CAD}\x{2CAF}\x{2CB1}\x{2CB3}\x{2CB5}\x{2CB7}\x{2CB9}\x{2CBB}\x{2CBD}\x{2CBF}\x{2CC1}\x{2CC3}\x{2CC5}\x{2CC7}\x{2CC9}\x{2CCB}\x{2CCD}\x{2CCF}\x{2CD1}\x{2CD3}\x{2CD5}\x{2CD7}\x{2CD9}\x{2CDB}\x{2CDD}\x{2CDF}\x{2CE1}\x{2CE3}-\x{2CE4}\x{2CEC}\x{2CEE}\x{2CF3}\x{2D00}-\x{2D25}\x{2D27}\x{2D2D}\x{A641}\x{A643}\x{A645}\x{A647}\x{A649}\x{A64B}\x{A64D}\x{A64F}\x{A651}\x{A653}\x{A655}\x{A657}\x{A659}\x{A65B}\x{A65D}\x{A65F}\x{A661}\x{A663}\x{A665}\x{A667}\x{A669}\x{A66B}\x{A66D}\x{A681}\x{A683}\x{A685}\x{A687}\x{A689}\x{A68B}\x{A68D}\x{A68F}\x{A691}\x{A693}\x{A695}\x{A697}\x{A699}\x{A69B}\x{A723}\x{A725}\x{A727}\x{A729}\x{A72B}\x{A72D}\x{A72F}-\x{A731}\x{A733}\x{A735}\x{A737}\x{A739}\x{A73B}\x{A73D}\x{A73F}\x{A741}\x{A743}\x{A745}\x{A747}\x{A749}\x{A74B}\x{A74D}\x{A74F}\x{A751}\x{A753}\x{A755}\x{A757}\x{A759}\x{A75B}\x{A75D}\x{A75F}\x{A761}\x{A763}\x{A765}\x{A767}\x{A769}\x{A76B}\x{A76D}\x{A76F}\x{A771}-\x{A778}\x{A77A}\x{A77C}\x{A77F}\x{A781}\x{A783}\x{A785}\x{A787}\x{A78C}\x{A78E}\x{A791}\x{A793}-\x{A795}\x{A797}\x{A799}\x{A79B}\x{A79D}\x{A79F}\x{A7A1}\x{A7A3}\x{A7A5}\x{A7A7}\x{A7A9}\x{A7B5}\x{A7B7}\x{A7FA}\x{AB30}-\x{AB5A}\x{AB60}-\x{AB65}\x{AB70}-\x{ABBF}\x{FB00}-\x{FB06}\x{FB13}-\x{FB17}\x{FF41}-\x{FF5A}]", "description" => "[a-zµß-öø-\x{00FF}\x{0101}\x{0103}\x{0105}\x{0107}\x{0109}\x{010B}\x{010D}\x{010F}\x{0111}\x{0113}\x{0115}\x{0117}\x{0119}\x{011B}\x{011D}\x{011F}\x{0121}\x{0123}\x{0125}\x{0127}\x{0129}\x{012B}\x{012D}\x{012F}\x{0131}\x{0133}\x{0135}\x{0137}-\x{0138}\x{013A}\x{013C}\x{013E}\x{0140}\x{0142}\x{0144}\x{0146}\x{0148}-\x{0149}\x{014B}\x{014D}\x{014F}\x{0151}\x{0153}\x{0155}\x{0157}\x{0159}\x{015B}\x{015D}\x{015F}\x{0161}\x{0163}\x{0165}\x{0167}\x{0169}\x{016B}\x{016D}\x{016F}\x{0171}\x{0173}\x{0175}\x{0177}\x{017A}\x{017C}\x{017E}-\x{0180}\x{0183}\x{0185}\x{0188}\x{018C}-\x{018D}\x{0192}\x{0195}\x{0199}-\x{019B}\x{019E}\x{01A1}\x{01A3}\x{01A5}\x{01A8}\x{01AA}-\x{01AB}\x{01AD}\x{01B0}\x{01B4}\x{01B6}\x{01B9}-\x{01BA}\x{01BD}-\x{01BF}\x{01C6}\x{01C9}\x{01CC}\x{01CE}\x{01D0}\x{01D2}\x{01D4}\x{01D6}\x{01D8}\x{01DA}\x{01DC}-\x{01DD}\x{01DF}\x{01E1}\x{01E3}\x{01E5}\x{01E7}\x{01E9}\x{01EB}\x{01ED}\x{01EF}-\x{01F0}\x{01F3}\x{01F5}\x{01F9}\x{01FB}\x{01FD}\x{01FF}\x{0201}\x{0203}\x{0205}\x{0207}\x{0209}\x{020B}\x{020D}\x{020F}\x{0211}\x{0213}\x{0215}\x{0217}\x{0219}\x{021B}\x{021D}\x{021F}\x{0221}\x{0223}\x{0225}\x{0227}\x{0229}\x{022B}\x{022D}\x{022F}\x{0231}\x{0233}-\x{0239}\x{023C}\x{023F}-\x{0240}\x{0242}\x{0247}\x{0249}\x{024B}\x{024D}\x{024F}-\x{0293}\x{0295}-\x{02AF}\x{0371}\x{0373}\x{0377}\x{037B}-\x{037D}\x{0390}\x{03AC}-\x{03CE}\x{03D0}-\x{03D1}\x{03D5}-\x{03D7}\x{03D9}\x{03DB}\x{03DD}\x{03DF}\x{03E1}\x{03E3}\x{03E5}\x{03E7}\x{03E9}\x{03EB}\x{03ED}\x{03EF}-\x{03F3}\x{03F5}\x{03F8}\x{03FB}-\x{03FC}\x{0430}-\x{045F}\x{0461}\x{0463}\x{0465}\x{0467}\x{0469}\x{046B}\x{046D}\x{046F}\x{0471}\x{0473}\x{0475}\x{0477}\x{0479}\x{047B}\x{047D}\x{047F}\x{0481}\x{048B}\x{048D}\x{048F}\x{0491}\x{0493}\x{0495}\x{0497}\x{0499}\x{049B}\x{049D}\x{049F}\x{04A1}\x{04A3}\x{04A5}\x{04A7}\x{04A9}\x{04AB}\x{04AD}\x{04AF}\x{04B1}\x{04B3}\x{04B5}\x{04B7}\x{04B9}\x{04BB}\x{04BD}\x{04BF}\x{04C2}\x{04C4}\x{04C6}\x{04C8}\x{04CA}\x{04CC}\x{04CE}-\x{04CF}\x{04D1}\x{04D3}\x{04D5}\x{04D7}\x{04D9}\x{04DB}\x{04DD}\x{04DF}\x{04E1}\x{04E3}\x{04E5}\x{04E7}\x{04E9}\x{04EB}\x{04ED}\x{04EF}\x{04F1}\x{04F3}\x{04F5}\x{04F7}\x{04F9}\x{04FB}\x{04FD}\x{04FF}\x{0501}\x{0503}\x{0505}\x{0507}\x{0509}\x{050B}\x{050D}\x{050F}\x{0511}\x{0513}\x{0515}\x{0517}\x{0519}\x{051B}\x{051D}\x{051F}\x{0521}\x{0523}\x{0525}\x{0527}\x{0529}\x{052B}\x{052D}\x{052F}\x{0561}-\x{0587}\x{13F8}-\x{13FD}\x{1D00}-\x{1D2B}\x{1D6B}-\x{1D77}\x{1D79}-\x{1D9A}\x{1E01}\x{1E03}\x{1E05}\x{1E07}\x{1E09}\x{1E0B}\x{1E0D}\x{1E0F}\x{1E11}\x{1E13}\x{1E15}\x{1E17}\x{1E19}\x{1E1B}\x{1E1D}\x{1E1F}\x{1E21}\x{1E23}\x{1E25}\x{1E27}\x{1E29}\x{1E2B}\x{1E2D}\x{1E2F}\x{1E31}\x{1E33}\x{1E35}\x{1E37}\x{1E39}\x{1E3B}\x{1E3D}\x{1E3F}\x{1E41}\x{1E43}\x{1E45}\x{1E47}\x{1E49}\x{1E4B}\x{1E4D}\x{1E4F}\x{1E51}\x{1E53}\x{1E55}\x{1E57}\x{1E59}\x{1E5B}\x{1E5D}\x{1E5F}\x{1E61}\x{1E63}\x{1E65}\x{1E67}\x{1E69}\x{1E6B}\x{1E6D}\x{1E6F}\x{1E71}\x{1E73}\x{1E75}\x{1E77}\x{1E79}\x{1E7B}\x{1E7D}\x{1E7F}\x{1E81}\x{1E83}\x{1E85}\x{1E87}\x{1E89}\x{1E8B}\x{1E8D}\x{1E8F}\x{1E91}\x{1E93}\x{1E95}-\x{1E9D}\x{1E9F}\x{1EA1}\x{1EA3}\x{1EA5}\x{1EA7}\x{1EA9}\x{1EAB}\x{1EAD}\x{1EAF}\x{1EB1}\x{1EB3}\x{1EB5}\x{1EB7}\x{1EB9}\x{1EBB}\x{1EBD}\x{1EBF}\x{1EC1}\x{1EC3}\x{1EC5}\x{1EC7}\x{1EC9}\x{1ECB}\x{1ECD}\x{1ECF}\x{1ED1}\x{1ED3}\x{1ED5}\x{1ED7}\x{1ED9}\x{1EDB}\x{1EDD}\x{1EDF}\x{1EE1}\x{1EE3}\x{1EE5}\x{1EE7}\x{1EE9}\x{1EEB}\x{1EED}\x{1EEF}\x{1EF1}\x{1EF3}\x{1EF5}\x{1EF7}\x{1EF9}\x{1EFB}\x{1EFD}\x{1EFF}-\x{1F07}\x{1F10}-\x{1F15}\x{1F20}-\x{1F27}\x{1F30}-\x{1F37}\x{1F40}-\x{1F45}\x{1F50}-\x{1F57}\x{1F60}-\x{1F67}\x{1F70}-\x{1F7D}\x{1F80}-\x{1F87}\x{1F90}-\x{1F97}\x{1FA0}-\x{1FA7}\x{1FB0}-\x{1FB4}\x{1FB6}-\x{1FB7}\x{1FBE}\x{1FC2}-\x{1FC4}\x{1FC6}-\x{1FC7}\x{1FD0}-\x{1FD3}\x{1FD6}-\x{1FD7}\x{1FE0}-\x{1FE7}\x{1FF2}-\x{1FF4}\x{1FF6}-\x{1FF7}\x{210A}\x{210E}-\x{210F}\x{2113}\x{212F}\x{2134}\x{2139}\x{213C}-\x{213D}\x{2146}-\x{2149}\x{214E}\x{2184}\x{2C30}-\x{2C5E}\x{2C61}\x{2C65}-\x{2C66}\x{2C68}\x{2C6A}\x{2C6C}\x{2C71}\x{2C73}-\x{2C74}\x{2C76}-\x{2C7B}\x{2C81}\x{2C83}\x{2C85}\x{2C87}\x{2C89}\x{2C8B}\x{2C8D}\x{2C8F}\x{2C91}\x{2C93}\x{2C95}\x{2C97}\x{2C99}\x{2C9B}\x{2C9D}\x{2C9F}\x{2CA1}\x{2CA3}\x{2CA5}\x{2CA7}\x{2CA9}\x{2CAB}\x{2CAD}\x{2CAF}\x{2CB1}\x{2CB3}\x{2CB5}\x{2CB7}\x{2CB9}\x{2CBB}\x{2CBD}\x{2CBF}\x{2CC1}\x{2CC3}\x{2CC5}\x{2CC7}\x{2CC9}\x{2CCB}\x{2CCD}\x{2CCF}\x{2CD1}\x{2CD3}\x{2CD5}\x{2CD7}\x{2CD9}\x{2CDB}\x{2CDD}\x{2CDF}\x{2CE1}\x{2CE3}-\x{2CE4}\x{2CEC}\x{2CEE}\x{2CF3}\x{2D00}-\x{2D25}\x{2D27}\x{2D2D}\x{A641}\x{A643}\x{A645}\x{A647}\x{A649}\x{A64B}\x{A64D}\x{A64F}\x{A651}\x{A653}\x{A655}\x{A657}\x{A659}\x{A65B}\x{A65D}\x{A65F}\x{A661}\x{A663}\x{A665}\x{A667}\x{A669}\x{A66B}\x{A66D}\x{A681}\x{A683}\x{A685}\x{A687}\x{A689}\x{A68B}\x{A68D}\x{A68F}\x{A691}\x{A693}\x{A695}\x{A697}\x{A699}\x{A69B}\x{A723}\x{A725}\x{A727}\x{A729}\x{A72B}\x{A72D}\x{A72F}-\x{A731}\x{A733}\x{A735}\x{A737}\x{A739}\x{A73B}\x{A73D}\x{A73F}\x{A741}\x{A743}\x{A745}\x{A747}\x{A749}\x{A74B}\x{A74D}\x{A74F}\x{A751}\x{A753}\x{A755}\x{A757}\x{A759}\x{A75B}\x{A75D}\x{A75F}\x{A761}\x{A763}\x{A765}\x{A767}\x{A769}\x{A76B}\x{A76D}\x{A76F}\x{A771}-\x{A778}\x{A77A}\x{A77C}\x{A77F}\x{A781}\x{A783}\x{A785}\x{A787}\x{A78C}\x{A78E}\x{A791}\x{A793}-\x{A795}\x{A797}\x{A799}\x{A79B}\x{A79D}\x{A79F}\x{A7A1}\x{A7A3}\x{A7A5}\x{A7A7}\x{A7A9}\x{A7B5}\x{A7B7}\x{A7FA}\x{AB30}-\x{AB5A}\x{AB60}-\x{AB65}\x{AB70}-\x{ABBF}\x{FB00}-\x{FB06}\x{FB13}-\x{FB17}\x{FF41}-\x{FF5A}]" );
    $this->peg_c35 = "/^[\\x{02B0}-\\x{02C1}\\x{02C6}-\\x{02D1}\\x{02E0}-\\x{02E4}\\x{02EC}\\x{02EE}\\x{0374}\\x{037A}\\x{0559}\\x{0640}\\x{06E5}-\\x{06E6}\\x{07F4}-\\x{07F5}\\x{07FA}\\x{081A}\\x{0824}\\x{0828}\\x{0971}\\x{0E46}\\x{0EC6}\\x{10FC}\\x{17D7}\\x{1843}\\x{1AA7}\\x{1C78}-\\x{1C7D}\\x{1D2C}-\\x{1D6A}\\x{1D78}\\x{1D9B}-\\x{1DBF}\\x{2071}\\x{207F}\\x{2090}-\\x{209C}\\x{2C7C}-\\x{2C7D}\\x{2D6F}\\x{2E2F}\\x{3005}\\x{3031}-\\x{3035}\\x{303B}\\x{309D}-\\x{309E}\\x{30FC}-\\x{30FE}\\x{A015}\\x{A4F8}-\\x{A4FD}\\x{A60C}\\x{A67F}\\x{A69C}-\\x{A69D}\\x{A717}-\\x{A71F}\\x{A770}\\x{A788}\\x{A7F8}-\\x{A7F9}\\x{A9CF}\\x{A9E6}\\x{AA70}\\x{AADD}\\x{AAF3}-\\x{AAF4}\\x{AB5C}-\\x{AB5F}\\x{FF70}\\x{FF9E}-\\x{FF9F}]/";
    $this->peg_c36 = array( "type" => "class", "value" => "[\x{02B0}-\x{02C1}\x{02C6}-\x{02D1}\x{02E0}-\x{02E4}\x{02EC}\x{02EE}\x{0374}\x{037A}\x{0559}\x{0640}\x{06E5}-\x{06E6}\x{07F4}-\x{07F5}\x{07FA}\x{081A}\x{0824}\x{0828}\x{0971}\x{0E46}\x{0EC6}\x{10FC}\x{17D7}\x{1843}\x{1AA7}\x{1C78}-\x{1C7D}\x{1D2C}-\x{1D6A}\x{1D78}\x{1D9B}-\x{1DBF}\x{2071}\x{207F}\x{2090}-\x{209C}\x{2C7C}-\x{2C7D}\x{2D6F}\x{2E2F}\x{3005}\x{3031}-\x{3035}\x{303B}\x{309D}-\x{309E}\x{30FC}-\x{30FE}\x{A015}\x{A4F8}-\x{A4FD}\x{A60C}\x{A67F}\x{A69C}-\x{A69D}\x{A717}-\x{A71F}\x{A770}\x{A788}\x{A7F8}-\x{A7F9}\x{A9CF}\x{A9E6}\x{AA70}\x{AADD}\x{AAF3}-\x{AAF4}\x{AB5C}-\x{AB5F}\x{FF70}\x{FF9E}-\x{FF9F}]", "description" => "[\x{02B0}-\x{02C1}\x{02C6}-\x{02D1}\x{02E0}-\x{02E4}\x{02EC}\x{02EE}\x{0374}\x{037A}\x{0559}\x{0640}\x{06E5}-\x{06E6}\x{07F4}-\x{07F5}\x{07FA}\x{081A}\x{0824}\x{0828}\x{0971}\x{0E46}\x{0EC6}\x{10FC}\x{17D7}\x{1843}\x{1AA7}\x{1C78}-\x{1C7D}\x{1D2C}-\x{1D6A}\x{1D78}\x{1D9B}-\x{1DBF}\x{2071}\x{207F}\x{2090}-\x{209C}\x{2C7C}-\x{2C7D}\x{2D6F}\x{2E2F}\x{3005}\x{3031}-\x{3035}\x{303B}\x{309D}-\x{309E}\x{30FC}-\x{30FE}\x{A015}\x{A4F8}-\x{A4FD}\x{A60C}\x{A67F}\x{A69C}-\x{A69D}\x{A717}-\x{A71F}\x{A770}\x{A788}\x{A7F8}-\x{A7F9}\x{A9CF}\x{A9E6}\x{AA70}\x{AADD}\x{AAF3}-\x{AAF4}\x{AB5C}-\x{AB5F}\x{FF70}\x{FF9E}-\x{FF9F}]" );
    $this->peg_c37 = "/^[ªº\\x{01BB}\\x{01C0}-\\x{01C3}\\x{0294}\\x{05D0}-\\x{05EA}\\x{05F0}-\\x{05F2}\\x{0620}-\\x{063F}\\x{0641}-\\x{064A}\\x{066E}-\\x{066F}\\x{0671}-\\x{06D3}\\x{06D5}\\x{06EE}-\\x{06EF}\\x{06FA}-\\x{06FC}\\x{06FF}\\x{0710}\\x{0712}-\\x{072F}\\x{074D}-\\x{07A5}\\x{07B1}\\x{07CA}-\\x{07EA}\\x{0800}-\\x{0815}\\x{0840}-\\x{0858}\\x{08A0}-\\x{08B4}\\x{0904}-\\x{0939}\\x{093D}\\x{0950}\\x{0958}-\\x{0961}\\x{0972}-\\x{0980}\\x{0985}-\\x{098C}\\x{098F}-\\x{0990}\\x{0993}-\\x{09A8}\\x{09AA}-\\x{09B0}\\x{09B2}\\x{09B6}-\\x{09B9}\\x{09BD}\\x{09CE}\\x{09DC}-\\x{09DD}\\x{09DF}-\\x{09E1}\\x{09F0}-\\x{09F1}\\x{0A05}-\\x{0A0A}\\x{0A0F}-\\x{0A10}\\x{0A13}-\\x{0A28}\\x{0A2A}-\\x{0A30}\\x{0A32}-\\x{0A33}\\x{0A35}-\\x{0A36}\\x{0A38}-\\x{0A39}\\x{0A59}-\\x{0A5C}\\x{0A5E}\\x{0A72}-\\x{0A74}\\x{0A85}-\\x{0A8D}\\x{0A8F}-\\x{0A91}\\x{0A93}-\\x{0AA8}\\x{0AAA}-\\x{0AB0}\\x{0AB2}-\\x{0AB3}\\x{0AB5}-\\x{0AB9}\\x{0ABD}\\x{0AD0}\\x{0AE0}-\\x{0AE1}\\x{0AF9}\\x{0B05}-\\x{0B0C}\\x{0B0F}-\\x{0B10}\\x{0B13}-\\x{0B28}\\x{0B2A}-\\x{0B30}\\x{0B32}-\\x{0B33}\\x{0B35}-\\x{0B39}\\x{0B3D}\\x{0B5C}-\\x{0B5D}\\x{0B5F}-\\x{0B61}\\x{0B71}\\x{0B83}\\x{0B85}-\\x{0B8A}\\x{0B8E}-\\x{0B90}\\x{0B92}-\\x{0B95}\\x{0B99}-\\x{0B9A}\\x{0B9C}\\x{0B9E}-\\x{0B9F}\\x{0BA3}-\\x{0BA4}\\x{0BA8}-\\x{0BAA}\\x{0BAE}-\\x{0BB9}\\x{0BD0}\\x{0C05}-\\x{0C0C}\\x{0C0E}-\\x{0C10}\\x{0C12}-\\x{0C28}\\x{0C2A}-\\x{0C39}\\x{0C3D}\\x{0C58}-\\x{0C5A}\\x{0C60}-\\x{0C61}\\x{0C85}-\\x{0C8C}\\x{0C8E}-\\x{0C90}\\x{0C92}-\\x{0CA8}\\x{0CAA}-\\x{0CB3}\\x{0CB5}-\\x{0CB9}\\x{0CBD}\\x{0CDE}\\x{0CE0}-\\x{0CE1}\\x{0CF1}-\\x{0CF2}\\x{0D05}-\\x{0D0C}\\x{0D0E}-\\x{0D10}\\x{0D12}-\\x{0D3A}\\x{0D3D}\\x{0D4E}\\x{0D5F}-\\x{0D61}\\x{0D7A}-\\x{0D7F}\\x{0D85}-\\x{0D96}\\x{0D9A}-\\x{0DB1}\\x{0DB3}-\\x{0DBB}\\x{0DBD}\\x{0DC0}-\\x{0DC6}\\x{0E01}-\\x{0E30}\\x{0E32}-\\x{0E33}\\x{0E40}-\\x{0E45}\\x{0E81}-\\x{0E82}\\x{0E84}\\x{0E87}-\\x{0E88}\\x{0E8A}\\x{0E8D}\\x{0E94}-\\x{0E97}\\x{0E99}-\\x{0E9F}\\x{0EA1}-\\x{0EA3}\\x{0EA5}\\x{0EA7}\\x{0EAA}-\\x{0EAB}\\x{0EAD}-\\x{0EB0}\\x{0EB2}-\\x{0EB3}\\x{0EBD}\\x{0EC0}-\\x{0EC4}\\x{0EDC}-\\x{0EDF}\\x{0F00}\\x{0F40}-\\x{0F47}\\x{0F49}-\\x{0F6C}\\x{0F88}-\\x{0F8C}\\x{1000}-\\x{102A}\\x{103F}\\x{1050}-\\x{1055}\\x{105A}-\\x{105D}\\x{1061}\\x{1065}-\\x{1066}\\x{106E}-\\x{1070}\\x{1075}-\\x{1081}\\x{108E}\\x{10D0}-\\x{10FA}\\x{10FD}-\\x{1248}\\x{124A}-\\x{124D}\\x{1250}-\\x{1256}\\x{1258}\\x{125A}-\\x{125D}\\x{1260}-\\x{1288}\\x{128A}-\\x{128D}\\x{1290}-\\x{12B0}\\x{12B2}-\\x{12B5}\\x{12B8}-\\x{12BE}\\x{12C0}\\x{12C2}-\\x{12C5}\\x{12C8}-\\x{12D6}\\x{12D8}-\\x{1310}\\x{1312}-\\x{1315}\\x{1318}-\\x{135A}\\x{1380}-\\x{138F}\\x{1401}-\\x{166C}\\x{166F}-\\x{167F}\\x{1681}-\\x{169A}\\x{16A0}-\\x{16EA}\\x{16F1}-\\x{16F8}\\x{1700}-\\x{170C}\\x{170E}-\\x{1711}\\x{1720}-\\x{1731}\\x{1740}-\\x{1751}\\x{1760}-\\x{176C}\\x{176E}-\\x{1770}\\x{1780}-\\x{17B3}\\x{17DC}\\x{1820}-\\x{1842}\\x{1844}-\\x{1877}\\x{1880}-\\x{18A8}\\x{18AA}\\x{18B0}-\\x{18F5}\\x{1900}-\\x{191E}\\x{1950}-\\x{196D}\\x{1970}-\\x{1974}\\x{1980}-\\x{19AB}\\x{19B0}-\\x{19C9}\\x{1A00}-\\x{1A16}\\x{1A20}-\\x{1A54}\\x{1B05}-\\x{1B33}\\x{1B45}-\\x{1B4B}\\x{1B83}-\\x{1BA0}\\x{1BAE}-\\x{1BAF}\\x{1BBA}-\\x{1BE5}\\x{1C00}-\\x{1C23}\\x{1C4D}-\\x{1C4F}\\x{1C5A}-\\x{1C77}\\x{1CE9}-\\x{1CEC}\\x{1CEE}-\\x{1CF1}\\x{1CF5}-\\x{1CF6}\\x{2135}-\\x{2138}\\x{2D30}-\\x{2D67}\\x{2D80}-\\x{2D96}\\x{2DA0}-\\x{2DA6}\\x{2DA8}-\\x{2DAE}\\x{2DB0}-\\x{2DB6}\\x{2DB8}-\\x{2DBE}\\x{2DC0}-\\x{2DC6}\\x{2DC8}-\\x{2DCE}\\x{2DD0}-\\x{2DD6}\\x{2DD8}-\\x{2DDE}\\x{3006}\\x{303C}\\x{3041}-\\x{3096}\\x{309F}\\x{30A1}-\\x{30FA}\\x{30FF}\\x{3105}-\\x{312D}\\x{3131}-\\x{318E}\\x{31A0}-\\x{31BA}\\x{31F0}-\\x{31FF}\\x{3400}-\\x{4DB5}\\x{4E00}-\\x{9FD5}\\x{A000}-\\x{A014}\\x{A016}-\\x{A48C}\\x{A4D0}-\\x{A4F7}\\x{A500}-\\x{A60B}\\x{A610}-\\x{A61F}\\x{A62A}-\\x{A62B}\\x{A66E}\\x{A6A0}-\\x{A6E5}\\x{A78F}\\x{A7F7}\\x{A7FB}-\\x{A801}\\x{A803}-\\x{A805}\\x{A807}-\\x{A80A}\\x{A80C}-\\x{A822}\\x{A840}-\\x{A873}\\x{A882}-\\x{A8B3}\\x{A8F2}-\\x{A8F7}\\x{A8FB}\\x{A8FD}\\x{A90A}-\\x{A925}\\x{A930}-\\x{A946}\\x{A960}-\\x{A97C}\\x{A984}-\\x{A9B2}\\x{A9E0}-\\x{A9E4}\\x{A9E7}-\\x{A9EF}\\x{A9FA}-\\x{A9FE}\\x{AA00}-\\x{AA28}\\x{AA40}-\\x{AA42}\\x{AA44}-\\x{AA4B}\\x{AA60}-\\x{AA6F}\\x{AA71}-\\x{AA76}\\x{AA7A}\\x{AA7E}-\\x{AAAF}\\x{AAB1}\\x{AAB5}-\\x{AAB6}\\x{AAB9}-\\x{AABD}\\x{AAC0}\\x{AAC2}\\x{AADB}-\\x{AADC}\\x{AAE0}-\\x{AAEA}\\x{AAF2}\\x{AB01}-\\x{AB06}\\x{AB09}-\\x{AB0E}\\x{AB11}-\\x{AB16}\\x{AB20}-\\x{AB26}\\x{AB28}-\\x{AB2E}\\x{ABC0}-\\x{ABE2}\\x{AC00}-\\x{D7A3}\\x{D7B0}-\\x{D7C6}\\x{D7CB}-\\x{D7FB}\\x{F900}-\\x{FA6D}\\x{FA70}-\\x{FAD9}\\x{FB1D}\\x{FB1F}-\\x{FB28}\\x{FB2A}-\\x{FB36}\\x{FB38}-\\x{FB3C}\\x{FB3E}\\x{FB40}-\\x{FB41}\\x{FB43}-\\x{FB44}\\x{FB46}-\\x{FBB1}\\x{FBD3}-\\x{FD3D}\\x{FD50}-\\x{FD8F}\\x{FD92}-\\x{FDC7}\\x{FDF0}-\\x{FDFB}\\x{FE70}-\\x{FE74}\\x{FE76}-\\x{FEFC}\\x{FF66}-\\x{FF6F}\\x{FF71}-\\x{FF9D}\\x{FFA0}-\\x{FFBE}\\x{FFC2}-\\x{FFC7}\\x{FFCA}-\\x{FFCF}\\x{FFD2}-\\x{FFD7}\\x{FFDA}-\\x{FFDC}]/";
    $this->peg_c38 = array( "type" => "class", "value" => "[ªº\x{01BB}\x{01C0}-\x{01C3}\x{0294}\x{05D0}-\x{05EA}\x{05F0}-\x{05F2}\x{0620}-\x{063F}\x{0641}-\x{064A}\x{066E}-\x{066F}\x{0671}-\x{06D3}\x{06D5}\x{06EE}-\x{06EF}\x{06FA}-\x{06FC}\x{06FF}\x{0710}\x{0712}-\x{072F}\x{074D}-\x{07A5}\x{07B1}\x{07CA}-\x{07EA}\x{0800}-\x{0815}\x{0840}-\x{0858}\x{08A0}-\x{08B4}\x{0904}-\x{0939}\x{093D}\x{0950}\x{0958}-\x{0961}\x{0972}-\x{0980}\x{0985}-\x{098C}\x{098F}-\x{0990}\x{0993}-\x{09A8}\x{09AA}-\x{09B0}\x{09B2}\x{09B6}-\x{09B9}\x{09BD}\x{09CE}\x{09DC}-\x{09DD}\x{09DF}-\x{09E1}\x{09F0}-\x{09F1}\x{0A05}-\x{0A0A}\x{0A0F}-\x{0A10}\x{0A13}-\x{0A28}\x{0A2A}-\x{0A30}\x{0A32}-\x{0A33}\x{0A35}-\x{0A36}\x{0A38}-\x{0A39}\x{0A59}-\x{0A5C}\x{0A5E}\x{0A72}-\x{0A74}\x{0A85}-\x{0A8D}\x{0A8F}-\x{0A91}\x{0A93}-\x{0AA8}\x{0AAA}-\x{0AB0}\x{0AB2}-\x{0AB3}\x{0AB5}-\x{0AB9}\x{0ABD}\x{0AD0}\x{0AE0}-\x{0AE1}\x{0AF9}\x{0B05}-\x{0B0C}\x{0B0F}-\x{0B10}\x{0B13}-\x{0B28}\x{0B2A}-\x{0B30}\x{0B32}-\x{0B33}\x{0B35}-\x{0B39}\x{0B3D}\x{0B5C}-\x{0B5D}\x{0B5F}-\x{0B61}\x{0B71}\x{0B83}\x{0B85}-\x{0B8A}\x{0B8E}-\x{0B90}\x{0B92}-\x{0B95}\x{0B99}-\x{0B9A}\x{0B9C}\x{0B9E}-\x{0B9F}\x{0BA3}-\x{0BA4}\x{0BA8}-\x{0BAA}\x{0BAE}-\x{0BB9}\x{0BD0}\x{0C05}-\x{0C0C}\x{0C0E}-\x{0C10}\x{0C12}-\x{0C28}\x{0C2A}-\x{0C39}\x{0C3D}\x{0C58}-\x{0C5A}\x{0C60}-\x{0C61}\x{0C85}-\x{0C8C}\x{0C8E}-\x{0C90}\x{0C92}-\x{0CA8}\x{0CAA}-\x{0CB3}\x{0CB5}-\x{0CB9}\x{0CBD}\x{0CDE}\x{0CE0}-\x{0CE1}\x{0CF1}-\x{0CF2}\x{0D05}-\x{0D0C}\x{0D0E}-\x{0D10}\x{0D12}-\x{0D3A}\x{0D3D}\x{0D4E}\x{0D5F}-\x{0D61}\x{0D7A}-\x{0D7F}\x{0D85}-\x{0D96}\x{0D9A}-\x{0DB1}\x{0DB3}-\x{0DBB}\x{0DBD}\x{0DC0}-\x{0DC6}\x{0E01}-\x{0E30}\x{0E32}-\x{0E33}\x{0E40}-\x{0E45}\x{0E81}-\x{0E82}\x{0E84}\x{0E87}-\x{0E88}\x{0E8A}\x{0E8D}\x{0E94}-\x{0E97}\x{0E99}-\x{0E9F}\x{0EA1}-\x{0EA3}\x{0EA5}\x{0EA7}\x{0EAA}-\x{0EAB}\x{0EAD}-\x{0EB0}\x{0EB2}-\x{0EB3}\x{0EBD}\x{0EC0}-\x{0EC4}\x{0EDC}-\x{0EDF}\x{0F00}\x{0F40}-\x{0F47}\x{0F49}-\x{0F6C}\x{0F88}-\x{0F8C}\x{1000}-\x{102A}\x{103F}\x{1050}-\x{1055}\x{105A}-\x{105D}\x{1061}\x{1065}-\x{1066}\x{106E}-\x{1070}\x{1075}-\x{1081}\x{108E}\x{10D0}-\x{10FA}\x{10FD}-\x{1248}\x{124A}-\x{124D}\x{1250}-\x{1256}\x{1258}\x{125A}-\x{125D}\x{1260}-\x{1288}\x{128A}-\x{128D}\x{1290}-\x{12B0}\x{12B2}-\x{12B5}\x{12B8}-\x{12BE}\x{12C0}\x{12C2}-\x{12C5}\x{12C8}-\x{12D6}\x{12D8}-\x{1310}\x{1312}-\x{1315}\x{1318}-\x{135A}\x{1380}-\x{138F}\x{1401}-\x{166C}\x{166F}-\x{167F}\x{1681}-\x{169A}\x{16A0}-\x{16EA}\x{16F1}-\x{16F8}\x{1700}-\x{170C}\x{170E}-\x{1711}\x{1720}-\x{1731}\x{1740}-\x{1751}\x{1760}-\x{176C}\x{176E}-\x{1770}\x{1780}-\x{17B3}\x{17DC}\x{1820}-\x{1842}\x{1844}-\x{1877}\x{1880}-\x{18A8}\x{18AA}\x{18B0}-\x{18F5}\x{1900}-\x{191E}\x{1950}-\x{196D}\x{1970}-\x{1974}\x{1980}-\x{19AB}\x{19B0}-\x{19C9}\x{1A00}-\x{1A16}\x{1A20}-\x{1A54}\x{1B05}-\x{1B33}\x{1B45}-\x{1B4B}\x{1B83}-\x{1BA0}\x{1BAE}-\x{1BAF}\x{1BBA}-\x{1BE5}\x{1C00}-\x{1C23}\x{1C4D}-\x{1C4F}\x{1C5A}-\x{1C77}\x{1CE9}-\x{1CEC}\x{1CEE}-\x{1CF1}\x{1CF5}-\x{1CF6}\x{2135}-\x{2138}\x{2D30}-\x{2D67}\x{2D80}-\x{2D96}\x{2DA0}-\x{2DA6}\x{2DA8}-\x{2DAE}\x{2DB0}-\x{2DB6}\x{2DB8}-\x{2DBE}\x{2DC0}-\x{2DC6}\x{2DC8}-\x{2DCE}\x{2DD0}-\x{2DD6}\x{2DD8}-\x{2DDE}\x{3006}\x{303C}\x{3041}-\x{3096}\x{309F}\x{30A1}-\x{30FA}\x{30FF}\x{3105}-\x{312D}\x{3131}-\x{318E}\x{31A0}-\x{31BA}\x{31F0}-\x{31FF}\x{3400}-\x{4DB5}\x{4E00}-\x{9FD5}\x{A000}-\x{A014}\x{A016}-\x{A48C}\x{A4D0}-\x{A4F7}\x{A500}-\x{A60B}\x{A610}-\x{A61F}\x{A62A}-\x{A62B}\x{A66E}\x{A6A0}-\x{A6E5}\x{A78F}\x{A7F7}\x{A7FB}-\x{A801}\x{A803}-\x{A805}\x{A807}-\x{A80A}\x{A80C}-\x{A822}\x{A840}-\x{A873}\x{A882}-\x{A8B3}\x{A8F2}-\x{A8F7}\x{A8FB}\x{A8FD}\x{A90A}-\x{A925}\x{A930}-\x{A946}\x{A960}-\x{A97C}\x{A984}-\x{A9B2}\x{A9E0}-\x{A9E4}\x{A9E7}-\x{A9EF}\x{A9FA}-\x{A9FE}\x{AA00}-\x{AA28}\x{AA40}-\x{AA42}\x{AA44}-\x{AA4B}\x{AA60}-\x{AA6F}\x{AA71}-\x{AA76}\x{AA7A}\x{AA7E}-\x{AAAF}\x{AAB1}\x{AAB5}-\x{AAB6}\x{AAB9}-\x{AABD}\x{AAC0}\x{AAC2}\x{AADB}-\x{AADC}\x{AAE0}-\x{AAEA}\x{AAF2}\x{AB01}-\x{AB06}\x{AB09}-\x{AB0E}\x{AB11}-\x{AB16}\x{AB20}-\x{AB26}\x{AB28}-\x{AB2E}\x{ABC0}-\x{ABE2}\x{AC00}-\x{D7A3}\x{D7B0}-\x{D7C6}\x{D7CB}-\x{D7FB}\x{F900}-\x{FA6D}\x{FA70}-\x{FAD9}\x{FB1D}\x{FB1F}-\x{FB28}\x{FB2A}-\x{FB36}\x{FB38}-\x{FB3C}\x{FB3E}\x{FB40}-\x{FB41}\x{FB43}-\x{FB44}\x{FB46}-\x{FBB1}\x{FBD3}-\x{FD3D}\x{FD50}-\x{FD8F}\x{FD92}-\x{FDC7}\x{FDF0}-\x{FDFB}\x{FE70}-\x{FE74}\x{FE76}-\x{FEFC}\x{FF66}-\x{FF6F}\x{FF71}-\x{FF9D}\x{FFA0}-\x{FFBE}\x{FFC2}-\x{FFC7}\x{FFCA}-\x{FFCF}\x{FFD2}-\x{FFD7}\x{FFDA}-\x{FFDC}]", "description" => "[ªº\x{01BB}\x{01C0}-\x{01C3}\x{0294}\x{05D0}-\x{05EA}\x{05F0}-\x{05F2}\x{0620}-\x{063F}\x{0641}-\x{064A}\x{066E}-\x{066F}\x{0671}-\x{06D3}\x{06D5}\x{06EE}-\x{06EF}\x{06FA}-\x{06FC}\x{06FF}\x{0710}\x{0712}-\x{072F}\x{074D}-\x{07A5}\x{07B1}\x{07CA}-\x{07EA}\x{0800}-\x{0815}\x{0840}-\x{0858}\x{08A0}-\x{08B4}\x{0904}-\x{0939}\x{093D}\x{0950}\x{0958}-\x{0961}\x{0972}-\x{0980}\x{0985}-\x{098C}\x{098F}-\x{0990}\x{0993}-\x{09A8}\x{09AA}-\x{09B0}\x{09B2}\x{09B6}-\x{09B9}\x{09BD}\x{09CE}\x{09DC}-\x{09DD}\x{09DF}-\x{09E1}\x{09F0}-\x{09F1}\x{0A05}-\x{0A0A}\x{0A0F}-\x{0A10}\x{0A13}-\x{0A28}\x{0A2A}-\x{0A30}\x{0A32}-\x{0A33}\x{0A35}-\x{0A36}\x{0A38}-\x{0A39}\x{0A59}-\x{0A5C}\x{0A5E}\x{0A72}-\x{0A74}\x{0A85}-\x{0A8D}\x{0A8F}-\x{0A91}\x{0A93}-\x{0AA8}\x{0AAA}-\x{0AB0}\x{0AB2}-\x{0AB3}\x{0AB5}-\x{0AB9}\x{0ABD}\x{0AD0}\x{0AE0}-\x{0AE1}\x{0AF9}\x{0B05}-\x{0B0C}\x{0B0F}-\x{0B10}\x{0B13}-\x{0B28}\x{0B2A}-\x{0B30}\x{0B32}-\x{0B33}\x{0B35}-\x{0B39}\x{0B3D}\x{0B5C}-\x{0B5D}\x{0B5F}-\x{0B61}\x{0B71}\x{0B83}\x{0B85}-\x{0B8A}\x{0B8E}-\x{0B90}\x{0B92}-\x{0B95}\x{0B99}-\x{0B9A}\x{0B9C}\x{0B9E}-\x{0B9F}\x{0BA3}-\x{0BA4}\x{0BA8}-\x{0BAA}\x{0BAE}-\x{0BB9}\x{0BD0}\x{0C05}-\x{0C0C}\x{0C0E}-\x{0C10}\x{0C12}-\x{0C28}\x{0C2A}-\x{0C39}\x{0C3D}\x{0C58}-\x{0C5A}\x{0C60}-\x{0C61}\x{0C85}-\x{0C8C}\x{0C8E}-\x{0C90}\x{0C92}-\x{0CA8}\x{0CAA}-\x{0CB3}\x{0CB5}-\x{0CB9}\x{0CBD}\x{0CDE}\x{0CE0}-\x{0CE1}\x{0CF1}-\x{0CF2}\x{0D05}-\x{0D0C}\x{0D0E}-\x{0D10}\x{0D12}-\x{0D3A}\x{0D3D}\x{0D4E}\x{0D5F}-\x{0D61}\x{0D7A}-\x{0D7F}\x{0D85}-\x{0D96}\x{0D9A}-\x{0DB1}\x{0DB3}-\x{0DBB}\x{0DBD}\x{0DC0}-\x{0DC6}\x{0E01}-\x{0E30}\x{0E32}-\x{0E33}\x{0E40}-\x{0E45}\x{0E81}-\x{0E82}\x{0E84}\x{0E87}-\x{0E88}\x{0E8A}\x{0E8D}\x{0E94}-\x{0E97}\x{0E99}-\x{0E9F}\x{0EA1}-\x{0EA3}\x{0EA5}\x{0EA7}\x{0EAA}-\x{0EAB}\x{0EAD}-\x{0EB0}\x{0EB2}-\x{0EB3}\x{0EBD}\x{0EC0}-\x{0EC4}\x{0EDC}-\x{0EDF}\x{0F00}\x{0F40}-\x{0F47}\x{0F49}-\x{0F6C}\x{0F88}-\x{0F8C}\x{1000}-\x{102A}\x{103F}\x{1050}-\x{1055}\x{105A}-\x{105D}\x{1061}\x{1065}-\x{1066}\x{106E}-\x{1070}\x{1075}-\x{1081}\x{108E}\x{10D0}-\x{10FA}\x{10FD}-\x{1248}\x{124A}-\x{124D}\x{1250}-\x{1256}\x{1258}\x{125A}-\x{125D}\x{1260}-\x{1288}\x{128A}-\x{128D}\x{1290}-\x{12B0}\x{12B2}-\x{12B5}\x{12B8}-\x{12BE}\x{12C0}\x{12C2}-\x{12C5}\x{12C8}-\x{12D6}\x{12D8}-\x{1310}\x{1312}-\x{1315}\x{1318}-\x{135A}\x{1380}-\x{138F}\x{1401}-\x{166C}\x{166F}-\x{167F}\x{1681}-\x{169A}\x{16A0}-\x{16EA}\x{16F1}-\x{16F8}\x{1700}-\x{170C}\x{170E}-\x{1711}\x{1720}-\x{1731}\x{1740}-\x{1751}\x{1760}-\x{176C}\x{176E}-\x{1770}\x{1780}-\x{17B3}\x{17DC}\x{1820}-\x{1842}\x{1844}-\x{1877}\x{1880}-\x{18A8}\x{18AA}\x{18B0}-\x{18F5}\x{1900}-\x{191E}\x{1950}-\x{196D}\x{1970}-\x{1974}\x{1980}-\x{19AB}\x{19B0}-\x{19C9}\x{1A00}-\x{1A16}\x{1A20}-\x{1A54}\x{1B05}-\x{1B33}\x{1B45}-\x{1B4B}\x{1B83}-\x{1BA0}\x{1BAE}-\x{1BAF}\x{1BBA}-\x{1BE5}\x{1C00}-\x{1C23}\x{1C4D}-\x{1C4F}\x{1C5A}-\x{1C77}\x{1CE9}-\x{1CEC}\x{1CEE}-\x{1CF1}\x{1CF5}-\x{1CF6}\x{2135}-\x{2138}\x{2D30}-\x{2D67}\x{2D80}-\x{2D96}\x{2DA0}-\x{2DA6}\x{2DA8}-\x{2DAE}\x{2DB0}-\x{2DB6}\x{2DB8}-\x{2DBE}\x{2DC0}-\x{2DC6}\x{2DC8}-\x{2DCE}\x{2DD0}-\x{2DD6}\x{2DD8}-\x{2DDE}\x{3006}\x{303C}\x{3041}-\x{3096}\x{309F}\x{30A1}-\x{30FA}\x{30FF}\x{3105}-\x{312D}\x{3131}-\x{318E}\x{31A0}-\x{31BA}\x{31F0}-\x{31FF}\x{3400}-\x{4DB5}\x{4E00}-\x{9FD5}\x{A000}-\x{A014}\x{A016}-\x{A48C}\x{A4D0}-\x{A4F7}\x{A500}-\x{A60B}\x{A610}-\x{A61F}\x{A62A}-\x{A62B}\x{A66E}\x{A6A0}-\x{A6E5}\x{A78F}\x{A7F7}\x{A7FB}-\x{A801}\x{A803}-\x{A805}\x{A807}-\x{A80A}\x{A80C}-\x{A822}\x{A840}-\x{A873}\x{A882}-\x{A8B3}\x{A8F2}-\x{A8F7}\x{A8FB}\x{A8FD}\x{A90A}-\x{A925}\x{A930}-\x{A946}\x{A960}-\x{A97C}\x{A984}-\x{A9B2}\x{A9E0}-\x{A9E4}\x{A9E7}-\x{A9EF}\x{A9FA}-\x{A9FE}\x{AA00}-\x{AA28}\x{AA40}-\x{AA42}\x{AA44}-\x{AA4B}\x{AA60}-\x{AA6F}\x{AA71}-\x{AA76}\x{AA7A}\x{AA7E}-\x{AAAF}\x{AAB1}\x{AAB5}-\x{AAB6}\x{AAB9}-\x{AABD}\x{AAC0}\x{AAC2}\x{AADB}-\x{AADC}\x{AAE0}-\x{AAEA}\x{AAF2}\x{AB01}-\x{AB06}\x{AB09}-\x{AB0E}\x{AB11}-\x{AB16}\x{AB20}-\x{AB26}\x{AB28}-\x{AB2E}\x{ABC0}-\x{ABE2}\x{AC00}-\x{D7A3}\x{D7B0}-\x{D7C6}\x{D7CB}-\x{D7FB}\x{F900}-\x{FA6D}\x{FA70}-\x{FAD9}\x{FB1D}\x{FB1F}-\x{FB28}\x{FB2A}-\x{FB36}\x{FB38}-\x{FB3C}\x{FB3E}\x{FB40}-\x{FB41}\x{FB43}-\x{FB44}\x{FB46}-\x{FBB1}\x{FBD3}-\x{FD3D}\x{FD50}-\x{FD8F}\x{FD92}-\x{FDC7}\x{FDF0}-\x{FDFB}\x{FE70}-\x{FE74}\x{FE76}-\x{FEFC}\x{FF66}-\x{FF6F}\x{FF71}-\x{FF9D}\x{FFA0}-\x{FFBE}\x{FFC2}-\x{FFC7}\x{FFCA}-\x{FFCF}\x{FFD2}-\x{FFD7}\x{FFDA}-\x{FFDC}]" );
    $this->peg_c39 = "/^[\\x{01C5}\\x{01C8}\\x{01CB}\\x{01F2}\\x{1F88}-\\x{1F8F}\\x{1F98}-\\x{1F9F}\\x{1FA8}-\\x{1FAF}\\x{1FBC}\\x{1FCC}\\x{1FFC}]/";
    $this->peg_c40 = array( "type" => "class", "value" => "[\x{01C5}\x{01C8}\x{01CB}\x{01F2}\x{1F88}-\x{1F8F}\x{1F98}-\x{1F9F}\x{1FA8}-\x{1FAF}\x{1FBC}\x{1FCC}\x{1FFC}]", "description" => "[\x{01C5}\x{01C8}\x{01CB}\x{01F2}\x{1F88}-\x{1F8F}\x{1F98}-\x{1F9F}\x{1FA8}-\x{1FAF}\x{1FBC}\x{1FCC}\x{1FFC}]" );
    $this->peg_c41 = "/^[A-ZÀ-ÖØ-Þ\\x{0100}\\x{0102}\\x{0104}\\x{0106}\\x{0108}\\x{010A}\\x{010C}\\x{010E}\\x{0110}\\x{0112}\\x{0114}\\x{0116}\\x{0118}\\x{011A}\\x{011C}\\x{011E}\\x{0120}\\x{0122}\\x{0124}\\x{0126}\\x{0128}\\x{012A}\\x{012C}\\x{012E}\\x{0130}\\x{0132}\\x{0134}\\x{0136}\\x{0139}\\x{013B}\\x{013D}\\x{013F}\\x{0141}\\x{0143}\\x{0145}\\x{0147}\\x{014A}\\x{014C}\\x{014E}\\x{0150}\\x{0152}\\x{0154}\\x{0156}\\x{0158}\\x{015A}\\x{015C}\\x{015E}\\x{0160}\\x{0162}\\x{0164}\\x{0166}\\x{0168}\\x{016A}\\x{016C}\\x{016E}\\x{0170}\\x{0172}\\x{0174}\\x{0176}\\x{0178}-\\x{0179}\\x{017B}\\x{017D}\\x{0181}-\\x{0182}\\x{0184}\\x{0186}-\\x{0187}\\x{0189}-\\x{018B}\\x{018E}-\\x{0191}\\x{0193}-\\x{0194}\\x{0196}-\\x{0198}\\x{019C}-\\x{019D}\\x{019F}-\\x{01A0}\\x{01A2}\\x{01A4}\\x{01A6}-\\x{01A7}\\x{01A9}\\x{01AC}\\x{01AE}-\\x{01AF}\\x{01B1}-\\x{01B3}\\x{01B5}\\x{01B7}-\\x{01B8}\\x{01BC}\\x{01C4}\\x{01C7}\\x{01CA}\\x{01CD}\\x{01CF}\\x{01D1}\\x{01D3}\\x{01D5}\\x{01D7}\\x{01D9}\\x{01DB}\\x{01DE}\\x{01E0}\\x{01E2}\\x{01E4}\\x{01E6}\\x{01E8}\\x{01EA}\\x{01EC}\\x{01EE}\\x{01F1}\\x{01F4}\\x{01F6}-\\x{01F8}\\x{01FA}\\x{01FC}\\x{01FE}\\x{0200}\\x{0202}\\x{0204}\\x{0206}\\x{0208}\\x{020A}\\x{020C}\\x{020E}\\x{0210}\\x{0212}\\x{0214}\\x{0216}\\x{0218}\\x{021A}\\x{021C}\\x{021E}\\x{0220}\\x{0222}\\x{0224}\\x{0226}\\x{0228}\\x{022A}\\x{022C}\\x{022E}\\x{0230}\\x{0232}\\x{023A}-\\x{023B}\\x{023D}-\\x{023E}\\x{0241}\\x{0243}-\\x{0246}\\x{0248}\\x{024A}\\x{024C}\\x{024E}\\x{0370}\\x{0372}\\x{0376}\\x{037F}\\x{0386}\\x{0388}-\\x{038A}\\x{038C}\\x{038E}-\\x{038F}\\x{0391}-\\x{03A1}\\x{03A3}-\\x{03AB}\\x{03CF}\\x{03D2}-\\x{03D4}\\x{03D8}\\x{03DA}\\x{03DC}\\x{03DE}\\x{03E0}\\x{03E2}\\x{03E4}\\x{03E6}\\x{03E8}\\x{03EA}\\x{03EC}\\x{03EE}\\x{03F4}\\x{03F7}\\x{03F9}-\\x{03FA}\\x{03FD}-\\x{042F}\\x{0460}\\x{0462}\\x{0464}\\x{0466}\\x{0468}\\x{046A}\\x{046C}\\x{046E}\\x{0470}\\x{0472}\\x{0474}\\x{0476}\\x{0478}\\x{047A}\\x{047C}\\x{047E}\\x{0480}\\x{048A}\\x{048C}\\x{048E}\\x{0490}\\x{0492}\\x{0494}\\x{0496}\\x{0498}\\x{049A}\\x{049C}\\x{049E}\\x{04A0}\\x{04A2}\\x{04A4}\\x{04A6}\\x{04A8}\\x{04AA}\\x{04AC}\\x{04AE}\\x{04B0}\\x{04B2}\\x{04B4}\\x{04B6}\\x{04B8}\\x{04BA}\\x{04BC}\\x{04BE}\\x{04C0}-\\x{04C1}\\x{04C3}\\x{04C5}\\x{04C7}\\x{04C9}\\x{04CB}\\x{04CD}\\x{04D0}\\x{04D2}\\x{04D4}\\x{04D6}\\x{04D8}\\x{04DA}\\x{04DC}\\x{04DE}\\x{04E0}\\x{04E2}\\x{04E4}\\x{04E6}\\x{04E8}\\x{04EA}\\x{04EC}\\x{04EE}\\x{04F0}\\x{04F2}\\x{04F4}\\x{04F6}\\x{04F8}\\x{04FA}\\x{04FC}\\x{04FE}\\x{0500}\\x{0502}\\x{0504}\\x{0506}\\x{0508}\\x{050A}\\x{050C}\\x{050E}\\x{0510}\\x{0512}\\x{0514}\\x{0516}\\x{0518}\\x{051A}\\x{051C}\\x{051E}\\x{0520}\\x{0522}\\x{0524}\\x{0526}\\x{0528}\\x{052A}\\x{052C}\\x{052E}\\x{0531}-\\x{0556}\\x{10A0}-\\x{10C5}\\x{10C7}\\x{10CD}\\x{13A0}-\\x{13F5}\\x{1E00}\\x{1E02}\\x{1E04}\\x{1E06}\\x{1E08}\\x{1E0A}\\x{1E0C}\\x{1E0E}\\x{1E10}\\x{1E12}\\x{1E14}\\x{1E16}\\x{1E18}\\x{1E1A}\\x{1E1C}\\x{1E1E}\\x{1E20}\\x{1E22}\\x{1E24}\\x{1E26}\\x{1E28}\\x{1E2A}\\x{1E2C}\\x{1E2E}\\x{1E30}\\x{1E32}\\x{1E34}\\x{1E36}\\x{1E38}\\x{1E3A}\\x{1E3C}\\x{1E3E}\\x{1E40}\\x{1E42}\\x{1E44}\\x{1E46}\\x{1E48}\\x{1E4A}\\x{1E4C}\\x{1E4E}\\x{1E50}\\x{1E52}\\x{1E54}\\x{1E56}\\x{1E58}\\x{1E5A}\\x{1E5C}\\x{1E5E}\\x{1E60}\\x{1E62}\\x{1E64}\\x{1E66}\\x{1E68}\\x{1E6A}\\x{1E6C}\\x{1E6E}\\x{1E70}\\x{1E72}\\x{1E74}\\x{1E76}\\x{1E78}\\x{1E7A}\\x{1E7C}\\x{1E7E}\\x{1E80}\\x{1E82}\\x{1E84}\\x{1E86}\\x{1E88}\\x{1E8A}\\x{1E8C}\\x{1E8E}\\x{1E90}\\x{1E92}\\x{1E94}\\x{1E9E}\\x{1EA0}\\x{1EA2}\\x{1EA4}\\x{1EA6}\\x{1EA8}\\x{1EAA}\\x{1EAC}\\x{1EAE}\\x{1EB0}\\x{1EB2}\\x{1EB4}\\x{1EB6}\\x{1EB8}\\x{1EBA}\\x{1EBC}\\x{1EBE}\\x{1EC0}\\x{1EC2}\\x{1EC4}\\x{1EC6}\\x{1EC8}\\x{1ECA}\\x{1ECC}\\x{1ECE}\\x{1ED0}\\x{1ED2}\\x{1ED4}\\x{1ED6}\\x{1ED8}\\x{1EDA}\\x{1EDC}\\x{1EDE}\\x{1EE0}\\x{1EE2}\\x{1EE4}\\x{1EE6}\\x{1EE8}\\x{1EEA}\\x{1EEC}\\x{1EEE}\\x{1EF0}\\x{1EF2}\\x{1EF4}\\x{1EF6}\\x{1EF8}\\x{1EFA}\\x{1EFC}\\x{1EFE}\\x{1F08}-\\x{1F0F}\\x{1F18}-\\x{1F1D}\\x{1F28}-\\x{1F2F}\\x{1F38}-\\x{1F3F}\\x{1F48}-\\x{1F4D}\\x{1F59}\\x{1F5B}\\x{1F5D}\\x{1F5F}\\x{1F68}-\\x{1F6F}\\x{1FB8}-\\x{1FBB}\\x{1FC8}-\\x{1FCB}\\x{1FD8}-\\x{1FDB}\\x{1FE8}-\\x{1FEC}\\x{1FF8}-\\x{1FFB}\\x{2102}\\x{2107}\\x{210B}-\\x{210D}\\x{2110}-\\x{2112}\\x{2115}\\x{2119}-\\x{211D}\\x{2124}\\x{2126}\\x{2128}\\x{212A}-\\x{212D}\\x{2130}-\\x{2133}\\x{213E}-\\x{213F}\\x{2145}\\x{2183}\\x{2C00}-\\x{2C2E}\\x{2C60}\\x{2C62}-\\x{2C64}\\x{2C67}\\x{2C69}\\x{2C6B}\\x{2C6D}-\\x{2C70}\\x{2C72}\\x{2C75}\\x{2C7E}-\\x{2C80}\\x{2C82}\\x{2C84}\\x{2C86}\\x{2C88}\\x{2C8A}\\x{2C8C}\\x{2C8E}\\x{2C90}\\x{2C92}\\x{2C94}\\x{2C96}\\x{2C98}\\x{2C9A}\\x{2C9C}\\x{2C9E}\\x{2CA0}\\x{2CA2}\\x{2CA4}\\x{2CA6}\\x{2CA8}\\x{2CAA}\\x{2CAC}\\x{2CAE}\\x{2CB0}\\x{2CB2}\\x{2CB4}\\x{2CB6}\\x{2CB8}\\x{2CBA}\\x{2CBC}\\x{2CBE}\\x{2CC0}\\x{2CC2}\\x{2CC4}\\x{2CC6}\\x{2CC8}\\x{2CCA}\\x{2CCC}\\x{2CCE}\\x{2CD0}\\x{2CD2}\\x{2CD4}\\x{2CD6}\\x{2CD8}\\x{2CDA}\\x{2CDC}\\x{2CDE}\\x{2CE0}\\x{2CE2}\\x{2CEB}\\x{2CED}\\x{2CF2}\\x{A640}\\x{A642}\\x{A644}\\x{A646}\\x{A648}\\x{A64A}\\x{A64C}\\x{A64E}\\x{A650}\\x{A652}\\x{A654}\\x{A656}\\x{A658}\\x{A65A}\\x{A65C}\\x{A65E}\\x{A660}\\x{A662}\\x{A664}\\x{A666}\\x{A668}\\x{A66A}\\x{A66C}\\x{A680}\\x{A682}\\x{A684}\\x{A686}\\x{A688}\\x{A68A}\\x{A68C}\\x{A68E}\\x{A690}\\x{A692}\\x{A694}\\x{A696}\\x{A698}\\x{A69A}\\x{A722}\\x{A724}\\x{A726}\\x{A728}\\x{A72A}\\x{A72C}\\x{A72E}\\x{A732}\\x{A734}\\x{A736}\\x{A738}\\x{A73A}\\x{A73C}\\x{A73E}\\x{A740}\\x{A742}\\x{A744}\\x{A746}\\x{A748}\\x{A74A}\\x{A74C}\\x{A74E}\\x{A750}\\x{A752}\\x{A754}\\x{A756}\\x{A758}\\x{A75A}\\x{A75C}\\x{A75E}\\x{A760}\\x{A762}\\x{A764}\\x{A766}\\x{A768}\\x{A76A}\\x{A76C}\\x{A76E}\\x{A779}\\x{A77B}\\x{A77D}-\\x{A77E}\\x{A780}\\x{A782}\\x{A784}\\x{A786}\\x{A78B}\\x{A78D}\\x{A790}\\x{A792}\\x{A796}\\x{A798}\\x{A79A}\\x{A79C}\\x{A79E}\\x{A7A0}\\x{A7A2}\\x{A7A4}\\x{A7A6}\\x{A7A8}\\x{A7AA}-\\x{A7AD}\\x{A7B0}-\\x{A7B4}\\x{A7B6}\\x{FF21}-\\x{FF3A}]/";
    $this->peg_c42 = array( "type" => "class", "value" => "[A-ZÀ-ÖØ-Þ\x{0100}\x{0102}\x{0104}\x{0106}\x{0108}\x{010A}\x{010C}\x{010E}\x{0110}\x{0112}\x{0114}\x{0116}\x{0118}\x{011A}\x{011C}\x{011E}\x{0120}\x{0122}\x{0124}\x{0126}\x{0128}\x{012A}\x{012C}\x{012E}\x{0130}\x{0132}\x{0134}\x{0136}\x{0139}\x{013B}\x{013D}\x{013F}\x{0141}\x{0143}\x{0145}\x{0147}\x{014A}\x{014C}\x{014E}\x{0150}\x{0152}\x{0154}\x{0156}\x{0158}\x{015A}\x{015C}\x{015E}\x{0160}\x{0162}\x{0164}\x{0166}\x{0168}\x{016A}\x{016C}\x{016E}\x{0170}\x{0172}\x{0174}\x{0176}\x{0178}-\x{0179}\x{017B}\x{017D}\x{0181}-\x{0182}\x{0184}\x{0186}-\x{0187}\x{0189}-\x{018B}\x{018E}-\x{0191}\x{0193}-\x{0194}\x{0196}-\x{0198}\x{019C}-\x{019D}\x{019F}-\x{01A0}\x{01A2}\x{01A4}\x{01A6}-\x{01A7}\x{01A9}\x{01AC}\x{01AE}-\x{01AF}\x{01B1}-\x{01B3}\x{01B5}\x{01B7}-\x{01B8}\x{01BC}\x{01C4}\x{01C7}\x{01CA}\x{01CD}\x{01CF}\x{01D1}\x{01D3}\x{01D5}\x{01D7}\x{01D9}\x{01DB}\x{01DE}\x{01E0}\x{01E2}\x{01E4}\x{01E6}\x{01E8}\x{01EA}\x{01EC}\x{01EE}\x{01F1}\x{01F4}\x{01F6}-\x{01F8}\x{01FA}\x{01FC}\x{01FE}\x{0200}\x{0202}\x{0204}\x{0206}\x{0208}\x{020A}\x{020C}\x{020E}\x{0210}\x{0212}\x{0214}\x{0216}\x{0218}\x{021A}\x{021C}\x{021E}\x{0220}\x{0222}\x{0224}\x{0226}\x{0228}\x{022A}\x{022C}\x{022E}\x{0230}\x{0232}\x{023A}-\x{023B}\x{023D}-\x{023E}\x{0241}\x{0243}-\x{0246}\x{0248}\x{024A}\x{024C}\x{024E}\x{0370}\x{0372}\x{0376}\x{037F}\x{0386}\x{0388}-\x{038A}\x{038C}\x{038E}-\x{038F}\x{0391}-\x{03A1}\x{03A3}-\x{03AB}\x{03CF}\x{03D2}-\x{03D4}\x{03D8}\x{03DA}\x{03DC}\x{03DE}\x{03E0}\x{03E2}\x{03E4}\x{03E6}\x{03E8}\x{03EA}\x{03EC}\x{03EE}\x{03F4}\x{03F7}\x{03F9}-\x{03FA}\x{03FD}-\x{042F}\x{0460}\x{0462}\x{0464}\x{0466}\x{0468}\x{046A}\x{046C}\x{046E}\x{0470}\x{0472}\x{0474}\x{0476}\x{0478}\x{047A}\x{047C}\x{047E}\x{0480}\x{048A}\x{048C}\x{048E}\x{0490}\x{0492}\x{0494}\x{0496}\x{0498}\x{049A}\x{049C}\x{049E}\x{04A0}\x{04A2}\x{04A4}\x{04A6}\x{04A8}\x{04AA}\x{04AC}\x{04AE}\x{04B0}\x{04B2}\x{04B4}\x{04B6}\x{04B8}\x{04BA}\x{04BC}\x{04BE}\x{04C0}-\x{04C1}\x{04C3}\x{04C5}\x{04C7}\x{04C9}\x{04CB}\x{04CD}\x{04D0}\x{04D2}\x{04D4}\x{04D6}\x{04D8}\x{04DA}\x{04DC}\x{04DE}\x{04E0}\x{04E2}\x{04E4}\x{04E6}\x{04E8}\x{04EA}\x{04EC}\x{04EE}\x{04F0}\x{04F2}\x{04F4}\x{04F6}\x{04F8}\x{04FA}\x{04FC}\x{04FE}\x{0500}\x{0502}\x{0504}\x{0506}\x{0508}\x{050A}\x{050C}\x{050E}\x{0510}\x{0512}\x{0514}\x{0516}\x{0518}\x{051A}\x{051C}\x{051E}\x{0520}\x{0522}\x{0524}\x{0526}\x{0528}\x{052A}\x{052C}\x{052E}\x{0531}-\x{0556}\x{10A0}-\x{10C5}\x{10C7}\x{10CD}\x{13A0}-\x{13F5}\x{1E00}\x{1E02}\x{1E04}\x{1E06}\x{1E08}\x{1E0A}\x{1E0C}\x{1E0E}\x{1E10}\x{1E12}\x{1E14}\x{1E16}\x{1E18}\x{1E1A}\x{1E1C}\x{1E1E}\x{1E20}\x{1E22}\x{1E24}\x{1E26}\x{1E28}\x{1E2A}\x{1E2C}\x{1E2E}\x{1E30}\x{1E32}\x{1E34}\x{1E36}\x{1E38}\x{1E3A}\x{1E3C}\x{1E3E}\x{1E40}\x{1E42}\x{1E44}\x{1E46}\x{1E48}\x{1E4A}\x{1E4C}\x{1E4E}\x{1E50}\x{1E52}\x{1E54}\x{1E56}\x{1E58}\x{1E5A}\x{1E5C}\x{1E5E}\x{1E60}\x{1E62}\x{1E64}\x{1E66}\x{1E68}\x{1E6A}\x{1E6C}\x{1E6E}\x{1E70}\x{1E72}\x{1E74}\x{1E76}\x{1E78}\x{1E7A}\x{1E7C}\x{1E7E}\x{1E80}\x{1E82}\x{1E84}\x{1E86}\x{1E88}\x{1E8A}\x{1E8C}\x{1E8E}\x{1E90}\x{1E92}\x{1E94}\x{1E9E}\x{1EA0}\x{1EA2}\x{1EA4}\x{1EA6}\x{1EA8}\x{1EAA}\x{1EAC}\x{1EAE}\x{1EB0}\x{1EB2}\x{1EB4}\x{1EB6}\x{1EB8}\x{1EBA}\x{1EBC}\x{1EBE}\x{1EC0}\x{1EC2}\x{1EC4}\x{1EC6}\x{1EC8}\x{1ECA}\x{1ECC}\x{1ECE}\x{1ED0}\x{1ED2}\x{1ED4}\x{1ED6}\x{1ED8}\x{1EDA}\x{1EDC}\x{1EDE}\x{1EE0}\x{1EE2}\x{1EE4}\x{1EE6}\x{1EE8}\x{1EEA}\x{1EEC}\x{1EEE}\x{1EF0}\x{1EF2}\x{1EF4}\x{1EF6}\x{1EF8}\x{1EFA}\x{1EFC}\x{1EFE}\x{1F08}-\x{1F0F}\x{1F18}-\x{1F1D}\x{1F28}-\x{1F2F}\x{1F38}-\x{1F3F}\x{1F48}-\x{1F4D}\x{1F59}\x{1F5B}\x{1F5D}\x{1F5F}\x{1F68}-\x{1F6F}\x{1FB8}-\x{1FBB}\x{1FC8}-\x{1FCB}\x{1FD8}-\x{1FDB}\x{1FE8}-\x{1FEC}\x{1FF8}-\x{1FFB}\x{2102}\x{2107}\x{210B}-\x{210D}\x{2110}-\x{2112}\x{2115}\x{2119}-\x{211D}\x{2124}\x{2126}\x{2128}\x{212A}-\x{212D}\x{2130}-\x{2133}\x{213E}-\x{213F}\x{2145}\x{2183}\x{2C00}-\x{2C2E}\x{2C60}\x{2C62}-\x{2C64}\x{2C67}\x{2C69}\x{2C6B}\x{2C6D}-\x{2C70}\x{2C72}\x{2C75}\x{2C7E}-\x{2C80}\x{2C82}\x{2C84}\x{2C86}\x{2C88}\x{2C8A}\x{2C8C}\x{2C8E}\x{2C90}\x{2C92}\x{2C94}\x{2C96}\x{2C98}\x{2C9A}\x{2C9C}\x{2C9E}\x{2CA0}\x{2CA2}\x{2CA4}\x{2CA6}\x{2CA8}\x{2CAA}\x{2CAC}\x{2CAE}\x{2CB0}\x{2CB2}\x{2CB4}\x{2CB6}\x{2CB8}\x{2CBA}\x{2CBC}\x{2CBE}\x{2CC0}\x{2CC2}\x{2CC4}\x{2CC6}\x{2CC8}\x{2CCA}\x{2CCC}\x{2CCE}\x{2CD0}\x{2CD2}\x{2CD4}\x{2CD6}\x{2CD8}\x{2CDA}\x{2CDC}\x{2CDE}\x{2CE0}\x{2CE2}\x{2CEB}\x{2CED}\x{2CF2}\x{A640}\x{A642}\x{A644}\x{A646}\x{A648}\x{A64A}\x{A64C}\x{A64E}\x{A650}\x{A652}\x{A654}\x{A656}\x{A658}\x{A65A}\x{A65C}\x{A65E}\x{A660}\x{A662}\x{A664}\x{A666}\x{A668}\x{A66A}\x{A66C}\x{A680}\x{A682}\x{A684}\x{A686}\x{A688}\x{A68A}\x{A68C}\x{A68E}\x{A690}\x{A692}\x{A694}\x{A696}\x{A698}\x{A69A}\x{A722}\x{A724}\x{A726}\x{A728}\x{A72A}\x{A72C}\x{A72E}\x{A732}\x{A734}\x{A736}\x{A738}\x{A73A}\x{A73C}\x{A73E}\x{A740}\x{A742}\x{A744}\x{A746}\x{A748}\x{A74A}\x{A74C}\x{A74E}\x{A750}\x{A752}\x{A754}\x{A756}\x{A758}\x{A75A}\x{A75C}\x{A75E}\x{A760}\x{A762}\x{A764}\x{A766}\x{A768}\x{A76A}\x{A76C}\x{A76E}\x{A779}\x{A77B}\x{A77D}-\x{A77E}\x{A780}\x{A782}\x{A784}\x{A786}\x{A78B}\x{A78D}\x{A790}\x{A792}\x{A796}\x{A798}\x{A79A}\x{A79C}\x{A79E}\x{A7A0}\x{A7A2}\x{A7A4}\x{A7A6}\x{A7A8}\x{A7AA}-\x{A7AD}\x{A7B0}-\x{A7B4}\x{A7B6}\x{FF21}-\x{FF3A}]", "description" => "[A-ZÀ-ÖØ-Þ\x{0100}\x{0102}\x{0104}\x{0106}\x{0108}\x{010A}\x{010C}\x{010E}\x{0110}\x{0112}\x{0114}\x{0116}\x{0118}\x{011A}\x{011C}\x{011E}\x{0120}\x{0122}\x{0124}\x{0126}\x{0128}\x{012A}\x{012C}\x{012E}\x{0130}\x{0132}\x{0134}\x{0136}\x{0139}\x{013B}\x{013D}\x{013F}\x{0141}\x{0143}\x{0145}\x{0147}\x{014A}\x{014C}\x{014E}\x{0150}\x{0152}\x{0154}\x{0156}\x{0158}\x{015A}\x{015C}\x{015E}\x{0160}\x{0162}\x{0164}\x{0166}\x{0168}\x{016A}\x{016C}\x{016E}\x{0170}\x{0172}\x{0174}\x{0176}\x{0178}-\x{0179}\x{017B}\x{017D}\x{0181}-\x{0182}\x{0184}\x{0186}-\x{0187}\x{0189}-\x{018B}\x{018E}-\x{0191}\x{0193}-\x{0194}\x{0196}-\x{0198}\x{019C}-\x{019D}\x{019F}-\x{01A0}\x{01A2}\x{01A4}\x{01A6}-\x{01A7}\x{01A9}\x{01AC}\x{01AE}-\x{01AF}\x{01B1}-\x{01B3}\x{01B5}\x{01B7}-\x{01B8}\x{01BC}\x{01C4}\x{01C7}\x{01CA}\x{01CD}\x{01CF}\x{01D1}\x{01D3}\x{01D5}\x{01D7}\x{01D9}\x{01DB}\x{01DE}\x{01E0}\x{01E2}\x{01E4}\x{01E6}\x{01E8}\x{01EA}\x{01EC}\x{01EE}\x{01F1}\x{01F4}\x{01F6}-\x{01F8}\x{01FA}\x{01FC}\x{01FE}\x{0200}\x{0202}\x{0204}\x{0206}\x{0208}\x{020A}\x{020C}\x{020E}\x{0210}\x{0212}\x{0214}\x{0216}\x{0218}\x{021A}\x{021C}\x{021E}\x{0220}\x{0222}\x{0224}\x{0226}\x{0228}\x{022A}\x{022C}\x{022E}\x{0230}\x{0232}\x{023A}-\x{023B}\x{023D}-\x{023E}\x{0241}\x{0243}-\x{0246}\x{0248}\x{024A}\x{024C}\x{024E}\x{0370}\x{0372}\x{0376}\x{037F}\x{0386}\x{0388}-\x{038A}\x{038C}\x{038E}-\x{038F}\x{0391}-\x{03A1}\x{03A3}-\x{03AB}\x{03CF}\x{03D2}-\x{03D4}\x{03D8}\x{03DA}\x{03DC}\x{03DE}\x{03E0}\x{03E2}\x{03E4}\x{03E6}\x{03E8}\x{03EA}\x{03EC}\x{03EE}\x{03F4}\x{03F7}\x{03F9}-\x{03FA}\x{03FD}-\x{042F}\x{0460}\x{0462}\x{0464}\x{0466}\x{0468}\x{046A}\x{046C}\x{046E}\x{0470}\x{0472}\x{0474}\x{0476}\x{0478}\x{047A}\x{047C}\x{047E}\x{0480}\x{048A}\x{048C}\x{048E}\x{0490}\x{0492}\x{0494}\x{0496}\x{0498}\x{049A}\x{049C}\x{049E}\x{04A0}\x{04A2}\x{04A4}\x{04A6}\x{04A8}\x{04AA}\x{04AC}\x{04AE}\x{04B0}\x{04B2}\x{04B4}\x{04B6}\x{04B8}\x{04BA}\x{04BC}\x{04BE}\x{04C0}-\x{04C1}\x{04C3}\x{04C5}\x{04C7}\x{04C9}\x{04CB}\x{04CD}\x{04D0}\x{04D2}\x{04D4}\x{04D6}\x{04D8}\x{04DA}\x{04DC}\x{04DE}\x{04E0}\x{04E2}\x{04E4}\x{04E6}\x{04E8}\x{04EA}\x{04EC}\x{04EE}\x{04F0}\x{04F2}\x{04F4}\x{04F6}\x{04F8}\x{04FA}\x{04FC}\x{04FE}\x{0500}\x{0502}\x{0504}\x{0506}\x{0508}\x{050A}\x{050C}\x{050E}\x{0510}\x{0512}\x{0514}\x{0516}\x{0518}\x{051A}\x{051C}\x{051E}\x{0520}\x{0522}\x{0524}\x{0526}\x{0528}\x{052A}\x{052C}\x{052E}\x{0531}-\x{0556}\x{10A0}-\x{10C5}\x{10C7}\x{10CD}\x{13A0}-\x{13F5}\x{1E00}\x{1E02}\x{1E04}\x{1E06}\x{1E08}\x{1E0A}\x{1E0C}\x{1E0E}\x{1E10}\x{1E12}\x{1E14}\x{1E16}\x{1E18}\x{1E1A}\x{1E1C}\x{1E1E}\x{1E20}\x{1E22}\x{1E24}\x{1E26}\x{1E28}\x{1E2A}\x{1E2C}\x{1E2E}\x{1E30}\x{1E32}\x{1E34}\x{1E36}\x{1E38}\x{1E3A}\x{1E3C}\x{1E3E}\x{1E40}\x{1E42}\x{1E44}\x{1E46}\x{1E48}\x{1E4A}\x{1E4C}\x{1E4E}\x{1E50}\x{1E52}\x{1E54}\x{1E56}\x{1E58}\x{1E5A}\x{1E5C}\x{1E5E}\x{1E60}\x{1E62}\x{1E64}\x{1E66}\x{1E68}\x{1E6A}\x{1E6C}\x{1E6E}\x{1E70}\x{1E72}\x{1E74}\x{1E76}\x{1E78}\x{1E7A}\x{1E7C}\x{1E7E}\x{1E80}\x{1E82}\x{1E84}\x{1E86}\x{1E88}\x{1E8A}\x{1E8C}\x{1E8E}\x{1E90}\x{1E92}\x{1E94}\x{1E9E}\x{1EA0}\x{1EA2}\x{1EA4}\x{1EA6}\x{1EA8}\x{1EAA}\x{1EAC}\x{1EAE}\x{1EB0}\x{1EB2}\x{1EB4}\x{1EB6}\x{1EB8}\x{1EBA}\x{1EBC}\x{1EBE}\x{1EC0}\x{1EC2}\x{1EC4}\x{1EC6}\x{1EC8}\x{1ECA}\x{1ECC}\x{1ECE}\x{1ED0}\x{1ED2}\x{1ED4}\x{1ED6}\x{1ED8}\x{1EDA}\x{1EDC}\x{1EDE}\x{1EE0}\x{1EE2}\x{1EE4}\x{1EE6}\x{1EE8}\x{1EEA}\x{1EEC}\x{1EEE}\x{1EF0}\x{1EF2}\x{1EF4}\x{1EF6}\x{1EF8}\x{1EFA}\x{1EFC}\x{1EFE}\x{1F08}-\x{1F0F}\x{1F18}-\x{1F1D}\x{1F28}-\x{1F2F}\x{1F38}-\x{1F3F}\x{1F48}-\x{1F4D}\x{1F59}\x{1F5B}\x{1F5D}\x{1F5F}\x{1F68}-\x{1F6F}\x{1FB8}-\x{1FBB}\x{1FC8}-\x{1FCB}\x{1FD8}-\x{1FDB}\x{1FE8}-\x{1FEC}\x{1FF8}-\x{1FFB}\x{2102}\x{2107}\x{210B}-\x{210D}\x{2110}-\x{2112}\x{2115}\x{2119}-\x{211D}\x{2124}\x{2126}\x{2128}\x{212A}-\x{212D}\x{2130}-\x{2133}\x{213E}-\x{213F}\x{2145}\x{2183}\x{2C00}-\x{2C2E}\x{2C60}\x{2C62}-\x{2C64}\x{2C67}\x{2C69}\x{2C6B}\x{2C6D}-\x{2C70}\x{2C72}\x{2C75}\x{2C7E}-\x{2C80}\x{2C82}\x{2C84}\x{2C86}\x{2C88}\x{2C8A}\x{2C8C}\x{2C8E}\x{2C90}\x{2C92}\x{2C94}\x{2C96}\x{2C98}\x{2C9A}\x{2C9C}\x{2C9E}\x{2CA0}\x{2CA2}\x{2CA4}\x{2CA6}\x{2CA8}\x{2CAA}\x{2CAC}\x{2CAE}\x{2CB0}\x{2CB2}\x{2CB4}\x{2CB6}\x{2CB8}\x{2CBA}\x{2CBC}\x{2CBE}\x{2CC0}\x{2CC2}\x{2CC4}\x{2CC6}\x{2CC8}\x{2CCA}\x{2CCC}\x{2CCE}\x{2CD0}\x{2CD2}\x{2CD4}\x{2CD6}\x{2CD8}\x{2CDA}\x{2CDC}\x{2CDE}\x{2CE0}\x{2CE2}\x{2CEB}\x{2CED}\x{2CF2}\x{A640}\x{A642}\x{A644}\x{A646}\x{A648}\x{A64A}\x{A64C}\x{A64E}\x{A650}\x{A652}\x{A654}\x{A656}\x{A658}\x{A65A}\x{A65C}\x{A65E}\x{A660}\x{A662}\x{A664}\x{A666}\x{A668}\x{A66A}\x{A66C}\x{A680}\x{A682}\x{A684}\x{A686}\x{A688}\x{A68A}\x{A68C}\x{A68E}\x{A690}\x{A692}\x{A694}\x{A696}\x{A698}\x{A69A}\x{A722}\x{A724}\x{A726}\x{A728}\x{A72A}\x{A72C}\x{A72E}\x{A732}\x{A734}\x{A736}\x{A738}\x{A73A}\x{A73C}\x{A73E}\x{A740}\x{A742}\x{A744}\x{A746}\x{A748}\x{A74A}\x{A74C}\x{A74E}\x{A750}\x{A752}\x{A754}\x{A756}\x{A758}\x{A75A}\x{A75C}\x{A75E}\x{A760}\x{A762}\x{A764}\x{A766}\x{A768}\x{A76A}\x{A76C}\x{A76E}\x{A779}\x{A77B}\x{A77D}-\x{A77E}\x{A780}\x{A782}\x{A784}\x{A786}\x{A78B}\x{A78D}\x{A790}\x{A792}\x{A796}\x{A798}\x{A79A}\x{A79C}\x{A79E}\x{A7A0}\x{A7A2}\x{A7A4}\x{A7A6}\x{A7A8}\x{A7AA}-\x{A7AD}\x{A7B0}-\x{A7B4}\x{A7B6}\x{FF21}-\x{FF3A}]" );
    $this->peg_c43 = "/^[a-zA-Z]/";
    $this->peg_c44 = array( "type" => "class", "value" => "[a-zA-Z]", "description" => "[a-zA-Z]" );
    $this->peg_c45 = "_";
    $this->peg_c46 = array( "type" => "literal", "value" => "_", "description" => "\"_\"" );
    $this->peg_c47 = "%";
    $this->peg_c48 = array( "type" => "literal", "value" => "%", "description" => "\"%\"" );
    $this->peg_c49 = "/^[0-9]/";
    $this->peg_c50 = array( "type" => "class", "value" => "[0-9]", "description" => "[0-9]" );
    $this->peg_c51 = "-";
    $this->peg_c52 = array( "type" => "literal", "value" => "-", "description" => "\"-\"" );
    $this->peg_c53 = "if";
    $this->peg_c54 = array( "type" => "literal", "value" => "if", "description" => "\"if\"" );
    $this->peg_c55 = "test";
    $this->peg_c56 = array( "type" => "literal", "value" => "test", "description" => "\"test\"" );
    $this->peg_c57 = "else";
    $this->peg_c58 = array( "type" => "literal", "value" => "else", "description" => "\"else\"" );
    $this->peg_c59 = "elif";
    $this->peg_c60 = array( "type" => "literal", "value" => "elif", "description" => "\"elif\"" );
    $this->peg_c61 = "define";
    $this->peg_c62 = array( "type" => "literal", "value" => "define", "description" => "\"define\"" );
    $this->peg_c63 = "/]]";
    $this->peg_c64 = array( "type" => "literal", "value" => "/]]", "description" => "\"/]]\"" );
    $this->peg_c65 = "\"";
    $this->peg_c66 = array( "type" => "literal", "value" => "\"", "description" => "\"\\\"\"" );
    $this->peg_c67 = "'";
    $this->peg_c68 = array( "type" => "literal", "value" => "'", "description" => "\"'\"" );
    $this->peg_c69 = "\\";
    $this->peg_c70 = array( "type" => "literal", "value" => "\\", "description" => "\"\\\\\"" );
    $this->peg_c71 = "\\\\";
    $this->peg_c72 = array( "type" => "literal", "value" => "\\\\", "description" => "\"\\\\\\\\\"" );
    $this->peg_c73 = "\\\"";
    $this->peg_c74 = array( "type" => "literal", "value" => "\\\"", "description" => "\"\\\\\\\"\"" );
    $this->peg_c75 = "\\'";
    $this->peg_c76 = array( "type" => "literal", "value" => "\\'", "description" => "\"\\\\'\"" );
    $this->peg_c77 = array("type" => "other", "description" => "whitespace allowed" );
    $this->peg_c78 = "/^[ \\t\\n\\r]/";
    $this->peg_c79 = array( "type" => "class", "value" => "[ \t\n\r]", "description" => "[ \t\n\r]" );
    $this->peg_c80 = array("type" => "other", "description" => "whitespace required" );

    $peg_startRuleFunctions = array( 'Root' => array($this, "peg_parseRoot") );
    $peg_startRuleFunction  = array($this, "peg_parseRoot");
    if (isset($options["startRule"])) {
      if (!(isset($peg_startRuleFunctions[$options["startRule"]]))) {
        throw new Exception("Can't start parsing from rule \"" + $options["startRule"] + "\".");
      }

      $peg_startRuleFunction = $peg_startRuleFunctions[$options["startRule"]];
    }

    /* BEGIN initializer code */

     require_once(__DIR__ . '/../CTP_classes.php');
     
    /* END initializer code */

    $peg_result = call_user_func($peg_startRuleFunction);

    $this->peg_cache = array();

    mb_regex_encoding($old_regex_encoding);

    if ($peg_result !== $this->peg_FAILED && $this->peg_currPos === $this->input_length) {
      $this->cleanup_state(); // Free up memory
      return $peg_result;
    } else {
      if ($peg_result !== $this->peg_FAILED && $this->peg_currPos < $this->input_length) {
        $this->peg_fail(array("type" => "end", "description" => "end of input" ));
      }

      $exception = $this->peg_buildException(null, $this->peg_maxFailExpected, $this->peg_maxFailPos);
      $this->cleanup_state(); // Free up memory
      throw $exception;
    }
  }

};