var define=window.define;window.M;define("local_trustgrade/question_editor",["jquery","core/ajax","core/notification","core/str","core/templates"],($,Ajax,Notification,Str,Templates)=>{var QuestionEditor={cmid:0,initialized:!1,init:function(cmid){this.cmid=cmid||0,this.initialized||(this.bindEvents(),this.initialized=!0)},bindEvents:()=>{$(document).off("click.questioneditor").off("change.questioneditor"),$(document).on("click.questioneditor","#add-new-question-btn",e=>{e.preventDefault(),QuestionEditor.addNewQuestion()}),$(document).on("click.questioneditor",".edit-question-btn",function(e){e.preventDefault();var questionItem=$(this).closest(".editable-question-item");QuestionEditor.enterEditMode(questionItem)}),$(document).on("click.questioneditor",".cancel-edit-btn",function(e){e.preventDefault();var questionItem=$(this).closest(".editable-question-item");QuestionEditor.exitEditMode(questionItem)}),$(document).on("click.questioneditor",".save-question-btn",function(e){e.preventDefault();var questionItem=$(this).closest(".editable-question-item");QuestionEditor.saveQuestion(questionItem)}),$(document).on("click.questioneditor",".delete-question-btn",function(e){e.preventDefault();var $button=$(this);if(!$button.prop("disabled")){$button.prop("disabled",!0);var questionItem=$button.closest(".editable-question-item");setTimeout(()=>QuestionEditor.deleteQuestion(questionItem,$button),100)}}),$(document).on("change.questioneditor",".question-type-input",function(e){var questionIndex=$(this).closest(".editable-question-item").data("question-index");QuestionEditor.updateOptionsSection($(this).val(),questionIndex)})},enterEditMode:questionItem=>{questionItem.find(".question-display-mode").hide(),questionItem.find(".question-edit-mode").show()},exitEditMode:questionItem=>{questionItem.find(".question-edit-mode").hide(),questionItem.find(".question-display-mode").show()},saveQuestion:questionItem=>{const questionIndex=questionItem.data("question-index"),cmid=questionItem.data("cmid"),questionType=questionItem.find(".question-type-input").val(),questionText=questionItem.find(".question-text-input").val(),points=Number.parseInt(questionItem.find(".question-points-input").val(),10),blooms=questionItem.find(".question-blooms-input").val()||void 0,questionData={id:Number.parseInt(questionItem.data("question-id")||0,10)||void 0,type:questionType,text:questionText,options:[],metadata:{points:isNaN(points)?0:points,...blooms?{blooms_level:blooms}:{}}};if("multiple_choice"===questionType)questionItem.find(".option-row").each(function(){const $row=$(this),isCorrect=$row.find(".correct-answer-radio").is(":checked"),optText=$row.find(".option-text-input").val()||"",optExplanation=$row.find(".option-explanation-input").val()||"";questionData.options.push({text:optText,is_correct:!!isCorrect,explanation:optExplanation})});else if("true_false"===questionType){const selectedVal=questionItem.find(`input[name^="tf_answer_${questionIndex}"]:checked`).val(),$trueRow=questionItem.find('.true-false-options .tf-row[data-value="true"]'),trueText=$trueRow.find(".tf-label").text()||"True",trueExpl=$trueRow.find(".option-explanation-input").val()||"",$falseRow=questionItem.find('.true-false-options .tf-row[data-value="false"]'),falseText=$falseRow.find(".tf-label").text()||"False",falseExpl=$falseRow.find(".option-explanation-input").val()||"";questionData.options.push({text:trueText,is_correct:"true"===selectedVal,explanation:trueExpl},{text:falseText,is_correct:"false"===selectedVal,explanation:falseExpl})}else"short_answer"===questionType&&(questionData.options=[]);if(questionData.text&&questionData.text.trim()){if("multiple_choice"===questionType){if(questionData.options.some(opt=>!(opt.text||"").trim()))return void Str.get_string("all_options_required","local_trustgrade").then(message=>Notification.addNotification({message:message,type:"error"}));if(!questionData.options.some(opt=>opt.is_correct))return void Str.get_string("correct_answer_required","local_trustgrade").then(message=>Notification.addNotification({message:message,type:"error"}))}var $saveBtn=questionItem.find(".save-question-btn");$saveBtn.prop("disabled",!0),Ajax.call([{methodname:"local_trustgrade_save_question",args:{cmid:cmid,question_index:questionIndex,question_data:JSON.stringify(questionData)}}])[0].done(response=>{response.success?(QuestionEditor.updateQuestionDisplay(questionItem,questionData),QuestionEditor.exitEditMode(questionItem),Str.get_string("question_saved_success","local_trustgrade").then(message=>Notification.addNotification({message:message,type:"success"}))):Notification.addNotification({message:response.error||"Failed to save question.",type:"error"})}).fail(Notification.exception).always(()=>$saveBtn.prop("disabled",!1))}else Str.get_string("question_text_required","local_trustgrade").then(message=>Notification.addNotification({message:message,type:"error"}))},deleteQuestion:(questionItem,$button)=>{Promise.all([Str.get_string("confirm_delete_question_title","local_trustgrade"),Str.get_string("confirm_delete_question_message","local_trustgrade"),Str.get_string("delete","core"),Str.get_string("cancel","core")]).then(strings=>{Notification.confirm(strings[0],strings[1],strings[2],strings[3],()=>{var questionIndex=questionItem.data("question-index"),cmid=questionItem.data("cmid");QuestionEditor.performDelete(questionItem,questionIndex,cmid)},()=>$button.prop("disabled",!1))})},performDelete:(questionItem,questionIndex,cmid)=>{Ajax.call([{methodname:"local_trustgrade_delete_question",args:{cmid:cmid,question_index:questionIndex}}])[0].done(response=>{response.success?(questionItem.fadeOut(300,function(){$(this).remove(),QuestionEditor.reindexQuestions()}),Str.get_string("question_deleted_success","local_trustgrade").then(message=>Notification.addNotification({message:message,type:"success"}))):Notification.addNotification({message:response.error||"Failed to delete question.",type:"error"})}).fail(Notification.exception)},updateQuestionDisplay:(questionItem,questionData)=>{var displayMode=questionItem.find(".question-display-mode .question-content");Promise.all([Str.get_string("question","local_trustgrade"),Str.get_string("correct","local_trustgrade"),Str.get_string("explanation","local_trustgrade"),Str.get_string("points","local_trustgrade")]).then(strings=>{const[qStr,correctStr,explStr,pointsStr]=strings;let html=`<p><strong>Type:</strong> ${String(questionData.type||"").replace("_"," ")}</p>`;if(questionData.metadata&&(null!=questionData.metadata.points||questionData.metadata.blooms_level)){const pts=null!=questionData.metadata.points?`${pointsStr}: ${questionData.metadata.points}`:"",bloom=questionData.metadata.blooms_level?` | Bloom's: ${questionData.metadata.blooms_level}`:"";html+=`<p>${pts}${bloom}</p>`}html+=`<p><strong>${qStr}:</strong> ${questionData.text||""}</p>`,Array.isArray(questionData.options)&&questionData.options.length>0&&(html+="<p><strong>Options:</strong></p><ul>",questionData.options.forEach(opt=>{const correctBadge=opt.is_correct?` <strong>(${correctStr})</strong>`:"",safeOptText=opt.text||"",safeExpl=opt.explanation?` <div class="option-explanation"><em>${explStr}:</em> ${opt.explanation}</div>`:"";html+=`<li>${safeOptText}${correctBadge}${safeExpl}</li>`}),html+="</ul>"),displayMode.html(html)})},updateOptionsSection:(questionType,questionIndex)=>{var optionsSection=$(`.editable-question-item[data-question-index="${questionIndex}"] .question-options-section`);if("multiple_choice"===questionType){const context={questionIndex:questionIndex,options:[{index:0,text:"",isCorrect:!0,explanation:"",optionLabel:"Option A"},{index:1,text:"",isCorrect:!1,explanation:"",optionLabel:"Option B"},{index:2,text:"",isCorrect:!1,explanation:"",optionLabel:"Option C"},{index:3,text:"",isCorrect:!1,explanation:"",optionLabel:"Option D"}]};Templates.render("local_trustgrade/question_multiple_choice_options",context).then(html=>optionsSection.html(html)).catch(Notification.exception)}else if("true_false"===questionType){const context={questionIndex:questionIndex,trueSelected:!0,falseSelected:!1,trueExplanation:"",falseExplanation:""};Templates.render("local_trustgrade/question_true_false_options",context).then(html=>optionsSection.html(html)).catch(Notification.exception)}else optionsSection.html("")},generateMultipleChoiceOptions:questionIndex=>(console.warn("generateMultipleChoiceOptions is deprecated, use updateOptionsSection instead"),""),generateTrueFalseOptions:questionIndex=>(console.warn("generateTrueFalseOptions is deprecated, use updateOptionsSection instead"),Promise.resolve("")),reindexQuestions:()=>{Str.get_string("question","local_trustgrade").then(str=>{$("#question-bank-container .editable-question-item").each(function(index){$(this).data("question-index",index),$(this).find(".question-header h5").text(`${str} ${index+1}`)})})},reinitialize:function(cmid){this.initialized=!1,this.init(cmid)},addNewQuestion:()=>{const newIndex=$("#question-bank-container .editable-question-item").length,editFormContext=QuestionEditor.prepareEditFormContext({id:0,type:"multiple_choice",text:"",options:[{text:"",is_correct:!0,explanation:""},{text:"",is_correct:!1,explanation:""},{text:"",is_correct:!1,explanation:""},{text:"",is_correct:!1,explanation:""}],metadata:{points:10,blooms_level:""}},newIndex);Templates.render("local_trustgrade/question_edit_form",editFormContext).then(editFormHtml=>{const context={index:newIndex,cmid:QuestionEditor.cmid,questionNumber:newIndex+1,editFormHtml:editFormHtml};return Templates.render("local_trustgrade/question_new_item",context)}).then(html=>{$(".add-question-section").before(html);const newQuestionItem=$(`.editable-question-item[data-question-index="${newIndex}"]`);QuestionEditor.updateOptionsSection("multiple_choice",newIndex),QuestionEditor.enterEditMode(newQuestionItem),newQuestionItem.find(".question-text-input").focus()}).catch(Notification.exception)},generateEditForm:(question,index)=>{const context=QuestionEditor.prepareEditFormContext(question,index);return Templates.render("local_trustgrade/question_edit_form",context).catch(err=>(Notification.exception(err),""))},prepareEditFormContext:(question,index)=>{const type=question.type||"multiple_choice",text=question.text||"",metadata=question.metadata||{},points=metadata.points||10,blooms=metadata.blooms_level||"",bloomsLevels=["","blooms_remember","blooms_understand","blooms_apply","blooms_analyze","blooms_evaluate","blooms_create"],bloomsPromises=bloomsLevels.map(level=>""===level?Promise.resolve("-"):Str.get_string(level,"local_trustgrade").catch(()=>level.replace("blooms_","")));return Promise.all(bloomsPromises).then(bloomsLabels=>{const bloomsOptions=bloomsLevels.map((level,i)=>({value:""===level?"":level.replace("blooms_","").charAt(0).toUpperCase()+level.replace("blooms_","").slice(1),label:bloomsLabels[i],selected:blooms===(""===level?"":level.replace("blooms_","").charAt(0).toUpperCase()+level.replace("blooms_","").slice(1))})),options=[];for(let i=0;i<4;i++){const opt=question.options[i]||{text:"",is_correct:0===i,explanation:""};options.push({index:i,text:opt.text,isCorrect:opt.is_correct,explanation:opt.explanation,optionLabel:`Option ${String.fromCharCode(65+i)}`})}return{index:index,text:text,type:type,points:points,bloomsLevel:blooms,bloomsOptions:bloomsOptions,isMultipleChoice:"multiple_choice"===type,isTrueFalse:"true_false"===type,isShortAnswer:"short_answer"===type,options:options}})}};return QuestionEditor});

//# sourceMappingURL=question_editor.min.js.map
