/**
 * Grading interface module for instructors.
 *
 * @module     local_trustgrade/grading
 * @package    local_trustgrade
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
(0,window.define)("local_trustgrade/grading",["jquery","core/ajax","core/notification","core/config","core/str","core/modal_factory","core/modal_events"],($,Ajax,Notification,M,Str,ModalFactory,ModalEvents)=>{var saveTimeout,cmid,pendingGrades=new Map;function saveGrade(userid,grade,$input){updateGradeStatus($input,"saving"),Ajax.call([{methodname:"local_trustgrade_save_grade",args:{cmid:cmid,userid:userid,grade:grade}}])[0].done(response=>{response.success?(updateGradeStatus($input,"saved"),pendingGrades.delete(userid),updatePendingGradesDisplay(),response.formatted_grade&&$input.val(response.formatted_grade)):(updateGradeStatus($input,"error"),Str.get_string("error_saving_grade_user","local_trustgrade",userid).then(errorText=>{Notification.addNotification({message:errorText+": "+(response.message||"Unknown error"),type:"error"})}).catch(()=>{Notification.addNotification({message:"Error saving grade for user "+userid+": "+(response.message||"Unknown error"),type:"error"})}))}).fail(ex=>{updateGradeStatus($input,"error"),Notification.exception(ex)})}function clearAllGrades(){var $button=$("#clear-all-grades");Str.get_string("clearing_grades","local_trustgrade").then(clearingText=>{$button.prop("disabled",!0).html('<i class="fa fa-spinner fa-spin"></i> '+clearingText)}).catch(()=>{$button.prop("disabled",!0).html('<i class="fa fa-spinner fa-spin"></i> Clearing...')}),Ajax.call([{methodname:"local_trustgrade_clear_all_grades",args:{cmid:cmid}}])[0].done(response=>{response.success?($(".grade-input").val("").each(function(){updateGradeStatus($(this),"")}),pendingGrades.clear(),updatePendingGradesDisplay(),Str.get_string("all_grades_cleared","local_trustgrade").then(message=>{Notification.addNotification({message:message,type:"success"})}).catch(()=>{Notification.addNotification({message:"All grades cleared successfully",type:"success"})})):Str.get_string("error_clearing_grades","local_trustgrade").then(errorText=>{Notification.addNotification({message:response.message||errorText,type:"error"})}).catch(()=>{Notification.addNotification({message:response.message||"Error clearing grades",type:"error"})})}).fail(Notification.exception).always(()=>{Str.get_string("clear_all_grades","local_trustgrade").then(buttonText=>{$button.prop("disabled",!1).html('<i class="fa fa-eraser"></i> '+buttonText)}).catch(()=>{$button.prop("disabled",!1).html('<i class="fa fa-eraser"></i> Clear All Grades')})})}function autoGradeByQuizScore(){var $button=$("#auto-grade-by-quiz");Str.get_string("auto_grading_progress","local_trustgrade").then(loadingText=>{$button.prop("disabled",!0).html('<i class="fa fa-spinner fa-spin"></i> '+loadingText)}).catch(()=>{$button.prop("disabled",!0).html('<i class="fa fa-spinner fa-spin"></i> Auto-grading...')}),Ajax.call([{methodname:"local_trustgrade_auto_grade_by_quiz",args:{cmid:cmid}}])[0].done(response=>{if(response.success){var gradesObj={};try{response.grades&&(gradesObj=JSON.parse(response.grades))}catch(e){Str.get_string("error_parsing_grades","local_trustgrade").then(errorText=>{console.error(errorText+":",e)}).catch(()=>{console.error("Error parsing grades JSON:",e)}),gradesObj={}}for(var userid in gradesObj)if(gradesObj.hasOwnProperty(userid)){var $input=$("#grade_"+userid),grade=gradesObj[userid];null!=grade&&($input.val(Number.parseFloat(grade).toFixed(2)),updateGradeStatus($input,"saved"),setTimeout(()=>{updateGradeStatus($input,"")},3e3))}pendingGrades.clear(),updatePendingGradesDisplay(),Str.get_string("auto_grade_success","local_trustgrade",response.graded_count).then(successText=>{Notification.addNotification({message:successText,type:"success"})}).catch(()=>{Notification.addNotification({message:response.graded_count+" students auto-graded based on quiz scores",type:"success"})})}else Str.get_string("auto_grade_error","local_trustgrade").then(errorText=>{Notification.addNotification({message:response.message||errorText.replace("{$a}","students"),type:"error"})}).catch(()=>{Notification.addNotification({message:response.message||"Error auto-grading students",type:"error"})})}).fail(Notification.exception).always(()=>{Str.get_string("auto_grade_button_text","local_trustgrade").then(buttonText=>{$button.prop("disabled",!1).html('<i class="fa fa-magic"></i> '+buttonText)}).catch(()=>{$button.prop("disabled",!1).html('<i class="fa fa-magic"></i> Auto-grade by Quiz Score')})})}function updateGradeStatus($input,status){var $icon=$input.siblings(".input-group-append").find(".grade-status-icon");switch($icon.removeClass("text-warning text-primary text-success text-danger"),$icon.html(""),status){case"pending":$icon.addClass("text-warning").html('<i class="fa fa-clock-o"></i>'),Str.get_string("grade_pending_save","local_trustgrade").then(title=>{$icon.attr("title",title)}).catch(()=>{$icon.attr("title","Grade pending save")});break;case"saving":$icon.addClass("text-primary").html('<i class="fa fa-spinner fa-spin"></i>'),Str.get_string("saving_grade","local_trustgrade").then(title=>{$icon.attr("title",title)}).catch(()=>{$icon.attr("title","Saving grade...")});break;case"saved":$icon.addClass("text-success").html('<i class="fa fa-check"></i>'),Str.get_string("grade_saved","local_trustgrade").then(title=>{$icon.attr("title",title)}).catch(()=>{$icon.attr("title","Grade saved")});break;case"error":$icon.addClass("text-danger").html('<i class="fa fa-exclamation-triangle"></i>'),Str.get_string("error_saving_grade","local_trustgrade").then(title=>{$icon.attr("title",title)}).catch(()=>{$icon.attr("title","Error saving grade")})}}function updatePendingGradesDisplay(){var count=pendingGrades.size,$counter=$("#pending-grades-count"),$bulkButton=$("#bulk-save-grades");count>0?(Str.get_string("unsaved_changes","local_trustgrade",count).then(text=>{$counter.text(text).show()}).catch(()=>{$counter.text(count+" unsaved change"+(1===count?"":"s")).show()}),$bulkButton.show()):($counter.hide(),$bulkButton.hide())}return{init:function(courseModuleId){cmid=courseModuleId||0,$(document).on("input",".grade-input",function(){var $input=$(this),userid=$input.data("userid"),grade=$input.val();pendingGrades.set(userid,grade),updateGradeStatus($input,"pending"),updatePendingGradesDisplay(),saveTimeout&&clearTimeout(saveTimeout),saveTimeout=setTimeout(()=>{saveGrade(userid,grade,$input)},2e3)}),$(document).on("blur",".grade-input",function(){var $input=$(this),userid=$input.data("userid"),grade=$input.val();pendingGrades.has(userid)&&(saveTimeout&&clearTimeout(saveTimeout),saveGrade(userid,grade,$input))}),$(document).on("keypress",".grade-input",function(e){if(13===e.which){var $input=$(this),userid=$input.data("userid"),grade=$input.val();saveTimeout&&clearTimeout(saveTimeout),saveGrade(userid,grade,$input)}}),$("#bulk-save-grades").on("click",()=>{!function(){if(0!==pendingGrades.size){var $button=$("#bulk-save-grades");Str.get_string("saving_grades","local_trustgrade").then(savingText=>{$button.prop("disabled",!0).html('<i class="fa fa-spinner fa-spin"></i> '+savingText)}).catch(()=>{$button.prop("disabled",!0).html('<i class="fa fa-spinner fa-spin"></i> Saving...')});var gradesObject={};pendingGrades.forEach((grade,userid)=>{gradesObject[userid]=grade}),Ajax.call([{methodname:"local_trustgrade_save_bulk_grades",args:{cmid:cmid,grades:JSON.stringify(gradesObject)}}])[0].done(response=>{response.success?(pendingGrades.forEach((grade,userid)=>{var $input=$("#grade_"+userid);updateGradeStatus($input,"saved"),setTimeout(()=>{updateGradeStatus($input,"")},3e3)}),pendingGrades.clear(),updatePendingGradesDisplay(),Str.get_string("grades_saved_success","local_trustgrade",response.saved_count).then(message=>{Notification.addNotification({message:message,type:"success"})}).catch(()=>{Notification.addNotification({message:response.saved_count+" grades saved successfully",type:"success"})})):Str.get_string("error_saving_grades","local_trustgrade").then(errorText=>{Notification.addNotification({message:response.message||errorText,type:"error"})}).catch(()=>{Notification.addNotification({message:response.message||"Error saving grades",type:"error"})})}).fail(Notification.exception).always(()=>{Str.get_string("save_all_pending","local_trustgrade").then(buttonText=>{$button.prop("disabled",!1).html('<i class="fa fa-save"></i> '+buttonText)}).catch(()=>{$button.prop("disabled",!1).html('<i class="fa fa-save"></i> Save All Pending')})})}else Str.get_string("no_pending_grades","local_trustgrade").then(message=>{Notification.addNotification({message:message,type:"info"})}).catch(()=>{Notification.addNotification({message:"No pending grades to save.",type:"info"})})}()}),$("#clear-all-grades").on("click",()=>{ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:Str.get_string("confirm_clear_all_grades","local_trustgrade"),body:Str.get_string("confirm_clear_all_grades_body","local_trustgrade")}).then(modal=>(modal.setSaveButtonText(Str.get_string("clear_all_grades","local_trustgrade")),modal.getRoot().on(ModalEvents.save,()=>{clearAllGrades()}),modal.show(),modal)).catch(()=>{confirm("Are you sure you want to clear all grades? This action cannot be undone.")&&clearAllGrades()})}),$("#auto-grade-by-quiz").on("click",()=>{ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:Str.get_string("auto_grade_by_quiz","local_trustgrade"),body:Str.get_string("auto_grade_confirmation","local_trustgrade")}).then(modal=>(modal.setSaveButtonText(Str.get_string("auto_grade_by_quiz","local_trustgrade")),modal.getRoot().on(ModalEvents.save,()=>{autoGradeByQuizScore()}),modal.show(),modal)).catch(()=>{confirm("This will automatically set grades based on quiz scores for all students. Existing grades will be overwritten. Continue?")&&autoGradeByQuizScore()})}),function(){var userids=[];if($(".grade-input").each(function(){userids.push($(this).data("userid"))}),0===userids.length)return;Ajax.call([{methodname:"local_trustgrade_get_current_grades",args:{cmid:cmid,userids:userids}}])[0].done(response=>{if(response.success&&response.grades){var gradesObj={};try{gradesObj=JSON.parse(response.grades)}catch(e){return void console.error("Error parsing grades JSON:",e)}for(var userid in gradesObj)if(gradesObj.hasOwnProperty(userid)){var $input=$("#grade_"+userid),grade=gradesObj[userid];null!=grade&&($input.val(Number.parseFloat(grade).toFixed(2)),updateGradeStatus($input,"saved"))}}}).fail(()=>{})}()}}});

//# sourceMappingURL=grading.min.js.map