/**
 * Main TrustGrade JavaScript module for AI-powered assignment analysis.
 *
 * @module     local_trustgrade/trustgrade
 * @package    local_trustgrade
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
var define=window.define,tinyMCE=(window.M,window.tinyMCE);define("local_trustgrade/trustgrade",["jquery","core/ajax","core/notification","core/str","core/modal_factory","core/templates"],($,Ajax,Notification,Str,ModalFactory,Templates)=>{var trustgrade={init:function(){this.bindEvents(),this.loadQuestionBank()},bindEvents:()=>{$(document).on("click","#check-instructions-btn",e=>{e.preventDefault(),trustgrade.checkInstructions()}),$(document).on("change","#id_trustgrade_questions_to_generate",e=>{e.preventDefault(),trustgrade.updateSingleQuizSetting("questions_to_generate",$(e.target).val())})},showErrorModal:(title,message)=>{ModalFactory.create({type:ModalFactory.types.ALERT,title:title,body:message}).then(modal=>modal.show())},showSuccessNotification:message=>{Notification.addNotification({message:message,type:"success"})},updateSingleQuizSetting:function(settingName,settingValue){var cmid=this.getCourseModuleId();cmid<=0||Ajax.call([{methodname:"local_trustgrade_update_quiz_setting",args:{cmid:cmid,setting_name:settingName,setting_value:settingValue}}])[0].done(response=>{response.success?Str.get_string("setting_updated_success","local_trustgrade",{setting:settingName.replace(/_/g," ")}).then(message=>{trustgrade.showSuccessNotification(message)}):Str.get_string("setting_update_error","local_trustgrade").then(title=>{trustgrade.showErrorModal(title,response.error||"An error occurred while updating the setting.")})}).fail(Notification.exception)},escapeHtml:value=>null==value?"":String(value).replace(/[&<>"']/g,s=>({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"}[s]||s)),renderRecommendation:recommendation=>new Promise(resolve=>{Promise.all([Str.get_string("criteria_evaluation","local_trustgrade"),Str.get_string("criterion","local_trustgrade"),Str.get_string("met","local_trustgrade"),Str.get_string("suggestions","local_trustgrade"),Str.get_string("evaluation","local_trustgrade"),Str.get_string("improved_assignment","local_trustgrade"),Str.get_string("no_criteria_provided","local_trustgrade"),Str.get_string("recommendation_error","local_trustgrade")]).then(strings=>{const[criteriaEvaluation,criterion,met,suggestions,evaluation,improvedAssignment,noCriteriaProvided,recommendationError]=strings,localizedStrings={criteria_evaluation:criteriaEvaluation,criterion:criterion,met:met,suggestions:suggestions,evaluation:evaluation,improved_assignment:improvedAssignment,no_criteria_provided:noCriteriaProvided,recommendation_error:recommendationError};try{if("string"==typeof recommendation){const content=recommendation.replace(/\n/g,"<br>");return void resolve(content)}if(!recommendation||"object"!=typeof recommendation)try{const txt=JSON.stringify(recommendation,null,2);return void resolve(trustgrade.escapeHtml(txt).replace(/\n/g,"<br>"))}catch(e){return void resolve("")}const table=recommendation.table||{},rows=Array.isArray(table.rows)?table.rows:[],tableTitle=table.title||criteriaEvaluation,processedRows=rows.map(row=>{const metValue=(row.Met||row["Met (y/n)"]||"").toLowerCase();return{Criterion:trustgrade.escapeHtml(row.Criterion||""),Met:trustgrade.escapeHtml(row.Met||row["Met (y/n)"]||""),Suggestions:row.Suggestions||"",isMetYes:"yes"===metValue||"y"===metValue||"true"===metValue,isMetNo:"no"===metValue||"n"===metValue||"false"===metValue,isMetPartial:"partial"===metValue||"partially"===metValue||"maybe"===metValue}});let html="";const tableContext={title:tableTitle,rows:processedRows,strings:localizedStrings};Templates.render("local_trustgrade/recommendation_table",tableContext).then(tableHtml=>{html+=tableHtml;const evalText=recommendation.EvaluationText&&recommendation.EvaluationText.content?String(recommendation.EvaluationText.content).replace(/\n/g,"<br>"):"";if(evalText){const evalContext={title:evaluation,content:evalText,icon:"fa fa-clipboard-check",sectionClass:"tg-eval-text"};return Templates.render("local_trustgrade/recommendation_section",evalContext)}return""}).then(evalHtml=>{html+=evalHtml;const improved=recommendation.ImprovedAssignment&&recommendation.ImprovedAssignment.content?String(recommendation.ImprovedAssignment.content).replace(/\n/g,"<br>"):"";if(improved){const improvedContext={title:improvedAssignment,content:improved,icon:"fa fa-lightbulb",sectionClass:"tg-improved"};return Templates.render("local_trustgrade/recommendation_section",improvedContext)}return""}).then(improvedHtml=>{html+=improvedHtml,resolve(html)}).catch(error=>{console.error("Template rendering error:",error),resolve(trustgrade.renderRecommendationLegacy(recommendation,localizedStrings))})}catch(error){console.error("Recommendation rendering error:",error),resolve(`<div class="alert alert-danger">${recommendationError}</div>`)}})}),renderRecommendationLegacy:(recommendation,strings)=>{const table=recommendation.table||{},rows=Array.isArray(table.rows)?table.rows:[],tableTitle=table.title||strings.criteria_evaluation,evalText=recommendation.EvaluationText&&recommendation.EvaluationText.content?String(recommendation.EvaluationText.content):"",improved=recommendation.ImprovedAssignment&&recommendation.ImprovedAssignment.content?String(recommendation.ImprovedAssignment.content):"";let html="";return html+='<div class="tg-section tg-table-section mb-4">',tableTitle&&(html+=`<h4 class="mb-3 text-primary fw-semibold">${trustgrade.escapeHtml(tableTitle)}</h4>`),html+=`\n        <div class="table-responsive shadow-sm rounded">\n          <table class="table table-hover table-striped mb-0 modern-criteria-table">\n            <thead class="table-dark">\n              <tr>\n                <th scope="col" class="fw-semibold">${trustgrade.escapeHtml(strings.criterion)}</th>\n                <th scope="col" class="fw-semibold text-center" style="width: 100px;">${trustgrade.escapeHtml(strings.met)}</th>\n                <th scope="col" class="fw-semibold">${trustgrade.escapeHtml(strings.suggestions)}</th>\n              </tr>\n            </thead>\n            <tbody>\n      `,rows.length>0?rows.forEach(r=>{const c=trustgrade.escapeHtml(r.Criterion??""),m=trustgrade.escapeHtml(r.Met??r["Met (y/n)"]??""),s=r.Suggestions??"",metValue=m.toLowerCase();let metBadge=`<span class="badge bg-primary rounded-pill">${m}</span>`;"yes"===metValue||"y"===metValue||"true"===metValue?metBadge=`<span class="badge bg-success rounded-pill"><i class="fa fa-check me-1"></i>${m}</span>`:"no"===metValue||"n"===metValue||"false"===metValue?metBadge=`<span class="badge bg-danger rounded-pill"><i class="fa fa-times me-1"></i>${m}</span>`:"partial"!==metValue&&"partially"!==metValue&&"maybe"!==metValue||(metBadge=`<span class="badge bg-warning rounded-pill"><i class="fa fa-minus me-1"></i>${m}</span>`),html+=`\n              <tr class="criteria-row">\n                <td class="criterion-cell"><div class="fw-medium text-dark">${c}</div></td>\n                <td class="met-cell text-center">${metBadge}</td>\n                <td class="suggestions-cell"><div class="text-muted small">${s}</div></td>\n              </tr>\n          `}):html+=`\n              <tr>\n                <td colspan="3" class="text-center text-muted py-4">\n                  <i class="fa fa-info-circle me-2"></i>${trustgrade.escapeHtml(strings.no_criteria_provided)}\n                </td>\n              </tr>\n        `,html+="\n            </tbody>\n          </table>\n        </div>\n      </div>\n      ",evalText&&(html+=`<div class="tg-section tg-eval-text mb-4">\n          <div class="card border-0 shadow-sm">\n            <div class="card-header bg-light border-0 py-3">\n              <h4 class="card-title mb-0 d-flex align-items-center">\n                <i class="fa fa-clipboard-check me-2 text-primary"></i>\n                ${trustgrade.escapeHtml(strings.evaluation)}\n              </h4>\n            </div>\n            <div class="card-body">\n              <div class="recommendation-content">${evalText.replace(/\n/g,"<br>")}</div>\n            </div>\n          </div>\n        </div>`),improved&&(html+=`<div class="tg-section tg-improved mb-4">\n          <div class="card border-0 shadow-sm">\n            <div class="card-header bg-light border-0 py-3">\n              <h4 class="card-title mb-0 d-flex align-items-center">\n                <i class="fa fa-lightbulb me-2 text-primary"></i>\n                ${trustgrade.escapeHtml(strings.improved_assignment)}\n              </h4>\n            </div>\n            <div class="card-body">\n              <div class="recommendation-content">${improved.replace(/\n/g,"<br>")}</div>\n            </div>\n          </div>\n        </div>`),html},checkInstructions:function(){var instructions=this.getInstructions();$("#check-instructions-btn").prop("disabled",!0),$("#ai-loading").show(),$("#ai-recommendation-container").hide();var cmid=this.getCourseModuleId();Ajax.call([{methodname:"local_trustgrade_check_instructions",args:{cmid:cmid,instructions:instructions||"",intro_itemid:trustgrade.getIntroEditorItemId(),intro_attachments_itemid:trustgrade.getIntroAttachmentsItemId()}}])[0].done(response=>{if(response.success)try{var recObj="string"==typeof response.recommendation?JSON.parse(response.recommendation):response.recommendation;trustgrade.renderRecommendation(recObj).then(recommendationHtml=>{response.from_cache?Str.get_string("cache_hit","local_trustgrade").then(cacheMessage=>{recommendationHtml='<div class="alert alert-info mb-2"><i class="fa fa-clock-o"></i> <small>'+cacheMessage+" (Debug mode)</small></div>"+recommendationHtml,$("#ai-recommendation").html(recommendationHtml)}):$("#ai-recommendation").html(recommendationHtml),$("#ai-recommendation-container").show()})}catch(e){const recommendationHtml=String(response.recommendation||"").replace(/\n/g,"<br>");$("#ai-recommendation").html(recommendationHtml),$("#ai-recommendation-container").show()}else Str.get_string("gateway_error","local_trustgrade").then(title=>{trustgrade.showErrorModal(title,response.error||"An error occurred.")})}).fail(Notification.exception).always(()=>{$("#check-instructions-btn").prop("disabled",!1),$("#ai-loading").hide()})},generateQuestions:function(){var instructions=this.getInstructions();$("#generate-questions-btn").prop("disabled",!0),$("#ai-question-loading").show();var cmid=this.getCourseModuleId();Ajax.call([{methodname:"local_trustgrade_generate_questions",args:{cmid:cmid,instructions:instructions||"",intro_itemid:trustgrade.getIntroEditorItemId(),intro_attachments_itemid:trustgrade.getIntroAttachmentsItemId()}}])[0].done(response=>{response.success?(response.message&&trustgrade.showSuccessNotification(response.message),trustgrade.loadQuestionBank()):Str.get_string("gateway_error","local_trustgrade").then(title=>{trustgrade.showErrorModal(title,response.error||"An error occurred.")})}).fail(Notification.exception).always(()=>{$("#generate-questions-btn").prop("disabled",!1),$("#ai-question-loading").hide()})},formatQuestionsDisplay:questions=>new Promise(resolve=>{Promise.all([Str.get_string("generated_questions","local_trustgrade"),Str.get_string("question","local_trustgrade"),Str.get_string("points","local_trustgrade"),Str.get_string("correct","local_trustgrade"),Str.get_string("explanation","local_trustgrade"),Str.get_string("blooms_level_label","local_trustgrade"),Str.get_string("options_label","local_trustgrade")]).then(strings=>{const[sGeneratedQuestions,sQuestion,sPoints,sCorrect,sExplanation,sBloomsLevel,sOptions]=strings;let html="<h4>"+sGeneratedQuestions+":</h4>";if(!Array.isArray(questions)||0===questions.length)return html+=`<div style="color:#666;">${trustgrade.escapeHtml("No questions generated.")}</div>`,void resolve(html);questions.forEach((q,index)=>{const qType=q&&q.type?String(q.type):"",qText=q&&q.text?String(q.text):"",points=q&&q.metadata&&("number"==typeof q.metadata.points||"string"==typeof q.metadata.points)?String(q.metadata.points):"",blooms=q&&q.metadata&&q.metadata.blooms_level?String(q.metadata.blooms_level):"";html+='<div class="question-item" style="margin-bottom: 20px; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">';let header=`${sQuestion} ${index+1}`;""!==points&&(header+=` (${trustgrade.escapeHtml(points)} ${sPoints})`),html+=`<h5>${trustgrade.escapeHtml(header)}</h5>`,qType&&(html+=`<p><strong>Type:</strong> ${trustgrade.escapeHtml(qType)}</p>`),html+=`<p><strong>${trustgrade.escapeHtml(sQuestion)}:</strong> ${trustgrade.escapeHtml(qText)}</p>`,blooms&&(html+=`<p><strong>${trustgrade.escapeHtml(sBloomsLevel)}:</strong> ${trustgrade.escapeHtml(blooms)}</p>`),Array.isArray(q.options)&&q.options.length>0&&(html+=`<div><strong>${trustgrade.escapeHtml(sOptions)}</strong></div><ul style="margin:6px 0 0 20px;">`,q.options.forEach((opt,optIndex)=>{const label=String.fromCharCode(65+optIndex)+".",optText=opt&&opt.text?String(opt.text):"",isCorrect=!(!opt||!opt.is_correct),explanation=opt&&opt.explanation?String(opt.explanation):"",correctBadge=isCorrect?` <span class="badge badge-success" style="display:inline-block; padding:2px 6px; background:#16a34a; color:#fff; border-radius:4px; font-size:12px;">${trustgrade.escapeHtml(sCorrect)}</span>`:"";html+='<li style="margin:6px 0;">',html+=`<div>${trustgrade.escapeHtml(label)} ${trustgrade.escapeHtml(optText)}${correctBadge}</div>`,explanation&&(html+=`<div style="margin-left:20px; color:#555;"><em>${trustgrade.escapeHtml(sExplanation)}:</em> ${trustgrade.escapeHtml(explanation)}</div>`),html+="</li>"}),html+="</ul>"),html+="</div>"}),resolve(html)})}),getInstructions:()=>{for(var instructions="",instructionSelectors=["#id_introeditor_ifr","#id_intro",'textarea[name="intro"]'],i=0;i<instructionSelectors.length;i++){var $element=$(instructionSelectors[i]);if($element.length>0){if($element.is("iframe"))try{var iframeDoc=$element[0].contentDocument||$element[0].contentWindow.document;instructions=$("<div>").html(iframeDoc.body.innerHTML).text()}catch(e){void 0!==tinyMCE&&tinyMCE.get("id_introeditor")&&(instructions=tinyMCE.get("id_introeditor").getContent({format:"text"}))}else instructions=$element.val()||"";if(instructions&&instructions.trim().length>0)break}}return"string"==typeof instructions?instructions.trim():""},getCourseModuleId:()=>{var cmid=new URLSearchParams(window.location.search).get("update");return cmid||(cmid=$('input[name="coursemodule"]').val()||0),Number.parseInt(cmid)||0},getIntroEditorItemId:()=>{var $input=$('input[name="introeditor[itemid]"]'),val=$input.length?$input.val():"",n=Number.parseInt(val||"0",10);return isNaN(n)?0:n},getIntroAttachmentsItemId:()=>{for(var candidates=['input[name="introattachments"]','input[name="introattachments_filemanager"]','input[name="introattachments[itemid]"]'],i=0;i<candidates.length;i++){var $el=$(candidates[i]);if($el.length){var v=Number.parseInt($el.val()||"0",10);if(!isNaN(v)&&v>0)return v}}return 0},loadQuestionBank:function(){var cmid=this.getCourseModuleId();cmid<=0||($("#question-bank-loading").show(),Ajax.call([{methodname:"local_trustgrade_get_question_bank",args:{cmid:cmid}}])[0].done(response=>{if(response.success){var questions=JSON.parse(response.questions);questions&&questions.length>0?Str.get_string("question_bank_title","local_trustgrade").then(title=>{var questionBankHtml="<h4>"+title+"</h4>"+response.html;$("#question-bank-container").html(questionBankHtml),"undefined"!=typeof require&&require(["local_trustgrade/question_editor"],QuestionEditor=>{QuestionEditor.reinitialize(cmid)})}):$("#question-bank-container").html("")}else Notification.addNotification({message:response.error||"Failed to load question bank",type:"warning"})}).fail(Notification.exception).always(()=>{$("#question-bank-loading").hide()}))}};return trustgrade});

//# sourceMappingURL=trustgrade.min.js.map