/**
 * Question bank interface module for managing quiz questions.
 *
 * @module     local_trustgrade/question_bank
 * @package    local_trustgrade
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_trustgrade/question_bank",["jquery","core/str","core/ajax","core/notification"],($,Str,Ajax,Notification)=>{var QuestionBank={strings:{},init:function(cmid){this.cmid=cmid||0,this.loadStrings().then(()=>{this.bindEvents()})},loadStrings:function(){return Str.get_strings([{key:"mandatory_question",component:"local_trustgrade"},{key:"make_mandatory",component:"local_trustgrade"},{key:"remove_mandatory",component:"local_trustgrade"},{key:"question_marked_mandatory",component:"local_trustgrade"},{key:"question_unmarked_mandatory",component:"local_trustgrade"},{key:"error_updating_question",component:"local_trustgrade"}]).then(strings=>(this.strings.mandatory_question=strings[0],this.strings.make_mandatory=strings[1],this.strings.remove_mandatory=strings[2],this.strings.question_marked_mandatory=strings[3],this.strings.question_unmarked_mandatory=strings[4],this.strings.error_updating_question=strings[5],strings))},bindEvents:function(){$("#generate-new-questions").on("click",()=>{this.generateQuestions()}),$(document).on("click",".toggle-mandatory-btn",e=>{e.preventDefault();const $btn=$(e.currentTarget),$questionItem=$btn.closest(".editable-question-item"),questionId=Number.parseInt($btn.data("question-id")),newMandatory=!(1===Number.parseInt($btn.data("mandatory")));QuestionBank.toggleMandatoryQuestion(questionId,newMandatory,$questionItem)})},generateQuestions:function(){var questionsCount=$("#questions-count").val();$("#generate-new-questions").prop("disabled",!0),$("#generation-loading").show(),Ajax.call([{methodname:"local_trustgrade_generate_questions",args:{cmid:this.cmid,count:Number.parseInt(questionsCount)}}])[0].then(response=>{$("#generation-loading").hide(),$("#generate-new-questions").prop("disabled",!1),response.success?(Notification.addNotification({message:questionsCount+" "+M.util.get_string("questions_generated_successfully","local_trustgrade"),type:"success"}),window.location.reload()):Notification.addNotification({message:response.error||M.util.get_string("error_generating_questions","local_trustgrade"),type:"error"})}).catch(error=>{$("#generation-loading").hide(),$("#generate-new-questions").prop("disabled",!1),Notification.addNotification({message:M.util.get_string("error_generating_questions","local_trustgrade"),type:"error"})})},toggleMandatoryQuestion:function(questionId,isMandatory,$questionItem){const $btn=$questionItem.find(".toggle-mandatory-btn");$btn.prop("disabled",!0),Ajax.call([{methodname:"local_trustgrade_toggle_mandatory_question",args:{questionid:questionId,is_mandatory:isMandatory}}])[0].then(response=>{if(response.success){const $mandatoryControls=$questionItem.find(".mandatory-controls");response.is_mandatory?$mandatoryControls.html('<span class="badge bg-danger mandatory-badge">'+this.strings.mandatory_question+'</span><button type="button" class="btn btn-sm btn-outline-secondary toggle-mandatory-btn" data-mandatory="1" data-question-id="'+questionId+'" title="'+this.strings.remove_mandatory+'"><i class="fa fa-times-circle" aria-hidden="true"></i> '+this.strings.remove_mandatory+"</button>"):$mandatoryControls.html('<button type="button" class="btn btn-sm btn-outline-primary toggle-mandatory-btn" data-mandatory="0" data-question-id="'+questionId+'" title="'+this.strings.make_mandatory+'"><i class="fa fa-star" aria-hidden="true"></i> '+this.strings.make_mandatory+"</button>"),$questionItem.find(".question-mandatory-input").prop("checked",response.is_mandatory),Notification.addNotification({message:response.is_mandatory?this.strings.question_marked_mandatory:this.strings.question_unmarked_mandatory,type:"success"})}else Notification.addNotification({message:response.error||this.strings.error_updating_question,type:"error"});$btn.prop("disabled",!1)}).catch(error=>{Notification.addNotification({message:this.strings.error_updating_question,type:"error"}),$btn.prop("disabled",!1)})}};return QuestionBank});

//# sourceMappingURL=question_bank.min.js.map
