/**
 * Submission processing module for handling submission UI overlays.
 *
 * @module     local_trustgrade/submission_processing
 * @package    local_trustgrade
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_trustgrade/submission_processing",["jquery","core/templates","core/str"],($,Templates,Str)=>({cmid:0,submissionId:0,processingOverlay:null,statusCheckInterval:null,questionsToGenerate:0,init:function(cmid){let questionsToGenerate=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;this.cmid=cmid,this.questionsToGenerate=questionsToGenerate,this.bindSubmissionEvents(),this.bindAssignmentFormEvents()},bindSubmissionEvents:function(){$(document).ready(()=>{var $forms=$('form[action*="editsubmission"], form[action*="editmode"], form.mform, #region-main form');$forms.length>0&&$forms.on("submit",e=>{this.questionsToGenerate>0&&this.showProcessingMessage("submission")})})},bindAssignmentFormEvents:function(){$(document).ready(()=>{var $assignmentForms=$('form[action*="modedit.php"], form.mform[action*="course/modedit.php"]');$assignmentForms.length>0&&$assignmentForms.on("submit",e=>{var $autoGenerateCheckbox=$("#id_trustgrade_auto_generate"),$trustgradeEnabled=$("#id_trustgrade_enabled");$autoGenerateCheckbox.length>0&&$autoGenerateCheckbox.is(":checked")&&$trustgradeEnabled.length>0&&$trustgradeEnabled.is(":checked")&&this.showProcessingMessage("questions")})})},showProcessingMessage:function(){let type=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"submission";var stringRequests=[];stringRequests="questions"===type?[{key:"processing_question_generation",component:"local_trustgrade"},{key:"processing_question_generation_message",component:"local_trustgrade"}]:[{key:"processing_submission",component:"local_trustgrade"},{key:"processing_submission_message",component:"local_trustgrade"}],Str.get_strings(stringRequests).then(strings=>{var context={title:strings[0],message:strings[1],spinner_class:"fa fa-spinner fa-spin"};return Templates.render("local_trustgrade/submission_processing_overlay",context)}).then(html=>{$("#submission-processing-overlay").remove(),$("body").append(html),$("body").css("overflow","hidden")}).catch(error=>{console.error("Error rendering processing overlay:",error),this.showFallbackProcessingMessage(type)})},showFallbackProcessingMessage:function(){var overlayHtml="";overlayHtml="questions"===(arguments.length>0&&void 0!==arguments[0]?arguments[0]:"submission")?'<div id="submission-processing-overlay" class="local-trustgrade submission-processing-overlay"><div class="processing-modal"><div class="spinner-container"><i class="fa fa-spinner fa-spin" aria-hidden="true"></i></div><h3 class="processing-title">Processing Assignment...</h3><p class="processing-message">Please wait while we save your assignment and prepare to generate questions...</p></div></div>':'<div id="submission-processing-overlay" class="local-trustgrade submission-processing-overlay"><div class="processing-modal"><div class="spinner-container"><i class="fa fa-spinner fa-spin" aria-hidden="true"></i></div><h3 class="processing-title">Processing...</h3><p class="processing-message">Please wait while we process your submission...</p></div></div>',$("#submission-processing-overlay").remove(),$("body").append(overlayHtml),$("body").css("overflow","hidden")},hideProcessingMessage:()=>{$("#submission-processing-overlay").remove(),$("body").css("overflow","")}}));

//# sourceMappingURL=submission_processing.min.js.map
