/**
 * Quiz interface module for student quiz attempts.
 *
 * @module     local_trustgrade/quiz
 * @package    local_trustgrade
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_trustgrade/quiz",["jquery","core/ajax","core/notification","core/str","core/templates"],($,Ajax,Notification,Str,Templates)=>({session:null,questions:[],settings:{},cmid:0,submissionid:0,currentQuestion:0,answers:{},timer:null,timeRemaining:0,attemptStarted:!1,attemptCompleted:!1,windowBlurCount:0,maxWindowBlurs:3,autoSaveInterval:null,init:function(session){session&&session.questions&&0!==session.questions.length&&(this.session=session,this.questions=session.questions,this.settings=session.settings,this.cmid=session.cmid,this.submissionid=session.submissionid,this.currentQuestion=session.current_question,this.answers=session.answers,this.attemptStarted=session.attempt_started,this.attemptCompleted=session.attempt_completed,this.windowBlurCount=session.window_blur_count,this.timeRemaining=session.time_remaining,this.attemptCompleted?this.showResults():this.attemptStarted?this.resumeQuiz():this.showIntegrityWarning())},resumeQuiz:function(){this.bindEvents(),this.bindIntegrityEvents(),this.startAutoSave(),this.showQuestion(this.currentQuestion),this.updateCounter()},showIntegrityWarning:function(){Promise.all([Str.get_string("important_formal_assessment","local_trustgrade"),Str.get_string("read_carefully","local_trustgrade"),Str.get_string("one_attempt_only","local_trustgrade"),Str.get_string("no_going_back","local_trustgrade"),Str.get_string("no_restarts","local_trustgrade"),Str.get_string("time_limits","local_trustgrade"),Str.get_string("no_cheating","local_trustgrade"),Str.get_string("final_grade","local_trustgrade"),Str.get_string("stay_focused","local_trustgrade"),Str.get_string("cannot_restart_notice","local_trustgrade"),Str.get_string("understand_start_quiz","local_trustgrade")]).then(strings=>{var templateContext={title:strings[0],subtitle:strings[1],rules:[strings[2],strings[3],strings[4],strings[5],strings[6],strings[7],strings[8]],notice:strings[9],button_text:strings[10]};Templates.render("local_trustgrade/quiz_integrity_warning",templateContext).then(html=>{$(".quiz-content").html(html),$(".question-counter").hide(),$(".quiz-navigation").hide(),this.bindStartEvent()}).catch(Notification.exception)})},bindStartEvent:function(){$(document).off("click.quizstart").on("click.quizstart","#start-quiz-btn",()=>{this.startQuizAttempt()})},startQuizAttempt:function(){Ajax.call([{methodname:"local_trustgrade_start_quiz_attempt",args:{cmid:this.cmid,submissionid:this.submissionid}}])[0].done(response=>{response.success?(this.attemptStarted=!0,Str.get_string("quiz_started_notice","local_trustgrade").then(message=>{Notification.addNotification({message:message,type:"info"})}),this.resumeQuiz()):Str.get_string("failed_start_session","local_trustgrade").then(message=>{Notification.addNotification({message:response.error||message,type:"error"})})}).fail(Notification.exception)},startAutoSave:function(){this.autoSaveInterval=setInterval(()=>{this.saveSessionState()},2e3)},saveSessionState:function(){if(this.attemptStarted&&!this.attemptCompleted){var updates={current_question:this.currentQuestion,answers:this.answers,time_remaining:this.timeRemaining,window_blur_count:this.windowBlurCount};Ajax.call([{methodname:"local_trustgrade_update_quiz_session",args:{cmid:this.cmid,submissionid:this.submissionid,updates:JSON.stringify(updates)}}])}},bindEvents:function(){$(document).off("click.quiz"),$(document).on("click.quiz","#next-btn",()=>{this.validateCurrentAnswer()&&(this.saveCurrentAnswer(),this.advanceToNextQuestion())}),$(document).on("click.quiz","#finish-btn",()=>{this.validateCurrentAnswer()&&(this.saveCurrentAnswer(),this.finishQuiz())}),$(document).on("change.quiz",'input[name="answer"]',()=>{this.updateNavigationButtons(),this.saveSessionState()}),$(document).on("input.quiz",'textarea[name="answer"]',()=>{this.updateNavigationButtons(),this.saveSessionState()})},bindIntegrityEvents:function(){$(window).on("blur.quiz",()=>{this.attemptStarted&&!this.attemptCompleted&&(this.windowBlurCount++,this.logIntegrityViolation("window_blur",{count:this.windowBlurCount}),this.windowBlurCount>=this.maxWindowBlurs?this.showIntegrityViolation():Str.get_string("window_switching_warning","local_trustgrade",{count:this.windowBlurCount,max:this.maxWindowBlurs}).then(message=>{Notification.addNotification({message:message,type:"warning"})}))}),$(document).on("contextmenu.quiz",()=>{if(this.attemptStarted&&!this.attemptCompleted)return this.logIntegrityViolation("right_click_attempt"),!1}),$(document).on("keydown.quiz",e=>{if(this.attemptStarted&&!this.attemptCompleted&&(123===e.keyCode||e.ctrlKey&&e.shiftKey&&(73===e.keyCode||74===e.keyCode)||e.ctrlKey&&85===e.keyCode))return e.preventDefault(),this.logIntegrityViolation("dev_tools_attempt"),Str.get_string("dev_tools_blocked","local_trustgrade").then(message=>{Notification.addNotification({message:message,type:"error"})}),!1}),$(window).on("beforeunload.quiz",()=>{if(this.attemptStarted&&!this.attemptCompleted)return Str.get_string("quiz_progress_saved","local_trustgrade").then(message=>message)})},logIntegrityViolation:function(violationType){let violationData=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};Ajax.call([{methodname:"local_trustgrade_log_integrity_violation",args:{cmid:this.cmid,submissionid:this.submissionid,violation_type:violationType,violation_data:JSON.stringify(violationData)}}])},getQuestionText:q=>q&&(q.text||q.question)||"",getOptionText:option=>null==option?"":"string"==typeof option?option:"object"==typeof option?option.text??option.label??String(option):String(option),getOptionExplanation:(question,index)=>{if(!question)return"";const options=question.options||[],i="number"==typeof index?index:Number.parseInt(index,10);if(Number.isNaN(i)||null==i)return"";if(Array.isArray(options)&&options[i]&&"object"==typeof options[i]&&"explanation"in options[i])return options[i].explanation||"";if(Array.isArray(question.explanations))return question.explanations[i]||"";if(question.explanations&&"object"==typeof question.explanations){const key=1===i?"true":0===i?"false":String(i);return question.explanations[key]||question.explanations[String(i)]||""}return question.option_explanations&&Array.isArray(question.option_explanations)&&question.option_explanations[i]||""},getCorrectAnswerIndex:question=>{if(!question)return null;if(Number.isInteger(question.correct_answer))return question.correct_answer;const options=question.options||[];for(let i=0;i<options.length;i++){const opt=options[i];if(opt&&"object"==typeof opt&&(!0===opt.correct||!0===opt.is_correct||!0===opt.isCorrect))return i}return null},isAnswerCorrect:function(question,userAnswer){if(!question)return!1;if("true_false"===question.type){if("boolean"!=typeof question.correct_answer)return!1;let userBool=null;return!0===userAnswer||"true"===userAnswer||1===userAnswer||"1"===userAnswer?userBool=!0:!1!==userAnswer&&"false"!==userAnswer&&0!==userAnswer&&"0"!==userAnswer||(userBool=!1),null!==userBool&&userBool===question.correct_answer}const correctIndex=this.getCorrectAnswerIndex(question);if(null==correctIndex)return!1;return("number"==typeof userAnswer?userAnswer:Number.parseInt(userAnswer,10))===correctIndex},advanceToNextQuestion:function(){this.currentQuestion<this.questions.length-1&&(this.currentQuestion++,this.showQuestion(this.currentQuestion),this.updateCounter(),this.saveSessionState())},showQuestion:function(index){var question=this.questions[index];Promise.all([Str.get_string("quiz_progress_complete","local_trustgrade",Math.round((index+1)/this.questions.length*100)),Str.get_string("question_x_of_y","local_trustgrade",{current:index+1,total:this.questions.length}),Str.get_string("instructor_question","local_trustgrade"),Str.get_string("based_on_submission","local_trustgrade"),Str.get_string("progress_auto_saved","local_trustgrade"),Str.get_string("true","local_trustgrade"),Str.get_string("false","local_trustgrade"),Str.get_string("enter_answer_placeholder","local_trustgrade")]).then(strings=>{var html=`<div class="quiz-progress mb-3">\n          <div class="progress">\n            <div class="progress-bar bg-primary" style="width: ${Math.round((index+1)/this.questions.length*100)}%"></div>\n          </div>\n          <small class="text-muted">${strings[1]} (${strings[0]})</small>\n        </div>\n        <div class="question-container">\n          <div class="question-header d-flex justify-content-between align-items-center">\n                        <span class="question-number me-3"><strong>${strings[1]}</strong></span>\n            <div class="d-flex align-items-center">\n          \n              <span class="question-source badge ${"instructor"===question.source?"badge-primary":"badge-success"}">\n                ${"instructor"===question.source?strings[2]:strings[3]}\n              </span>\n            </div>\n            <div class="question-timer-container"></div>\n          </div>\n          <div class="alert alert-info">\n            <i class="fa fa-info-circle"></i> \n            <small>${strings[4]}</small>\n          </div>\n          <h3 class="question-text">${this.getQuestionText(question)}</h3>`;if("multiple_choice"===question.type&&question.options)html+='<div class="question-options">',question.options.forEach((option,optIndex)=>{var checked=this.answers[index]===optIndex?"checked":"",label=this.getOptionText(option);html+=`<div class="form-check">\n              <input class="form-check-input" type="radio" name="answer" value="${optIndex}" id="option_${optIndex}" ${checked}>\n              <label class="form-check-label" for="option_${optIndex}">${label}</label>\n            </div>`}),html+="</div>";else if("true_false"===question.type){var trueChecked=!0===this.answers[index]?"checked":"",falseChecked=!1===this.answers[index]?"checked":"";html+=`<div class="question-options">\n            <div class="form-check">\n              <input class="form-check-input" type="radio" name="answer" value="true" id="true_option" ${trueChecked}>\n              <label class="form-check-label" for="true_option">${strings[5]}</label>\n            </div>\n            <div class="form-check">\n              <input class="form-check-input" type="radio" name="answer" value="false" id="false_option" ${falseChecked}>\n              <label class="form-check-label" for="false_option">${strings[6]}</label>\n            </div>\n          </div>`}else if("short_answer"===question.type){var savedAnswer=this.answers[index]||"";html+=`<div class="question-options">\n            <textarea class="form-control" name="answer" rows="4" placeholder="${strings[7]}">${savedAnswer}</textarea>\n          </div>`}html+="</div>",$(".quiz-content").html(html),$(".question-counter").show(),$(".quiz-navigation").show(),this.updateNavigationButtons(),this.settings.show_countdown&&this.startTimer()})},startTimer:function(){this.settings.show_countdown&&(this.timer&&clearInterval(this.timer),(this.timeRemaining<=0||this.timeRemaining>this.settings.time_per_question)&&(this.timeRemaining=this.settings.time_per_question),this.updateTimerDisplay(),$(".question-timer-container").show(),this.timer=setInterval(()=>{this.timeRemaining--,this.updateTimerDisplay(),this.timeRemaining<=0&&(this.stopTimer(),this.autoAdvance())},1e3))},stopTimer:function(){this.timer&&(clearInterval(this.timer),this.timer=null),$(".question-timer-container").hide()},updateTimerDisplay:function(){var minutes=Math.floor(this.timeRemaining/60),seconds=this.timeRemaining%60,timeString=minutes+":"+(seconds<10?"0":"")+seconds;Str.get_string("time_remaining","local_trustgrade",timeString).then(message=>{var timerHtml=`<div class="timer-display ${this.timeRemaining<=5?"timer-warning":""}">\n                          <i class="fa fa-clock-o"></i> ${message}\n                        </div>`;$(".question-timer-container").html(timerHtml)})},autoAdvance:function(){this.saveCurrentAnswer(),this.currentQuestion<this.questions.length-1?this.advanceToNextQuestion():this.finishQuiz()},updateCounter:function(){var total=this.questions.length,current=this.currentQuestion+1;Str.get_string("question_x_of_y","local_trustgrade",{current:current,total:total}).then(message=>{$(".question-counter").html(message)})},updateNavigationButtons:function(){$("#prev-btn").hide(),Promise.all([Str.get_string("next_question","local_trustgrade"),Str.get_string("submit_final_answers","local_trustgrade")]).then(strings=>{this.currentQuestion<this.questions.length-1?($("#next-btn").show().text(strings[0]),$("#finish-btn").hide()):($("#next-btn").hide(),$("#finish-btn").show().text(strings[1]))})},validateCurrentAnswer:function(){var question=this.questions[this.currentQuestion],hasAnswer=!1;return"multiple_choice"===question.type||"true_false"===question.type?hasAnswer=$('input[name="answer"]:checked').length>0:"short_answer"===question.type&&(hasAnswer=$('textarea[name="answer"]').val().trim().length>0),!!hasAnswer||(Str.get_string("provide_answer_warning","local_trustgrade").then(message=>{Notification.addNotification({message:message,type:"warning"})}),!1)},saveCurrentAnswer:function(){var question=this.questions[this.currentQuestion],answer=null;"multiple_choice"===question.type?void 0!==(answer=$('input[name="answer"]:checked').val())&&(this.answers[this.currentQuestion]=Number.parseInt(answer)):"true_false"===question.type?void 0!==(answer=$('input[name="answer"]:checked').val())&&(this.answers[this.currentQuestion]="true"===answer):"short_answer"===question.type&&(answer=$('textarea[name="answer"]').val().trim(),this.answers[this.currentQuestion]=answer),this.timeRemaining=this.settings.time_per_question},finishQuiz:function(){if(!this.attemptCompleted){this.attemptCompleted=!0,this.stopTimer(),this.autoSaveInterval&&clearInterval(this.autoSaveInterval),$(window).off(".quiz"),$(document).off(".quiz");var score=this.calculateScore();Ajax.call([{methodname:"local_trustgrade_complete_quiz_session",args:{cmid:this.cmid,submissionid:this.submissionid,final_answers:JSON.stringify(this.answers),final_score:score}}])[0].done(response=>{response.success||Str.get_string("failed_save_results","local_trustgrade",response.error||"Unknown error").then(message=>{Notification.addNotification({message:message,type:"error"})}),this.showResults()}).fail(()=>{Str.get_string("failed_save_contact_instructor","local_trustgrade").then(message=>{Notification.addNotification({message:message,type:"error"})}),this.showResults()})}},calculateScore:function(){var score=0;return this.questions.forEach((question,index)=>{var userAnswer=this.answers[index],isCorrect=this.isAnswerCorrect(question,userAnswer),points=question.points||10;isCorrect&&(score+=points)}),score},showResults:function(){var score=0,totalPoints=0;Promise.all([Str.get_string("quiz_completed_header","local_trustgrade"),Str.get_string("quiz_completed_message","local_trustgrade"),Str.get_string("correct","local_trustgrade"),Str.get_string("incorrect","local_trustgrade"),Str.get_string("your_answer","local_trustgrade"),Str.get_string("correct_answer_was","local_trustgrade"),Str.get_string("no_answer","local_trustgrade"),Str.get_string("explanation","local_trustgrade"),Str.get_string("final_grade_notice","local_trustgrade"),Str.get_string("true","local_trustgrade"),Str.get_string("false","local_trustgrade"),Str.get_string("question","local_trustgrade")]).then(strings=>{var resultsHtml=`<div class="quiz-completion-header alert alert-success">\n          <h2><i class="fa fa-check-circle"></i> ${strings[0]}</h2>\n          <p>${strings[1]}</p>\n        </div>\n        <div class="results-summary">`;this.questions.forEach((question,index)=>{var userAnswer=this.answers[index],isCorrect=this.isAnswerCorrect(question,userAnswer),points=question.points||10;if(totalPoints+=points,isCorrect&&(score+=points),resultsHtml+=`<div class="result-item ${isCorrect?"correct":"incorrect"}">\n            <div class="result-header">\n              <span class="question-number">${strings[11]} ${index+1}</span>\n              <span class="result-status ${isCorrect?"text-success":"text-danger"}">\n                ${isCorrect?`✓ ${strings[2]}`:`✗ ${strings[3]}`}\n              </span>\n            </div>\n            <p class="question-text">${this.getQuestionText(question)}</p>`,"multiple_choice"===question.type){var mcAnswerText=strings[6];null!=userAnswer&&question.options&&void 0!==question.options[Number(userAnswer)]&&(mcAnswerText=this.getOptionText(question.options[Number(userAnswer)])),resultsHtml+=`<p><strong>${strings[4].replace("{$a}",mcAnswerText)}</strong></p>`;var explanationText=this.getOptionExplanation(question,Number(userAnswer));explanationText&&(resultsHtml+=`<div class="explanation"><strong>${strings[7]}:</strong> ${explanationText}</div>`)}else if("true_false"===question.type){var tfAnswerText=void 0!==userAnswer?userAnswer?strings[9]:strings[10]:strings[6];resultsHtml+=`<p><strong>${strings[4].replace("{$a}",tfAnswerText)}</strong></p>`;var tfExplanation="";if(question.explanations&&"object"==typeof question.explanations)!0===userAnswer||"true"===userAnswer||1===userAnswer||"1"===userAnswer?tfExplanation=question.explanations.true||question.explanations[1]||question.explanations[1]||"":!1!==userAnswer&&"false"!==userAnswer&&0!==userAnswer&&"0"!==userAnswer||(tfExplanation=question.explanations.false||question.explanations[0]||question.explanations[0]||"");else if(Array.isArray(question.options)&&2===question.options.length){var idx=!0===userAnswer||"true"===userAnswer||1===userAnswer||"1"===userAnswer?1:0;question.options[idx]&&"object"==typeof question.options[idx]&&"explanation"in question.options[idx]&&(tfExplanation=question.options[idx].explanation||"")}tfExplanation&&(resultsHtml+=`<div class="explanation"><strong>${strings[7]}:</strong> ${tfExplanation}</div>`)}else"short_answer"===question.type&&(resultsHtml+=`<p><strong>${strings[4].replace("{$a}",userAnswer||strings[6])}</strong></p>`);resultsHtml+="</div>"});var percentage=totalPoints>0?Math.round(score/totalPoints*100):0;Str.get_string("final_score","local_trustgrade",{score:score,total:totalPoints,percentage:percentage}).then(scoreString=>{resultsHtml=`<div class="score-summary alert alert-info">\n              <h3>${scoreString}</h3>\n              <p><strong>${strings[8]}</strong></p>\n            </div>`+resultsHtml,resultsHtml+="</div>",this.windowBlurCount>0?Promise.all([Str.get_string("integrity_report_header","local_trustgrade"),Str.get_string("window_focus_lost","local_trustgrade",this.windowBlurCount),Str.get_string("integrity_recorded","local_trustgrade")]).then(integrityStrings=>{resultsHtml+=`<div class="integrity-report alert alert-warning">\n                <h4><i class="fa fa-exclamation-triangle"></i> ${integrityStrings[0]}</h4>\n                <p>${integrityStrings[1]}</p>\n                <p><small>${integrityStrings[2]}</small></p>\n              </div>`,this.displayResults(resultsHtml)}):this.displayResults(resultsHtml)})})},displayResults:resultsHtml=>{$(".quiz-content").hide(),$(".quiz-navigation").hide(),$(".question-counter").hide(),$(".question-timer-container").hide(),$(".quiz-results").html(resultsHtml).show()},showIntegrityViolation:function(){this.saveSessionState(),this.attemptCompleted=!0,this.stopTimer(),this.autoSaveInterval&&clearInterval(this.autoSaveInterval);var completionUpdates={current_question:this.currentQuestion,answers:this.answers,time_remaining:this.timeRemaining,window_blur_count:this.windowBlurCount,attempt_completed:!0};Ajax.call([{methodname:"local_trustgrade_update_quiz_session",args:{cmid:this.cmid,submissionid:this.submissionid,updates:JSON.stringify(completionUpdates)}}]),Promise.all([Str.get_string("integrity_violation_header","local_trustgrade"),Str.get_string("quiz_flagged","local_trustgrade"),Str.get_string("exceeded_window_switches","local_trustgrade",this.maxWindowBlurs),Str.get_string("incident_logged","local_trustgrade"),Str.get_string("progress_saved_cannot_continue","local_trustgrade")]).then(strings=>{var templateContext={title:strings[0],flagged_message:strings[1],exceeded_message:strings[2],logged_message:strings[3],progress_message:strings[4]};Templates.render("local_trustgrade/quiz_integrity_violation",templateContext).then(html=>{$(".quiz-content").html(html),$(".quiz-navigation").hide(),$(".question-counter").hide(),$(".question-timer-container").hide(),this.logIntegrityViolation("integrity_violation",{violation_type:"excessive_window_blur",window_blur_count:this.windowBlurCount,current_question:this.currentQuestion})}).catch(Notification.exception)})}}));

//# sourceMappingURL=quiz.min.js.map