/**
 * Task indicator module for showing pending async tasks
 *
 * @module     local_trustgrade/task_indicator
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_trustgrade/task_indicator",["jquery","core/ajax","core/notification","core/str"],($,Ajax,Notification,Str)=>{var TaskIndicator={indicatorElement:null,checkInterval:null,CHECK_FREQUENCY:1e4,init:function(){this.createIndicatorElement(),this.checkPendingTasks(),this.checkInterval=setInterval(function(){this.checkPendingTasks()}.bind(this),this.CHECK_FREQUENCY)},createIndicatorElement:function(){var indicator=$("<div>",{id:"trustgrade-task-indicator",class:"trustgrade-task-indicator hidden"});indicator.html('<div class="indicator-content">   <div class="indicator-icon">       <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">         <circle cx="16" cy="16" r="14" fill="#4CAF50" stroke="#fff" stroke-width="2"/>         <path d="M9 16L14 21L23 11" stroke="white" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>       </svg>   </div>   <div class="indicator-text">       <div class="indicator-title"></div>       <div class="indicator-message"></div>   </div>   <div class="indicator-spinner">       <i class="fa fa-spinner fa-spin"></i>   </div></div>'),$("body").append(indicator),this.indicatorElement=indicator},checkPendingTasks:function(){Ajax.call([{methodname:"local_trustgrade_get_pending_tasks",args:{},done:function(response){if(response.success&&response.tasks)try{var tasks=JSON.parse(response.tasks);tasks&&tasks.length>0?this.showIndicator(tasks[0]):this.hideIndicator()}catch(e){console.error("[TrustGrade] Error parsing tasks:",e),this.hideIndicator()}else this.hideIndicator()}.bind(this),fail:(error=>{console.error("[TrustGrade] Error checking pending tasks:",error)}).bind(this)}])},showIndicator:function(task){if(this.indicatorElement){var titleKey="ready"===task.status?"quiz_ready":"quiz_preparing",messageKey="ready"===task.status?"quiz_ready_message":"quiz_preparing_message";Str.get_strings([{key:titleKey,component:"local_trustgrade"},{key:messageKey,component:"local_trustgrade",param:task.assignment_name}]).done(function(strings){this.indicatorElement.find(".indicator-title").text(strings[0]),this.indicatorElement.find(".indicator-message").text(strings[1]),"ready"===task.status&&task.quiz_url?(this.indicatorElement.addClass("clickable").css("cursor","pointer"),this.indicatorElement.off("click").on("click",()=>{window.location.href=task.quiz_url}),this.indicatorElement.find(".indicator-spinner").hide()):(this.indicatorElement.removeClass("clickable").css("cursor","default"),this.indicatorElement.off("click"),this.indicatorElement.find(".indicator-spinner").show()),this.indicatorElement.removeClass("hidden").addClass("visible")}.bind(this)).fail(error=>{console.error("[TrustGrade] Error loading strings:",error)})}},hideIndicator:function(){this.indicatorElement&&this.indicatorElement.removeClass("visible").addClass("hidden")},destroy:function(){this.checkInterval&&(clearInterval(this.checkInterval),this.checkInterval=null),this.indicatorElement&&(this.indicatorElement.remove(),this.indicatorElement=null)}};return{init:()=>{$(document).ready(()=>{TaskIndicator.init()})}}});

//# sourceMappingURL=task_indicator.min.js.map