/**
 * Add TrustGrade quiz grade column to assignment grading table
 *
 * @module     local_trustgrade/grading_table
 * @package    local_trustgrade
 * @copyright  2025 CentricApp LTD
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_trustgrade/grading_table",["jquery","core/ajax","core/notification","core/str"],function($,Ajax,Notification,Str){return{init:function(cmid){console.log("[TrustGrade] TrustGrade grading table column loaded for cmid:",cmid);Str.get_strings([{key:"pluginname",component:"local_trustgrade"},{key:"time_taken",component:"local_trustgrade"}]).then(function(results){var pluginNameStr=results[0],timeTakenStr=results[1];$(document).ready(function(){addTrustGradeColumn(cmid,pluginNameStr,timeTakenStr)})}).catch(Notification.exception)}};function addTrustGradeColumn(cmid,pluginNameStr,timeTakenStr){var gradingTable=$("table.flexible.table.table-striped");if(0===gradingTable.length)return console.log("[TrustGrade] Grading table not found, retrying..."),void setTimeout(function(){addTrustGradeColumn(cmid,pluginNameStr,timeTakenStr)},500);console.log("[TrustGrade] Grading table found");var headerRow=gradingTable.find("thead tr");headerRow.length>0&&0===headerRow.find("th.trustgrade-quiz-grade").length&&headerRow.append('<th class="header c-trustgrade trustgrade-quiz-grade" scope="col">'+pluginNameStr+"</th>"),function(cmid,gradingTable,timeTakenStr){Ajax.call([{methodname:"local_trustgrade_get_quiz_grades_for_grading",args:{cmid:cmid}}])[0].done(function(response){if(console.log("[TrustGrade] Quiz grades response:",response),response.success){var grades=JSON.parse(response.grades);console.log("[TrustGrade] Parsed grades:",grades),gradingTable.find("tbody tr").each(function(){var row=$(this),userId=function(row){var userLink=row.find('a[href*="/user/view.php"]').first();if(userLink.length>0){var match=userLink.attr("href").match(/id=(\d+)/);if(match)return parseInt(match[1])}var userId=row.data("userid");if(userId)return parseInt(userId);var userInput=row.find('input[name*="userid"]');if(userInput.length>0)return parseInt(userInput.val());return null}(row);if(userId&&grades[userId]){var gradeData=grades[userId],gradeHtml='<div style="white-space: nowrap; text-align: right; direction: rtl;">';if(gradeHtml+='<div style="font-weight: bold; color: #0f6cbf;">',gradeHtml+=gradeData.earned_points+"/"+gradeData.total_points,gradeHtml+=" ("+gradeData.percentage+"%)",gradeHtml+="</div>",gradeData.completed){var date=new Date(1e3*gradeData.completed);gradeHtml+='<div style="font-size: 0.85em; color: #666;">',gradeHtml+=date.getDate()+"/"+("0"+(date.getMonth()+1)).slice(-2)+"/"+date.getFullYear()+" "+("0"+date.getHours()).slice(-2)+":"+("0"+date.getMinutes()).slice(-2),gradeHtml+="</div>"}gradeData.duration&&(gradeHtml+='<div style="font-size: 0.75em; color: #999;">',gradeHtml+=timeTakenStr+": "+gradeData.duration+"s",gradeHtml+="</div>"),gradeHtml+="</div>",row.append('<td class="cell c-trustgrade trustgrade-quiz-grade">'+gradeHtml+"</td>")}else userId?row.append('<td class="cell c-trustgrade trustgrade-quiz-grade">-</td>'):row.append('<td class="cell c-trustgrade trustgrade-quiz-grade"></td>')})}else{console.error("[TrustGrade] Failed to fetch quiz grades:",response.error),gradingTable.find("tbody tr").each(function(){$(this).append('<td class="cell c-trustgrade trustgrade-quiz-grade">-</td>')})}}).fail(function(error){console.error("[TrustGrade] AJAX error fetching quiz grades:",error),Notification.exception(error),gradingTable.find("tbody tr").each(function(){$(this).append('<td class="cell c-trustgrade trustgrade-quiz-grade">-</td>')})})}(cmid,gradingTable,timeTakenStr)}});

//# sourceMappingURL=grading_table.min.js.map