/**
 * Task indicator module for showing pending async tasks
 *
 * @module     local_trustgrade/task_indicator
 * @copyright  2025 CentricApp LTD <support@centricapp.co.il>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_trustgrade/task_indicator",["jquery","core/ajax","core/notification","core/str"],($,Ajax,Notification,Str)=>{var TaskIndicator={indicatorElement:null,lastCheckTime:null,recheckTimeout:null,visibilityChangeHandler:null,isPolling:!1,init:function(){this.createIndicatorElement(),this.checkHasPendingTasks(),$(window).on("storage.trustgrade",e=>{"trustgrade_has_active_task"===e.originalEvent.key&&"true"===e.originalEvent.newValue&&(console.log("[TrustGrade] Active task detected in another tab, starting polling"),this.startPolling())})},checkHasPendingTasks:function(){Ajax.call([{methodname:"local_trustgrade_has_pending_tasks",args:{},done:function(response){response.success&&response.has_tasks?(console.log("[TrustGrade] User has pending tasks, starting polling"),this.startPolling()):(console.log("[TrustGrade] No pending tasks found, will not poll"),localStorage.removeItem("trustgrade_has_active_task"))}.bind(this),fail:(error=>{console.error("[TrustGrade] Error checking for pending tasks:",error)}).bind(this)}])},startPolling:function(){this.isPolling||(this.isPolling=!0,this.lastCheckTime=Math.floor(Date.now()/1e3),this.checkPendingTasks(),this.visibilityChangeHandler=()=>{document.hidden||(console.log("[TrustGrade] Tab became visible, checking for updates"),this.handleTaskStatusChange())},document.addEventListener("visibilitychange",this.visibilityChangeHandler),$(window).on("focus.trustgrade",()=>{console.log("[TrustGrade] Window focused, checking for updates"),this.handleTaskStatusChange()}),this.scheduleNextCheck(6e4))},stopPolling:function(){console.log("[TrustGrade] Stopping polling"),this.isPolling=!1,this.recheckTimeout&&(clearTimeout(this.recheckTimeout),this.recheckTimeout=null),this.visibilityChangeHandler&&(document.removeEventListener("visibilitychange",this.visibilityChangeHandler),this.visibilityChangeHandler=null),$(window).off("focus.trustgrade"),localStorage.removeItem("trustgrade_has_active_task")},createIndicatorElement:function(){var indicator=$("<div>",{id:"trustgrade-task-indicator",class:"trustgrade-task-indicator hidden"});indicator.html('<div class="indicator-content">   <div class="indicator-icon">       <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">         <circle cx="16" cy="16" r="14" fill="#4CAF50" stroke="#fff" stroke-width="2"/>         <path d="M9 16L14 21L23 11" stroke="white" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>       </svg>   </div>   <div class="indicator-text">       <div class="indicator-title"></div>       <div class="indicator-message"></div>   </div>   <div class="indicator-spinner">       <i class="fa fa-spinner fa-spin"></i>   </div></div>'),$("body").append(indicator),this.indicatorElement=indicator},handleTaskStatusChange:function(){console.log("[TrustGrade] Checking for task updates"),this.recheckTimeout&&(clearTimeout(this.recheckTimeout),this.recheckTimeout=null),this.checkPendingTasks(),this.scheduleNextCheck(6e4)},scheduleNextCheck:function(delay){this.recheckTimeout&&clearTimeout(this.recheckTimeout),this.recheckTimeout=setTimeout(()=>{this.checkPendingTasks(),this.scheduleNextCheck(6e4)},delay)},checkPendingTasks:function(){let singleCheck=arguments.length>0&&void 0!==arguments[0]&&arguments[0];Ajax.call([{methodname:"local_trustgrade_get_pending_tasks",args:{},done:function(response){if(response.success&&response.tasks)try{var tasks=JSON.parse(response.tasks);tasks&&tasks.length>0?(this.isPolling||singleCheck||(console.log("[TrustGrade] Tasks found, starting polling"),this.startPolling()),this.showIndicator(tasks[0])):(this.hideIndicator(),this.isPolling&&!singleCheck&&this.stopPolling())}catch(e){console.error("[TrustGrade] Error parsing tasks:",e),this.hideIndicator()}else this.hideIndicator(),this.isPolling&&!singleCheck&&this.stopPolling()}.bind(this),fail:(error=>{console.error("[TrustGrade] Error checking pending tasks:",error)}).bind(this)}])},showIndicator:function(task){if(this.indicatorElement){var titleKey,messageKey,messageParam;if(console.log("[TrustGrade] Showing indicator for task:",task),task.error_message&&""!==task.error_message.trim())return console.log("[TrustGrade] Task has error_message:",task.error_message),void Str.get_strings([{key:"quiz_failed",component:"local_trustgrade"}]).done(function(strings){this.indicatorElement.find(".indicator-title").text(strings[0]),this.indicatorElement.find(".indicator-message").text(task.error_message),this.indicatorElement.removeClass("clickable").css("cursor","default"),this.indicatorElement.off("click"),this.indicatorElement.find(".indicator-spinner").hide(),this.indicatorElement.find(".indicator-icon").css("background","#f44336"),this.indicatorElement.removeClass("hidden").addClass("visible"),console.log("[TrustGrade] Task has error message, stopping polling"),this.stopPolling(),setTimeout(()=>{this.hideIndicator()},15e3)}.bind(this)).fail(function(error){console.error("[TrustGrade] Error loading failed string:",error)});"failed"===task.status?(titleKey="quiz_failed",messageKey="quiz_failed_message",messageParam=task.assignment_name):"ready"===task.status?(titleKey="quiz_ready",messageKey="quiz_ready_message",messageParam=task.assignment_name):(titleKey="quiz_preparing",messageKey="quiz_preparing_message",messageParam=task.assignment_name),Str.get_strings([{key:titleKey,component:"local_trustgrade"},{key:messageKey,component:"local_trustgrade",param:messageParam}]).done(function(strings){this.indicatorElement.find(".indicator-title").text(strings[0]),this.indicatorElement.find(".indicator-message").text(strings[1]),"ready"===task.status&&task.quiz_url?(this.indicatorElement.addClass("clickable").css("cursor","pointer"),this.indicatorElement.off("click").on("click",()=>{window.location.href=task.quiz_url}),this.indicatorElement.find(".indicator-spinner").hide(),this.indicatorElement.find(".indicator-icon").css("background","#4CAF50")):"failed"===task.status?(this.indicatorElement.removeClass("clickable").css("cursor","default"),this.indicatorElement.off("click"),this.indicatorElement.find(".indicator-spinner").hide(),this.indicatorElement.find(".indicator-icon").css("background","#f44336"),console.log("[TrustGrade] Task failed, stopping polling"),this.stopPolling(),setTimeout(()=>{this.hideIndicator()},1e4)):(this.indicatorElement.removeClass("clickable").css("cursor","default"),this.indicatorElement.off("click"),this.indicatorElement.find(".indicator-spinner").show(),this.indicatorElement.find(".indicator-icon").css("background","#4CAF50")),this.indicatorElement.removeClass("hidden").addClass("visible")}.bind(this)).fail(error=>{console.error("[TrustGrade] Error loading strings:",error)})}},hideIndicator:function(){this.indicatorElement&&this.indicatorElement.removeClass("visible").addClass("hidden")},destroy:function(){this.recheckTimeout&&(clearTimeout(this.recheckTimeout),this.recheckTimeout=null),this.visibilityChangeHandler&&(document.removeEventListener("visibilitychange",this.visibilityChangeHandler),this.visibilityChangeHandler=null),$(window).off("focus.trustgrade"),this.indicatorElement&&(this.indicatorElement.remove(),this.indicatorElement=null)}};return{init:()=>{$(document).ready(()=>{TaskIndicator.init()})}}});

//# sourceMappingURL=task_indicator.min.js.map