# Originality - Plagiarism Plugin for Moodle

[![Maintained by Mattan Dor (CentricApp)](https://img.shields.io/badge/Maintained%20by-Mattan%20Dor%20(CentricApp)-brightgreen)](https://centricapp.co)

![Originality Plugin Logo](https://originality.co.il/images/logo.png)

The Originality Plagiarism Plugin for Moodle is a powerful tool designed to detect and deter plagiarism in educational institutions using the Moodle learning management system (
LMS). This plugin integrates seamlessly with Moodle and provides educators with a reliable solution to promote academic integrity among students.

## Commercial Subscription Requirement

Please note that a commercial subscription is required to use the Originality Plagiarism Plugin for Moodle. To obtain a subscription and access the full functionality of the
plugin, please visit our website [originality.world](https://originality.world/) for more information.

## Features

- **Advanced Plagiarism Detection:** The plugin employs state-of-the-art algorithms to analyze student submissions and compare them against a vast database and online sources to
  identify potential instances of plagiarism.

- Both teachers and students do not need to learn a new tool. All existing screens remain as they are, with the addition of a single button for the teacher during the creation of
  an assignment, and a check box for the student.

- **User-friendly Reports:** The plugin generates detailed reports for each submitted assignment, highlighting each matching content found during the plagiarism analysis. The
  reports provide educators with clear evidence of plagiarism and assist in the decision-making process. Further, the plugin has a new feature that enables the detection of
  ghostwriting, be it a human, chatGPT, or a combination of both.

- **Intuitive Interface:** The plugin seamlessly integrates with the Moodle interface, ensuring a smooth user experience for both educators and students. The plagiarism-checking
  process is straightforward and can be easily initiated with a few simple clicks.

- **Database Integration:** The plugin is designed to work seamlessly with Moodle's database, storing plagiarism reports securely and efficiently. This integration ensures that
  educators can easily access and review reports whenever needed.

## Installation

To install the Plagiarism Originality Plugin for Moodle, follow these steps:

1. Download the plugin package from the official website: [https://moodle.org/plugins/plagiarism_originality/](https://moodle.org/plugins/plagiarism_originality/) or from Moodle’s
   website.

2. Log in to your Moodle site as an administrator.

3. Navigate to the "Site Administration" area.

4. Go to "Plugins" and select "Install plugins."

5. Choose the "Install plugin from ZIP file" option.

6. Upload the downloaded plugin package.

7. Follow the on-screen instructions to complete the installation process.

8. Once the plugin is installed, it creates an originality user, role, and token within your site to allow Originality to update Moodle when a report is available. Configure the
   settings according to your institution's requirements. Please contact [info@originality.world](mailto:info@originality.world]) to obtain your token.

9. You're ready to start using the Plagiarism Originality Plugin for Moodle!

[Click here](https://originality.world/Originality%20Plagiarism%20Plugin%20Installation%20Tutorial%202023-07.pdf) to download a tutorial on how to configure the Originality plugin
in Moodle.

## Usage

After installing the plugin, educators can enable the plagiarism-checking feature for specific assignments or activities within Moodle. Here's how to use the plugin:

1. Navigate to the course where you want to enable plagiarism checking.

2. Create or edit an assignment or activity.

3. Locate the plagiarism settings section and enable plagiarism checking.

4. Configure the desired plagiarism detection settings, such as similarity thresholds and exclusion rules.

5. Save the settings and make the assignment or activity available to students.

6. Once students submit their work, the plugin will automatically analyze the submissions for potential instances of plagiarism.

7. Educators can access the plagiarism reports for each submission, review the findings, and take appropriate actions based on the results.

## Support

If you encounter any issues or have questions regarding the Originality Plagiarism Plugin for Moodle, you can reach out to the support team via their
email [info@originality.world](info@originality.world)

## License

The Plagiarism Originality Plugin for Moodle is licensed under the [MIT License](https://opensource.org/licenses/MIT).
You are free to modify and distribute the plugin in accordance with the license terms.

## Acknowledgements

We would like to express our gratitude to the Moodle community and its leaders for developing and maintaining this valuable LMS.