# Custom Pages Documentation

## Overview
This module allows users to create and manage custom pages within Moodle. It provides a user-friendly interface for adding, editing, and deleting pages, as well as configuring various settings related to each page.

## Features
- **Add Pages**: Users can create new pages with specific content and settings.
- **Edit Pages**: Existing pages can be modified to update content or settings.
- **Delete Pages**: Users can remove pages that are no longer needed.
- **Access Control**: Define access levels for each page based on user capabilities.

## Usage
1. Navigate to **Site Administration** > **Plugins** > **Local Plugins** > **Page** > **Manage Pages** in the Moodle admin panel.
2. Click on **Add Page** to create a new page.
3. Fill in the required fields, including page name, content, and access level.
4. Save the page to make it available to users.

## Configuration
- **Access Level**: Specify the capabilities required to view the page. Use commas to separate multiple capabilities.
- **Additional HTML**: Optionally add custom HTML to the `<head>` section of the page for additional styling or scripts.

## Documentation
https://rosea.gitbook.io/page-by-roseathemes

## Help
For more information, refer to the support@rosea.io
