define(['jquery'], function($) {
    'use strict';

    return {
        init: function() {
            $(document).on('click', '.pagination a', function(e) {
                e.preventDefault();
                var url = $(this).attr('href');
                var tableContainer = $(this).closest('.lti-usage-table-group');
                var tableId = tableContainer.data('typeid');
                var scrollPosition = $(window).scrollTop();

                // Show loading indicator
                tableContainer.find('table').css('opacity', '0.5');

                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: 'html',
                    success: function(data) {
                        // Find the new table group in the response
                        var newTableGroup = $(data).find('[data-typeid="' + tableId + '"]');
                        if (newTableGroup.length) {
                            tableContainer.replaceWith(newTableGroup);
                        } else {
                            // Fallback: replace the whole content
                            $('.local-myplugin-lti-usage').html($(data).find('.local-myplugin-lti-usage').html());
                        }
                        // Scroll to the top of the table after content update
                        setTimeout(function() {
                            var newTableContainer = $('.lti-usage-table-group[data-typeid="' + tableId + '"]');
                            if (newTableContainer.length) {
                                $(window).scrollTop(newTableContainer.offset().top - 20);
                            }
                        }, 10);
                    },
                    error: function() {
                        alert('Error loading page');
                        tableContainer.find('table').css('opacity', '1');
                    }
                });
            });
        }
    };
});