/**
 * @module local_ltiusage/pagination
 * @copyright 2025 Michael Clark <michael.d.clark@glasgow.ac.uk>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("local_ltiusage/pagination",["jquery","core/ajax"],function($,ajax){var init=function(){$(document).off("click.pagination").on("click.pagination",".pagination a",function(e){e.preventDefault(),e.stopImmediatePropagation(),e.stopPropagation();var link=$(this);if(link.hasClass("disabled")||link.closest("li").hasClass("disabled"))return!1;var url=link.attr("href"),tableContainer=link.closest(".lti-usage-table-group"),pageMatch=url.match(/page_(\d+)=(\d+)/);if(!pageMatch)return!1;var typeId=parseInt(pageMatch[1]),pageNum=parseInt(pageMatch[2]);return tableContainer.find("table").css("opacity","0.5"),ajax.call([{methodname:"local_ltiusage_get_pagination",args:{typeid:typeId,page:pageNum,perpage:25},done:function(response){var tbody=tableContainer.find("tbody");tbody.empty(),response.rows.forEach(function(row){var deleteCell=response.candelete?'<td><a href="'+row.deletelink+'" onclick="return confirm(\'Are you sure you want to delete this LTI activity?\');">Delete</a></td>':"",tr="<tr><td>"+row.course+"</td><td>"+row.name+"</td><td>"+row.visible+'</td><td><a href="'+row.link+'">Open</a></td>'+deleteCell+"</tr>";tbody.append(tr)});var paginationUl=tableContainer.find(".pagination");if(paginationUl.length){var totalPages=Math.ceil(response.total/25),html="";html+='<li class="page-item'+(0===pageNum?" disabled":"")+'">',html+='<a href="'+url.replace(/page_\d+=\d+/,"page_"+typeId+"=0")+'" class="page-link'+(0===pageNum?" disabled":"")+'">&laquo; First</a>',html+="</li>",response.has_prev&&(html+='<li class="page-item">',html+='<a href="'+url.replace(/page_\d+=\d+/,"page_"+typeId+"="+response.prev)+'" class="page-link">&lsaquo; Previous</a>',html+="</li>"),html+='<li class="page-item disabled">',html+='<span class="page-link">Page '+(pageNum+1)+" of "+totalPages+"</span>",html+="</li>",response.has_next&&(html+='<li class="page-item">',html+='<a href="'+url.replace(/page_\d+=\d+/,"page_"+typeId+"="+response.next)+'" class="page-link">Next &rsaquo;</a>',html+="</li>"),html+='<li class="page-item'+(pageNum===totalPages-1?" disabled":"")+'">',html+='<a href="'+url.replace(/page_\d+=\d+/,"page_"+typeId+"="+(totalPages-1))+'" class="page-link'+(pageNum===totalPages-1?" disabled":"")+'">Last &raquo;</a>',html+="</li>",paginationUl.html(html)}tableContainer.find("table").css("opacity","1"),setTimeout(function(){$(window).scrollTop(tableContainer.offset().top-20)},10)}}]),!1})};return M.local_ltiusage=M.local_ltiusage||{},M.local_ltiusage.pagination={init:init},{init:init}});

//# sourceMappingURL=pagination.min.js.map