<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * CLI helper to encrypt endpoint/token values with the hardcoded master key.
 *
 * @package   local_inventario
 * @copyright 2025 mdlbox
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define('CLI_SCRIPT', true);
define('MOODLE_INTERNAL', true);

require_once(__DIR__ . '/../classes/local/secrets.php');

use local_inventario\local\secrets;

if ($argc < 2) {
    fwrite(STDERR, "Usage: php encrypt_secrets.php \"value\"\n");
    exit(1);
}

$value = (string)$argv[1];
$cipher = secrets::encrypt($value);

fwrite(STDOUT, $cipher . PHP_EOL);
