<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings for local_inventario.
 *
 * @package   local_inventario
 * @copyright 2026 mdlbox - https://mdlbox.com
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['actions'] = 'Actions';
$string['addreservation'] = 'Add reservation';
$string['all'] = 'All';
$string['allowperiodic'] = 'Allow periodic reservations (Pro only)';
$string['allowperiodic_desc'] = 'If enabled and license is Pro, users can create recurring reservations.';
$string['allowpublicpage'] = 'Public embeddable page (Pro only)';
$string['allowpublicpage_desc'] = 'Allow an anonymous, iframe-ready page that lists ongoing and upcoming reservations without personal data.';
$string['allreservations'] = 'All reservations';
$string['api_not_configured'] = 'API endpoint is not configured';
$string['apiendpoint'] = 'License endpoint';
$string['apiendpoint_desc'] = 'Remote HTTPS endpoint managed by the external inventory back-office.';
$string['apiinvalid'] = 'Invalid API response: {$a}';
$string['apikey'] = 'API Key';
$string['apirequestfailed'] = 'API request failed: {$a}';
$string['apitoken'] = 'API token';
$string['apitoken_desc'] = 'Token used to sign all outgoing calls towards the license backend.';
$string['availability'] = 'Availability';
$string['availability_enabled'] = 'Restrict availability to a specific period (Pro only)';
$string['availability_from'] = 'Available from';
$string['availability_times'] = 'Allowed time slots (one per line, HH:MM-HH:MM)';
$string['availability_to'] = 'Available until';
$string['availabilityerror_format'] = 'Invalid time slot format. Use HH:MM-HH:MM, one per line.';
$string['availabilityerror_outofrange'] = 'The reservation falls outside the object availability window.';
$string['availabilityerror_range'] = 'End availability must be after start.';
$string['availabilityerror_slot'] = 'The reservation times are not within the allowed slots.';
$string['availabilityerror_slotday'] = 'Reservations must stay within a single day when time slots are defined.';
$string['availableonly'] = 'Only available';
$string['backtoinventory'] = 'Back to inventory';
$string['calendarlegend'] = 'Legend';
$string['calendarnoreservations'] = 'No reservations found for the selected period.';
$string['calendarshowless'] = 'Show less';
$string['calendarshowmore'] = 'Show {$a} more';
$string['cannotdeleteexpiredreservation'] = 'Cannot delete an expired reservation: mark it as returned.';
$string['cannoteditexpiredreservation'] = 'Cannot edit an expired reservation.';
$string['checkinterval'] = 'License check interval (seconds)';
$string['checkinterval_desc'] = 'How often the plugin revalidates the license with the external backend.';
$string['childexists'] = 'Cannot delete this property because it has child properties.';
$string['confirmdeleteobject'] = 'Delete this object and related data?';
$string['confirmdeleteproperty'] = 'Delete property "{$a}"? This action cannot be undone.';
$string['confirmdeletereservation'] = 'Delete reservation for "{$a}"? This action cannot be undone.';
$string['confirmdeletesite'] = 'Delete site "{$a}"? This action cannot be undone.';
$string['confirmdeletetype'] = 'Delete object type "{$a}"? This action cannot be undone.';
$string['confirmreturn'] = 'Mark this reservation as returned?';
$string['confirmtoggle'] = 'Confirm visibility change?';
$string['currentlocation'] = 'Current location';
$string['datatype'] = 'Data type';
$string['datatype_bool'] = 'Yes/No';
$string['datatype_group'] = 'Group';
$string['datatype_number'] = 'Number';
$string['datatype_select'] = 'Select (comma separated options)';
$string['datatype_text'] = 'Text';
$string['defaultsite'] = 'Site 1';
$string['deprecatedajax'] = 'Deprecated AJAX endpoint: update the plugin and use external services.';
$string['downloadtemplate'] = 'Download CSV template';
$string['endtime'] = 'End';
$string['expired_body_template'] = 'Expiration notice body';
$string['expired_subject_template'] = 'Expiration notice subject';
$string['exportobjectscsv'] = 'Export objects CSV';
$string['exportpropertiescsv'] = 'Export properties CSV';
$string['exporttypescsv'] = 'Export types CSV';
$string['filter'] = 'Filter';
$string['filters'] = 'Filters';
$string['freelimits_body'] = 'The free version of the plugin can be used at no cost and is fully functional, but it comes with some limitations. It allows you to create up to 15 objects and a maximum of 5 properties, and it does not include access to advanced features. The free version is ideal for testing and basic use, while the PRO version removes all limits and unlocks the full potential of the plugin.';
$string['freelimits_guide'] = 'Not sure where to start configuring your inventory? Visit our page with the first steps for a correct setup: {$a}';
$string['freelimits_guide_link'] = 'https://mdlbox.com/knowledge_center/';
$string['freelimits_moreinfo'] = 'For more details, visit our official website: https://mdlbox.com';
$string['freelimits_title'] = 'Free version limits';
$string['hidden'] = 'Hidden';
$string['hiddenobject'] = 'The selected object is hidden.';
$string['hide'] = 'Hide';
$string['history'] = 'History';
$string['historyshowless'] = 'Show less';
$string['historyshowmore'] = 'Show more';
$string['importcsv'] = 'Import CSV';
$string['importcsvfile'] = 'CSV file';
$string['importcsvresult'] = 'Import completed. Created: {$a->created}, updated: {$a->updated}.';
$string['importobjectscsv'] = 'Import objects CSV';
$string['importpropertiescsv'] = 'Import properties CSV';
$string['importtypescsv'] = 'Import types CSV';
$string['invalidaction'] = 'Invalid action.';
$string['invalidcolor'] = 'Invalid color.';
$string['invalidobject'] = 'Invalid object data';
$string['invalidproperty'] = 'Invalid property data';
$string['invalidsite'] = 'Invalid site name';
$string['invalidtimerange'] = 'End date must be after start date.';
$string['invalidtype'] = 'Invalid object type.';
$string['inventario:deletereservations'] = 'Delete reservations';
$string['inventario:managelicense'] = 'Manage Inventario license';
$string['inventario:manageobjects'] = 'Manage objects';
$string['inventario:manageproperties'] = 'Manage custom properties';
$string['inventario:managesites'] = 'Manage inventory sites';
$string['inventario:reserve'] = 'Reserve objects';
$string['inventario:togglevisibility'] = 'Toggle object visibility';
$string['inventario:view'] = 'View the inventory';
$string['itemsperpage'] = 'Items per page';
$string['lastreservation'] = 'Last reservation';
$string['license'] = 'License / API Key';
$string['license_moreinfo'] = 'For more information visit: {$a}';
$string['licensedomain'] = 'Domain: {$a}';
$string['licenseerror'] = 'License check failed: {$a}';
$string['licenseexpired'] = 'License expired on {$a}.';
$string['licenseexpires'] = 'Expires on {$a}';
$string['licensefreeinfo'] = 'Free mode active. Upgrade to Pro to unlock all features.';
$string['licensefreekey'] = 'Free API Key. This key will show as expired.';
$string['licenseinfo'] = 'License information';
$string['licenseinvalid'] = 'License invalid or missing.';
$string['licenserefreshed'] = 'License refreshed';
$string['licensestatus'] = 'Status: {$a}';
$string['licensevalid'] = 'License validated.';
$string['licensevaliduntil'] = 'License valid until {$a}.';
$string['location'] = 'Location';
$string['locationrequiredbytype'] = 'Location is required for this object type.';
$string['manageobjects'] = 'Manage objects';
$string['manageproperties'] = 'Manage properties';
$string['managesites'] = 'Manage sites';
$string['managetypes'] = 'Manage object types';
$string['messageprovider:reservation_expired'] = 'Notification: reservation expired';
$string['messageprovider:reservation_overdue'] = 'Notification: reservation overdue';
$string['myreservationscount'] = 'Your reservations';
$string['nav_booking'] = 'Booking';
$string['nav_calendar'] = 'Calendar';
$string['nav_csv'] = 'CSV';
$string['nav_license'] = 'License';
$string['nav_list'] = 'List';
$string['nav_objects'] = 'Objects';
$string['nav_props'] = 'Object properties';
$string['nav_sites'] = 'Locations';
$string['nav_types'] = 'Object types';
$string['nochildproperties'] = 'No child properties';
$string['noobjects'] = 'No objects yet.';
$string['nopropertiesassigned'] = 'No properties assigned';
$string['noreservations'] = 'No reservations yet.';
$string['noreturnrequired'] = 'No return needed';
$string['noreturnrequiredtooltip'] = 'No return required for this object type';
$string['nostats'] = 'No usage recorded yet.';
$string['notificationtemplates'] = 'Notification templates';
$string['notificationtemplates_desc'] = 'Customize the messages sent for overdue reminders (items that need to be returned) and for simple expiry notices. Placeholders: {object}, {end}, {reservationurl}, {returnurl}, {userfullname}.';
$string['notificationtokenshint'] = 'Placeholders: {object}, {end}, {reservationurl}, {returnurl}, {userfullname}.';
$string['notyours'] = 'You can only manage your own reservations.';
$string['notypesdefined'] = 'No object types defined. Create a type first.';
$string['object'] = 'Object';
$string['objectcurrentlyreserved'] = 'Object currently reserved.';
$string['objectdeleted'] = 'Object deleted.';
$string['objectlimit'] = 'Free version limit reached: {$a} objects.';
$string['objectname'] = 'Object name';
$string['objects'] = 'Objects';
$string['objectslist'] = 'Objects list';
$string['options'] = 'Options';
$string['options_help'] = 'Only used for select fields. Provide comma separated options.';
$string['overdue_body_template'] = 'Overdue reminder body';
$string['overdue_subject_template'] = 'Overdue reminder subject';
$string['overduegrace'] = 'Overdue grace (minutes)';
$string['overduegrace_desc'] = 'Minutes after end time before a reservation is considered overdue.';
$string['overlap'] = 'The object is already reserved in that time range.';
$string['parentproperty'] = 'Parent property';
$string['period'] = 'Period';
$string['periodicnotallowed'] = 'Periodic reservations are disabled or not available in Free mode.';
$string['pluginname'] = 'Inventario';
$string['privacy:metadata:location'] = 'Location of use';
$string['privacy:metadata:objectid'] = 'Reserved object';
$string['privacy:metadata:reservations'] = 'Stores who reserved which objects and when.';
$string['privacy:metadata:siteid'] = 'Site of the reservation';
$string['privacy:metadata:timeend'] = 'End time';
$string['privacy:metadata:timestart'] = 'Start time';
$string['privacy:metadata:userid'] = 'User performing the reservation';
$string['proonly'] = 'Pro only';
$string['properties'] = 'Properties';
$string['property'] = 'Property';
$string['propertyduplicate'] = 'A property with the same name or short name already exists. Please choose a different name.';
$string['propertylimit'] = 'Free version limit reached: {$a} properties.';
$string['propertyname'] = 'Property name';
$string['propertyvalue'] = 'Property value';
$string['propinuse'] = 'Cannot delete this property because it has assigned values.';
$string['prorequired'] = 'This action requires Pro mode.';
$string['publiccurrent'] = 'Current and today\'s reservations';
$string['publicdisabled'] = 'Public page is disabled.';
$string['publichint'] = 'Public view (names are hidden).';
$string['publictitle'] = 'Inventory reservations';
$string['publicunreturned'] = 'Unreturned items';
$string['publicupcoming'] = 'Upcoming reservations';
$string['refreshlicense'] = 'Refresh license';
$string['repeat'] = 'Repeat';
$string['repeatcount'] = 'Occurrences';
$string['repeatdays'] = 'Interval (days)';
$string['requiredfield'] = 'Required';
$string['requireslocation'] = 'Requires usage location';
$string['requiresreturn'] = 'Requires physical return';
$string['reservation_expired'] = 'Reservation expired';
$string['reservation_overdue'] = 'Reservation overdue';
$string['reservationactive'] = 'Active';
$string['reservationconfirmation_body'] = 'Confirmation email body';
$string['reservationconfirmation_desc'] = 'Customize subject and body for confirmation emails. Placeholders: {object}, {type}, {site}, {location}, {start}, {end}, {properties}, {reservationurl}, {userfullname}.';
$string['reservationconfirmation_subject'] = 'Confirmation email subject';
$string['reservationconfirmation_tokens'] = 'Placeholders: {object}, {type}, {site}, {location}, {start}, {end}, {properties}, {reservationurl}, {userfullname}.';
$string['reservationconfirmationheading'] = 'Reservation confirmation email';
$string['reservationdeleted'] = 'Reservation deleted';
$string['reservationexpired'] = 'Reservation expired';
$string['reservationexpiredbody'] = 'Your reservation for "{$a->object}" expired on {$a->end}. Please manage it here: {$a->link}';
$string['reservationexpiredshort'] = 'Expired';
$string['reservationexpiredsubject'] = 'Reservation expired: {$a}';
$string['reservationhelp'] = 'Teachers can manage only their own reservations; managers can manage all.';
$string['reservationoverdue'] = 'Reservation overdue';
$string['reservationoverduebody'] = 'Your reservation for "{$a->object}" is overdue since {$a->end}. Please return the object or update the reservation: {$a->link}';
$string['reservationoverduesubject'] = 'Reservation overdue: {$a}';
$string['reservationreturned'] = 'Reservation returned';
$string['reservations'] = 'Reservations';
$string['reservationsactive'] = 'Active reservations';
$string['reservationscalendar'] = 'Reservations calendar';
$string['reservationslist'] = 'Reservations list';
$string['reserve'] = 'Reserve';
$string['resetfilters'] = 'Reset filters';
$string['returned'] = 'Returned';
$string['returnobject'] = 'Return object';
$string['role_inventario_booking'] = 'Inventory & Booking';
$string['role_inventario_booking_desc'] = 'Users assigned this role can use the "Inventory & Booking system" plugin. They can place reservations and manage their own bookings for objects provided by the administrator or platform managers.';
$string['shortname'] = 'Short name';
$string['show'] = 'Show';
$string['site'] = 'Site';
$string['sitedeleted'] = 'Site deleted';
$string['sitename'] = 'Site name';
$string['sitenotempty'] = 'The site contains objects and cannot be removed.';
$string['sortorder'] = 'Sort order';
$string['starttime'] = 'Start';
$string['stat_summary'] = 'Objects: {$a->objects}, reservations: {$a->reservations}';
$string['stats'] = 'Statistics';
$string['status'] = 'Status';
$string['status_active'] = 'Active';
$string['status_available'] = 'Available';
$string['status_offsite'] = 'Off-site';
$string['status_reserved'] = 'Reserved';
$string['status_unavailable'] = 'Unavailable';
$string['tamperdetected'] = 'Tampering detected; Pro mode disabled.';
$string['task_expiredreservations'] = 'Notify expired reservations';
$string['task_overduereservations'] = 'Remind overdue reservations';
$string['topobjects'] = 'Most used objects';
$string['type'] = 'Type';
$string['typecolor'] = 'Type color';
$string['typedeleted'] = 'Type deleted.';
$string['typedescription'] = 'Description';
$string['typeinuse'] = 'Cannot delete this type because objects are using it.';
$string['typename'] = 'Type name';
$string['typeproperties'] = 'Properties of this type';
$string['types'] = 'Types';
$string['unknownerror'] = 'Unknown error. Please try again.';
$string['unreturned'] = 'Unreturned';
$string['unreturnednotice'] = 'There are unreturned reservations for this object.';
$string['viewhistory'] = 'View history';
$string['visibility'] = 'Visibility';
$string['visibilitytoggle'] = 'Allow managers to hide/show (Pro)';
$string['visibilityupdated'] = 'Visibility updated';
$string['visible'] = 'Visible';
$string['visibletoggled'] = 'Visibility updated';
$string['yourreservations'] = 'Your reservations';
