<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The Flask LibreOffice document conversion event.
 *
 * @package     fileconverter_flasksoffice
 * @copyright   2020 Mirko Otto
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace fileconverter_flasksoffice\event;

/**
 * The Flask LibreOffice document conversion event.
 *
 * @package     fileconverter_flasksoffice
 * @copyright   2020 Mirko Otto
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class document_conversion extends \core\event\base {

    /**
     * Init method.
     */
    protected function init() {
        $this->data['crud'] = 'c';
        $this->data['edulevel'] = self::LEVEL_PARTICIPATING;

    }

    /**
     * Returns localised general event name.
     *
     * @return string
     */
    public static function get_name() {
        return get_string('event:document_conversion', 'fileconverter_flasksoffice');
    }

    /**
     * Returns description of what happened.
     *
     * @return string
     */
    public function get_description() {
        return "The conversion with id '{$this->other['id']}' has been executed and returned the status '{$this->other['status']}'";
    }
}
