# HTML Export Grade Report Plugin for Moodle

A Moodle grade report plugin that exports student grades as Word-compatible HTML files with hierarchical category structure.

## Features

- **Hierarchical Grade Display**: Shows grades grouped by categories, items, and users, just like the built-in Moodle gradebook
- **Visibility Respect**: Respects hidden items and grade display settings (percentage vs. real score)
- **Word Compatible**: Generates HTML that imports perfectly into Microsoft Word
- **RTL Support**: Supports right-to-left languages with proper text direction
- **Student & Teacher Access**: Both students (own grades) and teachers (all students) can export
- **Print Friendly**: CSS optimized for printing and Word document formatting

## Installation

1. Download the plugin files
2. Extract to your Moodle installation: `/grade/report/htmlexport/`
3. Log in as admin and visit the notifications page to complete installation
4. The plugin will appear in the grade reports section

## Usage

### For Teachers:
1. Navigate to your course gradebook
2. Go to "HTML Export" in the grade reports
3. Select a student from the dropdown
4. Click "Export as HTML" to download the grade report

### For Students:
1. View your grades in the course
2. Look for the HTML export option
3. Download your grade report as HTML

## File Structure

```
gradereport_htmlexport/
├── classes/
│   └── report.php          # Main report class
├── db/
│   └── access.php          # Capability definitions
├── lang/
│   └── en/
│       └── gradereport_htmlexport.php  # English language strings
├── templates/
│   └── grade_export.mustache  # Mustache template (optional)
├── index.php               # Main plugin interface
├── lib.php                 # Plugin library functions
├── styles.css              # Plugin styles
├── version.php             # Plugin version information
└── README.md               # This file
```

## Requirements

- Moodle 4.0 or higher
- PHP 7.4 or higher

## Version

Current version: 1.0.0 (2025-01-15)

## License

GNU GPL v3 or later

## Support

This plugin follows Moodle's standard grade report architecture and integrates seamlessly with existing gradebook functionality.