# HTML Export Grade Report

## Overview

This is a Moodle grade report plugin that exports student grades as Word-compatible HTML files. The plugin provides hierarchical grade display grouped by categories, items, and users, just like the built-in Moodle gradebook. It respects grade visibility, hidden items, and grade display settings (percentage vs. real score). The exported HTML files can be imported into Microsoft Word for further formatting or printing.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

**Plugin Architecture**: Built as a Moodle grade report plugin following Moodle's plugin development standards and file structure conventions. Uses the `gradereport_htmlexport` namespace and integrates with Moodle's core gradebook functionality.

**Frontend Design**: Implements a clean, form-based interface using CSS classes with the `gradereport-htmlexport` prefix to avoid styling conflicts. Features include:
- Form controls for export configuration options
- Live preview functionality for generated reports
- Responsive design with consistent spacing and typography
- Primary action buttons with hover states for better user experience

**Export System**: Generates Word-compatible HTML files with hierarchical grade structure. Key features include:
- Student selection interface for teachers
- Grade tree processing that respects Moodle's category structure
- Grade visibility and permission checking
- Multiple grade display formats (percentage, real score)
- Word-compatible CSS styling with RTL support
- Download as HTML file for import into Microsoft Word

**Integration Pattern**: Built as a gradereport plugin (`gradereport_htmlexport`) that integrates with Moodle's grade report system. Includes proper capability checks, navigation integration, and follows Moodle's plugin architecture standards.

## Phase 1 Implementation (Completed - January 2025)

**Core Functionality Implemented:**
- Complete plugin structure with version.php, lib.php, and report class
- Student grade data extraction using Moodle's grade_tree API  
- Hierarchical HTML generation with categories and grade items
- Word-compatible styling with print-friendly CSS
- RTL language support and proper text direction
- Grade visibility checking and permission validation
- Student selection form interface
- HTML file download with proper headers

**Technical Architecture:**
- Main report class: `gradereport_htmlexport_report` extends `grade_report`
- Grade tree processing with recursive category handling
- Grade formatting using Moodle's built-in grade display functions
- Capability-based access control for teachers and students

## Phase 2 Implementation (Completed - August 2025)

**Enhanced Features Added:**
- Site logo integration from Site administration > Appearance > Logos
- Modern purple gradient styling matching Moodle interface themes
- Category totals and course totals with proper calculations
- Color-coded grade displays (green for values, blue for percentages)
- Enhanced CSS with rounded corners, shadows, and print-friendly design
- **Bulk Download Functionality**: ZIP file export for all students at once

**Bulk Download System:**
- Export all students' grades as individual HTML files in a ZIP archive
- Automatic file generation with proper naming conventions
- Temporary file management with cleanup after download
- Progress confirmation dialog for large courses
- Teacher-only capability with proper permission checks

**Technical Improvements:**
- Fixed logo detection to prioritize site-wide logo settings
- Added category and course total calculations using Moodle's grade APIs
- Enhanced error handling for missing grades and permissions
- Updated CSS with modern styling and better visual hierarchy

## External Dependencies

**Moodle Core**: Depends on Moodle's core gradebook system, user management, and plugin architecture. Requires Moodle's standard libraries for database access, user authentication, and permission management.

**Web Technologies**: Built using standard web technologies (HTML, CSS, PHP) following Moodle's coding standards and best practices for plugin development.