<?php
// This file is part of Exabis Student Review
//
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>
//
// Exabis Student Review is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This script is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You can find the GNU General Public License at <http://www.gnu.org/licenses/>.
//
// This copyright notice MUST APPEAR in all copies of the script!

// shown in admin plugin list
$string['pluginname'] = 'Exabis Lernentwicklungsbericht';
// shown in block title and all headers
$string['blocktitle'] = 'Lernentwicklungsbericht';


// === grp1 ===
$string['exastud:use'] = 'Student Review benutzen';
$string['exastud:editperiods'] = 'Einstellungen bearbeiten';
$string['exastud:admin'] = 'Administrator';
$string['exastud:uploadpicture'] = 'Logo uploaden';
$string['exastud:addinstance'] = 'Student Review auf Kursseite anlegen';
$string['exastud:myaddinstance'] = 'Student Review auf Startseite anlegen';


// === grp2 ===
$string['head_teacher'] = 'Zuständiger Klassenlehrer';
$string['head_teachers'] = 'Klassenlehrkräfte';
$string['head_teachers_description'] = 'Können Klassen anlegen, Lehrkräfte und Schüler/innen zubuchen und den Lernentwicklungsbericht abrufen';
$string['new_head_teacher'] = 'Neue Klassenlehrkraft zuweisen';
$string['additional_head_teacher'] = 'Zusätzliche Klassenlehrkraft';
$string['additional_head_teachers'] = 'Zusätzliche Klassenlehrkräfte';
$string['configuration_classes'] = 'Klassen';
$string['configuration_classes_onlyadmin'] = 'Admin access';
$string['project_based_configuration'] = 'Projekt konfigurieren';
$string['report'] = 'Bericht';
$string['reports'] = 'Berichte exportieren';
$string['reports_server_notification'] = 'Falls der Bericht nicht ordnungsgemäß generiert wird, könnte dies auf eine zu große Datenmenge (timeout) hinweisen. Bitte drucken Sie in diesem Fall nicht die ganze Klasse, sondern jeweils nur eine Teilauswahl.';
$string['periods'] = 'Eingabezeiträume';
$string['review'] = 'Berichte befüllen';
$string['review_button'] = 'Bewerten';
$string['pictureupload'] = 'Logo Upload';
$string['upload_picture'] = 'Laden Sie das große Landeswappen für das Abschlusszeugnis hoch.';
$string['upload_success'] = 'Das neue Logo wurde erfolgreich hochgeladen!';
$string['availableusers'] = 'Verfügbare Benutzer';
$string['teachers'] = 'Lehrkräfte';
$string['teachers_options'] = 'Zuständige Lehrkraft';
$string['project_based_teachers'] = 'Projektbeurteiler';
$string['attention_plan_will_change'] = 'Bitte beachten Sie: Bei einer Änderung des Bildungsplans müssen alle Bewertungen erneut eingegeben werden.';
$string['attention_template_will_change'] = 'Bitte beachten Sie: Bei einer Änderung des Standard Zeugnisformulars wird für alle Schüler das Zeugnisformular geändert. Bestehende Formulareinstellungen wie z.B. Abgangszeugnis werden beibehalten.';
$string['class_info'] = 'Klasseneinstellungen';
$string['export_class'] = 'Sicherung der Klasse erstellen';
$string['export_class_password_message'] = 'Bitte notieren Sie sich das Passwort "<strong>{$a}</strong>", bevor Sie fortfahren';
$string['students'] = 'Schülerinnen und Schüler';
$string['studentgradereports'] = 'Schülerzeugnisse';
$string['no_entries_found'] = 'Keine Einträge gefunden';
$string['project_based_students'] = 'Projekte';
$string['errorinsertingclass'] = 'Fehler bei der Erstellung einer Klasse';
$string['redirectingtoclassinput'] = 'Keine Klasse definiert, Weiterleitung zur Eingabe';
$string['project_based_redirectingtoclassinput'] = 'Kein Projekt definiert, Weiterleitung zur Eingabe';
$string['errorupdatingclass'] = 'Fehler bei der Aktualisierung der Klasse';
$string['project_based_errorupdatingclass'] = 'Fehler bei der Aktualisierung des Projekts';
$string['editclassmemberlist'] = 'Schüler/innen bearbeiten';
$string['add_class_from_course'] = 'Aus Kurs hinzufügen';
$string['project_based_editclassmemberlist'] = 'Projekte bearbeiten';
$string['editclassteacherlist'] = 'Lehrkräfte bearbeiten';
$string['project_based_editclassteacherlist'] = 'Beurteiler bearbeiten';
$string['editclassname'] = 'Klassenname';
$string['project_based_editclassname'] = 'Projektname';
$string['editclasscategories'] = 'Beurteilungskategorien bearbeiten';
$string['noclassfound'] = 'Keine Klasse gefunden';
$string['project_based_noclassfound'] = 'Kein Projekt gefunden';
$string['configteacher'] = 'Lehrkräfte in {$a}';
$string['project_based_configteacher'] = 'Beurteiler in {$a}';
$string['configmember'] = 'Teilnehmer in {$a}';
$string['project_based_configmember'] = 'Projekte in {$a}';
$string['configcategories'] = 'Beurteilungskategorien in {$a}';
$string['errorinsertingstudents'] = 'Fehler beim Hinzufügen eines Schülers im Kurs';
$string['errorinsertingcategories'] = 'Fehler beim Hinzufügen einer Kategorie im Kurs';
$string['errorremovingstudents'] = 'Fehler beim Löschen eines Schülers im Kurs';
$string['errorremovingcategories'] = 'Fehler beim Löschen von Kategorien aus einem Kurs';
$string['back'] = 'zurück';
$string['periodinput'] = 'Zeitraumeingabe';
$string['redirectingtoperiodsinput'] = 'Keine Eingabezeiträume gefunden, Weiterleitung zur Eingabe eines Eingabezeitraums';
$string['perioddescription'] = 'Beschreibung';
$string['starttime'] = 'Startdatum';
$string['endtime'] = 'Enddatum';
$string['newperiod'] = 'Neuer Beurteilungszeitraum';
$string['invalidperiodid'] = 'Falsche Beurteilungszeitraums-ID';
$string['certificate_issue_date'] = 'Zeugnisausgabedatum';
$string['certificate_issue_date_class'] = 'Zeugnisdatum';
$string['noclassestoreview'] = 'Keine Klasse zur Beurteilung';
$string['project_based_noclassestoreview'] = 'Kein Projekt zur Beurteilung';
$string['class'] = 'Klasse';
$string['class_title_limit_message'] = 'Max. {$a} Zeichen.';
$string['class_title_for_report'] = 'Klassenname im Zeugnis';
$string['class_title_for_report_description'] = 'Dieser Klassenname wird im Zeugnis angezeigt. Wenn hier kein Wert eingefügt wird, wird obige Klassenbezeichnung verwendet.';
$string['class_educationplan'] = 'Bildungsplan';
$string['class_default_template'] = 'Standard Zeugnisformular';
$string['class_owner'] = 'Neue Klassenlehrkraft';
$string['class_logo'] = 'Class logo';
$string['school_logo'] = 'Schullogo';
$string['school_logo_description'] = 'maximale Bildgröße: {$a->width}x{$a->height} Pixel';
$string['class_delete'] = 'Klasse löschen';
$string['project_based_class'] = 'Projekt';
$string['reviewclass'] = 'Klassenbeurteilung';
$string['project_based_reviewclass'] = 'Projektbeurteilung';
$string['badclass'] = 'Sie können diese Klasse nicht beurteilen';
$string['project_based_badclass'] = 'Sie können dieses Projekt nicht beurteilen';
$string['nostudentstoreview'] = 'Keine Schüler zu beurteilen';
$string['reviewstudent'] = 'Student review';
$string['categories'] = 'Beurteilungskategorien';
$string['addallbasic'] = 'Standardkategorien hinzufügen';
$string['addallbasicalways'] = 'Alle neuen Standardkategorien automatisch zuordnen';
$string['basiccategories'] = 'Standardkategorien';
$string['availablecategories'] = 'Verfügbare Beurteilungskategorien';
$string['teamplayer'] = 'Teamfähigkeit';
$string['responsibility'] = 'Verantwortlichkeit';
$string['selfreliance'] = 'Selbstständigkeit';
$string['evaluation'] = 'Evaluation';
$string['badstudent'] = 'Der Schüler ist nicht Mitglied dieser Klasse';
$string['project_based_badstudent'] = 'Der Schüler nimmt nicht an diesem Projekt teil.';
$string['errorupdatingstudent'] = 'Fehler beim Aktualisierung des Schülers';
$string['errorinsertingstudent'] = 'Fehler beim Einfügen des Schülers';
$string['nostudentstoreport'] = 'Kein Schüler zu beurteilen';
$string['nostudentsfound'] = 'Keine Schüler gefunden.';
$string['errorstarttimebeforeendtime'] = 'Eingabezeitraum {$a->description} hat ein Enddatum vor dem Startdatum!';
$string['printversion'] = 'Druckversion';
$string['printall'] = 'Alle drucken';
$string['periodoverlaps'] = 'Eingabezeitraum {$a->period1} überschneidet sich mit {$a->period2}';
$string['periodserror'] = 'Fehler bei der Konfiguration der Eingabezeiträume';
$string['evaluation1'] = '1 - unzureichend';
$string['evaluation2'] = '2';
$string['evaluation3'] = '3';
$string['evaluation4'] = '4';
$string['evaluation5'] = '5';
$string['evaluation6'] = '6';
$string['evaluation7'] = '7';
$string['evaluation8'] = '8';
$string['evaluation9'] = '9';
$string['evaluation10'] = '10 - sehr gut';
$string['explainclassname'] = 'Hier können Sie den Klassennamen editieren und löschen';
$string['project_based_explainclassname'] = 'Hier können Sie den Projektnamen editieren';
$string['showall'] = 'Alle anzeigen';
$string['logosize'] = '';
$string['detailedreview'] = 'Ausführliche Beurteilung';
$string['studentreview'] = 'SCHÜLERBEWERTUNG';
$string['project_based_studentreview'] = 'PROJEKTBEWERTUNG';
$string['name'] = 'Name';
$string['periodreview'] = 'Bewertung für den Eingabezeitraum';
$string['reviewcount'] = 'Bewertungen abgegeben';
$string['print'] = 'Drucken';
$string['perioddesc'] = 'Beschreibung des Eingabezeitraums';
$string['noperiods'] = 'Es gibt noch keinen Eingabezeitraum. Bitte wenden Sie sich an den Administrator.';
$string['commentshouldnotbeempty'] = 'Der Kommentar darf nicht leer sein.';
$string['report_template'] = 'Vorlage';
$string['report_preview'] = 'Bildschirmausgabe';
$string['report_select_all'] = 'Alles markieren';
$string['select_all'] = 'Alles markieren';
$string['hide_all'] = 'alle ausblenden';
$string['show_all'] = 'alle einblenden';
$string['report_delete'] = 'Delete report: {$a}';
$string['report_delete_confirm_message'] = 'Are you sure that you want to delete report "{$a}"';
$string['report_selectdeselect_all'] = 'Alles aus-/abwählen';
$string['report_settings'] = 'Berichtskonfiguration';
$string['report_settings_edit'] = 'Berichts-Konfigurationen';
$string['report_settings_new'] = 'Neue Berichts-Konfiguration hinzufügen';
$string['report_settings_setting_id'] = '';
$string['report_settings_setting_title'] = 'Titel';
$string['report_settings_setting_bp'] = 'BP';
$string['report_settings_setting_hidden'] = 'Versteckt';
$string['report_settings_setting_rs_hs'] = 'Schnittberechnung maßgebliches Fach';
$string['report_settings_setting_category'] = 'Kategorie';
$string['report_settings_setting_template'] = 'Formular';
$string['report_settings_setting_grades'] = 'Notenskala';
$string['report_settings_setting_year'] = 'Schuljahr';
$string['report_settings_setting_reportdate'] = 'Zeugnisdatum';
$string['report_settings_setting_studentname'] = 'Vor- und Zuname';
$string['report_settings_setting_dateofbirth'] = 'Geburtsdatum';
$string['report_settings_setting_placeofbirth'] = 'Geburtsort';
$string['report_settings_setting_learninggroup'] = 'Lerngruppe';
$string['report_settings_setting_class'] = 'Klasse';
$string['report_settings_setting_focus'] = 'Schwerpunkt';
$string['report_settings_setting_learnsocialbehavior'] = 'Lern- u. Sozialverhalten';
$string['report_settings_setting_subjects'] = 'Fächer';
$string['report_settings_setting_comments'] = 'Bemerkungen';
$string['report_settings_setting_subjectelective'] = 'Wahlpflichtfach';
$string['report_settings_setting_subjectprofile'] = 'Profilfach';
$string['report_settings_setting_projektthema'] = 'Projektprüfung';
$string['report_settings_setting_ags'] = 'AGs';
$string['report_settings_setting_additional_params'] = 'weitere Parameter';
$string['report_settings_no'] = 'nein';
$string['report_settings_yes'] = 'ja';
$string['report_settings_countrows'] = '{$a} Zeilen';
$string['report_settings_countinrow'] = 'zu je {$a} Zeichen';
$string['report_settings_countinrow_short'] = 'zu je {$a} Zeichen';
$string['report_settings_maxchars_short'] = '{$a} z.';
$string['report_settings_maxchars'] = '{$a} Zeichen';
$string['report_settings_countrows_fieldtitle'] = 'Zeilen';
$string['report_settings_countinrow_fieldtitle'] = 'zu je Zeichen';
$string['report_settings_maxchars_fieldtitle'] = 'Zeichen';
$string['report_settings_button_add_additional_param'] = 'Neuen Parameter hinzufügen';
$string['report_settings_selectboxkey_fieldtitle'] = 'Schlüssel';
$string['report_settings_selectboxvalue_fieldtitle'] = 'Wert';
$string['delete_parameter'] = 'Parameter löschen';
$string['sort_parameter'] = 'Sort parameters (move)';
$string['move_here'] = 'Move here';
$string['delete'] = 'Löschen';
$string['add'] = 'Hinzufügen';
$string['report_setting_type_textarea'] = 'Textbereich';
$string['report_setting_type_text'] = 'Textfeld';
$string['report_setting_type_select'] = 'Auswahl';
$string['report_setting_type_header'] = 'Kopfzeile';
$string['report_setting_type_image'] = 'Bild';
$string['report_setting_type_image_maxbytes'] = 'Max size (bytes)';
$string['report_setting_type_image_width'] = 'Breite';
$string['report_setting_type_image_height'] = 'Höhe';
$string['report_setting_type_userdata'] = 'Profilfeld';
$string['report_setting_type_userdata_datakey'] = 'Voranngelegtes Profilfeld auswählen';
$string['report_setting_type_matrix'] = 'Matrix';
$string['report_setting_type_matrix_type'] = 'Matrix-Art';
$string['report_setting_type_matrix_type_checkbox'] = 'Checkbox';
$string['report_setting_type_matrix_type_radio'] = 'Radio-Button';
$string['report_setting_type_matrix_type_text'] = 'Text';
$string['report_setting_type_matrix_row_titles'] = 'Zeilen-Inhalte';
$string['report_setting_type_matrix_column_titles'] = 'Spalten-Inhalte';
$string['reset_report_templates'] = 'Standardvorlagen auf Originalwerte zurücksetzen';
$string['reinstall_report_templates'] = 'Standardvorlagen neu installieren';
$string['reset_report_selected_templates'] = 'Ausgewählte Vorlagen auf Originalwerte zurücksetzen';
$string['reset_report_templates_description'] = 'Sind Sie sicher? Standardvorlagen werden auf die Originalwerte zurückgesetzt. Benutzerdefinierte Vorlagen bleiben unverändert.';
$string['report_setting_current_title'] = 'Bisheriger Name';
$string['report_setting_current_file'] = 'Current template';
$string['report_setting_willbe_added'] = 'Vorlage existiert nicht und wird hinzugefügt. Falls die Vorlage gelöscht wurde kann der Administrator diese erneut hinzufügen.';
$string['report_button_import'] = 'Vorlagen importieren';
$string['report_button_export'] = 'Vorlagen exportieren';
$string['report_export_selected_templates'] = 'Ausgewählte Vorlagen exportieren';
$string['report_export_with_files'] = 'Add sources (files) of templates';
$string['report_export_update_reports'] = 'vorhandene Vorlagen aktualisieren';
$string['report_export_update_files'] = 'vorhandene Vorlage-Dateien aktualisieren';
$string['report_import_templates'] = 'Import';
$string['report_import_file_shouldnotbeempty'] = 'Dateiname fehlt.';
$string['report_import_inserted_list'] = 'Folgende Vorlagen wurden hinzugefügt';
$string['report_import_updated_list'] = 'Folgende Vorlagen wurden aktualisiert';
$string['report_import_ignored_list'] = 'Folgende Vorlagen wurden nicht berücksichtigt';
$string['report_settings_upload_new_filetemplate'] = 'Neue Vorlage hochladen';
$string['report_settings_upload_new_filetemplate_overwrite'] = 'bestehende Datei überschreiben';
$string['upload_new_templatefile'] = 'Neue Vorlage hochladen';
$string['hide_uploadform'] = 'Schließen';
$string['report_settings_copy'] = 'Copy report';
$string['report_settings_copy_newtitle'] = '{$a->title} - COPY !!!';
$string['report_settings_copy_done'] = 'Created a new report "{$a->newtitle}" (id: {$a->newid}) from "{$a->sourcetitle}" (id: {$a->sourceid})';
$string['select_student'] = 'Bitte wählen Sie zumindest einen Schüler/eine Schülerin aus';
$string['not_enough_data_for_report'] = 'Für den Schüler/die Schülerin wurden noch keine Bewertungen für das Zeugnis erfasst!';
$string['review_table_part_subjects'] = 'Eingaben als Fachlehrkraft';
$string['review_table_part_additional'] = 'Eingaben als Klassenlehrkraft';
$string['review_table_part_subjectsfromother'] = 'Weitere Fachlehrkräfte';
$string['additional_info'] = 'Zusatzinformationen';
$string['settings_only_learnsoziale'] = 'nur überfachliche Kompetenzen erfassen';
$string['settings_shoolname'] = 'Lernentwicklungsbericht: Schulname';
$string['settings_shooltype'] = 'Lernentwicklungsbericht: Schulart';
$string['settings_city'] = 'Lernentwicklungsbericht: Ort';
$string['settings_edustandarts'] = 'Bildungsstandards';
$string['settings_edustandarts_description'] = 'Liste, mit Kommata getrennt';
$string['settings_bw_reports'] = 'Gemeinschaftsschulen Berichte';
$string['settings_exacomp_verbeval'] = 'Exabis Kompetenzraster Notenverbalisierung verwenden';
$string['settings_exacomp_assessment_categories'] = 'Kompetenzraster für Beurteilungskategorien verwenden';
$string['settings_sourceId'] = 'Source ID';
$string['settings_sourceId_description'] = 'Automatisch generierte ID dieser Exastud Installation. Diese kann nicht geändert werden';
$string['settings_grade_interdisciplinary_competences'] = 'Überfachliche Kompetenzen für Klassenlehrkraft freischalten';
$string['report_learn_and_sociale'] = 'Lern- und Sozialverhalten';
$string['report_cross_competences'] = 'Überfachliche Kompetenzen';
$string['report_other_report_fields'] = 'Weitere Daten/Formularfelder';
$string['report_report_fields'] = 'Daten/Formularfelder';
$string['report_bilinguales'] = 'Bilingualer Unterricht';
$string['report_for_subjects'] = 'Zertifikat für Profilfach';
$string['report_for_additional'] = 'weitere Daten';
$string['report_report_eval'] = 'Projektprüfung';
$string['review_project_evalueations'] = 'Projektprüfung / Projektarbeit';
$string['report_student_template'] = 'Zeugnisformular';
$string['not_assigned'] = 'nicht zugeordnet';
$string['competencies'] = 'Überfachliche Kompetenzen';
$string['Note'] = 'Note';
$string['Niveau'] = 'Niveau';
$string['last_period'] = 'letztes Halbjahr:';
$string['periods_incorrect'] = 'Für das aktuelle Datum gibt es keinen oder mehrere Eingabezeiträume. Bitte überprüfen sie ihre Eingabezeiträume!';
$string['suggestions_from_exacomp'] = 'Vorschläge aus Exacomp';
$string['grade_and_difflevel'] = 'Note und Niveau';
$string['load_last_period'] = 'Eingaben von der letzten Periode/Halbjahr übernehmen';
$string['load_last_period_done'] = 'Daten der letzten Periode/Halbjahr wurden übernommen';
$string['grading'] = 'Bewertungsskala';
$string['Subjects'] = 'Fachbezeichnung';
$string['education_plans'] = 'Bildungspläne';
$string['de:Lernentwicklungsbericht: Schulname'] = 'Lernentwicklungsbericht: Schulname';
$string['de:Lernentwicklungsbericht: Ort'] = 'Lernentwicklungsbericht: Ort';
$string['de:Bildungsstandards'] = 'Bildungsstandards';
$string['de:Liste, mit Kommata getrennt'] = 'Liste, mit Kommata getrennt';
$string['de:Lernentwicklungsbericht: Zeugnisausgabedatum'] = 'Lernentwicklungsbericht: Zeugnisausgabedatum';
$string['delete_class_only_without_users'] = 'Es können nur Klassen ohne Schüler gelöscht werden';
$string['force_class_to_delete'] = 'Es können nur Klassen ohne Schüler gelöscht werden. Klassen, die durch ein Häkchen zur Löschung freigegeben sind, können vom Administrator gelöscht werden.';
$string['already_marked'] = 'diese Klasse ist bereits zur Löschung vorgemerkt';
$string['mark_to_delete_go'] = 'Markieren zur Löschung durch den Administrator.';
$string['unmark_to_delete_go'] = 'Markierung für die Löschung aufheben';
$string['unmark_to_delete_button'] = 'Markierung für die Löschung aufheben';
$string['class_marked_as_todelete'] = 'Diese Klasse ist zum Löschen durch den Administrator vorgemerkt.';
$string['class_marked_as_todelete_hover'] = 'Diese Klasse ist zum Löschen durch den Administrator vorgemerkt. Um die Vormerkung zu löschen hier klicken.';
$string['interdisciplinary_competences'] = 'Überfachliche Kompetenzen';
$string['average'] = 'Durchschnitt';


// === settings ===
$string['settings_detailed_review'] = 'Einzelpunktevergabe anzeigen';
$string['settings_detailed_review_body'] = 'Diese Einstellung erlaubt es die Punktevergabe der Beurteilenden einzeln einzusehen';
$string['settings_project_based_assessment'] = 'Beurteilung auf Projekt-Basis';
$string['settings_project_based_assessment_body'] = 'Diese Einstellung erlaubt es statt Klassen Projekte zu verwalten und zu beurteilen';
$string['blocksettings'] = 'Deckblattdaten';
$string['delete_confirmation'] = 'Soll "{$a}" wirklich gelöscht werden?';
$string['delete_subjectteacher_confirmation'] = 'Do you really want to delete this subject teacher?';
$string['delete_refuse_button'] = 'Löschanfrage ablehnen.';
$string['delete_class_refused'] = 'Anfrage wurde abgelehnt';
$string['logging'] = 'Logging aktivieren';
$string['settings_competence_evaltype'] = 'Bewertungsschema';
$string['settings_competence_evaltype_text'] = 'Text-Eintrag';
$string['settings_competence_evaltype_grade'] = 'Note';
$string['settings_competence_evaltype_point'] = 'Punkte';
$string['settings_competence_evalpoints_limit'] = 'Höchste Punkteanzahl';
$string['settings_competence_evalpoints_limit_description'] = 'Wenn als Bewertungsschema "Punkte" gewählt ist.';
$string['settings_eval_setup'] = 'Bewertungsschema Texteintrag';
$string['settings_eval_setup_link'] = 'Bewertungskategorien bearbeiten';


// === grp3 ===
$string['total'] = 'Gesamtpunkte';
$string['project_based_total'] = 'Gesamtpunkte';
$string['html_report'] = 'Gesamtübersicht';
$string['download'] = 'Download';

// === events ===
$string['event_classcreated_name'] = 'Class created';
$string['event_classdeleted_name'] = 'Class deleted';
$string['event_classupdated_name'] = 'Class updated';
$string['event_classmemberassigned_name'] = 'User assigned to class';
$string['event_classmemberunassigned_name'] = 'User unassigned from class';
$string['event_classteacherassigned_name'] = 'Teacher assigned to class';
$string['event_classteacherunassigned_name'] = 'Teacher unassigned from class';
$string['event_classteacherchanged_name'] = 'Teacher changed';
$string['event_classdatachanged_name'] = 'Data of the class was changed';
$string['event_studentdatachanged_name'] = 'Data of the student was changed';
$string['event_subjectstudentdatachanged_name'] = 'Data of the student was changed for subject';
$string['event_classassessmentcategory_added_name'] = 'Assessment category was added to class';
$string['event_classassessmentcategory_deleted_name'] = 'Assessment category was deleted from class';
$string['event_periodcreated_name'] = 'Period created';
$string['event_perioddeleted_name'] = 'Period deleted';
$string['event_periodupdated_name'] = 'Period updated';
$string['event_competencecreated_name'] = 'Competence created';
$string['event_competenceupdated_name'] = 'Competence updated';
$string['event_competencedeleted_name'] = 'Competence deleted';
$string['event_gradingoptioncreated_name'] = 'Grading option created';
$string['event_gradingoptionupdated_name'] = 'Grading option updated';
$string['event_gradingoptiondeleted_name'] = 'Grading option deleted';
$string['event_educationplancreated_name'] = 'Education plan created';
$string['event_educationplanupdated_name'] = 'Education plan updated';
$string['event_educationplandeleted_name'] = 'Education plan deleted';
$string['event_subjectcreated_name'] = 'Subject created';
$string['event_subjectupdated_name'] = 'Subject updated';
$string['event_subjectdeleted_name'] = 'Subject deleted';
$string['event_studenthidden_name'] = 'Student hidden';
$string['event_studentshown_name'] = 'Student shown';
$string['event_studentreviewcategorychanged_name'] = 'Student category review changed';
$string['event_studentreviewchanged_name'] = 'Student review changed';
$string['event_classownerupdated_name'] = 'Class teacher updated';
$string['template_textarea_limits_error'] = 'Please use defined limits for textarea fields';
$string['gender'] = 'Geschlecht';
$string['it_is_my_class'] = 'Meine Klasse';
$string['classowner_changed_message'] = 'Sie haben die Klassenlehrkraft für die Klasse "{$a->classtitle}" erfolgreich geänder auf {$a->owner}. ';
$string['attention_owner_will_change'] = 'Achtung, wenn sie eine neue Klassenlehrkraft zuteilen, haben sie keine Rechte mehr diese Klasse zu bearbeiten.';
$string['classteacher_grade_interdisciplinary_competences'] = 'Klassenlehrkraft kann überfachliche Kompetenzen erfassen';
$string['subjectteacher_grade_interdisciplinary_competences'] = 'Fachlehrer kann überfachliche Kompetenzen erfassen';
$string['classteacher_grade_learn_and_social_behaviour'] = 'Klassenlehrkraft kann Lern- und Sozialverhalten erfassen';
$string['subjectteacher_grade_learn_and_social_behaviour'] = 'Fachlehrer kann Lern- und Sozialverhalten erfassen';
$string['class_settings_can_edit_crosscompetencies'] = 'kann überfachliche Kompetenzen erfassen';
$string['class_settings_can_edit_learnsocial'] = 'kann Lern- und Sozialverhalten erfassen:';
$string['class_settings_class_teacher'] = 'Klassenlehrkraft';
$string['class_settings_subject_teacher'] = 'Fachlehrer';
$string['settings_heading_security'] = 'Sicherheit';
$string['settings_heading_security_description'] = '';
$string['export_password_message'] = 'Bitte notieren Sie sich das Passwort "<strong>{$a}</strong>", bevor Sie fortfahren.<br/><br/>
		Hinweis: Passwortgeschützte zip-Dateien können unter Windows zwar geöffnet werden, aber die Dateien innerhalb der Zip-Datei können nur mit einem externen Programm (z.B. 7-Zip) extrahiert werden.
		';
$string['settings_export_class_password'] = 'Sicherung von Klassen mit Passwort schützen (AES-256 Verschlüsselung)';
$string['settings_export_class_report_password'] = 'Export von Klassenberichten mit Passwort schützen (AES-256 Verschlüsselung)';
$string['settings_export_class_report_password_description'] = '(Nur ab php Version 7.2 verfügbar)';
$string['backup_description'] = 'Hier können Sie alle Tabellen des Lernentwicklungsberichts im sql-Format sichern. Das Einspielen der Sicherung führen Sie bitte mit einem Datenbank-Tool wie z.B. phpMyAdmin durch.';
$string['backup_go'] = 'Datenbank jetzt sichern';
$string['block_settings'] = 'Blockeinstellungen';
$string['teacher_subject_role'] = 'Fachbezeichnung / Rolle';
$string['teacher_for_project'] = 'Lehrkraft für Projektprüfung';
$string['teacher_for_bilingual'] = 'Lehrkraft für Bilingualer';
$string['report_for_bilingual'] = 'Zeugnisformular für Bilingualer';
$string['textblock'] = 'Formulierungsvorschläge';
$string['learn_and_sociale'] = 'Lern- und Sozialverhalten';
$string['cross_competences_for_head'] = 'Überfachliche Kompetenzen';
$string['learn_and_sociale_for_head'] = 'Lern- und Sozialverhalten';
$string['learn_and_sociale_for_head2'] = 'Überfachliche Kompetenzen';
$string['textarea_max'] = 'Max.';
$string['textarea_rows'] = 'Zeilen';
$string['textarea_chars'] = 'Zeichen';
$string['textarea_charsleft'] = 'Zeichen verfügbar';
$string['textarea_linestomuch'] = 'Zeilen zuviel';
$string['textarea_charstomuch'] = 'Zeichen zuviel';
$string['textarea_maxchars'] = 'Gesamtzeichen';
$string['textarea_limit_notation'] = 'Damit der Text vollständig ausgegeben werden kann, können in der letzten Zeile nur {$a->chars_per_row} Zeichen erfasst werden.';
$string['attention_send_message_to_classteacher'] = 'Bitte <a id="exastud_link_to_class_teacher" href="{$a->messagehref}" target="_blank">benachrichtigen</a> Sie die neue Klassenlehrkraft über die Neuzuteilung.';
$string['attention_admin_cannot_be_classteacher'] = 'Klassen können nur als Klassenlehrkraft erstellt werden. Bitte loggen Sie sich als Klassenlehrkraft ein, um eine Klasse zu erstellen.';
$string['subject_category'] = 'Kategorie';
$string['subject_category_m'] = 'maßgebliches Fach';
//'subject_category_m_rs' => [
//    'maßgebliches Fach',
//    'relevant Subject'
//],
$string['subject_category_b'] = 'beste Note of "Fächer"';
$string['filter_fieldset'] = 'Filter';
$string['filter_search'] = 'Suche';
$string['filter_bp'] = 'BP';
$string['filter_empty'] = 'keine';
$string['filter_category'] = 'Kategorie';
$string['filter_button'] = 'Filter';
$string['clear_filter'] = 'Filter zurücksetzen';
$string['not_found_report'] = 'Keine Berichtsvorlagen vorhanden';
$string['filter_show_fulltable'] = 'Gesamt-Tabelle anzeigen';
$string['temporary_hidden'] = 'vorübergehend deaktiviert';
$string['add_class'] = 'Klasse hinzufügen';
$string['copy_class_from_last_period'] = 'Klasse vom vorigen Eingabezeitraum kopieren';
$string['import_class_from_backup'] = 'Klasse von Sicherung wiederherstellen';
$string['only_profilesubject_teacher'] = 'Nur Profilfach-Lehrkräfte können diesen Eintrag bearbeiten.';
$string['man'] = 'männlich';
$string['woman'] = 'weiblich';
$string['UMan'] = 'Männlich';
$string['UWoman'] = 'Weiblich';
$string['legend'] = 'Legende';
$string['ags'] = 'Arbeitsgemeinschaften';
$string['acronym'] = 'Fachkürzel';
$string['subject'] = 'Fach';
$string['teacher'] = 'Lehrer';
$string['review_student_other_data_header'] = 'Kopfteil';
$string['review_student_other_data_body'] = 'Fächer';
$string['review_student_other_data_footer'] = 'Fussteil';
$string['leaders'] = 'Unterzeichnende';
$string['schoollieder_fieldtitle'] = 'Schulleiterin';
$string['groupleader_fieldtitle'] = 'Lerngruppenbegleiter/-In';
$string['auditleader_fieldtitle'] = 'Vorsitzende(r) des Prüfungsausschusses';
$string['classleader_fieldtitle'] = 'Klassenlehrer/-In';
$string['classteacher'] = 'Klassenlehrer';
$string['subjectteacher_change_button'] = 'neue Lehrkraft zuordnen und Bewertungen übernehmen';
$string['subjectteacher_delete_button'] = 'Die Zuordnung dieser Lehrkraft zu diesem Fach aufheben.';
$string['form_subject_teacher_form_header'] = 'Fach an andere Lehrkraft übertragen';
$string['form_subject_teacher_form_description'] = 'Sie können das Fach {$a->subjecttitle} einer anderen Lehrkraft übertragen. Die bisherige Lehrkraft ist {$a->currentteacher_name}. Alle Eingaben und Bewertungen von {$a->currentteacher_name} werden der neuen Lehrkraft übertragen.';
$string['form_subject_teacher_form_select_new_teacher'] = 'Neue Lehrkraft für {$a->subjecttitle}';
$string['form_subject_teacher_form_select_new_teacher_docu'] = 'In der Auswahl sind Benutzer aufgelistet, welche in diversen Zusammenhängen die Lehrerrolle innehaben (Klassenlehrer, Kurslehrer, Klassenersteller, Fachlehrer, zusätzlicher Klassenlehrer, Projekt- oder bilungualer Lehrer)';
$string['form_subject_teacher_form_no_head_class_teacher'] = 'Diese Lehrkraft auch als Klassenlehrkraft ersetzen.';
$string['form_subject_teacher_form_save'] = 'Lehrkraft jetzt übertragen.';
$string['button_interdisciplinary_skills'] = 'Überfachliche Kompetenzen bearbeiten';
$string['profilesubject'] = 'Profilfach';
$string['select_another_class'] = 'Andere Klasse auswählen';
$string['this_category_related_to_classes'] = 'Diese Kategorie wird in folgenden Klassen verwendet';
$string['this_category_reviewed_for_student'] = 'Zu dieser Kategorie gibt es Schülerbeurteilungen';
$string['info_category_without_cross_competences'] = 'Bei der Kategorie {$a->categorytitles} - gibt es keine &#8221;Überfachlichen Kompetenzen&#8220; ';
$string['donotleave_page_message'] = 'Sie haben noch nicht gespeichert. Wollen sie diese Seite verlassen ohne die Änderungen zu speichern?';
$string['please_enter_group_name'] = 'Bitte geben Sie die Klassen/Lerngruppenbezeichnung ein!';
$string['mixed_bw_nonbw_class_error_2'] = 'Template für die Klasse wurde nicht gefunden. Möglicherweise wollen sie die Klasse verwenden ohne "exastud | bw_active" aktiviert zu haben';
$string['report_settings_userdata_wrong_user_parameter'] = 'Profilfeld \'{$a->fieldname}\' existiert nicht. Bitte erstellen sie das Profilfeld oder ändern sie die Zuordnung.';
$string['report_settings_userdata_wrong_user_parameter_editurl_title'] = 'Benutzerprofil ändern';
$string['report_settings_no_template_file'] = 'Keine Berichtsdatei: {$a->filename}';
$string['report_settings_userdata_wrong_user_parameter_in_reports_list'] = 'Der Bericht hat falsche Marker defíniert. Bitte ändern sie den Bericht entsprechend.';
$string['report_edit_userprofile'] = 'Edit user profile';
$string['report_userprofile_field_info'] = 'User\'s property.';
$string['report_edit_userprofile_noaccess'] = 'You have not privilege to edit user\'s profile';
$string['report_settings_group_title_default'] = 'Standardeinstellung';
$string['report_settings_group_title_classTeacher'] = 'Klassenlehrer Eingabefelder';
$string['report_settings_group_title_other'] = 'Weitere Felder';
$string['report_settings_group_description_default'] = 'Diese Markierungen sind bereits im Modul enthalten und werden mit den Werten der entsprechenden Eingabefelder befüllt, falls sie im Bericht enthalten sind.';
$string['report_settings_group_description_classTeacher'] = 'Felder, die von der Klassenlehrkraft ausgefüllt werden können';
$string['report_settings_group_description_other'] = '';
$string['parent'] = 'Parent';
$string['allow_review_until'] = 'Bearbeitung Freigeben bis';
$string['allow_review_admin_approved'] = 'bestätigt';
$string['allow_review_admin_notapproved_yet'] = 'noch nicht bestätigt';
$string['allow_review_admin_approved_for_all'] = 'für alle';
$string['allow_review_make_request'] = 'Anfrage an die Klassenlehrkraft stellen um das Bearbeiten dieser Klasse für 1 Tag freizuschalten.';
$string['allow_review'] = 'Bearbeiten freischalten';
$string['allow_review_make_request_already'] = 'Die Freischaltung dieser Klasse zur Bearbeitung wurde beim Klassenlehrer angefragt. Es ist noch keine Zustimmung durch die Klassenlehrkraft erfolgt.';
$string['requests'] = 'Benutzeranfragen';
$string['requests_class_delete_list'] = 'Klasse löschen';
$string['requests_class_title'] = 'Klasse';
$string['requests_class_teacher'] = 'Klassenlehrkraft';
$string['requests_class_delete'] = 'Löschen';
$string['requests_unlock_review_list'] = 'Aktivieren der Beurteilungsmöglichkeit von Klassen aus vergangenen Eingabezeiträumen';
$string['requests_unlock_requested_teacher'] = 'Anfrage von Lehrkraft';
$string['requests_unlock_request_until'] = 'bis';
$string['requests_unlock_approve_button'] = 'Zustimmen';
$string['requests_unlock_prolong_button'] = 'Freigabe verlängern (auf jetzt + 24h)';
$string['requests_unlock_delete_button'] = 'Ablehnen';
$string['requests_unlock_request_created'] = 'die Anfrage wurde erstellt';
$string['requests_no_any'] = 'Keine Benutzeranfragen vorhanden';
$string['requests_for_you'] = 'Es sind Systemnachrichten für sie vorhanden.';
$string['not_selected'] = 'keine';
$string['project_teacher_also_was_changed'] = '{$a->newteachername} ist auch neuer Projektprüfer anstatt {$a->oldteachername}';
$string['can_not_delete_subject_teacher_because_has_grading'] = 'Dieser Fachlehrer hat bereits Beurteilungen in diesem Fach abgegeben. Er kann nicht als Fachlehrer gelöscht werden, bitte nehmen sie stattdessen einen Fachlehrerwechsel vor.';
$string['more_student_data'] = 'Detaildaten auf/zuklappen';
$string['more_student_data_all'] = 'Gesamtdaten in der Liste anzeigen.';
$string['more_student_data_all_hide'] = 'Anzeige gekürzter Daten für alle Schüler';
$string['messageprovider:approve_allow_review'] = 'Freigabe der Klasse aus vorigem Eingabezeitraum verlängern.';
$string['messageprovider:prolong_allow_review'] = 'Freigabe der Klasse aus vorigem Eingabezeitraum verlängern.';
$string['notification_allow_review_old_class_approve_subject'] = '{$a->site}: Die Freigabe der Klasse "{$a->classtitle}" wurde bestätigt';
$string['notification_allow_review_old_class_approve_body'] = 'Sehr geehrte/r {$a->receiver}, </br></br>Die Klasse "{$a->classtitle}" wurde freigegeben bis {$a->datetime}.</br></br> Diese Nachricht wurde automatisch generiert von {$a->site}.';
$string['notification_allow_review_old_class_approve_context'] = 'Klasse aus vorigem Eingabezeitraum freigeben.';
$string['notification_allow_review_old_class_prolong_subject'] = '{$a->site}: Die Freigabe der Klasse "{$a->classtitle}" wurde verlängert.';
$string['notification_allow_review_old_class_prolong_body'] = 'Sehr geehrte/r {$a->receiver}, </br></br>Die Freigabe der Klasse "{$a->classtitle}" wurde verlängert {$a->datetime}.</br></br> Diese Nachricht wurde automatisch generiert. {$a->site}.';
$string['notification_allow_review_old_class_prolong_context'] = 'Klasse aus vorigem Eingabezeitraum freigeben';
$string['no_possible_inputs_in_report'] = 'Im Berichtskonfigurator sind keine "Klassenlehrer Eingabefelder" definiert. Deshalb ist hier keine Dateneingabe möglich';
$string['message_interdisciplinary_competences_notes_limit'] = 'Bitte tragen sie Noten von 1-{$a->limit} ein.';
$string['message_interdisciplinary_competences_points_limit'] = 'Bitte tragen sie Punkte von 0-{$a->limit} ein.';
$string['cross_competences_maintable_title_for_grade'] = 'Bewertungsschema: Note';
$string['cross_competences_maintable_title_for_points'] = 'Bewertungsschema: Punkte';
$string['cross_competences_maintable_title_for_texts'] = 'Bewertungsschema: Text-Eintrag';
$string['review_class_averages'] = 'Schnittberechnung';
$string['review_class_average_value'] = 'Notenschnitt';
$string['review_class_average_not_calculated'] = 'Es wurde noch keine Schnittberechnung durchgeführt.';
$string['average_calculate_table_student'] = 'Student';
$string['average_calculate_table_subjecttype'] = 'Typ';
$string['average_calculate_table_factor'] = 'Faktor';
$string['average_calculate_table_grading'] = 'Beurteilung';
$string['average_calculate_table_summ'] = 'Summe';
$string['average_calculate_table_average'] = 'Schnitt';
$string['average_calculate_table_average_project_title'] = 'Projektarbeit / Projektprüfung';
$string['average_calculate_button'] = 'Berechnen';
$string['average_export_button'] = 'Export';
$string['average_needs_calculate'] = 'Bitte berechnen Sie die durchschnittliche Bewertung für den Schüler.';
$string['average_needs_calculate_for_student'] = 'Bitte führen Sie zuerst beim Schüler / bei der Schülerin {$a->studentname} eine Berechnung des Notenschnittes durch.';
$string['report_averages_title'] = 'Durchschnitt';
$string['report_averages_header_subjects'] = 'Fächer';
$string['report_averages_header_student'] = 'Schüler/in';
$string['report_averages_header_type'] = 'Type';
$string['report_averages_header_factor'] = 'Faktor';
$string['report_averages_header_grading'] = 'Beurteilung';
$string['report_averages_header_sum'] = 'Summe';
$string['report_averages_header_average'] = 'Durchschnitt';
$string['certificate_issue_date_missed_message'] = 'Es wurde noch kein Zeugnisausgabedatum angegeben. Der Administrator sollte zur korrekten Ausgabe des Zeugnisses das Zeugnisausgabedatum angeben.';
$string['reports_overviews'] = 'Übersichten';
$string['reports_certs_and_attachments'] = 'Zeugnisse und Anlagen';
$string['report_screen'] = 'Bildschirm';
$string['report_file'] = 'Datei';
$string['report_overview_xlsx'] = 'Notenübersicht (xlsx)';
$string['report_overview_docx'] = 'Notenübersicht (docx)';
$string['report_column_template'] = 'Zeugnisformular';
$string['Template'] = 'Zeugnis';
$string['Template_and_departure'] = 'Zeugnis / Abgangszeugnis';
$string['report_column_enddate'] = 'Ausgeschieden';
$string['not_defined'] = 'nicht gewählt';
$string['No_suggestions'] = 'Keine Vorschläge gefunden';
$string['no_project_examination_for_project'] = 'Projektprüfung für Formular \'{$a}\' nicht verfügbar';
$string['allow_reviewing'] = 'Bewertung erneut freigeben';
$string['prof_skills'] = 'Fachkompetenzen';
$string['hidden_students'] = 'Ausgeblendete Schüler';
$string['assigned_to'] = 'Zugeteilt zu {$a}';
$string['template_with_no_inputs'] = 'Dieses Formular hat keine weiteren Eingabfelder';
$string['old_subjects'] = 'Alte Fächer';
$string['class_group'] = 'Klasse/Lerngruppe';
$string['clas_group_add_students'] = 'Schüler hinzufügen';
$string['class_import_button'] = 'Prüfen';
$string['class_import_button_confirm'] = 'Jetzt Importieren';
$string['file_not_found'] = 'Keine Datei gefunden';
$string['file_not_selected'] = 'Keine Datei ausgewählt';
$string['file_is_wrong_format'] = 'Datei hat falsches Format';
$string['file_is_not_class_backup'] = 'Datei ist keine Sicherung einer Klasse';
$string['file_version_wrong'] = 'Das Dateiformat ist leider nicht mit dieser Version des Lernentwicklungsberichts kompatibel';
$string['wrong_password'] = 'Falsches Passwort';
$string['classname'] = 'Klassenname';
$string['import_class_already_exist'] = 'Klasse "{$a}" existiert bereits und wird überschrieben';
$string['import_evaluation_will_overwrite'] = 'Es wird eine Bewertung überschrieben (Typ: {$a->type}, Lehrer: {$a->teacher})';
$string['import_class_restored'] = 'Klasse "{$a}" wurde wiederhergestellt';
$string['import_class_checked_success'] = 'Klassendaten erfolgreich geprüft';
$string['import_class'] = 'Klasse Importieren';
$string['import_class_reviewsimport'] = 'Bewertung importieren';
$string['bp_title'] = 'Bezeichnung';
$string['bp_shorttitle'] = 'Kurzbezeichnung';
$string['bp_leb_always_print'] = 'Immer im LEB drucken';
$string['last_edited_by'] = 'Letzte Änderung von {$a->name} am {$a->time}';
$string['no_other_users_found'] = 'Keine anderen Benutzer gefunden';
$string['copy_class'] = 'Klasse kopieren';
$string['copy_class_new_title'] = 'Kopie von {$a}';
$string['class_add_students_from_group_description'] = 'Schüler, die in ihrem Nutzerprofil im Bereich "weitere Profileinstellungen" im Feld Klasse/Lerngruppe den entsprechenden Eintrag haben zur Klasse hinzufügen.';
