<?php
// This file is part of Exabis Student Review
//
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>
//
// Exabis Student Review is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This script is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You can find the GNU General Public License at <http://www.gnu.org/licenses/>.
//
// This copyright notice MUST APPEAR in all copies of the script!

// shown in admin plugin list
$string['pluginname'] = 'Exabis Student Review';
// shown in block title and all headers
$string['blocktitle'] = 'Student Review';


// === grp1 ===
$string['exastud:use'] = 'Use of Exabis Student Review';
$string['exastud:editperiods'] = 'Edit periods';
$string['exastud:admin'] = 'Administrator';
$string['exastud:uploadpicture'] = 'Upload logo';
$string['exastud:addinstance'] = 'Add Exabis Student Review to the course';
$string['exastud:myaddinstance'] = 'Add Exabis Student Review on My home';


// === grp2 ===
$string['head_teacher'] = 'Head teacher';
$string['head_teachers'] = 'Class teachers';
$string['head_teachers_description'] = 'Can create classes, assign teachers and students and view the learning development report';
$string['new_head_teacher'] = 'New class teachers';
$string['additional_head_teacher'] = 'Additional class teacher';
$string['additional_head_teachers'] = 'Additional class teachers';
$string['configuration_classes'] = 'Classes';
$string['configuration_classes_onlyadmin'] = 'Admin access';
$string['project_based_configuration'] = 'Edit project';
$string['report'] = 'Report';
$string['reports'] = 'Reports';
$string['reports_server_notification'] = 'If the report is not generated correctly, it could indicate an excessive amount of data or a server setting that is too low. Please contact the administrator of the server in this case.';
$string['periods'] = 'Periods';
$string['review'] = 'Review';
$string['review_button'] = 'Review';
$string['pictureupload'] = 'Logo Upload';
$string['upload_picture'] = 'You can upload a logo for a school-specific report';
$string['upload_success'] = 'The new logo was uploaded successfully!';
$string['availableusers'] = 'Available Users';
$string['teachers'] = 'Teachers';
$string['teachers_options'] = 'Teacher Options';
$string['project_based_teachers'] = 'Project-Teachers';
$string['attention_plan_will_change'] = 'Please note: if the education plan is changed, all ratings must be re-entered';
$string['attention_template_will_change'] = 'Please note: changing the standard certificate form will change the certificate form for all students.';
$string['class_info'] = 'Edit Class';
$string['export_class'] = 'Backup assessment data of class';
$string['export_class_password_message'] = 'Please remember the password "<strong>{$a}</strong>" before proceeding';
$string['students'] = 'Students';
$string['studentgradereports'] = 'Grade Reports';
$string['no_entries_found'] = 'No Entries found';
$string['project_based_students'] = 'Projects';
$string['errorinsertingclass'] = 'Error when inserting class';
$string['redirectingtoclassinput'] = 'No class information found, redirecting to class input.';
$string['project_based_redirectingtoclassinput'] = 'No project information found, redirecting to project input.';
$string['errorupdatingclass'] = 'Error when updating class';
$string['project_based_errorupdatingclass'] = 'Error when updating project';
$string['editclassmemberlist'] = 'Edit student list';
$string['add_class_from_course'] = 'Add from Course';
$string['project_based_editclassmemberlist'] = 'Edit project list';
$string['editclassteacherlist'] = 'Edit teacher list';
$string['project_based_editclassteacherlist'] = 'Edit teacher list';
$string['editclassname'] = 'Edit class';
$string['project_based_editclassname'] = 'Edit project';
$string['editclasscategories'] = 'Edit assessment categories';
$string['noclassfound'] = 'No class found!';
$string['project_based_noclassfound'] = 'No project found!';
$string['configteacher'] = 'Teachers in {$a}';
$string['project_based_configteacher'] = 'Teachers in {$a}';
$string['configmember'] = 'Students of {$a}';
$string['project_based_configmember'] = 'Students of {$a}';
$string['configcategories'] = 'Assessment categories in {$a}';
$string['errorinsertingstudents'] = 'Error occured when adding student to a course';
$string['errorinsertingcategories'] = 'Error occured when adding categorie to a course';
$string['errorremovingstudents'] = 'Error occured when removing student from a course';
$string['errorremovingcategories'] = 'Error occured when removing categories from a course';
$string['back'] = 'Back';
$string['periodinput'] = 'Periods input';
$string['redirectingtoperiodsinput'] = 'No period information found, redirecting to periods input';
$string['perioddescription'] = 'Description';
$string['starttime'] = 'Start time';
$string['endtime'] = 'End time';
$string['newperiod'] = 'New period';
$string['invalidperiodid'] = 'Invalid period-ID';
$string['certificate_issue_date'] = 'Certificate Issue Date';
$string['certificate_issue_date_class'] = 'Certificate Issue Date';
$string['noclassestoreview'] = 'No classes to review';
$string['project_based_noclassestoreview'] = 'No projects to review';
$string['class'] = 'Class';
$string['class_title_limit_message'] = 'Max. {$a} chars.';
$string['class_title_for_report'] = 'Class name in Report';
$string['class_title_for_report_description'] = 'This class title is used in reports. If this field is empty, in reports the title of class above is used';
$string['class_educationplan'] = 'Educational plan';
$string['class_default_template'] = 'Default template';
$string['class_owner'] = 'Current class teacher';
$string['class_logo'] = 'Class logo';
$string['school_logo'] = 'School logo';
$string['school_logo_description'] = 'Maximum size of image: {$a->width}x{$a->height} pixels';
$string['class_delete'] = 'Delete class';
$string['project_based_class'] = 'Project';
$string['reviewclass'] = 'Class review';
$string['project_based_reviewclass'] = 'Project review';
$string['badclass'] = 'You cannot edit this class';
$string['project_based_badclass'] = 'You cannot edit this project';
$string['nostudentstoreview'] = 'No students to review';
$string['reviewstudent'] = 'Student review';
$string['categories'] = 'Assessment categories';
$string['addallbasic'] = 'Add basic categories';
$string['addallbasicalways'] = 'Add all new basic categories automatically';
$string['basiccategories'] = 'Basic categories';
$string['availablecategories'] = 'Available assessment categories';
$string['teamplayer'] = 'Team player';
$string['responsibility'] = 'Responsibility';
$string['selfreliance'] = 'Self-reliance';
$string['evaluation'] = 'Evaluation';
$string['badstudent'] = 'The student is not member of this class';
$string['project_based_badstudent'] = 'The student is not member of this project';
$string['errorupdatingstudent'] = 'Error occured when updating student';
$string['errorinsertingstudent'] = 'Error occured when inserting student';
$string['nostudentstoreport'] = 'No students to report';
$string['nostudentsfound'] = 'No students found';
$string['errorstarttimebeforeendtime'] = 'Period {$a->description} has a start time before an end time!';
$string['printversion'] = 'Print version';
$string['printall'] = 'Print all';
$string['periodoverlaps'] = 'Period {$a->period1} overlaps with {$a->period2}';
$string['periodserror'] = 'Error with the configuration of periods';
$string['evaluation1'] = '1 - insufficient';
$string['evaluation2'] = '2';
$string['evaluation3'] = '3';
$string['evaluation4'] = '4';
$string['evaluation5'] = '5';
$string['evaluation6'] = '6';
$string['evaluation7'] = '7';
$string['evaluation8'] = '8';
$string['evaluation9'] = '9';
$string['evaluation10'] = '10 - very good';
$string['explainclassname'] = 'Edit class name here';
$string['project_based_explainclassname'] = 'Click here to edit the project name';
$string['showall'] = 'Show all';
$string['logosize'] = 'For efficient use the logo banner must be 840x100px. Please avoid using transparency in PNG files as they may cause an error while creating a PDF report.';
$string['detailedreview'] = 'Detailed review';
$string['studentreview'] = 'STUDENT REVIEW';
$string['project_based_studentreview'] = 'PROJECT REVIEW';
$string['name'] = 'Name';
$string['periodreview'] = 'Review for period';
$string['reviewcount'] = ' review(s) yet';
$string['print'] = 'Print';
$string['perioddesc'] = 'Description of the period: ';
$string['noperiods'] = 'There is no assessment-period defined yet. Please contact the administrator.';
$string['commentshouldnotbeempty'] = 'You have to enter a comment.';
$string['report_template'] = 'Template';
$string['report_preview'] = 'Preview';
$string['report_select_all'] = 'Select all';
$string['select_all'] = 'Select all';
$string['hide_all'] = 'Hide all';
$string['show_all'] = 'Show all';
$string['report_delete'] = 'Delete report: {$a}';
$string['report_delete_confirm_message'] = 'Are you sure that you want to delete report "{$a}"';
$string['report_selectdeselect_all'] = 'Select/Deselect all';
$string['report_settings'] = 'Report settings';
$string['report_settings_edit'] = 'Report configurations';
$string['report_settings_new'] = 'New report configuration';
$string['report_settings_setting_id'] = '';
$string['report_settings_setting_title'] = 'Title';
$string['report_settings_setting_bp'] = 'Curriculum';
$string['report_settings_setting_hidden'] = 'Hidden';
$string['report_settings_setting_rs_hs'] = 'RS/HS category';
$string['report_settings_setting_category'] = 'Category';
$string['report_settings_setting_template'] = 'Template';
$string['report_settings_setting_grades'] = 'Grades';
$string['report_settings_setting_year'] = 'School year';
$string['report_settings_setting_reportdate'] = 'Date for report card';
$string['report_settings_setting_studentname'] = 'First and second name';
$string['report_settings_setting_dateofbirth'] = 'Date of birth';
$string['report_settings_setting_placeofbirth'] = 'Place of birth';
$string['report_settings_setting_learninggroup'] = 'Learning group';
$string['report_settings_setting_class'] = 'Class';
$string['report_settings_setting_focus'] = 'Focus';
$string['report_settings_setting_learnsocialbehavior'] = 'Learning and social behavior';
$string['report_settings_setting_subjects'] = 'Subjects';
$string['report_settings_setting_comments'] = 'Comments';
$string['report_settings_setting_subjectelective'] = 'Elective subject';
$string['report_settings_setting_subjectprofile'] = 'Profile subject';
$string['report_settings_setting_projektthema'] = 'Project assessment';
$string['report_settings_setting_ags'] = 'Team';
$string['report_settings_setting_additional_params'] = 'Additional parameters';
$string['report_settings_no'] = 'no';
$string['report_settings_yes'] = 'yes';
$string['report_settings_countrows'] = '{$a} rows';
$string['report_settings_countinrow'] = 'with {$a} characters per row';
$string['report_settings_countinrow_short'] = '{$a} chars ';
$string['report_settings_maxchars_short'] = 'max {$a} chars';
$string['report_settings_maxchars'] = 'with a maximum of {$a} characters';
$string['report_settings_countrows_fieldtitle'] = 'Count of rows';
$string['report_settings_countinrow_fieldtitle'] = 'Characters per row';
$string['report_settings_maxchars_fieldtitle'] = 'Maximum of characters';
$string['report_settings_button_add_additional_param'] = 'Add a new parameter';
$string['report_settings_selectboxkey_fieldtitle'] = 'Key';
$string['report_settings_selectboxvalue_fieldtitle'] = 'Value';
$string['delete_parameter'] = 'Delete parameter';
$string['sort_parameter'] = 'Sort parameters (move)';
$string['move_here'] = 'Move here';
$string['delete'] = 'Delete';
$string['add'] = 'Add';
$string['report_setting_type_textarea'] = 'Textarea';
$string['report_setting_type_text'] = 'Text';
$string['report_setting_type_select'] = 'Select';
$string['report_setting_type_header'] = 'Header';
$string['report_setting_type_image'] = 'Picture';
$string['report_setting_type_image_maxbytes'] = 'Max size (bytes)';
$string['report_setting_type_image_width'] = 'Width';
$string['report_setting_type_image_height'] = 'Height';
$string['report_setting_type_userdata'] = 'Profile field';
$string['report_setting_type_userdata_datakey'] = 'Choose user\'s field';
$string['report_setting_type_matrix'] = 'Matrix';
$string['report_setting_type_matrix_type'] = 'Matrix type';
$string['report_setting_type_matrix_type_checkbox'] = 'Checkbox';
$string['report_setting_type_matrix_type_radio'] = 'Radio button';
$string['report_setting_type_matrix_type_text'] = 'Text';
$string['report_setting_type_matrix_row_titles'] = 'Row titles';
$string['report_setting_type_matrix_column_titles'] = 'Column titles';
$string['reset_report_templates'] = 'Reset default templates to default state';
$string['reinstall_report_templates'] = 'Reinstall all default templates';
$string['reset_report_selected_templates'] = 'Reset selected templates to default state';
$string['reset_report_templates_description'] = 'Are you sure? Default templates will be reset to default state. Custom templates will not be changed';
$string['report_setting_current_title'] = 'Current title';
$string['report_setting_current_file'] = 'Current template';
$string['report_setting_willbe_added'] = 'Does not exist now. Will be added.';
$string['report_button_import'] = 'Import reports';
$string['report_button_export'] = 'Export reports';
$string['report_export_selected_templates'] = 'Export selected';
$string['report_export_with_files'] = 'Add sources (files) of templates';
$string['report_export_update_reports'] = 'Update reports if existant';
$string['report_export_update_files'] = 'Update files if existant';
$string['report_import_templates'] = 'Import';
$string['report_import_file_shouldnotbeempty'] = 'File should not be empty.';
$string['report_import_inserted_list'] = 'These reports were inserted';
$string['report_import_updated_list'] = 'These reports were updated';
$string['report_import_ignored_list'] = 'These reports were ignored';
$string['report_settings_upload_new_filetemplate'] = 'Upload new template file';
$string['report_settings_upload_new_filetemplate_overwrite'] = 'Overwrite file if existant';
$string['upload_new_templatefile'] = 'Upload new template';
$string['hide_uploadform'] = 'Hide upload form';
$string['report_settings_copy'] = 'Copy report';
$string['report_settings_copy_newtitle'] = '{$a->title} - COPY !!!';
$string['report_settings_copy_done'] = 'Created a new report "{$a->newtitle}" (id: {$a->newid}) from "{$a->sourcetitle}" (id: {$a->sourceid})';
$string['select_student'] = 'Please select at least one student';
$string['not_enough_data_for_report'] = 'Not enough data for generating reports for selected students';
$string['review_table_part_subjects'] = 'Subjects';
$string['review_table_part_additional'] = 'General';
$string['review_table_part_subjectsfromother'] = 'From other subject teachers';
$string['additional_info'] = 'Additional info';
$string['settings_only_learnsoziale'] = 'Assessment of learning and social behavior only';
$string['settings_shoolname'] = 'Learning Development Report: School Name';
$string['settings_shooltype'] = 'Learning Development Report: School Type';
$string['settings_city'] = 'Learning Development Report: City';
$string['settings_edustandarts'] = 'Fulfillable educational standards';
$string['settings_edustandarts_description'] = 'Comma seperated list';
$string['settings_bw_reports'] = 'Use interdenominational schools reports';
$string['settings_exacomp_verbeval'] = 'Verbalized assessment from exabis competences';
$string['settings_exacomp_assessment_categories'] = 'Use competence grids for assessment categories';
$string['settings_sourceId'] = 'Source ID';
$string['settings_sourceId_description'] = 'Automatically generated ID of this Exastud installation. This ID can not be changed';
$string['settings_grade_interdisciplinary_competences'] = 'Show interdisciplinary competences to class teachers';
$string['report_learn_and_sociale'] = 'Learning and social behavior';
$string['report_cross_competences'] = 'Interdisciplinary competences';
$string['report_other_report_fields'] = 'Other report fields';
$string['report_report_fields'] = 'Report fields';
$string['report_bilinguales'] = 'Bilingual instruction';
$string['report_for_subjects'] = 'Certificate for profile subject';
$string['report_for_additional'] = 'Additional fields';
$string['report_report_eval'] = 'Project evaluations';
$string['review_project_evalueations'] = 'Project evaluations';
$string['report_student_template'] = 'Template';
$string['not_assigned'] = 'Not assigned';
$string['competencies'] = 'Interdisciplinary competences';
$string['Note'] = 'Grade';
$string['Niveau'] = 'Level';
$string['last_period'] = 'Last period:';
$string['periods_incorrect'] = 'Period defined is not correct';
$string['suggestions_from_exacomp'] = 'Grade suggestions from competence grid (exacomp)';
$string['grade_and_difflevel'] = 'Grade and difficulty level';
$string['load_last_period'] = 'Load last period';
$string['load_last_period_done'] = 'Last period is adapted';
$string['grading'] = 'Grading';
$string['Subjects'] = 'Subjects';
$string['education_plans'] = 'Educational Plans';
$string['de:Lernentwicklungsbericht: Schulname'] = 'Report: name of organization';
$string['de:Lernentwicklungsbericht: Ort'] = 'Report: city';
$string['de:Bildungsstandards'] = 'Fulfillable educational standards';
$string['de:Liste, mit Kommata getrennt'] = 'Comma seperated list';
$string['de:Lernentwicklungsbericht: Zeugnisausgabedatum'] = 'Report: date';
$string['delete_class_only_without_users'] = 'Only classes without students can be deleted';
$string['force_class_to_delete'] = 'Only classes without students can be deleted. But you can mark this class to deleting by site admin';
$string['already_marked'] = 'This class is already marked';
$string['mark_to_delete_go'] = 'Mark to delete by admin';
$string['unmark_to_delete_go'] = 'Unmark to delete by admin';
$string['unmark_to_delete_button'] = 'Unmark to delete';
$string['class_marked_as_todelete'] = 'This class marked to delete by site-admin';
$string['class_marked_as_todelete_hover'] = 'This class marked to delete by site admin. Click to redo deleting request.';
$string['interdisciplinary_competences'] = 'Interdisciplinary competences';
$string['average'] = 'Average';


// === settings ===
$string['settings_detailed_review'] = 'Detailed review';
$string['settings_detailed_review_body'] = 'This setting allows you to see all the assessments from teachers in detail';
$string['settings_project_based_assessment'] = 'Project based assessment';
$string['settings_project_based_assessment_body'] = 'This setting allows you to use project based assessment instead of class assessment';
$string['delete_confirmation'] = 'Do you really want to delete "{$a}"?';
$string['delete_subjectteacher_confirmation'] = 'Do you really want to delete this subject teacher?';
$string['delete_refuse_button'] = 'Refuse deletion';
$string['delete_class_refused'] = 'Refused';
$string['logging'] = 'Activate logging';
$string['settings_competence_evaltype'] = 'Assessment of competences is based on';
$string['settings_competence_evaltype_text'] = 'Text entry';
$string['settings_competence_evaltype_grade'] = 'Grades';
$string['settings_competence_evaltype_point'] = 'Points';
$string['settings_competence_evalpoints_limit'] = 'Maximum points for assessment type "points"';
$string['settings_competence_evalpoints_limit_description'] = 'If value of exastud/competence_evaltype is based upon points';
$string['settings_eval_setup'] = 'Assessment grading values';
$string['settings_eval_setup_link'] = 'Edit';


// === grp3 ===
$string['total'] = 'Total score';
$string['project_based_total'] = 'Total score';
$string['project_based_upload_picture'] = 'You can upload a logo for a project specific report';
$string['project_based_errorinsertingclass'] = 'Error occured while inserting project';
$string['html_report'] = 'Overview';
$string['download'] = 'Download';

// === events ===
$string['event_classcreated_name'] = 'Class created';
$string['event_classdeleted_name'] = 'Class deleted';
$string['event_classupdated_name'] = 'Class updated';
$string['event_classmemberassigned_name'] = 'User assigned to class';
$string['event_classmemberunassigned_name'] = 'User unassigned from class';
$string['event_classteacherassigned_name'] = 'Teacher assigned to class';
$string['event_classteacherunassigned_name'] = 'Teacher unassigned from class';
$string['event_classteacherchanged_name'] = 'Teacher changed';
$string['event_classdatachanged_name'] = 'Data of the class was changed';
$string['event_studentdatachanged_name'] = 'Data of the student was changed';
$string['event_subjectstudentdatachanged_name'] = 'Data of the student was changed for subject';
$string['event_classassessmentcategory_added_name'] = 'Assessment category was added to class';
$string['event_classassessmentcategory_deleted_name'] = 'Assessment category was deleted from class';
$string['event_periodcreated_name'] = 'Period created';
$string['event_perioddeleted_name'] = 'Period deleted';
$string['event_periodupdated_name'] = 'Period updated';
$string['event_competencecreated_name'] = 'Competence created';
$string['event_competenceupdated_name'] = 'Competence updated';
$string['event_competencedeleted_name'] = 'Competence deleted';
$string['event_gradingoptioncreated_name'] = 'Grading option created';
$string['event_gradingoptionupdated_name'] = 'Grading option updated';
$string['event_gradingoptiondeleted_name'] = 'Grading option deleted';
$string['event_educationplancreated_name'] = 'Educational plan created';
$string['event_educationplanupdated_name'] = 'Educational plan updated';
$string['event_educationplandeleted_name'] = 'Educational plan deleted';
$string['event_subjectcreated_name'] = 'Subject created';
$string['event_subjectupdated_name'] = 'Subject updated';
$string['event_subjectdeleted_name'] = 'Subject deleted';
$string['event_studenthidden_name'] = 'Student hidden';
$string['event_studentshown_name'] = 'Student shown';
$string['event_studentreviewcategorychanged_name'] = 'Student category assessment changed';
$string['event_studentreviewchanged_name'] = 'Student assessment changed';
$string['event_classownerupdated_name'] = 'Class teacher updated';
$string['template_textarea_limits_error'] = 'Please use defined limits for textarea fields';
$string['gender'] = 'Gender';
$string['it_is_my_class'] = 'My class';
$string['classowner_changed_message'] = 'You changed the class teacher "{$a->classtitle}" to {$a->owner}. So, you do not have access to edit this class from now!';
$string['attention_owner_will_change'] = 'Please note: if you will change the teacher of own class - you will not have access to edit this class!';
$string['classteacher_grade_interdisciplinary_competences'] = 'Class teacher can edit interdisciplinary competences';
$string['subjectteacher_grade_interdisciplinary_competences'] = 'Subject teacher can edit interdisciplinary competences';
$string['classteacher_grade_learn_and_social_behaviour'] = 'Class teacher can edit learning and social behaviour';
$string['subjectteacher_grade_learn_and_social_behaviour'] = 'Subject teacher can edit learning and social behavior ';
$string['class_settings_can_edit_crosscompetencies'] = 'can edit interdisciplinary competences';
$string['class_settings_can_edit_learnsocial'] = 'can edit learning and social competences';
$string['class_settings_class_teacher'] = 'Class teacher';
$string['class_settings_subject_teacher'] = 'Subject teacher';
$string['settings_heading_security'] = 'Security';
$string['settings_heading_security_description'] = '';
$string['export_password_message'] = 'Please remember the password "<strong>{$a}</strong>" before proceeding';
$string['settings_export_class_password'] = 'Passwort protection (AES-256 encryption) for class backups';
$string['settings_export_class_report_password'] = 'Passwort protection (AES-256 encryption) for class reports';
$string['settings_export_class_report_password_description'] = '(only available from php version 7.2 on)';
$string['backup_description'] = 'Create a backup of assessment data as an sql file. As an admin you can import this backup using a database tool like phpMyAdmin. Backups on teacher level are possible for their individual data.';
$string['backup_go'] = 'Backup Database now';
$string['block_settings'] = 'Settings';
$string['teacher_subject_role'] = 'Description of subject/role of teacher';
$string['teacher_for_project'] = 'Teacher for project assessment';
$string['teacher_for_bilingual'] = 'Teacher for bilingual assessment';
$string['report_for_bilingual'] = 'Report for bilingual assessment';
$string['textblock'] = 'Text block';
$string['learn_and_sociale'] = 'Learning and social behavior';
$string['cross_competences_for_head'] = 'Interdisciplinary competences';
$string['learn_and_sociale_for_head'] = 'Learning and social behavior';
$string['learn_and_sociale_for_head2'] = 'Learning and social behavior';
$string['textarea_max'] = 'Maximum';
$string['textarea_rows'] = 'Rows';
$string['textarea_chars'] = 'Characters';
$string['textarea_charsleft'] = 'Characters left';
$string['textarea_linestomuch'] = 'Lines too much';
$string['textarea_charstomuch'] = 'Characters too much';
$string['textarea_maxchars'] = 'All characters';
$string['textarea_limit_notation'] = 'To show full text in the Report, please do not type in more then {$a->chars_per_row} signs in the last row.';
$string['attention_send_message_to_classteacher'] = 'Do not forget to <a id="exastud_link_to_class_teacher" href="{$a->messagehref}" target="_blank">send a message</a> to the new class teacher about his new class';
$string['attention_admin_cannot_be_classteacher'] = 'Classes can only be defined in a class teacher role. Please log in as a class teacher to define a class.';
$string['subject_category'] = 'Category';
$string['subject_category_m'] = 'Relevant Subject';
//'subject_category_m_rs' => [
//    'maßgebliches Fach',
//    'relevant Subject'
//],
$string['subject_category_b'] = 'Best grade';
$string['filter_fieldset'] = 'Filter';
$string['filter_search'] = 'Title search';
$string['filter_bp'] = 'Curriculum';
$string['filter_empty'] = 'Empty';
$string['filter_category'] = 'Category';
$string['filter_button'] = 'Filter';
$string['clear_filter'] = 'Clear filters';
$string['not_found_report'] = 'No any report found';
$string['filter_show_fulltable'] = 'Show full table';
$string['temporary_hidden'] = 'Temporarily unavailable';
$string['add_class'] = 'Add Class';
$string['copy_class_from_last_period'] = 'Copy Class from last Period';
$string['import_class_from_backup'] = 'Import class from backup';
$string['only_profilesubject_teacher'] = 'Only profile subject\'s teacher can edit';
$string['man'] = 'male';
$string['woman'] = 'female';
$string['UMan'] = 'Male';
$string['UWoman'] = 'Female';
$string['legend'] = 'Key';
$string['ags'] = 'Working groups';
$string['acronym'] = 'Acronym';
$string['subject'] = 'Subject';
$string['teacher'] = 'Teacher';
$string['review_student_other_data_header'] = 'Header';
$string['review_student_other_data_body'] = 'Body';
$string['review_student_other_data_footer'] = 'Footer';
$string['leaders'] = 'Signatures';
$string['schoollieder_fieldtitle'] = 'School principal';
$string['groupleader_fieldtitle'] = 'Learning group tutor';
$string['auditleader_fieldtitle'] = 'Chairman of the Audit Committee';
$string['classleader_fieldtitle'] = 'Head of class';
$string['classteacher'] = 'Class teacher';
$string['subjectteacher_change_button'] = 'Match a new teacher and transmit his grading';
$string['subjectteacher_delete_button'] = 'Delete relation of this teacher and subject';
$string['form_subject_teacher_form_header'] = 'Transfer subject to other teacher';
$string['form_subject_teacher_form_description'] = 'You can transfer the subject {$a->subjecttitle} to another teacher. The current teacher is {$a->currentteacher_name}. All gradings from {$a->currentteacher_name} are transferred to new teacher.';
$string['form_subject_teacher_form_select_new_teacher'] = 'New teacher for {$a->subjecttitle}';
$string['form_subject_teacher_form_select_new_teacher_docu'] = 'In this Dropdown Users are listed, who have a teacher role in some context (classteacher, teacher in this course, classowner, teacher in a subject, additional class teacher, teacher for project, bilingual teacher)';
$string['form_subject_teacher_form_no_head_class_teacher'] = 'Also remove from head class teacher';
$string['form_subject_teacher_form_save'] = 'Transfer subject now.';
$string['button_interdisciplinary_skills'] = 'Interdisciplinary skills';
$string['profilesubject'] = 'Profile subject';
$string['select_another_class'] = 'Select another class';
$string['this_category_related_to_classes'] = 'This category is related to class';
$string['this_category_reviewed_for_student'] = 'This category has been reviewed for some students';
$string['info_category_without_cross_competences'] = 'if category is {$a->categorytitles} - this report does not have &#8221;interdisciplinary competences&#8220; ';
$string['donotleave_page_message'] = 'You have unsaved changes on this page. Do you want to leave this page and discard your changes or stay on this page?';
$string['please_enter_group_name'] = 'Please enter the class/group name!';
$string['mixed_bw_nonbw_class_error_2'] = 'Template for class not found. Please check the option of interdenominational schools - "exastud | bw_active"';
$string['report_settings_userdata_wrong_user_parameter'] = 'User profile field \'{$a->fieldname}\' does not exist. Create it or change value to existing field.';
$string['report_settings_userdata_wrong_user_parameter_editurl_title'] = 'Edit user profile fields';
$string['report_settings_no_template_file'] = 'No template file: {$a->filename}';
$string['report_settings_userdata_wrong_user_parameter_in_reports_list'] = 'This report has wrong userdata markers. Please edit this report to resolve this error.';
$string['report_edit_userprofile'] = 'Edit user profile';
$string['report_userprofile_field_info'] = 'User\'s property.';
$string['report_edit_userprofile_noaccess'] = 'You do not have the rights to edit user\'s profile';
$string['report_settings_group_title_default'] = 'Default';
$string['report_settings_group_title_classTeacher'] = 'For class teacher';
$string['report_settings_group_title_other'] = 'Additional fields';
$string['report_settings_group_description_default'] = 'These markers are fixed and will be filled with own values if they are in the report';
$string['report_settings_group_description_classTeacher'] = 'Fields to be filled in by the class teacher';
$string['report_settings_group_description_other'] = '';
$string['parent'] = 'Parent';
$string['allow_review_until'] = 'until';
$string['allow_review_admin_approved'] = 'approved';
$string['allow_review_admin_notapproved_yet'] = 'not approved yet';
$string['allow_review_admin_approved_for_all'] = 'for all';
$string['allow_review_make_request'] = 'make a request to admin for unlock editing';
$string['allow_review'] = 'unlock editing';
$string['allow_review_make_request_already'] = 'already requested for unlock editing';
$string['requests'] = 'System requests';
$string['requests_class_delete_list'] = 'Classes delete';
$string['requests_class_title'] = 'Class';
$string['requests_class_teacher'] = 'Class teacher';
$string['requests_class_delete'] = 'Delete';
$string['requests_unlock_review_list'] = 'Unlock to review';
$string['requests_unlock_requested_teacher'] = 'request for teacher';
$string['requests_unlock_request_until'] = 'until';
$string['requests_unlock_approve_button'] = 'Approve';
$string['requests_unlock_prolong_button'] = 'Prolong';
$string['requests_unlock_delete_button'] = 'Refuse';
$string['requests_unlock_request_created'] = 'Request created';
$string['requests_no_any'] = 'No any requests';
$string['requests_for_you'] = 'There are System Requests for you';
$string['not_selected'] = 'Empty';
$string['project_teacher_also_was_changed'] = '{$a->newteachername} also got Project Teacher instead of {$a->oldteachername}';
$string['can_not_delete_subject_teacher_because_has_grading'] = 'This subjectteachers have done grading in this class in this subject. It is not possible to delete him as subject teacher. Please change subject teacher in this case.';
$string['more_student_data'] = 'Show more data';
$string['more_student_data_all'] = 'Show more data for all students';
$string['more_student_data_all_hide'] = 'Hide detail data for all students';
$string['messageprovider:approve_allow_review'] = 'Approve of review of class from old period';
$string['messageprovider:prolong_allow_review'] = 'Prolong of review of class from old period';
$string['notification_allow_review_old_class_approve_subject'] = '{$a->site}: Review of class "{$a->classtitle}" was approved';
$string['notification_allow_review_old_class_approve_body'] = 'Dear {$a->receiver}, </br></br>Review of class "{$a->classtitle}" was approved until {$a->datetime}.</br></br> This message has been generated automatically from moodle site {$a->site}.';
$string['notification_allow_review_old_class_approve_context'] = 'Allow review class from old period';
$string['notification_allow_review_old_class_prolong_subject'] = '{$a->site}: Review of class "{$a->classtitle}" was prolonged';
$string['notification_allow_review_old_class_prolong_body'] = 'Dear {$a->receiver}, </br></br>Review of class "{$a->classtitle}" was prolonged to {$a->datetime}.</br></br> This message has been generated automatically from moodle site {$a->site}.';
$string['notification_allow_review_old_class_prolong_context'] = 'Allow review class from old period';
$string['no_possible_inputs_in_report'] = 'No fields defined in Report Configurator. No data input possible';
$string['message_interdisciplinary_competences_notes_limit'] = 'Please enter grades 1-{$a->limit}.';
$string['message_interdisciplinary_competences_points_limit'] = 'Please enter Point 0-{$a->limit}.';
$string['cross_competences_maintable_title_for_grade'] = 'Gradingscheme: Grade';
$string['cross_competences_maintable_title_for_points'] = 'Gradingscheme: Points';
$string['cross_competences_maintable_title_for_texts'] = 'Gradingscheme: Text entry';
$string['review_class_averages'] = 'Averages calculation';
$string['review_class_average_value'] = 'Average value';
$string['review_class_average_not_calculated'] = 'no average grading calculated';
$string['average_calculate_table_student'] = 'Student';
$string['average_calculate_table_subjecttype'] = 'type';
$string['average_calculate_table_factor'] = 'Factor';
$string['average_calculate_table_grading'] = 'Grading';
$string['average_calculate_table_summ'] = 'Summe';
$string['average_calculate_table_average'] = 'Average';
$string['average_calculate_table_average_project_title'] = 'Projektarbeit / Projektprüfung';
$string['average_calculate_button'] = 'Calculate';
$string['average_export_button'] = 'Export';
$string['average_needs_calculate'] = 'Please make calculation of average grading for student';
$string['average_needs_calculate_for_student'] = 'Please make calculation of average grading for student {$a->studentname}.';
$string['report_averages_title'] = 'Averages';
$string['report_averages_header_subjects'] = 'Subjects';
$string['report_averages_header_student'] = 'Student';
$string['report_averages_header_type'] = 'Type';
$string['report_averages_header_factor'] = 'Factor';
$string['report_averages_header_grading'] = 'Grading';
$string['report_averages_header_sum'] = 'Sum';
$string['report_averages_header_average'] = 'Average';
$string['certificate_issue_date_missed_message'] = 'No certificate issue date has yet been specified. The administrator should input the Certificate Issue Date for generating the certificate correctly.';
$string['reports_overviews'] = 'Overviews';
$string['reports_certs_and_attachments'] = 'Certificates and attachments';
$string['report_screen'] = 'Screen';
$string['report_file'] = 'File';
$string['report_overview_xlsx'] = 'Overview of grades (xlsx)';
$string['report_overview_docx'] = 'Overview of grades (docx)';
$string['report_column_template'] = 'Certificate form';
$string['Template'] = 'Certificate';
$string['Template_and_departure'] = 'Certificate / Certificate of Departure';
$string['report_column_enddate'] = 'Dropped out';
$string['not_defined'] = 'not defined';
$string['No_suggestions'] = 'No suggestions found';
$string['no_project_examination_for_project'] = 'Project examination for form \'{$a}\' not available';
$string['allow_reviewing'] = 'Allow reviewing this class';
$string['prof_skills'] = 'Professional skills';
$string['hidden_students'] = 'Hidden students';
$string['assigned_to'] = 'Assigned to {$a}';
$string['template_with_no_inputs'] = 'This template has no further input fields';
$string['old_subjects'] = 'Old subjects';
$string['class_group'] = 'Class group';
$string['clas_group_add_students'] = 'Add students';
$string['class_import_button'] = 'Check';
$string['class_import_button_confirm'] = 'Import now';
$string['file_not_found'] = 'File not found';
$string['file_not_selected'] = 'File not selected';
$string['file_is_wrong_format'] = 'The file is in the wrong format';
$string['file_is_not_class_backup'] = 'The file is not a backup of a Class';
$string['file_version_wrong'] = 'Unfortunately, the file format is not compatible with this version of assessment data';
$string['wrong_password'] = 'Wrong password';
$string['classname'] = 'Class name';
$string['import_class_already_exist'] = 'Class "{$a}" already exists and will be overwritten';
$string['import_evaluation_will_overwrite'] = 'An evaluation will be overwritten (Type: {$a->type}, Teacher: {$a->teacher})';
$string['import_class_restored'] = 'Class "{$a}" has been restored';
$string['import_class_checked_success'] = 'Class data checked successfully';
$string['import_class'] = 'Import class';
$string['import_class_reviewsimport'] = 'Import reviews';
$string['bp_title'] = 'Name';
$string['bp_shorttitle'] = 'Shortname';
$string['bp_leb_always_print'] = 'Always print';
$string['last_edited_by'] = 'Last Change by {$a->name} on {$a->time}';
$string['no_other_users_found'] = 'No other users found';
$string['copy_class'] = 'Copy Class';
$string['copy_class_new_title'] = 'Copy of {$a}';
$string['class_add_students_from_group_description'] = 'Students from this class group (see student user profile) will be added to the class';
