/**
 * Module to display and manage reactions and difficulty tracks on course page.
 * @copyright  2020 Quentin Fombaron, 2021 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_point_view/script_point_view",["jquery","core/ajax","core/notification"],(function($,ajax,notification){function $get(moduleId,selector){var $element=$("#module-"+moduleId+" .block_point_view.reactions-container");return void 0===selector?$element:$element.find(selector)}var Reactions={none:0,easy:1,better:2,hard:3},reactionVotedArray={};function setUpReactions(root,courseId,modulesWithReactions,reactionsHtml,pixSrc,cmid){modulesWithReactions.forEach((function(module){var moduleId=parseInt(module.cmid),moduleRoot=root.querySelector("#module-"+moduleId);if(moduleRoot||module.cmid===cmid){var uservote=parseInt(module.uservote);if(reactionVotedArray[moduleId]=uservote,module.cmid===cmid&&$('<div id="module-'+moduleId+'" class="activity-wrapper mr-5" style="width: 165px;">').insertAfter($(".header-actions-container")).prepend('<div class="activity-instance">'),0===$get(moduleId).length){var $module=$(moduleRoot);if($module.is(".modtype_label"))$module.find(".activity-grid").is(".noname-grid")&&$module.find(".activity-altcontent").length?$module.find(".activity-altcontent").css("display","flex").append(reactionsHtml):$module.find(".description, .activity-grid").first().before(reactionsHtml);else if($module.find(".activity-name-area").length){var $reactions=$(reactionsHtml);$module.find(".activity-groupmode-info, .activity-completion").length||$reactions.addClass("lastofline"),$module.find(".activity-name-area").append($reactions)}else $module.find(".tiles-activity-container").length?$module.find(".tiles-activity-container").after(reactionsHtml):$module.find(".activity-instance").after(reactionsHtml);var reactionsLock=!1;$get(moduleId,".reaction img").click((function(){!1===reactionsLock&&(reactionsLock=!0,function(courseId,moduleId,reactionName){var reactionSelect=Reactions[reactionName],previousReaction=reactionVotedArray[moduleId],newVote=reactionSelect===previousReaction?Reactions.none:reactionSelect;return ajax.call([{methodname:"block_point_view_update_db",args:{func:"update",courseid:courseId,cmid:moduleId,vote:newVote}}])[0].done((function(){(reactionVotedArray[moduleId]=newVote,previousReaction!==Reactions.none)&&updateReactionNb(moduleId,["","easy","better","hard"][previousReaction],-1,!1);newVote!==Reactions.none&&updateReactionNb(moduleId,reactionName,1,!0)})).fail(notification.exception)}(courseId,moduleId,$(this).data("reactionname")).always((function(){reactionsLock=!1,updateGroupImgAndNb(moduleId,pixSrc)})))})),$get(moduleId,".reactionnb").each((function(){var reactionName=$(this).data("reactionname"),reactionNb=parseInt(module["total"+reactionName]);updateReactionNb(moduleId,reactionName,reactionNb,uservote===Reactions[reactionName])})),updateGroupImgAndNb(moduleId,pixSrc),function(moduleId){var reactionImageSizeForRatio=function(ratio){return{top:15-10*ratio,left:10-10*ratio,height:20*ratio}},groupImageSizeForRatio=function(ratio){return{left:10*ratio-10,height:20*ratio}},$moduleInteractionsToHide=$("#module-"+moduleId+' button[data-action="toggle-manual-completion"],#module-'+moduleId+" .activity-info .automatic-completion-conditions > span.badge:first-of-type,#module-"+moduleId+' .activity-information [data-region="completionrequirements"],#module-'+moduleId+" .activity-grid > .activity-completion,#module-"+moduleId+" .activity-groupmode-info"),showReactions=function(){$get(moduleId,".reactions").removeClass("invisible"),$get(moduleId,".group_img").css({"pointer-events":"none"}).animate(groupImageSizeForRatio(0),300).hide(0),$get(moduleId,".group_nb").delay(200).hide(300),$moduleInteractionsToHide.delay(200).queue((function(next){$(this).css({opacity:0,transition:"opacity 0.3s ease-in-out"}),next()})).delay(300).queue((function(next){$(this).addClass("invisible"),next()})),["easy","better","hard"].forEach((function(reaction,index){var delay=50+150*index;$get(moduleId,'.reaction img[data-reactionname="'+reaction+'"]').delay(delay).animate(reactionImageSizeForRatio(1),300).css({"pointer-events":"auto"}),$get(moduleId,'.reactionnb[data-reactionname="'+reaction+'"]').delay(delay+300).queue((function(next){$(this).removeClass("invisible"),next()}))}))},hideReactions=function(){["hard","better","easy"].forEach((function(reaction,index){var delay=50+250*index;$get(moduleId,'.reaction img[data-reactionname="'+reaction+'"]').css({"pointer-events":"none"}).delay(delay).animate(reactionImageSizeForRatio(0),500),$get(moduleId,'.reactionnb[data-reactionname="'+reaction+'"]').delay(delay).queue((function(next){$(this).addClass("invisible"),next()}))})),$get(moduleId,".group_img").delay(500).show(0).animate(groupImageSizeForRatio(1),300).queue((function(next){$get(moduleId,".reactions").addClass("invisible"),next()})).css({"pointer-events":"auto"}),$get(moduleId,".group_nb").delay(600).show(0),$moduleInteractionsToHide.delay(600).queue((function(next){$(this).removeClass("invisible"),$(this).css({opacity:1,transition:"opacity 0.3s ease-in-out"}),next()}))},reactionsVisible=!1,groupTimeout=null,reactionsTimeout=null,triggerHideReactions=function(){reactionsTimeout=null,reactionsVisible=!1,hideReactions()},triggerShowReactions=function(){groupTimeout=null,reactionsVisible=!0,showReactions(),clearTimeout(reactionsTimeout),reactionsTimeout=setTimeout(triggerHideReactions,2e3)};$get(moduleId,".group_img").mouseover((function(){$(this).stop().animate(groupImageSizeForRatio(1.15),100),groupTimeout=setTimeout(triggerShowReactions,300)})).mouseout((function(){reactionsVisible||(clearTimeout(groupTimeout),$(this).stop().animate(groupImageSizeForRatio(1),100))})).click(triggerShowReactions),$get(moduleId,".reaction img").mouseover((function(){$(this).stop().animate(reactionImageSizeForRatio(2),100)})).mouseout((function(){$(this).stop().animate(reactionImageSizeForRatio(1),100)})),$get(moduleId,".reactions").mouseout((function(){clearTimeout(reactionsTimeout),reactionsTimeout=setTimeout(triggerHideReactions,1e3)})).mouseover((function(){clearTimeout(reactionsTimeout)}))}(moduleId)}}}))}function updateGroupImgAndNb(moduleId,pix){var groupImg="group_",totalNb=0;$get(moduleId,".reactionnb").each((function(){var reactionNb=parseInt($(this).text());reactionNb>0&&(groupImg+=$(this).data("reactionname").toUpperCase().charAt(0)),totalNb+=reactionNb})),$get(moduleId,".group_img").attr("src",pix[groupImg]);var $groupNbWrapper=$get(moduleId,".group_nb"),$groupNb=$groupNbWrapper.find("span");$groupNb.text(totalNb).attr("title",M.util.get_string("totalreactions","block_point_view",totalNb)),$groupNbWrapper.toggleClass("invisible",0===totalNb).toggleClass("voted",reactionVotedArray[moduleId]!==Reactions.none);var digits=Math.min((""+totalNb).length,5);$groupNb.css({right:Math.max(.25*(digits-2),0)+"em",transform:"scaleX("+(1+.03*digits*digits-.35*digits+.34)+")"})}function updateReactionNb(moduleId,reactionName,diff,isSelected){var $reactionNb=$get(moduleId,'.reactionnb[data-reactionname="'+reactionName+'"]'),nbReaction=parseInt($reactionNb.text())+diff;$reactionNb.text(nbReaction).toggleClass("nbselected",isSelected),$get(moduleId,'.reaction img[data-reactionname="'+reactionName+'"]').toggleClass("novote",0===nbReaction)}return{init:function(courseId){$((function(){var call,data=$(".block_point_view[data-blockdata]").data("blockdata"),cmid=null;document.body.classList.forEach((function(bodyClass){var matches=bodyClass.match(/cmid-(\d+)/);cmid=matches?matches[1]:cmid})),(call=function(root){void 0===root&&(root=document.body),function(root,difficultyLevels,trackColors,cmid){difficultyLevels.forEach((function(module){var moduleRoot=root.querySelector("#module-"+module.id);if(moduleRoot||module.cmid===cmid){var difficultyLevel=parseInt(module.difficultyLevel),title="";if(difficultyLevel>0){var tracklabel=["greentrack","bluetrack","redtrack","blacktrack"][difficultyLevel-1];title=M.util.get_string(tracklabel,"block_point_view")}var track=document.createElement("div");track.title=title,track.classList.add("block_point_view","track"),track.style.backgroundColor=trackColors[difficultyLevel];var container=moduleRoot.querySelector(".activitytitle");container&&container.closest(".activity-grid")&&(container=container.closest(".activity-grid")),container||(container=moduleRoot.querySelector(".activity-item .description, .activity-item .activity-altcontent")),container.querySelector(".block_point_view.track")||(container.querySelector(".mod-indent")?container.insertBefore(track,container.querySelector(".mod-indent").nextSibling):container.prepend(track)),cmid===module.id&&document.querySelector(".page-context-header").prepend(track)}}))}(root,data.difficultylevels,data.trackcolors,cmid),setUpReactions(root,courseId,data.moduleswithreactions,data.reactionstemplate,data.pix,cmid)})(),document.body.classList.contains("format-tiles")&&(MutationObserver=window.MutationObserver||window.WebKitMutationObserver,new MutationObserver((function(mutations){mutations.forEach((function(mutation){mutation.addedNodes.forEach((function(addedNode){addedNode.nodeType!==Node.TEXT_NODE&&((addedNode.id||"").startsWith("module-")?call(addedNode.parentElement):addedNode.querySelector("[id^=module-]")&&call(addedNode))}))}))})).observe(document.querySelector(".course-content"),{childList:!0,subtree:!0}))}))}}}));

//# sourceMappingURL=script_point_view.min.js.map