<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Simple class to extend admin_setting_configduration to make the protected
 * static method get_duration_text available
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class enrol_accesscodes_configduration extends admin_setting_configduration {
    /**
     * Converts seconds to some more user friendly string.
     * @param int $seconds
     * @param null|string The value to use when the duration is empty. If not specified, a "None" value is used.
     * @return string
     */
    public static function get_duration_as_text(int $seconds, ?string $emptyvalue = null): string {
        return parent::get_duration_text($seconds);
    }
}
