<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Access codes enrolemnt test data generator class
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class enrol_accesscodes_generator extends component_generator_base {
    /**
     * Create a codeset
     * @param array $data
     *
     * @return object
     */
    public function create_codeset($data) {
        global $DB;

        $codesetobj = (object) [
            'name' => $data['name'],
            'creatorid' => $data['userid'],
        ];

        if (!empty($data['timeexpires'])) {
            $codesetobj->timeexpires = $data['timeexpires'];
        }

        $codesetid = $DB->insert_record('enrol_accesscodes_codesets', $codesetobj);

        $codeset = $DB->get_record('enrol_accesscodes_codesets', ['id' => $codesetid]);

        return $codeset;
    }

    /**
     * Create a code
     * @param array $data
     *
     * @return object
     */
    public function create_code($data) {
        global $DB;

        $codeobj = (object) [
            'codesetid' => $data['codesetid'],
            'code' => $data['code'],
            'status' => $data['status'] ?? 'available',
        ];
        $codeid = $DB->insert_record('enrol_accesscodes_codes', $codeobj);

        $codecoursesobj = (object) [
            'codesetid' => $data['codesetid'],
            'courseid' => $data['courseid'],

        ];
        $DB->insert_record('enrol_accesscodes_cs_crs', $codecoursesobj);

        $code = $DB->get_record('enrol_accesscodes_codes', ['id' => $codeid]);

        return $code;
    }
}
