<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require('../../config.php');
require_once($CFG->libdir . '/adminlib.php');
require_once($CFG->dirroot . '/enrol/accesscodes/classes/codeset_form.php');
require_once($CFG->dirroot . '/enrol/accesscodes/classes/accesscodes_helper.php');

admin_externalpage_setup('enrol_accesscodes/managecodesets');

$systemcontext = context_system::instance();

$thisurl = new moodle_url('/enrol/accesscodes/add_codeset.php');

$heading = get_string('createcodeset', 'enrol_accesscodes');

$PAGE->set_title($heading);
$PAGE->set_heading($heading);
$PAGE->set_url($thisurl);
$PAGE->set_context($systemcontext);

$hasaccessto = has_capability('enrol/accesscodes:manageallcodes', $systemcontext) ? 'all' : 'own';

$breadcrumbrootstring = $hasaccessto == 'all' ?
    get_string('managecodes', 'enrol_accesscodes') : get_string('managemycodes', 'enrol_accesscodes');

$PAGE->navbar->ignore_active();
$PAGE->navbar->add(
    $breadcrumbrootstring,
    new moodle_url('/enrol/accesscodes/manage_codesets.php')
);

$itemnode = $PAGE->navbar->add($heading);

$mform = new enrol_accesscodes\codeset_form();

// Form processing and displaying is done here.
if ($mform->is_cancelled()) {
    $returnurl = new moodle_url('/enrol/accesscodes/manage_codesets.php');
    redirect($returnurl);
} else if ($formdata = $mform->get_data()) {
    $codeset = (object) [];
    $codeset->name = $formdata->codeset_name;
    $codeset->allcourses = $formdata->all_courses;
    $codeset->timeexpires = $formdata->time_expires;
    $codeset->enrolperiod = $formdata->enrol_period;
    $codeset->timecreated = time();
    $codeset->timemodified = time();
    $codeset->creatorid = $USER->id;

    $codeset->id = $DB->insert_record('enrol_accesscodes_codesets', $codeset);

    if ($formdata->all_courses == 0) {
        foreach ($formdata->valid_courses as $courseid) {
            $cscrsrecord = (object) [
                'codesetid' => $codeset->id,
                'courseid' => $courseid,
            ];
            $DB->insert_record('enrol_accesscodes_cs_crs', $cscrsrecord);
        }
    }

    $codes = enrol_accesscodes\accesscodes_helper::generate_codes($formdata->number_of_codes);
    foreach ($codes as $c) {
        $coderecord = (object) [
            'code' => $c,
            'codesetid' => $codeset->id,
            'status' => 'available',
            'timecreated' => time(),
            'timemodified' => time(),
        ];
        $DB->insert_record('enrol_accesscodes_codes', $coderecord);
    }

    \core\notification::add(get_string('codesetadded', 'enrol_accesscodes'), \core\notification::SUCCESS);
    $returnurl = new moodle_url('/enrol/accesscodes/manage_codesets.php');
    redirect($returnurl);
}

echo $OUTPUT->header();

$mform->display();

echo $OUTPUT->footer();
