<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace enrol_accesscodes;
/**
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class accesscodes_helper {
    /**
     * Generate a code
     *
     * @param int $size
     * @return string
     */
    private static function generate_code(int $size = 16): string {
        $chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVZYabcdefghijklmnopqrstuvwxyz';
        $code = substr(str_shuffle($chars), 0, $size);
        return $code;
    }


    /**
     * Generate codes
     *
     * @param int $num
     * @return array
     */
    public static function generate_codes(int $num): array {
        global $DB;

        $codes = [];
        for ($i = 0; $i < $num; $i++) {
            do {
                // Generate code.
                $code = self::generate_code(16);
                // Loop to search for an identical available code (used ones are reusable), if found generate another one.
                $codeinarray = in_array($code, $codes);
                $recordexists = $DB->record_exists('enrol_accesscodes_codes', ['code' => $code, 'status' => 'available']);
                $codevalid = (!$codeinarray && !$recordexists);
            } while (!$codevalid);
            $codes[] = $code;
        }

        return $codes;
    }
}
