<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require('../../config.php');
require_once($CFG->libdir . '/adminlib.php');

admin_externalpage_setup('enrol_accesscodes/managecodesets');

$systemcontext = context_system::instance();

$hasaccessto = has_capability('enrol/accesscodes:manageallcodes', $systemcontext) ? 'all' : 'own';

$codesetid = required_param('id', PARAM_INT);
$codeset = $DB->get_record('enrol_accesscodes_codesets', ['id' => $codesetid]);

if ($codeset->creatorid != $USER->id && $hasaccessto != 'all') {
    throw new \moodle_exception('nopermissions', 'error', '', get_string('viewexception', 'enrol_accesscodes'));
}

$confirm = optional_param('confirm', null, PARAM_INT);
$returnurl = new moodle_url('/enrol/accesscodes/manage_codesets.php');
$confirmurl = new moodle_url(
    '/enrol/accesscodes/delete_codeset.php',
    [
        'confirm' => $codeset->id,
        'id' => $codeset->id,
        'sesskey' => sesskey(),
    ]
);

if ($confirm == $codesetid && confirm_sesskey()) {
    // Delete unused codes for codeset.
    $DB->delete_records('enrol_accesscodes_codes', ['codesetid' => $codeset->id, 'status' => 'available']);
    // Delete courses for codeset.
    $DB->delete_records('enrol_accesscodes_cs_crs', ['codesetid' => $codeset->id]);
    // Delete codeset.
    $DB->delete_records('enrol_accesscodes_codesets', ['id' => $codeset->id]);

    \core\notification::add(get_string('codesetdeleted', 'enrol_accesscodes'), \core\notification::SUCCESS);
    redirect($returnurl);
}

$thisurl = new moodle_url('/enrol/accesscodes/delete_codeset.php', ['id' => $codesetid]);

$heading = get_string('deletecodeset', 'enrol_accesscodes') . ' - ' . $codeset->name;

$PAGE->set_title($heading);
$PAGE->set_heading($heading);
$PAGE->set_url($thisurl);
$PAGE->set_context($systemcontext);

$breadcrumbrootstring = $hasaccessto == 'all' ?
    get_string('managecodes', 'enrol_accesscodes') : get_string('managemycodes', 'enrol_accesscodes');

$PAGE->navbar->ignore_active();
$PAGE->navbar->add(
    $breadcrumbrootstring,
    new moodle_url('/enrol/accesscodes/manage_codesets.php')
);

$itemnode = $PAGE->navbar->add($heading);

$confirmstring = get_string('confirmdeletecodeset', 'enrol_accesscodes', $codeset->name);

echo $OUTPUT->header();
echo $OUTPUT->confirm($confirmstring, $confirmurl, $returnurl);

echo $OUTPUT->footer();
