<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Access codes helper PHPunit tests
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace enrol_accesscodes;

use enrol_accesscodes\codeset_form;
use advanced_testcase;
use context_course;

/**
 * Enrol accesscodes codeset_form functions tests
 *
 * @package    enrol_accesscodes
 * @category   external
 * @covers     \enrol_accesscodes\codeset_form
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      Moodle 3.8
 * @group enrol_accesscodes_externalib
 */
final class codeset_form_test extends advanced_testcase {
    /**
     * test form description
     */
    public function test_codeset_form(): void {
        global $DB;
        self::resetAfterTest(true);

        $course = self::getDataGenerator()->create_course();
        $user = self::getDataGenerator()->create_user();

        $context = context_course::instance($course->id);

        $accesscodesplugin = enrol_get_plugin('accesscodes');

        $enabled = enrol_get_plugins(true);
        $enabled['accesscodes'] = true;
        $enabled = array_keys($enabled);
        set_config('enrol_plugins_enabled', implode(',', $enabled));

        $studentrole = $DB->get_record('role', ['shortname' => 'student']);
        $instanceid = $accesscodesplugin->add_instance($course, [
            'status' => ENROL_INSTANCE_ENABLED,
            'name' => 'Test instance 1',
            'customint6' => 1,
            'roleid' => $studentrole->id,
        ]);

        $instance = $DB->get_record('enrol', ['id' => $instanceid], '*', MUST_EXIST);

        // Get the data we are submitting for the form.
        $formdata = [];
        $formdata['codeset_name'] = "Test codeset";
        $formdata['all_courses'] = 1;
        $formdata['time_expires'] = 0;
        $formdata['number_of_codes'] = 10;

        codeset_form::mock_submit($formdata);

        $form = new codeset_form();

        $data = $form->get_data();

        $this->assertTrue($form->is_validated());

        foreach ($formdata as $key => $value) {
            $this->assertEquals($value, $data->$key);
        }

        $formdata['codeset_name'] = "Test codeset 2";
        $formdata['all_courses'] = 0;

        codeset_form::mock_submit($formdata);

        $form = new codeset_form();

        $data = $form->get_data();

        $this->assertFalse($form->is_validated());

        $formdata['codeset_name'] = "Test codeset 3";
        $formdata['all_courses'] = 0;
        $formdata['valid_courses'] = [$course->id];

        codeset_form::mock_submit($formdata);

        $form = new codeset_form();

        $data = $form->get_data();

        $this->assertTrue($form->is_validated());
    }
}
