<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Access codes plugin external functions and service definitions.
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
    'enrol_accesscodes_get_instance_info' => [
        'classname'   => 'enrol_accesscodes\external\get_instance_info',
        'description' => 'Access codes enrolment instance information.',
        'type'        => 'read',
        'services'    => [MOODLE_OFFICIAL_MOBILE_SERVICE],
    ],
    'enrol_accesscodes_enrol_user' => [
        'classname'   => 'enrol_accesscodes\external\enrol_user',
        'description' => 'Enrol the current user in the given course if they provide a valid access code.',
        'type'        => 'write',
        'services'    => [MOODLE_OFFICIAL_MOBILE_SERVICE],
    ],
];
