<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_accesscodes', language 'en'.
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accesscode'] = "Access code";
$string['accesscodes'] = "Access codes";
$string['accesscodes:config'] = 'Configure access code enrol instances';
$string['accesscodes:enrolself'] = 'Enrol in course using access code';
$string['accesscodes:holdkey'] = 'Appear as the access code holder';
$string['accesscodes:manage'] = 'Manage enrolled users';
$string['accesscodes:manageallcodes'] = 'Manage all users codesets';
$string['accesscodes:manageowncodes'] = 'Manage your own codesets';
$string['accesscodes:unenrol'] = 'Unenrol users from course';
$string['accesscodes:unenrolself'] = 'Unenrol self from the course';
$string['additionalcodes'] = 'Number of additional codes to generate';
$string['additionalcodes_help'] = 'How many additional codes should be generated?';
$string['allcourses'] = "All courses";
$string['allcourses_help'] = "Should the codes work on all courses with this enrolment method enabled, or only specific courses?";
$string['available'] = "Available";

$string['cannotenrol'] = 'Enrolment is disabled or inactive';
$string['cannotenrolearly'] = 'You cannot enrol yet; enrolment starts on {$a}.';
$string['cannotenrollate'] = 'You cannot enrol any more, enrolment ended on {$a}.';

$string['code'] = 'Code';
$string['codesavailable'] = 'Codes available';
$string['codescantbereduced'] = 'Warning, number of codes cannot be reduced after submitting this form (additional codes can be added).';
$string['codesetadded'] = "Codeset created successfully";
$string['codesetdeleted'] = "Codeset deleted";
$string['codesetname'] = "Codeset name";
$string['codesetupdated'] = "Codeset updated";
$string['cohortnonmemberinfo'] = 'Only members of cohort \'{$a}\' can self-enrol.';
$string['cohortonly'] = 'Only cohort members';
$string['cohortonly_help'] = 'Access code enrolment may be restricted to members of a specified cohort only. Note that changing this setting has no effect on existing enrolments.';
$string['confirmbulkdeleteenrolment'] = 'Are you sure you want to delete these user enrolments?';
$string['confirmdeletecodeset'] = 'Are you absolutely sure you want to delete the codeset {$a}? This action cannot be undone.';
$string['coursesrequirederror'] = "Please choose at least one course or make available to all courses.";
$string['createcodeset'] = "Create codeset";
$string['createdby'] = 'Created by';
$string['customwelcomemessage'] = 'Custom welcome message';
$string['customwelcomemessage_help'] = 'A custom welcome message may be added as plain text or Moodle-auto format, including HTML tags and multi-lang tags.

The following placeholders may be included in the message:

* Course name {$a->coursename}
* Link to user\'s profile page {$a->profileurl}
* User email {$a->email}
* User fullname {$a->fullname}';

$string['datecreated'] = 'Date created';
$string['defaultrole'] = 'Default role assignment';
$string['defaultrole_desc'] = 'Select role which should be assigned to users during access code enrolment';
$string['deletecodeset'] = "Delete codeset";
$string['deleteselectedusers'] = 'Delete selected user enrolments';

$string['editexception'] = "Edit codesets you did not create.";
$string['editselectedusers'] = 'Edit selected user enrolments';
$string['enrolenddate'] = 'End date';
$string['enrolenddate_help'] = 'If enabled, users can enrol themselves until this date only.';
$string['enrolenddaterror'] = 'Enrolment end date cannot be earlier than start date';
$string['enrolme'] = 'Enrol me';
$string['enrolmentduration'] = 'Enrolment duration';
$string['enrolmentduration_help'] = 'How long should the enrolment last from the time that the code is used, if left blank the enrolment method default will be used.';
$string['enrolperiod'] = 'Enrolment duration';
$string['enrolperiod_desc'] = 'Default length of time that the enrolment is valid. If set to zero, the enrolment duration will be unlimited by default.';
$string['enrolperiod_help'] = 'Length of time that the enrolment is valid, starting with the moment the user enrols themselves. If disabled, the enrolment duration will be unlimited.';
$string['enrolstartdate'] = 'Start date';
$string['enrolstartdate_help'] = 'If enabled, users can enrol themselves from this date onward only.';
$string['expiredaction'] = 'Enrolment expiry action';
$string['expiredaction_help'] = 'Select action to carry out when user enrolment expires. Please note that some user data and settings are purged from course during course unenrolment.';
$string['expiredcode'] = "Access code has expired.";
$string['expireinpasterror'] = "The expiry date must be in the future.";
$string['expirydate'] = 'Expiry date';
$string['expirydate_help'] = 'Codes will stop working after the expiry date, this does not affect codes used before the expiry date (e.g. it will not unenrol the user).';
$string['expirymessageenrolledbody'] = 'Dear {$a->user},

This is a notification that your enrolment in the course \'{$a->course}\' is due to expire on {$a->timeend}.

If you need help, please contact {$a->enroller}.';
$string['expirymessageenrolledsubject'] = 'Self enrolment expiry notification';
$string['expirymessageenrollerbody'] = 'Access code enrolment in the course \'{$a->course}\' will expire within the next {$a->threshold} for the following users:

{$a->users}

To extend their enrolment, go to {$a->extendurl}';

$string['expirymessageenrollersubject'] = 'Access code enrolment expiry notification';

$string['expirynotifyall'] = 'Teacher and enrolled user';
$string['expirynotifyenroller'] = 'Teacher only';
$string['export'] = "Export";
$string['exportcodes'] = "Export codes";
$string['exportpersonaldatawarning'] = "Codes will be exported without user information to preserve data privacy.";

$string['invalidcode'] = "Invalid access code.";
$string['invalidforcourse'] = "Access code is not valid for this course.";

$string['longtimenosee'] = 'Unenrol inactive after';
$string['longtimenosee_help'] = 'If users haven\'t accessed a course for a long time, then they are automatically unenrolled. This parameter specifies that time limit.';

$string['managecodes'] = "Manage access codes";
$string['managemycodes'] = "Manage my access codes";
$string['maxenrolled'] = 'Max enrolled users';
$string['maxenrolled_help'] = 'Specifies the maximum number of users that can enrol with this method. 0 means no limit.';
$string['maxenrolledreached'] = 'Maximum number of users allowed to enrol was already reached.';
$string['messageprovider:expiry_notification'] = 'Access code enrolment expiry notifications';

$string['newenrols'] = 'Allow new enrolments';
$string['newenrols_desc'] = 'Allow users to enrol into new courses by default.';
$string['newenrols_help'] = 'This setting determines whether a user can enrol into this course.';
$string['nonzerocodeserror'] = "Please choose a number of codes to be generated.";
$string['nopassword'] = 'No enrolment key required.';
$string['numberofcodes'] = 'Number of codes';
$string['numberofcodes_help'] = 'How many codes should be generated?';

$string['password'] = 'Enrolment key';
$string['password_help'] = 'An enrolment key enables access to the course to be restricted to only those who know the key.

If the field is left blank, any user may enrol in the course.

If an enrolment key is specified, any user attempting to enrol in the course will be required to supply the key. Note that a user only needs to supply the enrolment key ONCE, when they enrol in the course.';
$string['passwordinvalid'] = 'Incorrect enrolment key, please try again';
$string['passwordinvalidhint'] = 'That enrolment key was incorrect, please try again<br />
(Here\'s a hint - it starts with \'{$a}\')';
$string['pluginname'] = 'Access code enrolment';
$string['pluginname_desc'] = 'The access code enrolment plugin allows users to enrol in a course using single use access codes. Internally the enrolment is done via the manual enrolment plugin which has to be enabled in the same course.';

$string['privacy:metadata:enrol_accesscodes'] = 'The Access codes enrolment plugin may store personal data relating to enrolments in the enrol_accesscodes_codes table.';
$string['privacy:metadata:enrol_accesscodes:code'] = 'The enrolment code';
$string['privacy:metadata:enrol_accesscodes:codesetid'] = 'The codeset ID to which the code relates';
$string['privacy:metadata:enrol_accesscodes:courseid'] = 'The course ID to which the enrolment relates';
$string['privacy:metadata:enrol_accesscodes:status'] = 'The status of the code';
$string['privacy:metadata:enrol_accesscodes:timecreated'] = 'The time when the enrolment is created';
$string['privacy:metadata:enrol_accesscodes:timemodified'] = 'The time when the enrolment is modified';
$string['privacy:metadata:enrol_accesscodes:userid'] = 'The ID of the user to which the role assignment relates';

$string['role'] = 'Default assigned role';

$string['saveandgenerate'] = 'Save and generate codes';
$string['searchcodesetname'] = 'Search codeset name';
$string['sendcoursewelcomemessage'] = 'Send course welcome message';
$string['sendcoursewelcomemessage_help'] = 'When a user enrols in the course, they may be sent a welcome message email. If sent from the course contact (by default the teacher), and more than one user has this role, the email is sent from the first user to be assigned the role.';
$string['sendexpirynotificationstask'] = "Access code enrolment send expiry notifications task";
$string['showall'] = 'Show all';
$string['status'] = 'Allow existing enrolments';
$string['status_desc'] = 'Enable access code enrolment method in new courses.';
$string['status_help'] = 'If enabled together with \'Allow new enrolments\' disabled, only users who enrolled previously can access the course. If disabled, this access code enrolment method is effectively disabled, since all existing access code enrolments are suspended and new users cannot enrol.';
$string['syncenrolmentstask'] = 'Synchronise access code enrolments task';

$string['unenrol'] = 'Unenrol user';
$string['unenrolselfconfirm'] = 'Do you really want to unenrol yourself from course "{$a}"?';
$string['unenroluser'] = 'Do you really want to unenrol "{$a->user}" from course "{$a->course}"?';
$string['unenrolusers'] = 'Unenrol users';
$string['used'] = "Used";
$string['usedby'] = 'Used by';
$string['usedfor'] = 'Used for';
$string['usepasswordpolicy'] = 'Use password policy';
$string['usepasswordpolicy_desc'] = 'Use standard password policy for access codes.';

$string['validcourses'] = "Valid courses";
$string['validcourses_help'] = "Which courses should the codes work on? Only courses that have an instance of the accesscodes enrolment method will be available here.";
$string['viewcodes'] = "View codes";
$string['viewexception'] = "View codesets you did not create.";

$string['welcometocourse'] = 'Welcome to {$a}';
$string['welcometocoursetext'] = 'Welcome to {$a->coursename}!

If you have not done so already, you should edit your profile page so that we can learn more about you:

  {$a->profileurl}';
