<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Access codes helper PHPunit tests
 *
 * @package    enrol_accesscodes
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace enrol_accesscodes;

use enrol_accesscodes\accesscodes_helper;
use advanced_testcase;

/**
 * Enrol accesscodes helper functions tests
 *
 * @package    enrol_accesscodes
 * @category   external
 * @covers     \enrol_accesscodes\accesscodes_helper
 * @copyright  2025 Andy McGill {@link https://brookesia.co.uk}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      Moodle 3.8
 * @group enrol_accesscodes_externalib
 */
final class helper_test extends advanced_testcase {
    /**
     * test generate code description
     */
    public function test_generate_codes(): void {
        $codes = accesscodes_helper::generate_codes(2);

        $this->assertEquals(2, count($codes));
        $this->assertNotEquals($codes[0], $codes[1]);
        $this->assertMatchesRegularExpression('/^[a-zA-Z0-9]*$/', $codes[0]);
    }
}
