<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace local_coursefilters;

/**
 * Basic course filter factory.
 * @package    local_coursefilters
 * @copyright  2024 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
abstract class filter_factory {
    /**
     * Base factory method returning a filter corresponding to the given name.
     * @param string $name Filter name, should have a corresponding class \local_coursefilters\{$name}_filter existing.
     * @return filter
     */
    public static function get_filter($name): filter {
        $classname = "\\local_coursefilters\\{$name}_filter";
        if (!class_exists($classname)) {
            throw new \coding_exception('[local_coursefilters] The required filter does not exist: ' . $name);
        }
        return new $classname();
    }
}
