<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace local_coursefilters;

/**
 * Course filter for courses with open access.
 * @package    local_coursefilters
 * @copyright  2024 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class openaccess_filter extends filter {
    /**
     * {@inheritDoc}
     * @see \local_coursefilters\filter::needs_auth()
     */
    public function needs_auth(): bool {
        return false;
    }

    /**
     * {@inheritDoc}
     * @see \local_coursefilters\filter::show_if_none()
     */
    public function show_if_none(): bool {
        return false;
    }

    /**
     * {@inheritDoc}
     * @param int $courseid Course ID.
     * @see \local_coursefilters\filter::course_is_in_filter()
     */
    public function course_is_in_filter($courseid): bool {
        global $DB;
        if ($DB->record_exists('enrol', [
                'courseid' => $courseid,
                'enrol' => 'guest',
                'status' => ENROL_INSTANCE_ENABLED,
        ])) {
            // Guest access.
            return true;
        }
        if ($DB->record_exists('enrol', [
                'courseid' => $courseid,
                'enrol' => 'self',
                'status' => ENROL_INSTANCE_ENABLED,
                'password' => null,
        ])) {
            // Self enrol without password.
            return true;
        }
        return false;
    }
}
