<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Administration plugin-specific settings definition.
 * @package    local_coursefilters
 * @copyright  2024 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

if ($hassiteconfig) {
    $settings = new admin_settingpage('local_coursefilters', get_string('pluginname', 'local_coursefilters'));

    foreach ([ 'openaccess', 'enrolled', 'notenrolled', 'teacher' ] as $filter) {
        $settings->add(new admin_setting_configmultiselect(
                'local_coursefilters/' . $filter . 'filterlocations',
                get_string('setting:' . $filter . 'filterlocations', 'local_coursefilters'),
                get_string('setting:' . $filter . 'filterlocations_desc', 'local_coursefilters'),
                [ 'site-index', 'course-search', 'course-index', 'course-index-category' ],
                [
                        'site-index' => get_string('setting:siteindex', 'local_coursefilters'),
                        'course-search' => get_string('setting:coursesearch', 'local_coursefilters'),
                        'course-index' => get_string('setting:courseindex', 'local_coursefilters'),
                        'course-index-category' => get_string('setting:courseindexcategory', 'local_coursefilters'),
                ]
                ));
        if ($filter === 'teacher') {
            $roles = role_get_names(context_system::instance(), ROLENAME_ALIAS, true);
            $settings->add(new admin_setting_configmultiselect(
                    'local_coursefilters/' . $filter . 'filterroles',
                    get_string('setting:' . $filter . 'filterroles', 'local_coursefilters'),
                    get_string('setting:' . $filter . 'filterroles_desc', 'local_coursefilters'),
                    [],
                    $roles
                    ));
        }
    }

    $ADMIN->add('localplugins', $settings);
    $settings = null;
}
