/* eslint no-var: "error" */
/* eslint capitalized-comments: "off" */
/* eslint-env es6 */

import {loadFragment} from 'core/fragment';
import {loadStrings} from './util/string-helper';
import {call} from 'core/ajax';
import notification from 'core/notification';
import {replaceNodeContents} from 'core/templates';

export default {
    install(Vue/* ,options */) {

        let strings = loadStrings({
            editmod: {
                save$core: "save$core",
                cancel$core: "cancel$core",
            }
        });

        Vue.component('s-edit-mod', {
            props: {
                cmid: {
                    type: Number,
                },
                coursectxid: {
                    type: Number,
                },
                title: {
                    type: String,
                    'default': "",
                },
                genericonly: {
                    type: Boolean,
                    'default': false,
                }
            },
            data() {
                return {
                    content: "",
                    text: strings.editmod,
                };
            },
            computed: {
            },
            methods: {
                openForm() {
                    const self = this;
                    self.$refs.editormodal.show();
                },
                onShown() {
                    const self = this;
                    let params = {cmid: this.cmid};
                    loadFragment('local_treestudyplan', 'mod_edit_form', this.coursectxid, params).then((html, js) => {
                        replaceNodeContents(self.$refs.content, html, js);
                        return null;
                    }).catch(notification.exception);

                },
                onSave() {
                    const self = this;
                    let form = this.$refs.content.getElementsByTagName("form")[0];

                   // markFormSubmitted(form); // Moodle 4.00+ only
                    // We call this, so other modules can update the form with the latest state.
                    form.dispatchEvent(new Event("save-form-state"));
                    // Tell all form fields we are about to submit the form.
                   // notifyFormSubmittedByJavascript(form); // Moodle 4.00+ only

                    const formdata = new FormData(form);
                    const data = new URLSearchParams(formdata).toString();
                    // const formdata = new FormData(form);
                    // const data = {};
                    // formdata.forEach((value, key) => (data[key] = value));

                    call([{
                        methodname: 'local_treestudyplan_submit_cm_editform',
                        args: {cmid: this.cmid, formdata: data}
                    }])[0].then(() => {
                        self.$emit("saved", formdata);
                        return null;
                    }).catch(notification.exception);
                }
            },
            template: `
            <span class='s-edit-mod'><a href='#' @click.prevent="openForm"><slot><i class="fa fa-cog"></i></slot></a>
                <b-modal
                    ref="editormodal"
                    scrollable
                    centered
                    size="xl"
                    id="'modal-cm-'+cmid"
                    @shown="onShown"
                    @ok="onSave"
                    :title="title"
                    :ok-title="text.save$core"
                    ><div :class="'s-edit-mod-form '+ (genericonly?'genericonly':'')" ref="content"
                        ><div class="d-flex justify-content-center mb-3"><b-spinner variant="primary"></b-spinner></div
                    ></div
                ></b-modal>
            </span>
            `,
        });
    }
};

