/* eslint camelcase: "off" */
import {get_strings} from 'core/str';
import {getStrings} from 'core/str';
import Debugger from './debugger';
let debug = new Debugger("string-helper");

/* Determine the proper getstrings function to use (MDL4.3+ recommends use of getStrings, which is jquery independent) */
const getstrFunc = (getStrings !== undefined) ? getStrings : get_strings;

/**
 * Load the translation of strings from a strings object
 * @param {Object} strings The map of strings
 * @param {String} plugin Name of plugin to load for by default (leave empty for 'local_treestudyplan')
 * @returns {Object} The map with strings loaded in
 */
export function loadStrings(strings, plugin) {
    if (plugin === undefined) {
        plugin = 'local_treestudyplan';
    }
    for (let idx in strings) {
        let stringkeys = [];
        for (const handle in strings[idx]) {
            const key = strings[idx][handle];
            let parts = key.split(/[$@]/);
            let identifier = parts[0];
            let component = (parts.length > 1) ? parts[1] : plugin;
            stringkeys.push({key: identifier, component: component});
        }
        getstrFunc(stringkeys).then(function(str) {
            let i = 0;
            for (const handle in strings[idx]) {
                strings[idx][handle] = str[i];
                i++;
            }
            return;
        }).catch((x) => {
            debug.warn(x);
        });
    }

    return strings;
}

/**
 * Load the translation of strings from a strings object based on keys
 * Used for loading values for a drop down menu or the like
 * @param {Object} string_keys The map of stringkeys
 * @param {String} plugin Name of plugin to load for by default (leave empty for 'local_treestudyplan')
 * @returns {Object} The map with strings loaded in
 */
export function loadStringKeys(string_keys, plugin) {
    if (plugin === undefined) {
        plugin = 'local_treestudyplan';
    }
    for (let idx in string_keys) {
        // Get text strings for condition settings
        let stringkeys = [];
        for (const i in string_keys[idx]) {
            const key = string_keys[idx][i].textkey;
            let parts = key.split("$");
            let identifier = parts[0];
            let component = (parts.length > 1) ? parts[1] : plugin;
            stringkeys.push({key: identifier, component: component});
        }
        getstrFunc(stringkeys).then(function(strings) {
            for (const i in strings) {
                const s = strings[i];
                const l = string_keys[idx][i];
                l.text = s;
            }
            return;
        }).catch((x) => {
            debug.warn(x);
        });
    }
    return string_keys;
}

/**
 * String formatting function - replaces {name} in string by value of same key in values parameter
 * @param {string} str String t
 * @param {object} values Object containing keys to replace {key} strings with
 * @returns {string} Formatted string
 */
export function strformat(str, values) {
    return str.replace(/\{(\w+)\}/g, (m, m1) => {
        if (m1 && values.hasOwnProperty(m1)) {
            return values[m1];
        } else {
            return m;
        }
    });
}
