<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Background task to refresh the list of associaded teachers with studyplans
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_treestudyplan\task;
defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/course/externallib.php');
use local_treestudyplan\teachingfinder;

/**
 * Background task to refresh the list of associaded teachers with studyplans
 */
class refreshteacherlist extends \core\task\scheduled_task {
    /**
     * Maximum time a result is valid before refreshing
     * @var int
     */
    const CACHE_TIME = 4 * 60 * 60; // 2 hours.

    /**
     * Return the task's name as shown in admin screens.
     *
     * @return string
     */
    public function get_name() {
        return get_string('refreshteacherlist_name', 'local_treestudyplan');
    }

    /**
     * Execute the task.
     */
    public function execute() {
        \mtrace("Ververs lijst met leraren");
        $teacherids = teachingfinder::list_teacher_ids();
        foreach ($teacherids as $tid) {
            $utime = teachingfinder::get_update_time($tid);
            if (time() - $utime > self::CACHE_TIME) {
                \mtrace("Teacher {$tid} is due for a refresh of the list");
                teachingfinder::update_teaching_cache($tid);
            }
        }

    }
}
