<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Webservice function register
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
    /***************************
     * Studyplan functions
     ***************************/
    'local_treestudyplan_list_studyplans' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'list_studyplans',          // External function name.
        'description'   => 'List available studyplans',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan, local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_studyplan_map' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'get_studyplan_map',          // External function name.
        'description'   => 'Retrieve studyplan map',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_studyplan_resultmap' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'get_studyplan_resultmap',          // External function name.
        'description'   => 'Retrieve studyplan result map',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_studyline_map' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'get_studyline_map',          // External function name.
        'description'   => 'Retrieve studyline map',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_add_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'add_studyplan',          // External function name.
        'description'   => 'Add studyplan',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_add_studyline' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'add_studyline',          // External function name.
        'description'   => 'Add studyline',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_edit_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'edit_studyplan',          // External function name.
        'description'   => 'Edit studyplan',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_edit_studyline' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'edit_studyline',          // External function name.
        'description'   => 'Edit studyline',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'delete_studyplan',          // External function name.
        'description'   => 'Delete studyplan',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyplanpage' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'delete_studyplanpage',          // External function name.
        'description'   => 'Delete studyplan page',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyline' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'delete_studyline',          // External function name.
        'description'   => 'Delete studyline',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_reorder_studylines' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'reorder_studylines',          // External function name.
        'description'   => 'Reorder studylines',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_get_studyitem' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'get_studyitem',          // External function name.
        'description'   => 'Retrieve study item',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_add_studyitem' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'add_studyitem',          // External function name.
        'description'   => 'Add study item',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_edit_studyitem' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'edit_studyitem',          // External function name.
        'description'   => 'Edit study item',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_reorder_studyitems' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'reorder_studyitems',          // External function name.
        'description'   => 'Reorder study items',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyitem' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'delete_studyitem',          // External function name.
        'description'   => 'Delete study item',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_studyitems' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'connect_studyitems',          // External function name.
        'description'   => 'Connect study items',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_studyitems' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'disconnect_studyitems',          // External function name.
        'description'   => 'Disconnect study items',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    /***************************
     * Badge functions
     ***************************/

    'local_treestudyplan_list_badges' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'list_badges',          // External function name.
        'description'   => 'List available site badges',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_search_badges' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'search_badges',          // External function name.
        'description'   => 'Search available site badges',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_search_related_badges' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'search_related_badges',          // External function name.
        'description'   => 'Search badges related to courses in the studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],

    /***************************
     * Association functions
     ***************************/
    'local_treestudyplan_list_cohort' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'list_cohort',          // External function name.
        'description'   => 'List available cohorts',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_find_user' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'find_user',          // External function name.
        'description'   => 'Find user',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_cohort' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'connect_cohort',          // External function name.
        'description'   => 'Connect cohort to studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_cohort' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'disconnect_cohort',          // External function name.
        'description'   => 'Disconnect cohort from study plan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_user' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'connect_user',          // External function name.
        'description'   => 'Connect user to study plan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_user' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'disconnect_user',          // External function name.
        'description'   => 'Disconnect user from studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_associated_users' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'associated_users',          // External function name.
        'description'   => 'List users associated with a studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_associated_cohorts' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'associated_cohorts',          // External function name.
        'description'   => 'List cohorts associated with a studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_associated_coaches' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'associated_coaches',          // External function name.
        'description'   => 'List coaches associated with a studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_find_coach' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'find_coach',          // External function name.
        'description'   => 'Find available coach',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_coach' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'connect_coach',          // External function name.
        'description'   => 'Connect coach to study plan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_coach' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'disconnect_coach',          // External function name.
        'description'   => 'Disconnect coach from studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    /***************************
     * Category mapping
     ***************************/
    'local_treestudyplan_search_courses' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'search_courses',          // External function name.
        'description'   => 'Search courses',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_map_categories' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'map_categories',          // External function name.
        'description'   => 'List available root categories',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_category' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'get_category',          // External function name.
        'description'   => 'Get details for specified category',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_include_grade' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'include_grade',          // External function name.
        'description'   => 'Include gradable in result',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan, local/treestudyplan:selectowngradables',
        'loginrequired' => true,
    ],
    'local_treestudyplan_require_competency' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'require_competency',          // External function name.
        'description'   => 'Mark competency as required in course outcome',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan, local/treestudyplan:selectowngradables',
        'loginrequired' => true,
    ],
    'local_treestudyplan_all_associated' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'all_associated',          // External function name.
        'description'   => 'List associated users',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_all_associated_grouped' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'all_associated_grouped',          // External function name.
        'description'   => 'List associated users by group',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    /***************************
     * Studyplan functions
     ***************************/
    'local_treestudyplan_list_aggregators' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'list_aggregators',          // External function name.
        'description'   => 'List available aggregators',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_force_studyplan_scale' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'force_studyplan_scale',          // External function name.
        'description'   => 'Change all associated gradables to the chosen scale if possible',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:forcescales',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_scales' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'list_scales',          // External function name.
        'description'   => 'List system scales',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:forcescales',
        'loginrequired' => true,
    ],
    'local_treestudyplan_duplicate_plan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'duplicate_plan',          // External function name.
        'description'   => 'Copy studyplan',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_export_plan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'export_plan',          // External function name.
        'description'   => 'Export studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_export_page' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'export_page',          // External function name.
        'description'   => 'Export studyplan page',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_import_plan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'import_plan',          // External function name.
        'description'   => 'Import study plan',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_import_pages' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'import_pages',          // External function name.
        'description'   => 'Import study plan pages',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_import_studylines' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'import_studylines',          // External function name.
        'description'   => 'Import study plan',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_period' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'get_period',          // External function name.
        'description'   => 'Get period name and timing',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_edit_period' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'edit_period',          // External function name.
        'description'   => 'Edit period name and timing',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_submit_cm_editform' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'submit_cm_editform',          // External function name.
        'description'   => 'Submit course module edit form',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_available_categories' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'list_available_categories',          // External function name.
        'description'   => 'Get categories hosting  a studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_scan_badge_progress' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'scan_badge_progress',          // External function name.
        'description'   => 'Scan progress of students in attaining badge',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_scan_completion_progress' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'scan_completion_progress',          // External function name.
        'description'   => 'Scan progress of students in attaining completions',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_scan_grade_progress' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\courseservice',  // Class containing the external function.
        'methodname'    => 'scan_grade_progress',          // External function name.
        'description'   => 'Scan progress of students in attaining grades',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_cascade_cohortsync' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\associationservice',  // Class containing the external function.
        'methodname'    => 'cascade_cohortsync',          // External function name.
        'description'   => 'Sync cohortsync to studyplan association',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_course_period_timing' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'course_period_timing',          // External function name.
        'description'   => 'Chenge course start and end times to match period',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_set_studyitem_span' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'set_studyitem_span',          // External function name.
        'description'   => 'Change the span of a course item',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_mform' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\utilityservice',  // Class containing the external function.
        'methodname'    => 'get_mform',          // External function name.
        'description'   => 'Get a studyplan specific form',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_submit_mform' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\utilityservice',  // Class containing the external function.
        'methodname'    => 'submit_mform',          // External function name.
        'description'   => 'Submit a studyplan specific form through ajax',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_bulk_course_timing' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'bulk_course_timing',          // External function name.
        'description'   => 'Change course start/end dates to match that of the studyplan period',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_user_studyplans' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'list_user_studyplans',          // External function name.
        'description'   => 'List user studyplans',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_user_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'get_user_studyplan',          // External function name.
        'description'   => 'Retrieve user studyplan',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_invited_studyplans' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'list_invited_studyplans',          // External function name.
        'description'   => 'List studyplans for user from invite',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => false,
    ],
    'local_treestudyplan_get_invited_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'get_invited_studyplan',          // External function name.
        'description'   => 'Retrieve studyplan for user from invite',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => false,
    ],
    'local_treestudyplan_list_own_studyplans' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'list_own_studyplans',          // External function name.
        'description'   => 'List studyplans for current user',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_own_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'get_own_studyplan',          // External function name.
        'description'   => 'Retrieve studyplan for current user',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_teaching_studyplans' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'list_teaching_studyplans',          // External function name.
        'description'   => 'List studyplans for current user as teacher',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_teaching_studyplan' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'get_teaching_studyplan',          // External function name.
        'description'   => 'Retrieve studyplan for current user as teacher',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_coaching_studyplans' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'list_coaching_studyplans',          // External function name.
        'description'   => 'List studyplans for current user as coach',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    /***************************
     * Studyplan report functions
     ***************************/
    'local_treestudyplan_get_report_structure' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\reportservice',  // Class containing the external function.
        'methodname'    => 'get_report_structure',          // External function name.
        'description'   => 'Retrieve studyplan report structure',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_report_data' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\reportservice',  // Class containing the external function.
        'methodname'    => 'get_report_data',          // External function name.
        'description'   => 'Retrieve studyplan report data for student ',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_report_details' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\reportservice',  // Class containing the external function.
        'methodname'    => 'get_report_details',          // External function name.
        'description'   => 'Retrieve studyplan report details for student ',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    /***************************
     * Studyline enrollment functions
     ***************************/
    'local_treestudyplan_list_roles' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'list_roles',          // External function name.
        'description'   => 'Retrieve list of available roles in the studyplan\'s context',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_line_enrol_self' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studentstudyplanservice',  // Class containing the external function.
        'methodname'    => 'line_enrol_self',          // External function name.
        'description'   => 'Enroll yourself in a study line',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_line_enrol_students' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'line_enrol_students',          // External function name.
        'description'   => 'Enroll a student in a study line',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_line_unenrol_students' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'line_unenrol_students',          // External function name.
        'description'   => 'Enrol a student in a study line',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:lineunenrol',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_line_enrolled_students' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'list_line_enrolled_students',          // External function name.
        'description'   => 'Show students enrolled in an enrollable study line',
        'type'          => 'write',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    /***************************
     * Utility functions
     ***************************/
    'local_treestudyplan_count_templates' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\studyplanservice',  // Class containing the external function.
        'methodname'    => 'count_templates',          // External function name.
        'description'   => 'Count number of templates',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_getsettings' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\utilityservice',  // Class containing the external function.
        'methodname'    => 'getsettings',          // External function name.
        'description'   => 'Get some studypln related settings',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],

    /***************************
     * Share API Functions
     ***************************/
    'local_treestudyplan_find_users' => [         // Web service function name.
        'classname'     => '\local_treestudyplan\shareservice',  // Class containing the external function.
        'methodname'    => 'find_users',          // External function name.
        'description'   => 'Find potential users',
        'type'          => 'read',                  // Database rights of the web service function (read, write).
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:manageshares',
        'loginrequired' => true,
    ],


];
