<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Show student's studyplans in a report overview
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");

require_once($CFG->libdir.'/weblib.php');

use local_treestudyplan\studyplan;
use local_treestudyplan\teachingfinder;

$systemcontext = context_system::instance();

$PAGE->set_url("/local/treestudyplan/myreport.php", []);
require_login();

$PAGE->set_pagelayout('base');
$PAGE->set_context($systemcontext);

$amteaching = teachingfinder::is_teaching($USER->id);
$haveplans = studyplan::exist_for_user($USER->id);

if ($amteaching) {
    $PAGE->set_title(get_string('myreport_teachermode', 'local_treestudyplan'));
    $PAGE->set_heading(get_string('myreport_teachermode', 'local_treestudyplan'));
} else {
    $PAGE->set_title(get_string('report_invited', 'local_treestudyplan', "{$USER->firstname} {$USER->lastname}"));
    $PAGE->set_heading(get_string('report_invited', 'local_treestudyplan', "{$USER->firstname} {$USER->lastname}"));
}

$enableplansharing = get_config("local_treestudyplan", "enableplansharing") && !$amteaching;

// Load javascripts and specific css.
$PAGE->requires->css(new moodle_url($CFG->wwwroot.'/local/treestudyplan/css/bootstrap-vue/bootstrap-vue.css'));
if ($CFG->debugdeveloper) {
    $PAGE->requires->css(new moodle_url($CFG->wwwroot.'/local/treestudyplan/styles.css'));
}

print $OUTPUT->header();
print $OUTPUT->render_from_template('local_treestudyplan/myreport', [
    "type" => $amteaching ? 'teaching' : 'own',
    "key" => "",
    "enableplansharing" => $enableplansharing,
]);
print $OUTPUT->footer();
